/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord.input.logic;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionInputCheckXCommand;
import org.apache.oozie.command.coord.CoordActionStartXCommand;
import org.apache.oozie.command.coord.CoordMaterializeTransitionXCommand;
import org.apache.oozie.command.coord.CoordSubmitXCommand;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.jdom.JDOMException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestCoordinatorInputLogic
extends XDataTestCase {
    private Services services;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    @Test(expected=CommandException.class)
    public void testValidateRange() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<combine name=\"test\"><data-in dataset=\"A\" /><data-in dataset=\"b\" /></combine>";
        String inputEvent = "<data-in name=\"A\" dataset=\"a\"><start-instance>${coord:current(-5)}</start-instance><end-instance>${coord:current(0)}</end-instance></data-in><data-in name=\"B\" dataset=\"b\"><start-instance>${coord:current(-4)}</start-instance><end-instance>${coord:current(0)}</end-instance></data-in>";
        conf.set("partitionName", "test");
        try {
            this._testCoordSubmit("coord-inputlogic.xml", conf, inputLogic, inputEvent, true);
            TestCoordinatorInputLogic.fail();
        }
        catch (CommandException e) {
            TestCoordinatorInputLogic.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E0803);
        }
    }

    public void testDryRun() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<or name=\"test\"><and><or><data-in dataset=\"A\" /><data-in dataset=\"B\" /></or><or><data-in dataset=\"C\" /><data-in dataset=\"D\" /></or></and><and><data-in dataset=\"A\" /><data-in dataset=\"B\" /></and></or>";
        conf.set("partitionName", "test");
        this._testCoordSubmit("coord-inputlogic.xml", conf, inputLogic, "", true);
    }

    public void testNestedCondition() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<or name=\"test\"><and><or><data-in dataset=\"A\" /><data-in dataset=\"B\" /></or><or><data-in dataset=\"C\" /><data-in dataset=\"D\" /></or></and><and><data-in dataset=\"A\" /><data-in dataset=\"B\" /></and></or>";
        conf.set("partitionName", "test");
        String jobId = this._testCoordSubmit("coord-inputlogic.xml", conf, inputLogic);
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        String input1 = this.createTestCaseSubDir("input-data/a/2014/10/08/00/_SUCCESS".split("/"));
        String input2 = this.createTestCaseSubDir("input-data/b/2014/10/08/00/_SUCCESS".split("/"));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)2);
        this.checkDataSets(dataSets, input1, input2);
    }

    public void testNestedCondition1() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<and name=\"test\"><or><and><data-in dataset=\"A\"/><data-in dataset=\"B\"/></and><and><data-in dataset=\"C\"/><data-in dataset=\"D\"/></and></or><and><data-in dataset=\"E\"/><data-in dataset=\"F\"/></and></and>";
        conf.set("partitionName", "test");
        conf.set("A_done_flag", "done");
        String jobId = this._testCoordSubmit("coord-inputlogic.xml", conf, inputLogic);
        String input1 = this.createTestCaseSubDir("input-data/a/2014/10/08/00/done".split("/"));
        String input2 = this.createTestCaseSubDir("input-data/b/2014/10/08/00/_SUCCESS".split("/"));
        String input3 = this.createTestCaseSubDir("input-data/e/2014/10/08/00/_SUCCESS".split("/"));
        String input4 = this.createTestCaseSubDir("input-data/f/2014/10/08/00/_SUCCESS".split("/"));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)4);
        this.checkDataSets(dataSets, input1.replace("/done", ""), input2, input3, input4);
    }

    public void testNestedCondition2() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<or name=\"${partitionName}\"><and><data-in dataset=\"A\" /><data-in dataset=\"B\" /><data-in dataset=\"C\" /><data-in dataset=\"D\" /></and><and><data-in dataset=\"E\" /><data-in dataset=\"F\" /></and></or>";
        conf.set("partitionName", "test");
        conf.set("A_done_flag", "done");
        String jobId = this._testCoordSubmit("coord-inputlogic.xml", conf, inputLogic);
        String input1 = this.createTestCaseSubDir("input-data/a/2014/10/08/00/done".split("/"));
        String input2 = this.createTestCaseSubDir("input-data/b/2014/10/08/00/_SUCCESS".split("/"));
        String input3 = this.createTestCaseSubDir("input-data/c/2014/10/08/00/_SUCCESS".split("/"));
        String input4 = this.createTestCaseSubDir("input-data/e/2014/10/08/00/_SUCCESS".split("/"));
        String input5 = this.createTestCaseSubDir("input-data/f/2014/10/08/00/_SUCCESS".split("/"));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)2);
        this.checkDataSets(dataSets, input4, input5);
        this.checkDataSetsForFalse(dataSets, input1, input2, input3);
    }

    public void testNestedCondition3() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<and name=\"test\"><and><data-in dataset=\"A\" /><data-in dataset=\"B\" /></and><and><data-in dataset=\"C\" /><data-in dataset=\"D\" /></and><and><data-in dataset=\"E\" /><data-in dataset=\"F\" /></and></and>";
        conf.set("partitionName", "test");
        String jobId = this._testCoordSubmit("coord-inputlogic.xml", conf, inputLogic);
        String input1 = this.createTestCaseSubDir("input-data/a/2014/10/08/00/_SUCCESS".split("/"));
        String input2 = this.createTestCaseSubDir("input-data/b/2014/10/08/00/_SUCCESS".split("/"));
        String input3 = this.createTestCaseSubDir("input-data/c/2014/10/08/00/_SUCCESS".split("/"));
        String input4 = this.createTestCaseSubDir("input-data/d/2014/10/08/00/_SUCCESS".split("/"));
        String input5 = this.createTestCaseSubDir("input-data/e/2014/10/08/00/_SUCCESS".split("/"));
        String input6 = this.createTestCaseSubDir("input-data/f/2014/10/08/00/_SUCCESS".split("/"));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)6);
        this.checkDataSets(dataSets, input1, input2, input3, input4, input5, input6);
    }

    public void testSimpleOr() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<or name=\"test\"><data-in dataset=\"A\" /><data-in dataset=\"B\" /></or>";
        conf.set("partitionName", "test");
        String jobId = this._testCoordSubmit("coord-inputlogic.xml", conf, inputLogic);
        String input1 = this.createTestCaseSubDir("input-data/a/2014/10/08/00/_SUCCESS".split("/"));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)1);
        this.checkDataSets(dataSets, input1);
    }

    public void testSimpleOr1() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<or name=\"test\"><and><data-in dataset=\"C\" /><data-in dataset=\"D\" /></and><or><data-in dataset=\"A\" /><data-in dataset=\"B\" /></or></or>";
        String jobId = this._testCoordSubmit("coord-inputlogic.xml", conf, inputLogic);
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertEquals((Object)actionBean.getStatus(), (Object)CoordinatorAction.Status.WAITING);
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        String input1 = this.createTestCaseSubDir("input-data/b/2014/10/08/00/_SUCCESS".split("/"));
        this.startCoordAction(jobId);
        actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)1);
        this.checkDataSets(dataSets, input1);
    }

    public void testOrWithMin() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<or name=\"test\"><data-in dataset=\"A\" min=\"3\"/><data-in dataset=\"B\" min=\"3\"/></or>";
        conf.set("initial_instance_a", "2014-10-07T00:00Z");
        conf.set("initial_instance_b", "2014-10-07T00:00Z");
        String jobId = this._testCoordSubmit("coord-inputlogic-range.xml", conf, inputLogic, this.getInputEventForRange());
        String input1 = this.createTestCaseSubDir("input-data/a/2014/10/08/00/_SUCCESS".split("/"));
        String input2 = this.createTestCaseSubDir("input-data/a/2014/10/07/23/_SUCCESS".split("/"));
        String input3 = this.createTestCaseSubDir("input-data/b/2014/10/07/21/_SUCCESS".split("/"));
        String input4 = this.createTestCaseSubDir("input-data/b/2014/10/07/20/_SUCCESS".split("/"));
        String input5 = this.createTestCaseSubDir("input-data/b/2014/10/07/19/_SUCCESS".split("/"));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)3);
        this.checkDataSets(dataSets, input3, input4, input5);
    }

    public void testAndWithMin() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<and name=\"test\"><data-in dataset=\"A\" min=\"2\"/><data-in dataset=\"B\" min=\"3\"/><data-in dataset=\"C\" min=\"0\"/></and>";
        conf.set("initial_instance_a", "2014-10-07T00:00Z");
        conf.set("initial_instance_b", "2014-10-07T00:00Z");
        String jobId = this._testCoordSubmit("coord-inputlogic-range.xml", conf, inputLogic, this.getInputEventForRange());
        String input1 = this.createTestCaseSubDir("input-data/a/2014/10/08/00/_SUCCESS".split("/"));
        String input2 = this.createTestCaseSubDir("input-data/a/2014/10/07/23/_SUCCESS".split("/"));
        String input3 = this.createTestCaseSubDir("input-data/b/2014/10/07/21/_SUCCESS".split("/"));
        String input4 = this.createTestCaseSubDir("input-data/b/2014/10/07/20/_SUCCESS".split("/"));
        String input5 = this.createTestCaseSubDir("input-data/b/2014/10/07/19/_SUCCESS".split("/"));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)5);
        this.checkDataSets(dataSets, input1, input2, input3, input4, input5, input5);
    }

    public void testMultipleInstance() throws Exception {
        Configuration conf = this.getConf();
        Date now = new Date();
        String inputLogic = "<and name=\"test\"><data-in dataset=\"A\" min=\"2\"/><data-in dataset=\"B\"/></and>";
        String event = "<data-in name=\"A\" dataset=\"a\"><instance>${coord:current(-5)}</instance><instance>${coord:latest(-1)}</instance><instance>${coord:futureRange(0,2,10)}</instance></data-in><data-in name=\"B\" dataset=\"b\"><instance>${coord:latest(0)}</instance><instance>${coord:latestRange(-3,0)}</instance></data-in>";
        conf.set("start_time", DateUtils.formatDateOozieTZ((Date)now));
        conf.set("end_time", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() + 10800000L)));
        conf.set("initial_instance_a", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 18000000L)));
        conf.set("initial_instance_b", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 18000000L)));
        String jobId = this._testCoordSubmit("coord-inputlogic-range.xml", conf, inputLogic, event);
        List<String> inputDir = this.createDirWithTime("input-data/a/", now, 3, 5, 0, -1, -2);
        inputDir.addAll(this.createDirWithTime("input-data/b/", now, 0, 1));
        this.startCoordActionForWaiting(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertTrue((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        inputDir.addAll(this.createDirWithTime("input-data/b/", now, 2, 3));
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)10);
        this.checkDataSets(dataSets, inputDir.toArray(new String[inputDir.size()]));
    }

    public void testAnd() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<and name=\"test\"><data-in dataset=\"A\"/><data-in dataset=\"B\"/></and>";
        String jobId = this._testCoordSubmit("coord-inputlogic.xml", conf, inputLogic);
        String input1 = this.createTestCaseSubDir("input-data/a/2014/10/08/00/_SUCCESS".split("/"));
        String input2 = this.createTestCaseSubDir("input-data/b/2014/10/08/00/_SUCCESS".split("/"));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)2);
        this.checkDataSets(dataSets, input1, input2);
    }

    public void testCombine() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<combine name=\"test\"><data-in dataset=\"A\" /><data-in dataset=\"B\" /></combine>";
        conf.set("initial_instance_a", "2014-10-07T00:00Z");
        conf.set("initial_instance_b", "2014-10-07T00:00Z");
        String jobId = this._testCoordSubmit("coord-inputlogic-range.xml", conf, inputLogic, this.getInputEventForRange());
        String input1 = this.createTestCaseSubDir("input-data/a/2014/10/08/00/_SUCCESS".split("/"));
        String input2 = this.createTestCaseSubDir("input-data/a/2014/10/07/23/_SUCCESS".split("/"));
        String input3 = this.createTestCaseSubDir("input-data/a/2014/10/07/22/_SUCCESS".split("/"));
        String input4 = this.createTestCaseSubDir("input-data/b/2014/10/07/21/_SUCCESS".split("/"));
        String input5 = this.createTestCaseSubDir("input-data/b/2014/10/07/20/_SUCCESS".split("/"));
        String input6 = this.createTestCaseSubDir("input-data/b/2014/10/07/19/_SUCCESS".split("/"));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)6);
        this.checkDataSets(dataSets, input1, input2, input3, input4, input5, input6);
    }

    public void testCombineNegative() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<combine name=\"test\"><data-in dataset=\"A\" /><data-in dataset=\"B\" /></combine>";
        conf.set("initial_instance_a", "2014-10-07T00:00Z");
        conf.set("initial_instance_b", "2014-10-07T00:00Z");
        final String jobId = this._testCoordSubmit("coord-inputlogic-range.xml", conf, inputLogic, this.getInputEventForRange());
        this.createTestCaseSubDir("input-data/a/2014/10/08/00/_SUCCESS".split("/"));
        this.createTestCaseSubDir("input-data/a/2014/10/07/23/_SUCCESS".split("/"));
        this.createTestCaseSubDir("input-data/b/2014/10/07/21/_SUCCESS".split("/"));
        this.createTestCaseSubDir("input-data/b/2014/10/07/20/_SUCCESS".split("/"));
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
                return !actionBean.getStatus().equals((Object)CoordinatorAction.Status.WAITING);
            }
        });
        CoordinatorAction actionBean = (CoordinatorAction)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertEquals((Object)actionBean.getStatus(), (Object)CoordinatorAction.Status.WAITING);
    }

    public void testSingeSetWithMin() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<or name=\"test\"><data-in dataset=\"A\" min=\"3\" /></or>";
        conf.set("initial_instance_a", "2014-10-07T00:00Z");
        conf.set("initial_instance_b", "2014-10-07T00:00Z");
        String jobId = this._testCoordSubmit("coord-inputlogic-range.xml", conf, inputLogic, this.getInputEventForRange());
        String input1 = this.createTestCaseSubDir("input-data/a/2014/10/08/00/_SUCCESS".split("/"));
        String input2 = this.createTestCaseSubDir("input-data/a/2014/10/07/23/_SUCCESS".split("/"));
        String input3 = this.createTestCaseSubDir("input-data/a/2014/10/07/19/_SUCCESS".split("/"));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)3);
        this.checkDataSets(dataSets, input1, input2, input3);
    }

    public void testCombineWithMin() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<combine name=\"test\" min=\"4\"><data-in dataset=\"A\" /><data-in dataset=\"B\" /></combine>";
        conf.set("initial_instance_a", "2014-10-07T00:00Z");
        conf.set("initial_instance_b", "2014-10-07T00:00Z");
        String jobId = this._testCoordSubmit("coord-inputlogic-range.xml", conf, inputLogic, this.getInputEventForRange());
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        String input1 = this.createTestCaseSubDir("input-data/a/2014/10/08/00/_SUCCESS".split("/"));
        String input2 = this.createTestCaseSubDir("input-data/a/2014/10/07/23/_SUCCESS".split("/"));
        String input3 = this.createTestCaseSubDir("input-data/a/2014/10/07/22/_SUCCESS".split("/"));
        String input4 = this.createTestCaseSubDir("input-data/b/2014/10/07/21/_SUCCESS".split("/"));
        String input5 = this.createTestCaseSubDir("input-data/b/2014/10/07/20/_SUCCESS".split("/"));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)5);
        this.checkDataSets(dataSets, input1, input2, input3, input4, input5);
    }

    public void testMinWait() throws Exception {
        Configuration conf = this.getConf();
        Date now = new Date();
        String inputLogic = "<combine name=\"test\" min= \"4\" wait=\"1\"><data-in dataset=\"A\" /><data-in dataset=\"B\" /></combine>";
        conf.set("start_time", DateUtils.formatDateOozieTZ((Date)now));
        conf.set("end_time", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() + 10800000L)));
        conf.set("initial_instance_a", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 18000000L)));
        conf.set("initial_instance_b", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 18000000L)));
        String jobId = this._testCoordSubmit("coord-inputlogic-range.xml", conf, inputLogic, this.getInputEventForRange());
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        List<String> inputDir = this.createDirWithTime("input-data/b/", now, 0, 1, 2, 3, 4);
        this.startCoordActionForWaiting(jobId);
        this.sleep(60000);
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)5);
        this.checkDataSets(dataSets, inputDir.toArray(new String[inputDir.size()]));
    }

    public void testWait() throws Exception {
        Configuration conf = this.getConf();
        Date now = new Date();
        String inputLogic = "<combine name=\"test\" wait=\"1\"><data-in dataset=\"A\" /><data-in dataset=\"B\" /></combine>";
        conf.set("start_time", DateUtils.formatDateOozieTZ((Date)now));
        conf.set("end_time", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() + 10800000L)));
        conf.set("initial_instance_a", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 18000000L)));
        conf.set("initial_instance_b", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 18000000L)));
        String jobId = this._testCoordSubmit("coord-inputlogic-range.xml", conf, inputLogic, this.getInputEventForRange());
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        List<String> inputDir = this.createDirWithTime("input-data/b/", now, 0, 1, 2, 3, 4);
        this.startCoordActionForWaiting(jobId);
        this.sleep(60000);
        inputDir.addAll(this.createDirWithTime("input-data/b/", now, 5));
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)6);
        this.checkDataSets(dataSets, inputDir.toArray(new String[inputDir.size()]));
    }

    public void testWaitFail() throws Exception {
        Configuration conf = this.getConf();
        Date now = new Date();
        String inputLogic = "<or name=\"test\" min=\"${min}\" wait=\"${wait}\"><data-in dataset=\"${dataA}\" /><data-in dataset=\"${dataB}\" /></or>";
        conf.set("start_time", DateUtils.formatDateOozieTZ((Date)now));
        conf.set("min", "4");
        conf.set("wait", "180");
        conf.set("dataA", "A");
        conf.set("dataB", "B");
        conf.set("end_time", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() + 10800000L)));
        conf.set("initial_instance_a", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 18000000L)));
        conf.set("initial_instance_b", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 18000000L)));
        String jobId = this._testCoordSubmit("coord-inputlogic-range.xml", conf, inputLogic, this.getInputEventForRange());
        this.createDirWithTime("input-data/b/", now, 0, 1, 2, 3, 4);
        this.startCoordActionForWaiting(jobId);
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertTrue((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
    }

    public void testLatest() throws Exception {
        Configuration conf = this.getConf();
        conf.set("initial_instance_a", "2014-10-07T00:00Z");
        conf.set("initial_instance_b", "2014-10-07T00:00Z");
        String inputLogic = "<data-in name=\"test\" dataset=\"A\"/>";
        String jobId = this._testCoordSubmit("coord-inputlogic-latest.xml", conf, inputLogic);
        String input1 = this.createTestCaseSubDir("input-data/a/2014/10/08/00/_SUCCESS".split("/"));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)1);
        this.checkDataSets(dataSets, input1);
    }

    public void testLatestRange() throws Exception {
        Configuration conf = this.getConf();
        Date now = new Date();
        conf.set("start_time", DateUtils.formatDateOozieTZ((Date)now));
        conf.set("end_time", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() + 10800000L)));
        conf.set("initial_instance_a", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 18000000L)));
        conf.set("initial_instance_b", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 18000000L)));
        String inputLogic = "<data-in name=\"test\" dataset=\"A\" min =\"2\" />";
        String jobId = this._testCoordSubmit("coord-inputlogic-range-latest.xml", conf, inputLogic);
        this.createDirWithTime("input-data/a/", now, 0, 1);
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordinatorInputLogic.assertEquals((int)dataSets.split(",").length, (int)2);
    }

    public void testCoordWithoutInputCheck() throws Exception {
        XConfiguration conf = new XConfiguration();
        String jobId = this.setupCoord((Configuration)conf, "coord-multiple-input-instance3.xml");
        this.sleep(1000);
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        CoordinatorAction actionBean = (CoordinatorAction)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertEquals((String)actionBean.getMissingDependencies(), (String)"!!${coord:latest(0)}#${coord:latest(-1)}");
    }

    private String _testCoordSubmit(String coordinatorXml, Configuration conf, String inputLogic) throws Exception {
        return this._testCoordSubmit(coordinatorXml, conf, inputLogic, "", false);
    }

    private String _testCoordSubmit(String coordinatorXml, Configuration conf, String inputLogic, String inputEvent) throws Exception {
        return this._testCoordSubmit(coordinatorXml, conf, inputLogic, inputEvent, false);
    }

    private String _testCoordSubmit(String coordinatorXml, Configuration conf, String inputLogic, String inputEvent, boolean dryRun) throws Exception {
        String appPath = "file://" + this.getTestCaseDir() + File.separator + "coordinator.xml";
        String content = IOUtils.getResourceAsString((String)coordinatorXml, (int)-1);
        content = content.replace("=input-logic=", inputLogic);
        content = content.replace("=input-events=", inputEvent);
        FileWriter writer = new FileWriter(new URI(appPath).getPath());
        IOUtils.copyCharStream((Reader)new StringReader(content), (Writer)writer);
        conf.set("oozie.coord.application.path", appPath);
        conf.set("user.name", TestCoordinatorInputLogic.getTestUser());
        conf.set("nameNode", "hdfs://localhost:9000");
        conf.set("queueName", "default");
        conf.set("jobTracker", "localhost:9001");
        conf.set("examplesRoot", "examples");
        if (conf.get("A_done_flag") == null) {
            conf.set("A_done_flag", "_SUCCESS");
        }
        return (String)new CoordSubmitXCommand(dryRun, conf).call();
    }

    private Configuration getConf() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("data_set_a", "file://" + this.getTestCaseDir() + "/input-data/a");
        conf.set("data_set_b", "file://" + this.getTestCaseDir() + "/input-data/b");
        conf.set("data_set_c", "file://" + this.getTestCaseDir() + "/input-data/c");
        conf.set("data_set_d", "file://" + this.getTestCaseDir() + "/input-data/d");
        conf.set("data_set_e", "file://" + this.getTestCaseDir() + "/input-data/e");
        conf.set("data_set_f", "file://" + this.getTestCaseDir() + "/input-data/f");
        conf.set("partitionName", "test");
        conf.set("start_time", "2014-10-08T00:00Z");
        conf.set("end_time", "2015-10-08T00:00Z");
        conf.set("initial_instance_a", "2014-10-08T00:00Z");
        conf.set("initial_instance_b", "2014-10-08T00:00Z");
        conf.set("wfPath", this.getWFPath());
        return conf;
    }

    public String getWFPath() throws Exception {
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='map-reduce-wf'> <start to='end' /> <end name='end' /> </workflow-app>";
        this.writeToFile(appXml, workflowUri);
        return workflowUri;
    }

    private void writeToFile(String appXml, String appPath) throws IOException {
        File wf = new File(URI.create(appPath));
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(wf));
            out.println(appXml);
        }
    }

    public void checkDataSets(String dataSets, String ... values) {
        HashSet<String> inputDataSets = new HashSet<String>();
        for (String dataSet : dataSets.split(",")) {
            inputDataSets.add(dataSet.substring(dataSet.indexOf(this.getTestCaseDir())));
        }
        for (String value : values) {
            TestCoordinatorInputLogic.assertTrue((boolean)inputDataSets.contains(value.replace("/_SUCCESS", "")));
        }
    }

    public void checkDataSetsForFalse(String dataSets, String ... values) {
        HashSet<String> inputDataSets = new HashSet<String>();
        for (String dataSet : dataSets.split(",")) {
            inputDataSets.add(dataSet.substring(dataSet.indexOf(this.getTestCaseDir())));
        }
        for (String value : values) {
            TestCoordinatorInputLogic.assertFalse((boolean)inputDataSets.contains(value));
        }
    }

    private void startCoordAction(String jobId) throws CommandException, JPAExecutorException {
        this.startCoordAction(jobId, CoordinatorAction.Status.WAITING);
    }

    private void startCoordAction(final String jobId, CoordinatorAction.Status coordActionStatus) throws CommandException, JPAExecutorException {
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        this.waitFor(50000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
                return !actionBean.getStatus().equals((Object)CoordinatorAction.Status.WAITING);
            }
        });
        CoordinatorAction actionBean = (CoordinatorAction)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertFalse((boolean)actionBean.getStatus().equals((Object)coordActionStatus));
        CoordinatorJobBean coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{jobId});
        new CoordActionStartXCommand(actionBean.getId(), coordJob.getUser(), coordJob.getAppName(), actionBean.getJobId()).call();
    }

    private void startCoordActionForWaiting(final String jobId) throws CommandException, JPAExecutorException, JDOMException {
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
                return !actionBean.getStatus().equals((Object)CoordinatorAction.Status.WAITING);
            }
        });
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordinatorInputLogic.assertTrue((String)"should be waiting", (boolean)actionBean.getStatus().equals((Object)CoordinatorAction.Status.WAITING));
    }

    private String setupCoord(Configuration conf, String coordFile) throws CommandException, IOException {
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        Reader reader = IOUtils.getResourceAsReader((String)coordFile, (int)-1);
        FileWriter writer = new FileWriter(appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordinatorInputLogic.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand(conf);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        sc = new CoordSubmitXCommand(conf);
        return (String)sc.call();
    }

    private String getInputEventForRange() {
        return "<data-in name=\"A\" dataset=\"a\"><start-instance>${coord:current(-5)}</start-instance><end-instance>${coord:current(0)}</end-instance></data-in><data-in name=\"B\" dataset=\"b\"><start-instance>${coord:current(-5)}</start-instance><end-instance>${coord:current(0)}</end-instance></data-in><data-in name=\"C\" dataset=\"c\"><start-instance>${coord:current(-5)}</start-instance> <end-instance>${coord:current(0)}</end-instance></data-in><data-in name=\"D\" dataset=\"d\"><start-instance>${coord:current(-5)}</start-instance><end-instance>${coord:current(0)}</end-instance></data-in><data-in name=\"E\" dataset=\"e\"><start-instance>${coord:current(-5)}</start-instance><end-instance>${coord:current(0)}</end-instance></data-in><data-in name=\"F\" dataset=\"f\"><start-instance>${coord:current(-5)}</start-instance> <end-instance>${coord:current(0)}</end-instance></data-in>";
    }

    public List<String> createDirWithTime(String dirPrefix, Date date, int ... hours) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy/MM/dd/HH");
        TimeZone tzUTC = TimeZone.getTimeZone("UTC");
        sd.setTimeZone(tzUTC);
        ArrayList<String> createdDirPath = new ArrayList<String>();
        for (int hour : hours) {
            createdDirPath.add(this.createTestCaseSubDir((dirPrefix + sd.format(new Date(date.getTime() - (long)(hour * 60 * 60 * 1000))) + "/_SUCCESS").split("/")));
        }
        return createdDirPath;
    }
}

