/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord.input.logic;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionInputCheckXCommand;
import org.apache.oozie.command.coord.CoordActionStartXCommand;
import org.apache.oozie.command.coord.CoordMaterializeTransitionXCommand;
import org.apache.oozie.command.coord.CoordPushDependencyCheckXCommand;
import org.apache.oozie.command.coord.CoordSubmitXCommand;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XHCatTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.JDOMException;

public class TestCoordInputLogicPush
extends XHCatTestCase {
    private Services services;
    private String server;
    private static final String table = "table1";
    final long TIME_DAYS = 86400000L;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.services = super.setupServicesForHCatalog();
        this.services.init();
        this.createTestTable();
        this.server = this.getMetastoreAuthority();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
        this.dropTestTable();
    }

    private void createSingleTestTable(String db) throws Exception {
        this.dropTable(db, table, true);
        this.dropDatabase(db, true);
        this.createDatabase(db);
        this.createTable(db, table, "dt,country");
    }

    private void createTestTable() throws Exception {
        this.createSingleTestTable("db_a");
        this.createSingleTestTable("db_b");
        this.createSingleTestTable("db_c");
        this.createSingleTestTable("db_d");
        this.createSingleTestTable("db_e");
        this.createSingleTestTable("db_f");
    }

    private void dropSingleTestTable(String db) throws Exception {
        this.dropTable(db, table, false);
        this.dropDatabase(db, false);
    }

    private void dropTestTable() throws Exception {
        this.dropSingleTestTable("db_a");
        this.dropSingleTestTable("db_b");
        this.dropSingleTestTable("db_c");
        this.dropSingleTestTable("db_d");
        this.dropSingleTestTable("db_e");
        this.dropSingleTestTable("db_f");
    }

    public void testExists() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<or name=\"test\"><data-in dataset=\"B\" /><data-in dataset=\"D\" /></or>";
        conf.set("partitionName", "test");
        String jobId = this._testCoordSubmit("coord-inputlogic-hcat.xml", conf, inputLogic, TEST_TYPE.CURRENT_SINGLE);
        String input = this.addPartition("db_b", table, "dt=20141008;country=usa");
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        Configuration runConf = this.getActionConf(actionBean);
        String dataSets = runConf.get("inputLogicData");
        TestCoordInputLogicPush.assertEquals((int)dataSets.split(",").length, (int)1);
        this.checkDataSets(dataSets, input);
    }

    public void testNestedCondition3() throws Exception {
        Configuration conf = this.getConf();
        String inputLogic = "<and name=\"test\"><and><data-in dataset=\"A\" /><data-in dataset=\"B\" /></and><and><data-in dataset=\"C\" /><data-in dataset=\"D\" /></and><and><data-in dataset=\"E\" /><data-in dataset=\"F\" /></and></and>";
        conf.set("partitionName", "test");
        String jobId = this._testCoordSubmit("coord-inputlogic-hcat.xml", conf, inputLogic, TEST_TYPE.CURRENT_SINGLE);
        String input1 = this.addPartition("db_a", table, "dt=20141008;country=usa");
        String input2 = this.addPartition("db_b", table, "dt=20141008;country=usa");
        String input3 = this.addPartition("db_c", table, "dt=20141008;country=usa");
        String input4 = this.addPartition("db_d", table, "dt=20141008;country=usa");
        String input5 = this.addPartition("db_e", table, "dt=20141008;country=usa");
        String input6 = this.addPartition("db_f", table, "dt=20141008;country=usa");
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        Configuration runConf = this.getActionConf(actionBean);
        String dataSets = runConf.get("inputLogicData");
        TestCoordInputLogicPush.assertEquals((int)dataSets.split(",").length, (int)6);
        this.checkDataSets(dataSets, input1, input2, input3, input4, input5, input6);
    }

    public void testNestedConditionWithRange() throws Exception {
        Configuration conf = this.getConfForCombine();
        Date now = new Date();
        conf.set("start_time", DateUtils.formatDateOozieTZ((Date)now));
        conf.set("end_time", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() + 864000000L)));
        conf.set("initial_instance_a", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 432000000L)));
        conf.set("initial_instance_b", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 432000000L)));
        String inputLogic = "<and name=\"test\" min=\"2\" ><or min=\"2\"><data-in dataset=\"A\" /><data-in dataset=\"B\" /></or><or min=\"2\"><data-in dataset=\"C\" /><data-in dataset=\"D\" /></or><and min=\"2\"><data-in dataset=\"A\" /><data-in dataset=\"C\" /></and></and>";
        conf.set("partitionName", "test");
        String jobId = this._testCoordSubmit("coord-inputlogic-hcat.xml", conf, inputLogic, TEST_TYPE.CURRENT_RANGE, TEST_TYPE.LATEST_RANGE);
        List<String> inputPartition = this.createPartitionWithTime("db_a", now, 0, 1, 2);
        inputPartition.addAll(this.createPartitionWithTime("db_c", now, 0, 1, 2));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        Configuration runConf = this.getActionConf(actionBean);
        String dataSets = runConf.get("inputLogicData");
        TestCoordInputLogicPush.assertEquals((int)dataSets.split(",").length, (int)12);
        this.checkDataSets(dataSets, inputPartition.toArray(new String[inputPartition.size()]));
    }

    public void testLatestRange() throws Exception {
        Configuration conf = this.getConfForCombine();
        Date now = new Date();
        conf.set("start_time", DateUtils.formatDateOozieTZ((Date)now));
        conf.set("end_time", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() + 864000000L)));
        conf.set("initial_instance_a", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 432000000L)));
        conf.set("initial_instance_b", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 432000000L)));
        String inputLogic = "<and name=\"test\"><data-in dataset=\"A\" /><data-in dataset=\"B\" /></and>";
        String jobId = this._testCoordSubmit("coord-inputlogic-combine.xml", conf, inputLogic, TEST_TYPE.LATEST_RANGE);
        List<String> inputDir = this.createDirWithTime("input-data/b/", now, 0, 1, 2, 3, 4, 5);
        inputDir.addAll(this.createPartitionWithTime("db_a", now, 0, 1, 2, 3, 4, 5));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordInputLogicPush.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordInputLogicPush.assertEquals((int)dataSets.split(",").length, (int)12);
        this.checkDataSets(dataSets, inputDir.toArray(new String[inputDir.size()]));
    }

    public void testCurrentLatest() throws Exception {
        Configuration conf = this.getConfForCombine();
        Date now = new Date();
        conf.set("start_time", DateUtils.formatDateOozieTZ((Date)now));
        conf.set("end_time", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() + 864000000L)));
        conf.set("initial_instance_a", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 432000000L)));
        conf.set("initial_instance_b", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 432000000L)));
        String inputLogic = "<and name=\"test\"><data-in dataset=\"A\"/><data-in dataset=\"B\"/></and>";
        String jobId = this._testCoordSubmit("coord-inputlogic-combine.xml", conf, inputLogic, TEST_TYPE.LATEST_RANGE, TEST_TYPE.CURRENT_RANGE);
        List<String> inputDir = this.createDirWithTime("input-data/b/", now, 0, 1, 2, 3, 4, 5);
        inputDir.addAll(this.createPartitionWithTime("db_a", now, 0, 1, 2, 3, 4, 5));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordInputLogicPush.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordInputLogicPush.assertEquals((int)dataSets.split(",").length, (int)12);
        this.checkDataSets(dataSets, inputDir.toArray(new String[inputDir.size()]));
    }

    public void testLatestRangeComplex() throws Exception {
        Configuration conf = this.getConfForCombine();
        Date now = new Date();
        conf.set("start_time", DateUtils.formatDateOozieTZ((Date)now));
        conf.set("end_time", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() + 864000000L)));
        conf.set("initial_instance_a", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 432000000L)));
        conf.set("initial_instance_b", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 432000000L)));
        String inputLogic = "<or name=\"test\"><and><data-in name=\"testA\" dataset=\"A\" /><data-in name=\"testB\" dataset=\"B\" /></and><and name=\"test\"><data-in name=\"testC\" dataset=\"C\" /><data-in name=\"testD\" dataset=\"D\" /></and></or>";
        String jobId = this._testCoordSubmit("coord-inputlogic-combine.xml", conf, inputLogic, TEST_TYPE.LATEST_RANGE);
        List<String> inputDir = this.createDirWithTime("input-data/b/", now, 0, 1, 2, 3, 4, 5);
        inputDir.addAll(this.createPartitionWithTime("db_a", now, 0, 1, 2, 3, 4, 5));
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordInputLogicPush.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordInputLogicPush.assertEquals((int)dataSets.split(",").length, (int)12);
        this.checkDataSets(dataSets, inputDir.toArray(new String[inputDir.size()]));
    }

    public void testHcatHdfs() throws Exception {
        Configuration conf = this.getConfForCombine();
        conf.set("initial_instance_a", "2014-10-07T00:00Z");
        conf.set("initial_instance_b", "2014-10-07T00:00Z");
        String inputLogic = "<and name=\"test\"><data-in name=\"testA\" dataset=\"A\" /><data-in name=\"testB\" dataset=\"B\" /></and>";
        String jobId = this._testCoordSubmit("coord-inputlogic-combine.xml", conf, inputLogic, TEST_TYPE.CURRENT_SINGLE);
        String input1 = this.createTestCaseSubDir("input-data/b/2014/10/08/_SUCCESS".split("/"));
        String input2 = this.addPartition("db_a", table, "dt=20141008;country=usa");
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        new CoordPushDependencyCheckXCommand(jobId + "@1").call();
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordInputLogicPush.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordInputLogicPush.assertEquals((int)dataSets.split(",").length, (int)2);
        this.checkDataSets(dataSets, input1, input2);
    }

    public void testHcatHdfsLatest() throws Exception {
        Configuration conf = this.getConfForCombine();
        Date now = new Date();
        conf.set("start_time", DateUtils.formatDateOozieTZ((Date)now));
        conf.set("end_time", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() + 864000000L)));
        conf.set("initial_instance_a", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 432000000L)));
        conf.set("initial_instance_b", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 432000000L)));
        conf.set("initial_instance", DateUtils.formatDateOozieTZ((Date)new Date(now.getTime() - 432000000L)));
        SimpleDateFormat sd = new SimpleDateFormat("yyyy/MM/dd");
        TimeZone tzUTC = TimeZone.getTimeZone("UTC");
        sd.setTimeZone(tzUTC);
        String inputLogic = "<and name=\"test\" min = \"1\" ><data-in dataset=\"A\" /><data-in dataset=\"D\" /></and>";
        String jobId = this._testCoordSubmit("coord-inputlogic-combine.xml", conf, inputLogic, TEST_TYPE.LATEST_RANGE);
        String input1 = this.createTestCaseSubDir(("input-data/d/" + sd.format(now) + "/_SUCCESS").split("/"));
        sd = new SimpleDateFormat("yyyyMMdd");
        String input2 = this.addPartition("db_a", table, "dt=" + sd.format(now) + ";country=usa");
        this.startCoordAction(jobId);
        CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordInputLogicPush.assertFalse((boolean)CoordinatorAction.Status.WAITING.equals((Object)actionBean.getStatus()));
        XConfiguration runConf = new XConfiguration((Reader)new StringReader(actionBean.getRunConf()));
        String dataSets = runConf.get("inputLogicData");
        TestCoordInputLogicPush.assertEquals((int)dataSets.split(",").length, (int)2);
        this.checkDataSets(dataSets, input1, input2);
    }

    private Configuration getConf() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("start_time", "2014-10-08T00:00Z");
        conf.set("end_time", "2015-10-08T00:00Z");
        conf.set("initial_instance", "2014-10-08T00:00Z");
        String dataset1 = "hcat://" + this.getMetastoreAuthority();
        conf.set("data_set", dataset1.toString());
        conf.set("db_a", "db_a");
        conf.set("db_b", "db_b");
        conf.set("db_c", "db_c");
        conf.set("db_d", "db_d");
        conf.set("db_e", "db_e");
        conf.set("db_f", "db_f");
        conf.set("table", table);
        conf.set("wfPath", this.getWFPath());
        conf.set("partitionName", "test");
        return conf;
    }

    private Configuration getConfForCombine() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("start_time", "2014-10-08T00:00Z");
        conf.set("end_time", "2015-10-08T00:00Z");
        conf.set("initial_instance", "2014-10-08T00:00Z");
        conf.set("data_set_b", "file://" + this.getTestCaseDir() + "/input-data/b");
        conf.set("data_set_d", "file://" + this.getTestCaseDir() + "/input-data/d");
        conf.set("data_set_f", "file://" + this.getTestCaseDir() + "/input-data/f");
        conf.set("start_time", "2014-10-08T00:00Z");
        conf.set("end_time", "2015-10-08T00:00Z");
        conf.set("initial_instance_a", "2014-10-08T00:00Z");
        conf.set("initial_instance_b", "2014-10-08T00:00Z");
        String dataset1 = "hcat://" + this.getMetastoreAuthority();
        conf.set("data_set", dataset1.toString());
        conf.set("db_a", "db_a");
        conf.set("db_b", "db_b");
        conf.set("db_c", "db_c");
        conf.set("db_d", "db_d");
        conf.set("db_e", "db_e");
        conf.set("db_f", "db_f");
        conf.set("table", table);
        conf.set("wfPath", this.getWFPath());
        conf.set("partitionName", "test");
        return conf;
    }

    private String _testCoordSubmit(String coordinatorXml, Configuration conf, String inputLogic, TEST_TYPE ... testType) throws Exception {
        String appPath = "file://" + this.getTestCaseDir() + File.separator + "coordinator.xml";
        String content = IOUtils.getResourceAsString((String)coordinatorXml, (int)-1);
        content = content.replaceAll("=input-logic=", inputLogic);
        for (int i = 1; i <= 6; ++i) {
            content = i - 1 < testType.length ? content.replaceAll("=data-in-param-" + i + "=", this.getEnumText(testType[i - 1])) : content.replaceAll("=data-in-param-" + i + "=", this.getEnumText(testType[testType.length - 1]));
        }
        FileWriter writer = new FileWriter(new URI(appPath).getPath());
        IOUtils.copyCharStream((Reader)new StringReader(content), (Writer)writer);
        conf.set("oozie.coord.application.path", appPath);
        conf.set("user.name", TestCoordInputLogicPush.getTestUser());
        conf.set("nameNode", "hdfs://localhost:9000");
        conf.set("queueName", "default");
        conf.set("jobTracker", "localhost:9001");
        conf.set("examplesRoot", "examples");
        String coordId = null;
        try {
            coordId = (String)new CoordSubmitXCommand(conf).call();
        }
        catch (CommandException e) {
            e.printStackTrace();
            TestCoordInputLogicPush.fail((String)("should not throw exception " + e.getMessage()));
        }
        return coordId;
    }

    public String getWFPath() throws Exception {
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='map-reduce-wf'> <start to='end' /> <end name='end' /> </workflow-app>";
        this.writeToFile(appXml, workflowUri);
        return workflowUri;
    }

    private void writeToFile(String appXml, String appPath) throws IOException {
        File wf = new File(URI.create(appPath));
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(wf));
            out.println(appXml);
        }
    }

    public void checkDataSets(String dataSets, String ... values) {
        HashSet<String> inputDataSets = new HashSet<String>();
        for (String dataSet : dataSets.split(",")) {
            if (dataSet.indexOf(this.getTestCaseDir()) >= 0) {
                inputDataSets.add(dataSet.substring(dataSet.indexOf(this.getTestCaseDir())));
                continue;
            }
            inputDataSets.add(dataSet);
        }
        for (String value : values) {
            TestCoordInputLogicPush.assertTrue((boolean)inputDataSets.contains(value.replace("/_SUCCESS", "")));
        }
    }

    private void startCoordAction(final String jobId) throws CommandException, JPAExecutorException {
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        new CoordPushDependencyCheckXCommand(jobId + "@1").call();
        new CoordActionInputCheckXCommand(jobId + "@1", jobId).call();
        this.waitFor(50000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
                return !actionBean.getStatus().equals((Object)CoordinatorAction.Status.WAITING);
            }
        });
        CoordinatorAction actionBean = (CoordinatorAction)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        TestCoordInputLogicPush.assertFalse((String)"Action status should not be waiting", (boolean)actionBean.getStatus().equals((Object)CoordinatorAction.Status.WAITING));
        this.waitFor(50000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorActionBean actionBean = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
                return !actionBean.getStatus().equals((Object)CoordinatorAction.Status.READY);
            }
        });
        CoordinatorJobBean coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{jobId});
        new CoordActionStartXCommand(actionBean.getId(), coordJob.getUser(), coordJob.getAppName(), actionBean.getJobId()).call();
    }

    public Configuration getActionConf(CoordinatorActionBean actionBean) throws JDOMException {
        XConfiguration conf = new XConfiguration();
        Element eAction = XmlUtils.parseXml((String)actionBean.getActionXml());
        Element configElem = eAction.getChild("action", eAction.getNamespace()).getChild("workflow", eAction.getNamespace()).getChild("configuration", eAction.getNamespace());
        List elementList = configElem.getChildren("property", eAction.getNamespace());
        for (Element element : elementList) {
            conf.set(((Element)element.getChildren().get(0)).getText(), ((Element)element.getChildren().get(1)).getText());
        }
        return conf;
    }

    private String getEnumText(TEST_TYPE testType) {
        switch (testType) {
            case LATEST_SINGLE: {
                return "<instance>\\${coord:latest(0)}</instance>";
            }
            case LATEST_RANGE: {
                return "<start-instance>\\${coord:latest(-5)}</start-instance><end-instance>\\${coord:latest(0)}</end-instance>";
            }
            case CURRENT_SINGLE: {
                return "<instance>\\${coord:current(0)}</instance>";
            }
            case CURRENT_RANGE: {
                return "<start-instance>\\${coord:current(-5)}</start-instance><end-instance>\\${coord:current(0)}</end-instance>";
            }
        }
        return "";
    }

    public List<String> createDirWithTime(String dirPrefix, Date date, int ... hours) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy/MM/dd");
        TimeZone tzUTC = TimeZone.getTimeZone("UTC");
        sd.setTimeZone(tzUTC);
        ArrayList<String> createdDirPath = new ArrayList<String>();
        for (int hour : hours) {
            createdDirPath.add(this.createTestCaseSubDir((dirPrefix + sd.format(new Date(date.getTime() - (long)hour * 86400000L)) + "/_SUCCESS").split("/")));
        }
        return createdDirPath;
    }

    public List<String> createPartitionWithTime(String database, Date date, int ... hours) throws Exception {
        ArrayList<String> createdPartition = new ArrayList<String>();
        SimpleDateFormat sd = new SimpleDateFormat("yyyyMMdd");
        TimeZone tzUTC = TimeZone.getTimeZone("UTC");
        sd.setTimeZone(tzUTC);
        for (int hour : hours) {
            createdPartition.add(this.addPartition(database, table, "dt=" + sd.format(new Date(date.getTime() - (long)hour * 86400000L)) + ";country=usa"));
        }
        return createdPartition;
    }

    @Override
    protected String addPartition(String db, String table, String partitionSpec) throws Exception {
        super.addPartition(db, table, partitionSpec);
        return "hcat://" + this.server + "/" + db + "/" + table + "/" + partitionSpec;
    }

    static enum TEST_TYPE {
        CURRENT_SINGLE,
        CURRENT_RANGE,
        LATEST_SINGLE,
        LATEST_RANGE;

    }
}

