/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.DagELFunctions;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.coord.CoordELFunctions;
import org.apache.oozie.coord.SyncCoordAction;
import org.apache.oozie.coord.SyncCoordDataset;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.dependency.FSURIHandler;
import org.apache.oozie.dependency.HCatURIHandler;
import org.apache.oozie.service.ELService;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XHCatTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;
import org.junit.Test;

public class TestHCatELFunctions
extends XHCatTestCase {
    ELEvaluator eval = null;
    SyncCoordAction appInst = null;
    SyncCoordDataset ds = null;
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.getConf().set("oozie.service.URIHandlerService.uri.handlers", FSURIHandler.class.getName() + "," + HCatURIHandler.class.getName());
        this.services.setService(HCatAccessorService.class);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    @Test
    public void testHCatExists() throws Exception {
        this.dropTable("db1", "table1", true);
        this.dropDatabase("db1", true);
        this.createDatabase("db1");
        this.createTable("db1", "table1", "year,month,dt,country");
        this.addPartition("db1", "table1", "year=2012;month=12;dt=02;country=us");
        Configuration protoConf = new Configuration();
        protoConf.set("user.name", TestHCatELFunctions.getTestUser());
        protoConf.set("hadoop.job.ugi", TestHCatELFunctions.getTestUser() + ",group");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", "appPath");
        conf.set("user.name", TestHCatELFunctions.getTestUser());
        conf.set("test.dir", this.getTestCaseDir());
        conf.set("partition1", this.getHCatURI("db1", "table1", "dt=02").toString());
        conf.set("partition2", this.getHCatURI("db1", "table1", "dt=05").toString());
        LiteWorkflowApp def = new LiteWorkflowApp("name", "<workflow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)conf, "wfId");
        WorkflowJobBean wf = new WorkflowJobBean();
        wf.setId(job.getId());
        wf.setAppName("name");
        wf.setAppPath("appPath");
        wf.setUser(TestHCatELFunctions.getTestUser());
        wf.setGroup("group");
        wf.setWorkflowInstance((WorkflowInstance)job);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        protoConf.writeXml((OutputStream)baos);
        wf.setProtoActionConf(baos.toString());
        WorkflowActionBean action = new WorkflowActionBean();
        action.setId("actionId");
        action.setName("actionName");
        ELEvaluator eval = ((ELService)Services.get().get(ELService.class)).createEvaluator("workflow");
        DagELFunctions.configureEvaluator((ELEvaluator)eval, (WorkflowJobBean)wf, (WorkflowActionBean)action);
        TestHCatELFunctions.assertEquals((boolean)true, (boolean)((Boolean)eval.evaluate("${hcat:exists(wf:conf('partition1'))}", Boolean.class)));
        TestHCatELFunctions.assertEquals((boolean)false, (boolean)((Boolean)eval.evaluate("${hcat:exists(wf:conf('partition2'))}", Boolean.class)));
        this.dropTable("db1", "table1", true);
        this.dropDatabase("db1", true);
    }

    @Test
    public void testDatabasePh1() throws Exception {
        this.init("coord-job-submit-data");
        String expr = "${coord:databaseIn('ABC')}";
        this.eval.setVariable("oozie.dataname.ABC", (Object)"data-in");
        TestHCatELFunctions.assertEquals((String)"${coord:databaseIn('ABC')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:databaseIn('ABCD')}";
        try {
            TestHCatELFunctions.assertEquals((String)"${coord:databaseIn('ABCD')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
            TestHCatELFunctions.fail((String)"should throw exception because Data-in ABCD is not defiend");
        }
        catch (Exception exception) {
            // empty catch block
        }
        expr = "${coord:databaseOut('ABC')}";
        this.eval.setVariable("oozie.dataname.ABC", (Object)"data-out");
        TestHCatELFunctions.assertEquals((String)"${coord:databaseOut('ABC')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:databaseOut('ABCD')}";
        try {
            TestHCatELFunctions.assertEquals((String)"${coord:databaseOut('ABCD')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
            TestHCatELFunctions.fail((String)"should throw exception because Data-out ABCD is not defiend");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init("coord-sla-submit");
        this.eval.setVariable("oozie.dataname.ABCD", (Object)"data-out");
        TestHCatELFunctions.assertEquals((String)"${coord:databaseOut('ABCD')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    @Test
    public void testTablePh1() throws Exception {
        this.init("coord-job-submit-data");
        String expr = "${coord:tableIn('ABC')}";
        this.eval.setVariable("oozie.dataname.ABC", (Object)"data-in");
        TestHCatELFunctions.assertEquals((String)"${coord:tableIn('ABC')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:tableIn('ABCD')}";
        try {
            TestHCatELFunctions.assertEquals((String)"${coord:tableIn('ABCD')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
            TestHCatELFunctions.fail((String)"should throw exception because Data-in ABCD is not defiend");
        }
        catch (Exception exception) {
            // empty catch block
        }
        expr = "${coord:tableOut('ABC')}";
        this.eval.setVariable("oozie.dataname.ABC", (Object)"data-out");
        TestHCatELFunctions.assertEquals((String)"${coord:tableOut('ABC')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:tableOut('ABCD')}";
        try {
            TestHCatELFunctions.assertEquals((String)"${coord:tableOut('ABCD')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
            TestHCatELFunctions.fail((String)"should throw exception because Data-out ABCD is not defiend");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init("coord-sla-submit");
        expr = "${coord:tableOut('ABC')}";
        this.eval.setVariable("oozie.dataname.ABC", (Object)"data-out");
        TestHCatELFunctions.assertEquals((String)"${coord:tableOut('ABC')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    @Test
    public void testdataInPartitionFilterPh1() throws Exception {
        this.init("coord-job-submit-data");
        String expr = "${coord:dataInPartitionFilter('ABC', 'pig')}";
        this.eval.setVariable("oozie.dataname.ABC", (Object)"data-in");
        TestHCatELFunctions.assertEquals((String)"${coord:dataInPartitionFilter('ABC', 'pig')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:dataInPartitionFilter('ABCD')}";
        this.eval.setVariable("oozie.dataname.ABCD", (Object)"data-in");
        try {
            TestHCatELFunctions.assertEquals((String)"${coord:dataInPartitionFilter('ABCD')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
            TestHCatELFunctions.fail((String)"should throw exception because dataInPartitionFilter() requires 2 parameters");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDataInPartitionMinPh1() throws Exception {
        this.init("coord-job-submit-data");
        String expr = "${coord:dataInPartitionMin('ABC', 'mypartition')}";
        this.eval.setVariable("oozie.dataname.ABC", (Object)"data-in");
        TestHCatELFunctions.assertEquals((String)"${coord:dataInPartitionMin('ABC', 'mypartition')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:dataInPartitionMin('ABCD')}";
        this.eval.setVariable("oozie.dataname.ABCD", (Object)"data-in");
        try {
            TestHCatELFunctions.assertEquals((String)"${coord:dataInPartitionMin('ABCD')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
            TestHCatELFunctions.fail((String)"should throw exception because EL function requires 2 parameters");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDataInPartitionMaxPh1() throws Exception {
        this.init("coord-job-submit-data");
        String expr = "${coord:dataInPartitionMax('ABC', 'mypartition')}";
        this.eval.setVariable("oozie.dataname.ABC", (Object)"data-in");
        TestHCatELFunctions.assertEquals((String)"${coord:dataInPartitionMax('ABC', 'mypartition')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:dataInPartitionMax('ABCD')}";
        this.eval.setVariable("oozie.dataname.ABCD", (Object)"data-in");
        try {
            TestHCatELFunctions.assertEquals((String)"${coord:dataInPartitionMax('ABCD')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
            TestHCatELFunctions.fail((String)"should throw exception because EL function requires 2 parameters");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDataInPartitionsPh1() throws Exception {
        this.init("coord-job-submit-data");
        String expr = "${coord:dataInPartitions('ABC', 'hive-export')}";
        this.eval.setVariable("oozie.dataname.ABC", (Object)"data-in");
        TestHCatELFunctions.assertEquals((String)"${coord:dataInPartitions('ABC', 'hive-export')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:dataInPartitions('ABCD', 'hive-export')}";
        try {
            CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
            TestHCatELFunctions.fail((String)"should throw exception because Data-in is not defined");
        }
        catch (Exception exception) {
            // empty catch block
        }
        expr = "${coord:dataInPartitions('ABCD')}";
        this.eval.setVariable("oozie.dataname.ABCD", (Object)"data-in");
        try {
            CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
            TestHCatELFunctions.fail((String)"should throw exception because EL function requires 2 parameters");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDataOutPartitionsPh1() throws Exception {
        this.init("coord-job-submit-data");
        String expr = "${coord:dataOutPartitions('ABC')}";
        this.eval.setVariable("oozie.dataname.ABC", (Object)"data-out");
        TestHCatELFunctions.assertEquals((String)"${coord:dataOutPartitions('ABC')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:dataOutPartitions('ABCD')}";
        try {
            TestHCatELFunctions.assertEquals((String)"${coord:dataOutPartitions('ABCD')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
            TestHCatELFunctions.fail((String)"should throw exception because Data-in is not defiend");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init("coord-sla-submit");
        this.eval.setVariable("oozie.dataname.ABCD", (Object)"data-out");
        TestHCatELFunctions.assertEquals((String)"${coord:dataOutPartitions('ABCD')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    @Test
    public void testDataOutPartitionValuePh1() throws Exception {
        this.init("coord-job-submit-data");
        String expr = "${coord:dataOutPartitionValue('ABC', 'mypartition')}";
        this.eval.setVariable("oozie.dataname.ABC", (Object)"data-out");
        TestHCatELFunctions.assertEquals((String)"${coord:dataOutPartitionValue('ABC', 'mypartition')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:dataOutPartitionValue('ABCD')}";
        this.eval.setVariable("oozie.dataname.ABCD", (Object)"data-out");
        try {
            TestHCatELFunctions.assertEquals((String)"${coord:dataOutPartitionValue('ABCD')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
            TestHCatELFunctions.fail((String)"should throw exception because EL function requires 2 parameters");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDatabase() throws Exception {
        this.init("coord-action-start", "hcat://hcat.server.com:5080/mydb/clicks/datastamp=12;region=us");
        this.eval.setVariable(".datain.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=12;region=us");
        this.eval.setVariable(".datain.ABC.unresolved", (Object)Boolean.FALSE);
        String expr = "${coord:databaseIn('ABC')}";
        TestHCatELFunctions.assertEquals((String)"mydb", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.eval.setVariable(".dataout.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=12;region=us");
        this.eval.setVariable(".dataout.ABC.unresolved", (Object)Boolean.FALSE);
        expr = "${coord:databaseOut('ABC')}";
        TestHCatELFunctions.assertEquals((String)"mydb", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    @Test
    public void testTable() throws Exception {
        this.init("coord-action-start", "hcat://hcat.server.com:5080/mydb/clicks/datastamp=12;region=us");
        this.eval.setVariable(".datain.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=12;region=us");
        this.eval.setVariable(".datain.ABC.unresolved", (Object)Boolean.FALSE);
        String expr = "${coord:tableIn('ABC')}";
        TestHCatELFunctions.assertEquals((String)"clicks", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.eval.setVariable(".dataout.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=12;region=us");
        this.eval.setVariable(".dataout.ABC.unresolved", (Object)Boolean.FALSE);
        expr = "${coord:tableOut('ABC')}";
        TestHCatELFunctions.assertEquals((String)"clicks", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.init("coord-sla-create", "hcat://hcat.server.com:5080/mydb/clicks/datastamp=12;region=us");
        this.eval.setVariable(".dataout.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=12;region=us");
        this.eval.setVariable(".dataout.ABC.unresolved", (Object)Boolean.FALSE);
        expr = "${coord:tableOut('ABC')}";
        TestHCatELFunctions.assertEquals((String)"clicks", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    @Test
    public void testdataInPartitionFilter() throws Exception {
        this.init("coord-action-start");
        this.eval.setVariable(".datain.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=12;region=us");
        this.eval.setVariable(".datain.ABC.unresolved", (Object)Boolean.FALSE);
        String expr = "${coord:dataInPartitionFilter('ABC', 'pig')}";
        String res = CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
        TestHCatELFunctions.assertTrue((res.equals("(datastamp=='12' AND region=='us')") || res.equals("(region=='us' AND datastamp=='12')") ? 1 : 0) != 0);
        this.eval.setVariable(".datain.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=12;region=us,hcat://hcat.server.com:5080/mydb/clicks/datastamp=13;region=us");
        this.eval.setVariable(".datain.ABC.unresolved", (Object)Boolean.FALSE);
        expr = "${coord:dataInPartitionFilter('ABC', 'pig')}";
        res = CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
        TestHCatELFunctions.assertTrue((res.equals("(datastamp=='12' AND region=='us') OR (datastamp=='13' AND region=='us')") || res.equals("(datastamp=='12' AND region=='us') OR (region=='us' AND datastamp=='13')") || res.equals("(region=='us' AND datastamp=='12') OR (datastamp=='13' AND region=='us')") || res.equals("(region=='us' AND datastamp=='12') OR (region=='us' AND datastamp=='13')") ? 1 : 0) != 0);
        this.eval.setVariable(".datain.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=12;region=us");
        this.eval.setVariable(".datain.ABC.unresolved", (Object)Boolean.FALSE);
        expr = "${coord:dataInPartitionFilter('ABC', 'java')}";
        res = CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
        TestHCatELFunctions.assertTrue((res.equals("(datastamp='12' AND region='us')") || res.equals("(region='us' AND datastamp='12')") ? 1 : 0) != 0);
    }

    @Test
    public void testDataOutPartitions() throws Exception {
        this.init("coord-action-start");
        String expr = "${coord:dataOutPartitions('ABC')}";
        this.eval.setVariable(".dataout.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=20120230;region=us");
        this.eval.setVariable(".dataout.ABC.unresolved", (Object)Boolean.FALSE);
        String res = CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
        TestHCatELFunctions.assertTrue((boolean)res.equals("'datastamp=20120230,region=us'"));
        this.init("coord-sla-create");
        this.eval.setVariable(".dataout.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=20130230;region=euro");
        this.eval.setVariable(".dataout.ABC.unresolved", (Object)Boolean.FALSE);
        res = CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
        TestHCatELFunctions.assertTrue((res.equals("'datastamp=20130230,region=us'") || res.equals("'datastamp=20130230,region=euro'") ? 1 : 0) != 0);
    }

    @Test
    public void testDataOutPartitionValue() throws Exception {
        this.init("coord-action-start");
        String expr = "${coord:dataOutPartitionValue('ABC','datastamp')}";
        this.eval.setVariable(".dataout.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=20120230;region=US");
        this.eval.setVariable(".dataout.ABC.unresolved", (Object)Boolean.FALSE);
        String res = CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
        TestHCatELFunctions.assertTrue((boolean)res.equals("20120230"));
        expr = "${coord:dataOutPartitionValue('ABC','region')}";
        res = CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
        TestHCatELFunctions.assertTrue((boolean)res.equals("US"));
        this.init("coord-sla-create");
        this.eval.setVariable(".dataout.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=20120230;region=US");
        this.eval.setVariable(".dataout.ABC.unresolved", (Object)Boolean.FALSE);
        expr = "${coord:dataOutPartitionValue('ABC','datastamp')}";
        res = CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
        TestHCatELFunctions.assertTrue((boolean)res.equals("20120230"));
        expr = "${coord:dataOutPartitionValue('ABC','region')}";
        res = CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
        TestHCatELFunctions.assertTrue((boolean)res.equals("US"));
    }

    @Test
    public void testDataInPartitionMin() throws Exception {
        this.init("coord-action-start");
        this.eval.setVariable(".datain.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=12;region=us,hcat://hcat.server.com:5080/mydb/clicks/datastamp=13;region=us,hcat://hcat.server.com:5080/mydb/clicks/datastamp=10;region=us");
        this.eval.setVariable(".datain.ABC.unresolved", (Object)Boolean.FALSE);
        String expr = "${coord:dataInPartitionMin('ABC','datastamp')}";
        String res = CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
        TestHCatELFunctions.assertTrue((boolean)res.equals("10"));
    }

    @Test
    public void testDataInPartitionMax() throws Exception {
        this.init("coord-action-start");
        this.eval.setVariable(".datain.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=20;region=us,hcat://hcat.server.com:5080/mydb/clicks/datastamp=12;region=us,hcat://hcat.server.com:5080/mydb/clicks/datastamp=13;region=us,hcat://hcat.server.com:5080/mydb/clicks/datastamp=10;region=us");
        this.eval.setVariable(".datain.ABC.unresolved", (Object)Boolean.FALSE);
        String expr = "${coord:dataInPartitionMax('ABC','datastamp')}";
        String res = CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
        TestHCatELFunctions.assertTrue((boolean)res.equals("20"));
    }

    @Test
    public void testDataInPartitions() throws Exception {
        this.init("coord-action-start");
        String expr = "${coord:dataInPartitions('ABC', 'hive-export')}";
        this.eval.setVariable(".datain.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=20120230;region=us");
        this.eval.setVariable(".datain.ABC.unresolved", (Object)Boolean.FALSE);
        String res = CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
        TestHCatELFunctions.assertTrue((res.equals("datastamp='20120230',region='us'") || res.equals("region='us',datastamp='20120230'") ? 1 : 0) != 0);
        try {
            expr = "${coord:dataInPartitions('ABC', 'invalid-type')}";
            this.eval.setVariable(".datain.ABC", (Object)"hcat://hcat.server.com:5080/mydb/clicks/datastamp=20120230;region=us");
            this.eval.setVariable(".datain.ABC.unresolved", (Object)Boolean.FALSE);
            res = CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
            TestHCatELFunctions.fail((String)"EL function should throw exception because of invalid type");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init(String tag) throws Exception {
        this.init(tag, "hdfs://localhost:9000/user/" + TestHCatELFunctions.getTestUser() + "/US/${YEAR}/${MONTH}/${DAY}");
    }

    private void init(String tag, String uriTemplate) throws Exception {
        this.eval = ((ELService)Services.get().get(ELService.class)).createEvaluator(tag);
        this.eval.setVariable("user.name", (Object)TestHCatELFunctions.getTestUser());
        this.eval.setVariable("group.name", (Object)TestHCatELFunctions.getTestGroup());
        this.appInst = new SyncCoordAction();
        this.ds = new SyncCoordDataset();
        this.ds.setFrequency(1);
        this.ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-09-01T23:59Z"));
        this.ds.setTimeUnit(TimeUnit.DAY);
        this.ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        this.ds.setName("test");
        this.ds.setUriTemplate(uriTemplate);
        this.ds.setType("SYNC");
        this.ds.setDoneFlag("");
        this.appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2009-09-10T23:59Z"));
        this.appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-09-09T23:59Z"));
        this.appInst.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        this.appInst.setActionId("00000-oozie-C@1");
        this.appInst.setName("mycoordinator-app");
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)this.ds, (SyncCoordAction)this.appInst);
    }
}

