/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.coord.CoordUtils;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.Pair;

public class TestCoordUtils
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        this.services.destroy();
        super.tearDown();
    }

    public void testGetCoordActionsFromIds() throws Exception {
        int actionNum = 1;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        String jobId = job.getId();
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(jobId, actionNum, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        List coordActions = CoordUtils.getCoordActionsFromIds((String)jobId, (String)Integer.toString(actionNum));
        TestCoordUtils.assertEquals((int)1, (int)coordActions.size());
        TestCoordUtils.assertEquals((Object)action1, coordActions.get(0));
    }

    public void testGetCoordActionsFromIdsRange() throws Exception {
        int actionNum1 = 1;
        int actionNum2 = 2;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        String jobId = job.getId();
        this.addRecordToCoordActionTable(jobId, actionNum1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(jobId, actionNum2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        String rerunScope = Integer.toString(actionNum1) + "-" + Integer.toString(actionNum2);
        List coordActions = CoordUtils.getCoordActionsFromIds((String)jobId, (String)rerunScope);
        TestCoordUtils.assertEquals((int)2, (int)coordActions.size());
    }

    public void testGetCoordActionsFromDate() throws Exception {
        int actionNum = 1;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        String jobId = job.getId();
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(jobId, actionNum, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml", 0);
        List coordActions = CoordUtils.getCoordActionsFromDates((String)jobId, (String)"2009-12-15T01:00Z", (boolean)false);
        TestCoordUtils.assertEquals((int)1, (int)coordActions.size());
        TestCoordUtils.assertEquals((Object)action1, coordActions.get(0));
    }

    public void testGetCoordActionsFromDateRange() throws Exception {
        int actionNum1 = 1;
        int actionNum2 = 2;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        String jobId = job.getId();
        this.addRecordToCoordActionTable(jobId, actionNum1, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml", 0);
        this.addRecordToCoordActionTable(jobId, actionNum2, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action2.xml", 0);
        String rerunScope = "2009-12-15T01:00Z::2009-12-16T01:00Z";
        List coordActions = CoordUtils.getCoordActionsFromDates((String)jobId, (String)rerunScope, (boolean)false);
        TestCoordUtils.assertEquals((int)2, (int)coordActions.size());
    }

    public void testGetWhereClause() throws Exception {
        HashMap filterMap = new HashMap();
        Pair STATUS_FILTER = Pair.of((Object)"status", (Object)CoordinatorEngine.FILTER_COMPARATORS.EQUALS);
        ArrayList<String> positiveFilter = new ArrayList<String>();
        positiveFilter.add("RUNNING");
        positiveFilter.add("KILLED");
        filterMap.put(STATUS_FILTER, positiveFilter);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query q = em.createNamedQuery("GET_COORD_ACTIONS_COUNT_BY_JOBID");
        String query = q.toString();
        StringBuilder sbTotal = new StringBuilder(query);
        StringBuilder statusClause = new StringBuilder();
        Map params = CoordUtils.getWhereClause((StringBuilder)statusClause, filterMap);
        sbTotal.insert(sbTotal.length(), statusClause);
        TestCoordUtils.assertTrue((boolean)sbTotal.toString().contains("and a.statusStr IN (:p1, :p2)"));
        TestCoordUtils.assertEquals(params.get("p1"), (Object)"RUNNING");
        TestCoordUtils.assertEquals(params.get("p2"), (Object)"KILLED");
    }
}

