/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.coord.CoordELFunctions;
import org.apache.oozie.coord.SyncCoordAction;
import org.apache.oozie.coord.SyncCoordDataset;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.service.ELService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ELEvaluator;

public class TestCoordELFunctions
extends XTestCase {
    ELEvaluator eval = null;
    SyncCoordAction appInst = null;
    SyncCoordDataset ds = null;
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testURIVars() throws Exception {
        this.init("coord-job-submit-freq");
        String expr = "${YEAR}";
        try {
            TestCoordELFunctions.assertEquals((String)expr, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
            TestCoordELFunctions.fail((String)"should throw exception beacuse coord-job-submit-freq doesn't resolve YEAR/MONTH/DAY");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init("coord-job-submit-nofuncs");
        TestCoordELFunctions.assertEquals((String)expr, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${MONTH}";
        TestCoordELFunctions.assertEquals((String)expr, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${DAY}";
        TestCoordELFunctions.assertEquals((String)expr, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${HOUR}";
        TestCoordELFunctions.assertEquals((String)expr, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${MINUTE}";
        TestCoordELFunctions.assertEquals((String)expr, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testDay() throws Exception {
        this.init("coord-job-submit-freq");
        String expr = "${coord:days(1)}";
        TestCoordELFunctions.assertEquals((String)"1", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        TestCoordELFunctions.assertEquals((Object)TimeUnit.DAY, (Object)((TimeUnit)this.eval.getVariable("timeunit")));
        expr = "${coord:days(256)}";
        TestCoordELFunctions.assertEquals((String)"256", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        TestCoordELFunctions.assertEquals((Object)TimeUnit.DAY, (Object)((TimeUnit)this.eval.getVariable("timeunit")));
    }

    public void testMonth() throws Exception {
        this.init("coord-job-submit-freq");
        String expr = "${coord:months(1)}";
        TestCoordELFunctions.assertEquals((String)"1", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        TestCoordELFunctions.assertEquals((Object)TimeUnit.MONTH, (Object)((TimeUnit)this.eval.getVariable("timeunit")));
        expr = "${coord:months(1) + 7}";
        TestCoordELFunctions.assertEquals((String)"8", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        TestCoordELFunctions.assertEquals((Object)TimeUnit.MONTH, (Object)((TimeUnit)this.eval.getVariable("timeunit")));
        expr = "${coord:months(256)}";
        TestCoordELFunctions.assertEquals((String)"256", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        TestCoordELFunctions.assertEquals((Object)TimeUnit.MONTH, (Object)((TimeUnit)this.eval.getVariable("timeunit")));
        expr = "${coord:months(coord:months(7))}";
        TestCoordELFunctions.assertEquals((String)"7", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        TestCoordELFunctions.assertEquals((Object)TimeUnit.MONTH, (Object)((TimeUnit)this.eval.getVariable("timeunit")));
    }

    public void testHours() throws Exception {
        this.init("coord-job-submit-freq");
        String expr = "${coord:hours(1)}";
        TestCoordELFunctions.assertEquals((String)"60", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        TestCoordELFunctions.assertEquals((Object)TimeUnit.MINUTE, (Object)((TimeUnit)this.eval.getVariable("timeunit")));
        expr = "${coord:hours(coord:hours(1))}";
        TestCoordELFunctions.assertEquals((String)"3600", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        TestCoordELFunctions.assertEquals((Object)TimeUnit.MINUTE, (Object)((TimeUnit)this.eval.getVariable("timeunit")));
    }

    public void testEndOfDays() throws Exception {
        this.init("coord-job-submit-freq");
        String expr = "${coord:endOfDays(1)}";
        expr = "${coord:endOfDays(3)}";
        TestCoordELFunctions.assertEquals((String)"3", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        TestCoordELFunctions.assertEquals((Object)TimeUnit.DAY, (Object)((TimeUnit)this.eval.getVariable("timeunit")));
        TestCoordELFunctions.assertEquals((Object)TimeUnit.END_OF_DAY, (Object)((TimeUnit)this.eval.getVariable("endOfDuration")));
    }

    public void testEndOfMonths() throws Exception {
        this.init("coord-job-submit-freq");
        String expr = "${coord:endOfMonths(1)}";
        expr = "${coord:endOfMonths(3)}";
        TestCoordELFunctions.assertEquals((String)"3", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        TestCoordELFunctions.assertEquals((Object)TimeUnit.MONTH, (Object)((TimeUnit)this.eval.getVariable("timeunit")));
        TestCoordELFunctions.assertEquals((Object)TimeUnit.END_OF_MONTH, (Object)((TimeUnit)this.eval.getVariable("endOfDuration")));
    }

    public void testMinutes() throws Exception {
        this.init("coord-job-submit-freq");
        String expr = "${coord:minutes(1)}";
        expr = "${coord:minutes(1)}";
        TestCoordELFunctions.assertEquals((String)"1", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        TestCoordELFunctions.assertEquals((Object)TimeUnit.MINUTE, (Object)((TimeUnit)this.eval.getVariable("timeunit")));
        expr = "${coord:minutes(coord:minutes(1))}";
        TestCoordELFunctions.assertEquals((String)"1", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        TestCoordELFunctions.assertEquals((Object)TimeUnit.MINUTE, (Object)((TimeUnit)this.eval.getVariable("timeunit")));
    }

    public void testTzOffsetPh1() throws Exception {
        this.init("coord-job-submit-instances");
        String expr = "${coord:current(-coord:tzOffset())}";
        TestCoordELFunctions.assertEquals((String)"${coord:current(-3)}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testDataNamesPh1() throws Exception {
        this.init("coord-job-submit-data");
        String expr = "${coord:dataIn('ABC')}";
        this.eval.setVariable("oozie.dataname.ABC", (Object)"data-in");
        TestCoordELFunctions.assertEquals((String)"${coord:dataIn('ABC')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:dataIn('ABCD')}";
        try {
            TestCoordELFunctions.assertEquals((String)"${coord:dataIn('ABCD')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
            TestCoordELFunctions.fail((String)"should throw exception beacuse Data in is not defiend");
        }
        catch (Exception exception) {
            // empty catch block
        }
        expr = "${coord:dataOut('EFG')}";
        this.eval.setVariable("oozie.dataname.EFG", (Object)"data-out");
        TestCoordELFunctions.assertEquals((String)"${coord:dataOut('EFG')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:dataOut('EFGH')}";
        try {
            TestCoordELFunctions.assertEquals((String)"${coord:dataOut('EFGH')}", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
            TestCoordELFunctions.fail((String)"should throw exception beacuse Data in is not defiend");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testHoursInDay() throws Exception {
        this.init("coord-action-create");
        String expr = "${coord:hoursInDay(1)}";
        String res = CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
        TestCoordELFunctions.assertEquals((String)"24", (String)res);
        expr = "${coord:hoursInDay(coord:hoursInDay(1))}";
        res = CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
        SyncCoordAction appInst = new SyncCoordAction();
        SyncCoordDataset ds = new SyncCoordDataset();
        ds.setFrequency(1);
        ds.setTimeUnit(TimeUnit.DAY);
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-02T00:00Z"));
        ds.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        ds.setName("test1");
        ds.setType("SYNC");
        appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2009-09-10T23:59Z"));
        appInst.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-01T08:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-01-01T08:00Z"));
        appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2010-10-01T00:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:hoursInDay(0)}";
        TestCoordELFunctions.assertEquals((String)"24", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:hoursInDay(0)}";
        TestCoordELFunctions.assertEquals((String)"24", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:hoursInDay(-2)}";
        TestCoordELFunctions.assertEquals((String)"24", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-03-08T08:00Z"));
        appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2010-10-01T00:00Z"));
        ds.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:hoursInDay(0)}";
        TestCoordELFunctions.assertEquals((String)"24", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setTimeZone(DateUtils.getTimeZone((String)"Europe/London"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:hoursInDay(0)}";
        TestCoordELFunctions.assertEquals((String)"24", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-03-08T08:00Z"));
        appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2010-10-01T00:00Z"));
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:hoursInDay(0)}";
        TestCoordELFunctions.assertEquals((String)"23", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:hoursInDay(1)}";
        TestCoordELFunctions.assertEquals((String)"24", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-11-01T08:00Z"));
        appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2010-10-01T00:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:hoursInDay(0)}";
        TestCoordELFunctions.assertEquals((String)"25", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-03-08T08:00Z"));
        appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2010-10-01T00:00Z"));
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        ds.setEndOfDuration(TimeUnit.END_OF_DAY);
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:hoursInDay(0)}";
        TestCoordELFunctions.assertEquals((String)"23", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:hoursInDay(1)}";
        TestCoordELFunctions.assertEquals((String)"24", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:hoursInDay(-1)}";
        TestCoordELFunctions.assertEquals((String)"24", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testDaysInMonth() throws Exception {
        this.init("coord-action-create");
        String expr = "${coord:daysInMonth(1)}";
        TestCoordELFunctions.assertEquals((String)"30", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:daysInMonth(coord:daysInMonth(1))}";
        TestCoordELFunctions.assertEquals((String)"31", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        SyncCoordAction appInst = new SyncCoordAction();
        SyncCoordDataset ds = new SyncCoordDataset();
        ds.setFrequency(1);
        ds.setTimeUnit(TimeUnit.MONTH);
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-02T00:00Z"));
        ds.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        ds.setName("test1");
        ds.setType("SYNC");
        appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2009-09-10T23:59Z"));
        appInst.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-01T00:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T11:00Z"));
        appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2010-10-01T00:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:daysInMonth(0)}";
        TestCoordELFunctions.assertEquals((String)"28", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:daysInMonth(-1)}";
        TestCoordELFunctions.assertEquals((String)"31", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:daysInMonth(2)}";
        TestCoordELFunctions.assertEquals((String)"30", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:daysInMonth(-3)}";
        TestCoordELFunctions.assertEquals((String)"30", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:daysInMonth(3)}";
        TestCoordELFunctions.assertEquals((String)"31", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T11:00Z"));
        appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2010-10-01T00:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:daysInMonth(0)}";
        TestCoordELFunctions.assertEquals((String)"28", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setFrequency(1);
        ds.setTimeUnit(TimeUnit.MONTH);
        ds.setEndOfDuration(TimeUnit.END_OF_MONTH);
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-02T00:00Z"));
        ds.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        ds.setName("test1");
        ds.setType("SYNC");
        appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2009-09-10T23:59Z"));
        appInst.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-01T00:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T11:00Z"));
        appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2010-10-01T00:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:daysInMonth(0)}";
        TestCoordELFunctions.assertEquals((String)"28", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:daysInMonth(-1)}";
        TestCoordELFunctions.assertEquals((String)"31", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:daysInMonth(2)}";
        TestCoordELFunctions.assertEquals((String)"30", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:daysInMonth(-3)}";
        TestCoordELFunctions.assertEquals((String)"30", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:daysInMonth(3)}";
        TestCoordELFunctions.assertEquals((String)"31", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T11:00Z"));
        appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2010-10-01T00:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:daysInMonth(0)}";
        TestCoordELFunctions.assertEquals((String)"28", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testTZOffset() throws Exception {
        this.init("coord-action-create");
        String expr = "${coord:tzOffset()}";
        TestCoordELFunctions.assertEquals((String)"0", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.appInst.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        this.ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        this.appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2012-06-13T00:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)this.ds, (SyncCoordAction)this.appInst);
        TestCoordELFunctions.assertEquals((String)"-420", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2012-12-13T00:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)this.ds, (SyncCoordAction)this.appInst);
        TestCoordELFunctions.assertEquals((String)"-480", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testDateOffset() throws Exception {
        this.init("coord-action-start");
        String expr = "${coord:dateOffset(\"2009-09-08T23:59Z\", 2, \"DAY\")}";
        TestCoordELFunctions.assertEquals((String)"2009-09-10T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:dateOffset(\"2009-09-08T23:59Z\", -1, \"DAY\")}";
        TestCoordELFunctions.assertEquals((String)"2009-09-07T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:dateOffset(\"2009-09-08T23:59Z\", 1, \"YEAR\")}";
        TestCoordELFunctions.assertEquals((String)"2010-09-08T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testDateTzOffset() throws Exception {
        this.init("coord-action-start");
        String expr = "${coord:dateTzOffset(\"2012-06-13T00:00Z\", \"America/Los_Angeles\")}";
        TestCoordELFunctions.assertEquals((String)"2012-06-12T17:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:dateTzOffset(\"2012-06-13T00:00Z\", \"PST\")}";
        TestCoordELFunctions.assertEquals((String)"2012-06-12T17:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:dateTzOffset(\"2012-12-13T00:00Z\", \"America/Los_Angeles\")}";
        TestCoordELFunctions.assertEquals((String)"2012-12-12T16:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:dateTzOffset(\"2012-12-13T00:00Z\", \"PST\")}";
        TestCoordELFunctions.assertEquals((String)"2012-12-12T16:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testCurrentRange() throws Exception {
        this.init("coord-action-create");
        String expr = "${coord:currentRange(-1, 0)}";
        TestCoordELFunctions.assertEquals((String)"2009-09-09T23:59Z#2009-09-08T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-09-01T23:59Z"));
        TestCoordELFunctions.assertEquals((String)"2009-09-01T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testCurrent() throws Exception {
        this.init("coord-action-create");
        String expr = "${coord:current(-1)}";
        TestCoordELFunctions.assertEquals((String)"2009-09-08T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-05-30T00:45Z"));
        this.ds.setFrequency(1);
        this.ds.setTimeUnit(TimeUnit.DAY);
        this.ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-02T00:00Z"));
        this.ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        expr = "${coord:current(0)} ${coord:current(1)} ${coord:current(-1)} ${coord:current(-3)}";
        TestCoordELFunctions.assertEquals((String)"2009-05-29T23:00Z 2009-05-30T23:00Z 2009-05-28T23:00Z 2009-05-26T23:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-05-30T00:45Z"));
        this.ds.setFrequency(30);
        this.ds.setTimeUnit(TimeUnit.MINUTE);
        this.ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-08T00:00Z"));
        expr = "${coord:current(0)} ${coord:current(1)} ${coord:current(-1)} ${coord:current(-3)}";
        TestCoordELFunctions.assertEquals((String)"2009-05-30T00:30Z 2009-05-30T01:00Z 2009-05-30T00:00Z 2009-05-29T23:00Z", (String)((String)this.eval.evaluate(expr, String.class)));
        SyncCoordAction appInst = new SyncCoordAction();
        SyncCoordDataset ds = new SyncCoordDataset();
        ds.setFrequency(1);
        ds.setTimeUnit(TimeUnit.DAY);
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-02T00:00Z"));
        ds.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        ds.setName("test1");
        ds.setType("SYNC");
        appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2009-09-10T23:59Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-05-30T00:00Z "));
        appInst.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-05-30T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-05-31T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(-1)}";
        TestCoordELFunctions.assertEquals((String)"2009-05-29T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(-3)}";
        TestCoordELFunctions.assertEquals((String)"2009-05-27T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setFrequency(7);
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-08T00:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-05-28T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-06-04T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(-1)}";
        TestCoordELFunctions.assertEquals((String)"2009-05-21T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(-3)}";
        TestCoordELFunctions.assertEquals((String)"2009-05-07T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-03-08T10:45Z"));
        ds.setFrequency(1);
        ds.setTimeUnit(TimeUnit.DAY);
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-03-06T10:00Z"));
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        expr = "${coord:current(-2)} ${coord:current(-1)} ${coord:current(0)} ${coord:current(1)} ${coord:current(2)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-06T10:00Z 2009-03-07T10:00Z 2009-03-08T09:00Z 2009-03-09T09:00Z 2009-03-10T09:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-11-01T08:00Z"));
        ds.setFrequency(1);
        ds.setTimeUnit(TimeUnit.DAY);
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-10-30T08:00Z"));
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        expr = "${coord:current(-2)} ${coord:current(-1)} ${coord:current(0)} ${coord:current(1)} ${coord:current(2)}";
        TestCoordELFunctions.assertEquals((String)"2009-10-30T08:00Z 2009-10-31T08:00Z 2009-11-01T08:00Z 2009-11-02T09:00Z 2009-11-03T09:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setFrequency(1);
        ds.setTimeUnit(TimeUnit.DAY);
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-02T09:00Z"));
        ds.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        ds.setName("test1");
        ds.setType("SYNC");
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-05-30T12:00Z "));
        ds.setEndOfDuration(TimeUnit.END_OF_DAY);
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-05-30T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-05-31T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setEndOfDuration(TimeUnit.END_OF_DAY);
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-01T08:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-01-01T08:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setEndOfDuration(TimeUnit.END_OF_DAY);
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-01T08:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-01-01T08:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setEndOfDuration(TimeUnit.END_OF_DAY);
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-01T07:01Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-01-01T08:01Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-01-01T08:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-01-02T08:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setEndOfDuration(TimeUnit.END_OF_DAY);
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-01T7:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-01-01T18:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-01-01T08:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-01-02T08:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setEndOfDuration(TimeUnit.END_OF_DAY);
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-03-07T07:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-03-07T09:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-07T08:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-08T08:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setEndOfDuration(TimeUnit.END_OF_DAY);
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-03-08T07:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-03-08T08:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-08T08:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-09T07:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setEndOfDuration(TimeUnit.END_OF_DAY);
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-03-09T07:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-03-10T08:01Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-10T07:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-11T07:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setEndOfDuration(TimeUnit.END_OF_DAY);
        ds.setFrequency(2);
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-03-09T07:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-03-10T07:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-10T07:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-12T07:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setTimeUnit(TimeUnit.MONTH);
        ds.setEndOfDuration(TimeUnit.END_OF_MONTH);
        ds.setFrequency(1);
        ds.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-01T00:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T00:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-02-01T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-01T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setEndOfDuration(TimeUnit.END_OF_MONTH);
        ds.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-01T08:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T08:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-02-01T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-01T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setEndOfDuration(TimeUnit.END_OF_MONTH);
        ds.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-31T08:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T08:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-02-01T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-01T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setEndOfDuration(TimeUnit.END_OF_MONTH);
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-01-01T08:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T08:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-02-01T08:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-01T08:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setEndOfDuration(TimeUnit.END_OF_MONTH);
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-02-02T08:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-03-02T08:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-01T08:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-04-01T07:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setEndOfDuration(TimeUnit.END_OF_MONTH);
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-02-01T08:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-03-01T08:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-01T08:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-04-01T07:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setEndOfDuration(TimeUnit.END_OF_MONTH);
        ds.setFrequency(3);
        ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-02-01T08:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-03-01T08:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2009-03-01T08:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2009-06-01T07:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setEndOfDuration(TimeUnit.END_OF_MONTH);
        ds.setFrequency(1);
        ds.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2010-01-01T00:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2016-10-31T00:55Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2016-10-01T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2016-11-01T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(-1)}";
        TestCoordELFunctions.assertEquals((String)"2016-09-01T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        ds.setTimeUnit(TimeUnit.YEAR);
        ds.setEndOfDuration(TimeUnit.YEAR);
        ds.setFrequency(1);
        ds.setTimeZone(DateUtils.getTimeZone((String)"UTC"));
        ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"1963-01-01T00:00Z"));
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2016-10-31T00:55Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)ds, (SyncCoordAction)appInst);
        expr = "${coord:current(0)}";
        TestCoordELFunctions.assertEquals((String)"2016-01-01T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(1)}";
        TestCoordELFunctions.assertEquals((String)"2017-01-01T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:current(-1)}";
        TestCoordELFunctions.assertEquals((String)"2015-01-01T00:00Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testOffset() throws Exception {
        this.init("coord-action-create");
        String expr = "${coord:offset(-1440, \"MINUTE\")}";
        TestCoordELFunctions.assertEquals((String)"2009-09-08T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:offset(-24, \"HOUR\")}";
        TestCoordELFunctions.assertEquals((String)"2009-09-08T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:offset(-1, \"DAY\")}";
        TestCoordELFunctions.assertEquals((String)"2009-09-08T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:offset(1, \"MONTH\")}";
        TestCoordELFunctions.assertEquals((String)"2009-10-09T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:offset(1, \"YEAR\")}";
        TestCoordELFunctions.assertEquals((String)"2010-09-09T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:offset(-10, \"DAY\")}";
        TestCoordELFunctions.assertEquals((String)"", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2015-01-02T00:45Z"));
        this.ds.setFrequency(1);
        this.ds.setTimeUnit(TimeUnit.YEAR);
        this.ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2010-01-02T00:01Z"));
        this.ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        expr = "${coord:offset(0, \"YEAR\")} ${coord:offset(1, \"YEAR\")} ${coord:offset(-1, \"YEAR\")} ${coord:offset(-3, \"YEAR\")}";
        TestCoordELFunctions.assertEquals((String)"2015-01-02T00:01Z 2016-01-02T00:01Z 2014-01-02T00:01Z 2012-01-02T00:01Z", (String)((String)this.eval.evaluate(expr, String.class)));
        expr = "${coord:offset(0, \"MONTH\")} ${coord:offset(12, \"MONTH\")} ${coord:offset(-12, \"MONTH\")} ${coord:offset(-36, \"MONTH\")}";
        TestCoordELFunctions.assertEquals((String)"2015-01-02T00:01Z 2016-01-02T00:01Z 2014-01-02T00:01Z 2012-01-02T00:01Z", (String)((String)this.eval.evaluate(expr, String.class)));
        expr = "${coord:offset(0, \"DAY\")} ${coord:offset(365, \"DAY\")} ${coord:offset(-365, \"DAY\")} ${coord:offset(-1096, \"DAY\")}";
        TestCoordELFunctions.assertEquals((String)"2015-01-02T00:01Z 2016-01-02T00:01Z 2014-01-02T00:01Z 2012-01-02T00:01Z", (String)((String)this.eval.evaluate(expr, String.class)));
        expr = "${coord:offset(0, \"HOUR\")} ${coord:offset(8760, \"HOUR\")} ${coord:offset(-8760, \"HOUR\")} ${coord:offset(-26304, \"HOUR\")}";
        TestCoordELFunctions.assertEquals((String)"2015-01-02T00:01Z 2016-01-02T00:01Z 2014-01-02T00:01Z 2012-01-02T00:01Z", (String)((String)this.eval.evaluate(expr, String.class)));
        expr = "${coord:offset(0, \"MINUTE\")} ${coord:offset(525600, \"MINUTE\")} ${coord:offset(-525600, \"MINUTE\")} ${coord:offset(-1578240, \"MINUTE\")}";
        TestCoordELFunctions.assertEquals((String)"2015-01-02T00:01Z 2016-01-02T00:01Z 2014-01-02T00:01Z 2012-01-02T00:01Z", (String)((String)this.eval.evaluate(expr, String.class)));
        this.appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2015-01-02T00:45Z"));
        this.ds.setFrequency(1);
        this.ds.setTimeUnit(TimeUnit.MINUTE);
        this.ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2010-01-02T00:01Z"));
        this.ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        expr = "${coord:offset(0, \"MINUTE\")} ${coord:offset(1, \"MINUTE\")} ${coord:offset(-1, \"MINUTE\")} ${coord:offset(-3, \"MINUTE\")}";
        TestCoordELFunctions.assertEquals((String)"2015-01-02T00:45Z 2015-01-02T00:46Z 2015-01-02T00:44Z 2015-01-02T00:42Z", (String)((String)this.eval.evaluate(expr, String.class)));
        expr = "${coord:offset(0, \"HOUR\")} ${coord:offset(1, \"HOUR\")} ${coord:offset(-1, \"HOUR\")} ${coord:offset(-3, \"HOUR\")}";
        TestCoordELFunctions.assertEquals((String)"2015-01-02T00:45Z 2015-01-02T01:45Z 2015-01-01T23:45Z 2015-01-01T21:45Z", (String)((String)this.eval.evaluate(expr, String.class)));
        expr = "${coord:offset(0, \"DAY\")} ${coord:offset(1, \"DAY\")} ${coord:offset(-1, \"DAY\")} ${coord:offset(-3, \"DAY\")}";
        TestCoordELFunctions.assertEquals((String)"2015-01-02T00:45Z 2015-01-03T00:45Z 2015-01-01T00:45Z 2014-12-30T00:45Z", (String)((String)this.eval.evaluate(expr, String.class)));
        expr = "${coord:offset(0, \"MONTH\")} ${coord:offset(1, \"MONTH\")} ${coord:offset(-1, \"MONTH\")} ${coord:offset(-3, \"MONTH\")}";
        TestCoordELFunctions.assertEquals((String)"2015-01-02T00:45Z 2015-02-02T00:45Z 2014-12-02T00:45Z 2014-10-01T23:45Z", (String)((String)this.eval.evaluate(expr, String.class)));
        expr = "${coord:offset(0, \"YEAR\")} ${coord:offset(1, \"YEAR\")} ${coord:offset(-1, \"YEAR\")} ${coord:offset(-3, \"YEAR\")}";
        TestCoordELFunctions.assertEquals((String)"2015-01-02T00:45Z 2016-01-02T00:45Z 2014-01-02T00:45Z 2012-01-02T00:45Z", (String)((String)this.eval.evaluate(expr, String.class)));
        this.appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2015-01-02T00:45Z"));
        this.ds.setFrequency(4);
        this.ds.setTimeUnit(TimeUnit.HOUR);
        this.ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2010-01-02T00:01Z"));
        this.ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        expr = "${coord:offset(5, \"MINUTE\")}";
        TestCoordELFunctions.assertEquals((String)"2015-01-02T00:01Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:offset(1, \"HOUR\")}";
        TestCoordELFunctions.assertEquals((String)"2015-01-02T00:01Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:offset(7, \"HOUR\")}";
        TestCoordELFunctions.assertEquals((String)"2015-01-02T04:01Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:offset(-2, \"HOUR\")}";
        TestCoordELFunctions.assertEquals((String)"2015-01-01T20:01Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:offset(-43825, \"HOUR\")}";
        TestCoordELFunctions.assertEquals((String)"", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:offset(1, \"blah\")}";
        try {
            CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
            TestCoordELFunctions.fail((String)("eval of " + expr + " should have thrown an exception"));
        }
        catch (Exception e) {
            TestCoordELFunctions.assertTrue((boolean)e.getMessage().contains("Unable to evaluate"));
        }
        expr = "${coord:offset(4.5, \"blah\")}";
        try {
            CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
            TestCoordELFunctions.fail((String)("eval of " + expr + " should have thrown an exception"));
        }
        catch (Exception e) {
            TestCoordELFunctions.assertTrue((boolean)e.getMessage().contains("Unable to evaluate"));
        }
    }

    public void testLatest() throws Exception {
        this.init("coord-action-start");
        String expr = "${coord:latest(0)}";
        Configuration conf = new Configuration();
        this.eval.setVariable("oozie.coord.el.conf", (Object)conf);
        this.getTestCaseDir();
        this.ds.setUriTemplate(this.getTestCaseFileUri("${YEAR}/${MONTH}/${DAY}"));
        this.createTestCaseSubDir("2009/09/10/_SUCCESS".split("/"));
        TestCoordELFunctions.assertEquals((String)"2009-09-10T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.createTestCaseSubDir("2009/09/09/_SUCCESS".split("/"));
        expr = "${coord:latest(-1)}";
        TestCoordELFunctions.assertEquals((String)"2009-09-09T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.createTestCaseSubDir("2009/09/08/_SUCCESS".split("/"));
        expr = "${coord:latest(-2)}";
        TestCoordELFunctions.assertEquals((String)"2009-09-08T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:latest(-100)}";
        TestCoordELFunctions.assertEquals((String)expr, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        expr = "${coord:latest(1)}";
        try {
            TestCoordELFunctions.assertEquals((String)expr, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
            TestCoordELFunctions.fail((String)"Should throw exception, because latest for +ve instance is not valid");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testPh1Future() throws Exception {
        this.init("coord-job-submit-instances");
        String expr = "${coord:future(1, 10)}";
        TestCoordELFunctions.assertEquals((String)expr, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testFormatTime() throws Exception {
        String expr1 = "${coord:formatTime(\"2009-09-08T23:59Z\", \"yyyy\")}";
        String expr2 = "${coord:formatTime(\"2009-09-08T23:59Z\", \"yyyyMMdd_HHmmss\")}";
        this.init("coord-action-create");
        TestCoordELFunctions.assertEquals((String)"2009", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr1));
        TestCoordELFunctions.assertEquals((String)"20090908_235900", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr2));
        this.init("coord-action-create-inst");
        TestCoordELFunctions.assertEquals((String)"2009", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr1));
        TestCoordELFunctions.assertEquals((String)"20090908_235900", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr2));
        this.init("coord-action-start");
        TestCoordELFunctions.assertEquals((String)"2009", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr1));
        TestCoordELFunctions.assertEquals((String)"20090908_235900", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr2));
        String utcDate = "2009-09-08T23:59Z";
        String expr3 = "${coord:formatTime(date, \"yyyy\")}";
        String expr3_eval = "${coord:formatTime('" + utcDate + "' , yyyy)}";
        this.init("coord-job-submit-instances");
        this.eval.setVariable("date", (Object)utcDate);
        TestCoordELFunctions.assertEquals((String)expr3_eval, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr3));
        this.init("coord-job-submit-data");
        this.eval.setVariable("date", (Object)utcDate);
        TestCoordELFunctions.assertEquals((String)expr3_eval, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr3));
        this.init("coord-sla-submit");
        this.eval.setVariable("date", (Object)utcDate);
        TestCoordELFunctions.assertEquals((String)expr3_eval, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr3));
    }

    public void testEpochTime() throws Exception {
        String expr1 = "${coord:epochTime(\"2009-09-08T23:59Z\", \"false\")}";
        String expr2 = "${coord:epochTime(\"2009-09-08T23:59Z\", \"true\")}";
        this.init("coord-action-create");
        TestCoordELFunctions.assertEquals((String)"1252454340", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr1));
        TestCoordELFunctions.assertEquals((String)"1252454340000", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr2));
        this.init("coord-action-create-inst");
        TestCoordELFunctions.assertEquals((String)"1252454340", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr1));
        TestCoordELFunctions.assertEquals((String)"1252454340000", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr2));
        this.init("coord-action-start");
        TestCoordELFunctions.assertEquals((String)"1252454340", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr1));
        TestCoordELFunctions.assertEquals((String)"1252454340000", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr2));
        String utcDate = "2009-09-08T23:59Z";
        String expr3 = "${coord:epochTime(date, \"true\")}";
        String expr3_eval = "${coord:epochTime('" + utcDate + "' , true)}";
        this.init("coord-job-submit-instances");
        this.eval.setVariable("date", (Object)utcDate);
        TestCoordELFunctions.assertEquals((String)expr3_eval, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr3));
        this.init("coord-job-submit-data");
        this.eval.setVariable("date", (Object)utcDate);
        TestCoordELFunctions.assertEquals((String)expr3_eval, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr3));
        this.init("coord-sla-submit");
        this.eval.setVariable("date", (Object)utcDate);
        TestCoordELFunctions.assertEquals((String)expr3_eval, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr3));
    }

    public void testFuture() throws Exception {
        this.init("coord-job-submit-instances");
        String expr = "${coord:future(1, 20)}";
        this.init("coord-action-start");
        Configuration conf = new Configuration();
        this.eval.setVariable("oozie.coord.el.conf", (Object)conf);
        this.getTestCaseDir();
        this.ds.setUriTemplate(this.getTestCaseFileUri("/${YEAR}/${MONTH}/${DAY}"));
        this.createTestCaseSubDir("2009/09/10/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/09/11/_SUCCESS".split("/"));
        TestCoordELFunctions.assertEquals((String)"2009-09-11T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        try {
            expr = "${coord:future(-1, 3)}";
            CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
            TestCoordELFunctions.fail((String)"Should fail for negative instance value");
        }
        catch (Exception exception) {
            // empty catch block
        }
        expr = "${coord:future(4, 20)}";
        String res = "${coord:future(4, 20)}";
        TestCoordELFunctions.assertEquals((String)res, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testNominalTime() throws Exception {
        this.init("coord-job-submit-data");
        String expr = "${coord:nominalTime()}";
        this.init("coord-action-start");
        expr = "${coord:nominalTime()}";
        TestCoordELFunctions.assertEquals((String)"2009-09-09T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.init("coord-sla-create");
        TestCoordELFunctions.assertEquals((String)"2009-09-09T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testActualTime() throws Exception {
        this.init("coord-job-submit-data");
        String expr = "${coord:actualTime()}";
        this.init("coord-action-start");
        expr = "${coord:actualTime()}";
        TestCoordELFunctions.assertEquals((String)"2009-09-10T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.init("coord-sla-submit");
        TestCoordELFunctions.assertEquals((String)expr, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.init("coord-sla-create");
        TestCoordELFunctions.assertEquals((String)"2009-09-10T23:59Z", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testDataIn() throws Exception {
        this.init("coord-action-start");
        this.eval.setVariable(".datain.ABC", (Object)"file:///tmp/coord/US/2009/1/30,file:///tmp/coord/US/2009/1/31");
        this.eval.setVariable(".datain.ABC.unresolved", (Object)Boolean.FALSE);
        String expr = "${coord:dataIn('ABC')}";
        TestCoordELFunctions.assertEquals((String)"file:///tmp/coord/US/2009/1/30,file:///tmp/coord/US/2009/1/31", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.eval.setVariable(".datain.ABC", (Object)"file:///tmp/coord/US/2009/1/30,file:///tmp/coord/US/2009/1/31");
        this.eval.setVariable(".datain.ABC.unresolved", (Object)Boolean.TRUE);
        TestCoordELFunctions.assertEquals((String)expr, (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testDataOut() throws Exception {
        this.init("coord-action-start");
        this.eval.setVariable(".dataout.ABC", (Object)"file:///tmp/coord/US/2009/1/30,file:///tmp/coord/US/2009/1/31");
        String expr = "${coord:dataOut('ABC')}";
        TestCoordELFunctions.assertEquals((String)"file:///tmp/coord/US/2009/1/30,file:///tmp/coord/US/2009/1/31", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.init("coord-sla-create");
        this.eval.setVariable(".dataout.ABC", (Object)"file:///tmp/coord/US/2009/1/30,file:///tmp/coord/US/2009/1/31");
        TestCoordELFunctions.assertEquals((String)"file:///tmp/coord/US/2009/1/30,file:///tmp/coord/US/2009/1/31", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testActionId() throws Exception {
        this.init("coord-action-start");
        String expr = "${coord:actionId()}";
        TestCoordELFunctions.assertEquals((String)"00000-oozie-C@1", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.init("coord-sla-create");
        TestCoordELFunctions.assertEquals((String)"00000-oozie-C@1", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testName() throws Exception {
        this.init("coord-action-start");
        String expr = "${coord:name()}";
        TestCoordELFunctions.assertEquals((String)"mycoordinator-app", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testConf() throws Exception {
        this.init("coord-job-submit-freq");
        this.eval.setVariable("my.test.variable", (Object)"test");
        String expr = "${coord:conf('my.test.variable')}";
        TestCoordELFunctions.assertEquals((String)"test", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testUser() throws Exception {
        this.init("coord-job-submit-freq");
        String expr = "${coord:user()}";
        TestCoordELFunctions.assertEquals((String)"test_user", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.init("coord-job-submit-instances");
        expr = "${coord:user()}";
        TestCoordELFunctions.assertEquals((String)"test_user", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.init("coord-job-submit-data");
        expr = "${coord:user()}";
        TestCoordELFunctions.assertEquals((String)"test_user", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.init("coord-sla-submit");
        expr = "${coord:user()}";
        TestCoordELFunctions.assertEquals((String)"test_user", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.init("coord-action-create");
        expr = "${coord:user()}";
        TestCoordELFunctions.assertEquals((String)"test_user", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.init("coord-action-create-inst");
        expr = "${coord:user()}";
        TestCoordELFunctions.assertEquals((String)"test_user", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.init("coord-sla-create");
        expr = "${coord:user()}";
        TestCoordELFunctions.assertEquals((String)"test_user", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.init("coord-action-start");
        expr = "${coord:user()}";
        TestCoordELFunctions.assertEquals((String)"test_user", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
        this.init("coord-action-create-inst");
        expr = "${coord:user()}";
        TestCoordELFunctions.assertEquals((String)"test_user", (String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr));
    }

    public void testAbsoluteRange() throws Exception {
        this.init("coord-action-create");
        this.ds = new SyncCoordDataset();
        this.ds.setFrequency(7);
        this.ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-08-20T01:00Z"));
        this.ds.setTimeUnit(TimeUnit.DAY);
        this.ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        this.ds.setName("test");
        this.ds.setUriTemplate("hdfs:///tmp/workflows/${YEAR}/${MONTH}/${DAY};region=us");
        this.ds.setType("SYNC");
        this.ds.setDoneFlag("");
        this.appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-08-20T01:00Z"));
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)this.ds, (SyncCoordAction)this.appInst);
        String expr = "${coord:absoluteRange(\"2009-08-20T01:00Z\",\"0\")}";
        TestCoordELFunctions.assertEquals((String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr), (String)"2009-08-20T01:00Z");
        expr = "${coord:absoluteRange(\"2009-08-20T01:00Z\",\"1\")}";
        TestCoordELFunctions.assertEquals((String)CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr), (String)"2009-08-27T01:00Z#2009-08-20T01:00Z");
        try {
            expr = "${coord:absoluteRange(\"2009-08-20T01:00Z\",\"-1\")}";
            CoordELFunctions.evalAndWrap((ELEvaluator)this.eval, (String)expr);
            TestCoordELFunctions.fail((String)"start-instance is greater than the end-instance and there was no exception");
        }
        catch (Exception e) {
            TestCoordELFunctions.assertTrue((boolean)e.getCause().getMessage().contains("start-instance should be equal or earlier than the end-instance"));
        }
    }

    void init(String tag) throws Exception {
        this.init(tag, "hdfs://localhost:9000/user/" + TestCoordELFunctions.getTestUser() + "/US/${YEAR}/${MONTH}/${DAY}");
    }

    private void init(String tag, String uriTemplate) throws Exception {
        this.eval = ((ELService)Services.get().get(ELService.class)).createEvaluator(tag);
        this.eval.setVariable("user.name", (Object)"test_user");
        this.eval.setVariable("group.name", (Object)"test_group");
        this.appInst = new SyncCoordAction();
        this.ds = new SyncCoordDataset();
        this.ds.setFrequency(1);
        this.ds.setInitInstance(DateUtils.parseDateOozieTZ((String)"2009-09-01T23:59Z"));
        this.ds.setTimeUnit(TimeUnit.DAY);
        this.ds.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        this.ds.setName("test");
        this.ds.setUriTemplate(uriTemplate);
        this.ds.setType("SYNC");
        this.ds.setDoneFlag("");
        this.appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2009-09-10T23:59Z"));
        this.appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-09-09T23:59Z"));
        this.appInst.setTimeZone(DateUtils.getTimeZone((String)"America/Los_Angeles"));
        this.appInst.setActionId("00000-oozie-C@1");
        this.appInst.setName("mycoordinator-app");
        CoordELFunctions.configureEvaluator((ELEvaluator)this.eval, (SyncCoordDataset)this.ds, (SyncCoordAction)this.appInst);
    }
}

