/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.wf.HangServlet;
import org.apache.oozie.command.wf.WorkflowNotificationXCommand;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.EmbeddedServletContainer;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.workflow.WorkflowInstance;
import org.junit.Assert;
import org.mockito.Mockito;

public class TestWorkflowNotificationXCommand
extends XTestCase {
    private EmbeddedServletContainer container;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.notification.url.connection.timeout", "50");
        Services services = new Services();
        services.init();
        this.container = new EmbeddedServletContainer("blah");
        this.container.addServletEndpoint("/hang/*", HangServlet.class);
        CallbackServlet.reset();
        this.container.addServletEndpoint("/callback/*", CallbackServlet.class);
        this.container.start();
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this.container.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Services.get().destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
    }

    public void testWFNotificationTimeout() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.workflow.notification.url", this.container.getServletURL("/hang/*"));
        WorkflowInstance wfi = (WorkflowInstance)Mockito.mock(WorkflowInstance.class);
        Mockito.when((Object)wfi.getConf()).thenReturn((Object)conf);
        WorkflowJobBean workflow = (WorkflowJobBean)Mockito.mock(WorkflowJobBean.class);
        Mockito.when((Object)workflow.getId()).thenReturn((Object)"1");
        Mockito.when((Object)workflow.getStatus()).thenReturn((Object)WorkflowJob.Status.SUCCEEDED);
        Mockito.when((Object)workflow.getWorkflowInstance()).thenReturn((Object)wfi);
        WorkflowNotificationXCommand command = new WorkflowNotificationXCommand(workflow);
        command.setRetry(3);
        long start = System.currentTimeMillis();
        command.call();
        long end = System.currentTimeMillis();
        Assert.assertTrue((end - start >= 50L ? 1 : 0) != 0);
        Assert.assertTrue((end - start < 10000L ? 1 : 0) != 0);
    }

    public void testWFNotification() throws Exception {
        String notificationUrl = "/callback/wf?jobId=$jobId&parentId=$parentId";
        this._testNotificationParentId(notificationUrl, "1", null, "");
        notificationUrl = "/callback/wf?jobId=$jobId";
        this._testNotificationParentId(notificationUrl, "1", null, null);
        notificationUrl = "/callback/wf?jobId=$jobId&parentId=$parentId";
        this._testNotificationParentId(notificationUrl, "1", "0000000-111111-oozie-XXX-C@1", "0000000-111111-oozie-XXX-C@1");
        notificationUrl = "/callback/wf?jobId=$jobId";
        this._testNotificationParentId(notificationUrl, "1", "0000000-111111-oozie-XXX-C@1", null);
    }

    private void _testNotificationParentId(String notificationUrl, String jobId, String parentId, String expectedParentId) throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.workflow.notification.url", this.container.getServletURL(notificationUrl));
        WorkflowInstance wfi = (WorkflowInstance)Mockito.mock(WorkflowInstance.class);
        Mockito.when((Object)wfi.getConf()).thenReturn((Object)conf);
        WorkflowJobBean workflow = (WorkflowJobBean)Mockito.mock(WorkflowJobBean.class);
        Mockito.when((Object)workflow.getId()).thenReturn((Object)jobId);
        Mockito.when((Object)workflow.getStatus()).thenReturn((Object)WorkflowJob.Status.SUCCEEDED);
        Mockito.when((Object)workflow.getParentId()).thenReturn((Object)parentId);
        Mockito.when((Object)workflow.getWorkflowInstance()).thenReturn((Object)wfi);
        WorkflowNotificationXCommand command = new WorkflowNotificationXCommand(workflow);
        command.setRetry(3);
        command.call();
        Assert.assertEquals((Object)jobId, (Object)CallbackServlet.JOB_ID);
        Assert.assertEquals((Object)expectedParentId, (Object)CallbackServlet.PARENT_ID);
    }

    public static class CallbackServlet
    extends HttpServlet {
        public static volatile String JOB_ID = null;
        public static String NODE_NAME = null;
        public static String STATUS = null;
        public static String PARENT_ID = null;

        public static void reset() {
            JOB_ID = null;
            NODE_NAME = null;
            STATUS = null;
            PARENT_ID = null;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            JOB_ID = req.getParameter("jobId");
            NODE_NAME = req.getParameter("nodeName");
            STATUS = req.getParameter("status");
            PARENT_ID = req.getParameter("parentId");
            resp.setStatus(200);
        }
    }
}

