/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.StartXCommand;
import org.apache.oozie.command.wf.SubmitXCommand;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class TestSubmitXCommand
extends XDataTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.log4j.file", "oozie-log4j.properties");
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        super.tearDown();
    }

    public void testSubmitAppName() throws Exception {
        XConfiguration conf = new XConfiguration();
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='${appName}-foo'> <start to='end' /> <end name='end' /> </workflow-app>";
        this.writeToFile(appXml, workflowUri);
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestSubmitXCommand.getTestUser());
        conf.set("appName", "var-app-name");
        SubmitXCommand sc = new SubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        WorkflowStoreService wss = (WorkflowStoreService)Services.get().get(WorkflowStoreService.class);
        WorkflowStore ws = wss.create();
        WorkflowJobBean wfb = ws.getWorkflow(jobId, false);
        TestSubmitXCommand.assertEquals((String)"var-app-name-foo", (String)wfb.getAppName());
    }

    public void testSubmitReservedVars() throws Exception {
        XConfiguration conf = new XConfiguration();
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='map-reduce-wf'> <start to='end' /> <end name='end' /> </workflow-app>";
        this.writeToFile(appXml, workflowUri);
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestSubmitXCommand.getTestUser());
        conf.set("GB", "5");
        SubmitXCommand sc = new SubmitXCommand((Configuration)conf);
        try {
            sc.call();
            TestSubmitXCommand.fail((String)"WF job submission should fail with reserved variable definitions.");
        }
        catch (CommandException commandException) {
            // empty catch block
        }
    }

    public void testAppPathIsDir() throws Exception {
        XConfiguration conf = new XConfiguration();
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='map-reduce-wf'> <start to='end' /> <end name='end' /> </workflow-app>";
        this.writeToFile(appXml, workflowUri);
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestSubmitXCommand.getTestUser());
        SubmitXCommand sc = new SubmitXCommand((Configuration)conf);
        try {
            sc.call();
        }
        catch (CommandException ce) {
            TestSubmitXCommand.fail((String)"Should succeed");
        }
    }

    public void testAppPathIsFile1() throws Exception {
        XConfiguration conf = new XConfiguration();
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='map-reduce-wf'> <start to='end' /> <end name='end' /> </workflow-app>";
        this.writeToFile(appXml, workflowUri);
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestSubmitXCommand.getTestUser());
        SubmitXCommand sc = new SubmitXCommand((Configuration)conf);
        try {
            sc.call();
        }
        catch (CommandException ce) {
            TestSubmitXCommand.fail((String)"Should succeed");
        }
    }

    public void testAppPathIsFile2() throws Exception {
        XConfiguration conf = new XConfiguration();
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='map-reduce-wf'> <start to='end' /> <end name='end' /> </workflow-app>";
        this.writeToFile(appXml, workflowUri);
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestSubmitXCommand.getTestUser());
        SubmitXCommand sc = new SubmitXCommand((Configuration)conf);
        try {
            sc.call();
        }
        catch (CommandException ce) {
            TestSubmitXCommand.fail((String)"Should succeed");
        }
    }

    public void testAppPathIsFileNegative() throws Exception {
        XConfiguration conf = new XConfiguration();
        String workflowUri = this.getTestCaseFileUri("test.xml");
        String appXml = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='map-reduce-wf'> <start to='end' /> <end name='end' /> </workflow-app>";
        this.writeToFile(appXml, workflowUri);
        conf.set("oozie.wf.application.path", this.getTestCaseFileUri("does_not_exist.xml"));
        conf.set("user.name", TestSubmitXCommand.getTestUser());
        SubmitXCommand sc = new SubmitXCommand((Configuration)conf);
        try {
            sc.call();
            TestSubmitXCommand.fail((String)"should fail");
        }
        catch (CommandException commandException) {
            // empty catch block
        }
    }

    public void testDryrunValidXml() throws Exception {
        XConfiguration conf = new XConfiguration();
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = IOUtils.getResourceAsString((String)"wf-schema-valid-global.xml", (int)-1);
        this.writeToFile(appXml, workflowUri);
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestSubmitXCommand.getTestUser());
        SubmitXCommand sc = new SubmitXCommand(true, (Configuration)conf);
        try {
            sc.call();
            TestSubmitXCommand.fail((String)"Should fail with variable cannot be resolved");
        }
        catch (CommandException ex) {
            TestSubmitXCommand.assertEquals((Object)ErrorCode.E0803, (Object)ex.getErrorCode());
            TestSubmitXCommand.assertEquals((String)"E0803: IO error, variable [foo] cannot be resolved", (String)ex.getMessage());
        }
        conf.set("foo", "foo");
        sc = new SubmitXCommand(true, (Configuration)conf);
        TestSubmitXCommand.assertEquals((String)"OK", (String)((String)sc.call()));
    }

    public void testDryrunInvalidXml() throws Exception {
        XConfiguration conf = new XConfiguration();
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = IOUtils.getResourceAsString((String)"wf-loop1-invalid.xml", (int)-1);
        this.writeToFile(appXml, workflowUri);
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestSubmitXCommand.getTestUser());
        SubmitXCommand sc = new SubmitXCommand(true, (Configuration)conf);
        try {
            sc.call();
            TestSubmitXCommand.fail((String)"Should have gotten E0707 because the XML has a loop");
        }
        catch (CommandException ce) {
            TestSubmitXCommand.assertEquals((Object)ErrorCode.E0707, (Object)ce.getErrorCode());
            TestSubmitXCommand.assertEquals((String)"E0707: Loop detected at parsing, node [a], path [:start:->a->c->a]", (String)ce.getMessage());
        }
        conf = new XConfiguration();
        appXml = IOUtils.getResourceAsString((String)"wf-transition-invalid.xml", (int)-1);
        this.writeToFile(appXml, workflowUri);
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestSubmitXCommand.getTestUser());
        sc = new SubmitXCommand(true, (Configuration)conf);
        try {
            sc.call();
            TestSubmitXCommand.fail((String)"Should have gotten E0708 because the XML has an invalid transition");
        }
        catch (CommandException ce) {
            TestSubmitXCommand.assertEquals((Object)ErrorCode.E0708, (Object)ce.getErrorCode());
            TestSubmitXCommand.assertEquals((String)"E0708: Invalid transition, node [c] transition [f]", (String)ce.getMessage());
        }
        conf = new XConfiguration();
        appXml = IOUtils.getResourceAsString((String)"wf-schema-invalid.xml", (int)-1);
        this.writeToFile(appXml, workflowUri);
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestSubmitXCommand.getTestUser());
        sc = new SubmitXCommand(true, (Configuration)conf);
        try {
            sc.call();
            TestSubmitXCommand.fail((String)"Should have gotten E0701 because the XML has an invalid element");
        }
        catch (CommandException ce) {
            TestSubmitXCommand.assertEquals((Object)ErrorCode.E0701, (Object)ce.getErrorCode());
            TestSubmitXCommand.assertTrue((boolean)ce.getMessage().contains("XML schema error"));
            TestSubmitXCommand.assertTrue((boolean)ce.getMessage().contains("starting with element 'xstart'"));
            TestSubmitXCommand.assertTrue((boolean)ce.getMessage().contains("'{\"uri:oozie:workflow:0.1\":start}' is expected"));
        }
    }

    public void testProtoConfStorage() throws Exception {
        final OozieClient wfClient = LocalOozie.getClient();
        XConfiguration conf = new XConfiguration();
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='${appName}-foo'> <start to='end' /> <end name='end' /> </workflow-app>";
        this.writeToFile(appXml, workflowUri);
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestSubmitXCommand.getTestUser());
        conf.set("appName", "var-app-name");
        SubmitXCommand sc = new SubmitXCommand((Configuration)conf);
        final String jobId = (String)sc.call();
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId).getStatus() == WorkflowJob.Status.PREP;
            }
        });
        WorkflowJobBean wf = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{jobId});
        XConfiguration protoConf = new XConfiguration((Reader)new StringReader(wf.getProtoActionConf()));
        if (protoConf.get("mapreduce.job.user.name") != null) {
            TestSubmitXCommand.assertEquals((int)3, (int)protoConf.size());
        } else {
            TestSubmitXCommand.assertEquals((int)2, (int)protoConf.size());
        }
        TestSubmitXCommand.assertNull((Object)protoConf.get("oozie.wf.application.lib"));
        new File(this.getTestCaseDir() + "/lib").mkdirs();
        File.createTempFile("parentLibrary", ".jar", new File(this.getTestCaseDir() + "/lib"));
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestSubmitXCommand.getTestUser());
        conf.set("appName", "var-app-name");
        sc = new SubmitXCommand((Configuration)conf);
        final String jobId1 = (String)sc.call();
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId1).getStatus() == WorkflowJob.Status.PREP;
            }
        });
        wf = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{jobId1});
        protoConf = new XConfiguration((Reader)new StringReader(wf.getProtoActionConf()));
        if (protoConf.get("mapreduce.job.user.name") != null) {
            TestSubmitXCommand.assertEquals((int)4, (int)protoConf.size());
        } else {
            TestSubmitXCommand.assertEquals((int)3, (int)protoConf.size());
        }
        TestSubmitXCommand.assertNotNull((Object)protoConf.get("oozie.wf.application.lib"));
    }

    public void testWFConfigDefaultVarResolve() throws Exception {
        final OozieClient wfClient = LocalOozie.getClient();
        FileOutputStream os = new FileOutputStream(this.getTestCaseDir() + "/config-default.xml");
        XConfiguration defaultConf = new XConfiguration();
        defaultConf.set("outputDir", "default-output-dir");
        defaultConf.set("foo.bar", "default-foo-bar");
        defaultConf.set("foobarRef", "${foo.bar}");
        defaultConf.set("key", "default_value");
        defaultConf.set("should_resolve", "${should.resolve}");
        defaultConf.set("mixed", "${nameNode}/${outputDir}");
        defaultConf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String actionXml = "<map-reduce><job-tracker>${jobTracker}</job-tracker><name-node>${nameNode}</name-node>        <prepare>          <delete path=\"${nameNode}/user/${wf:user()}/mr/${outputDir}\"/>        </prepare>        <configuration>          <property><name>bb</name><value>BB</value></property>          <property><name>cc</name><value>from_action</value></property>        </configuration>      </map-reduce>";
        String wfXml = "<workflow-app xmlns=\"uri:oozie:workflow:0.5\" name=\"map-reduce-wf\">    <start to=\"mr-node\"/>    <action name=\"mr-node\">" + actionXml + "    <ok to=\"end\"/>    <error to=\"fail\"/></action><kill name=\"fail\">    <message>Map/Reduce failed, error message[${wf:errorMessage(wf:lastErrorNode())}]</message></kill><end name=\"end\"/></workflow-app>";
        this.writeToFile(wfXml, workflowUri);
        XConfiguration conf = new XConfiguration();
        conf.set("nameNode", this.getNameNodeUri());
        conf.set("jobTracker", this.getJobTrackerUri());
        conf.set("foobarRef", "foobarRef");
        conf.set("key", "job_prop_value");
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestSubmitXCommand.getTestUser());
        conf.set("should.resolve", "resolved");
        SubmitXCommand sc = new SubmitXCommand((Configuration)conf);
        final String jobId = (String)sc.call();
        new StartXCommand(jobId).call();
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId).getStatus() == WorkflowJob.Status.KILLED;
            }
        });
        String actionId = jobId + "@mr-node";
        WorkflowActionBean action = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, new Object[]{actionId});
        Element eAction = XmlUtils.parseXml((String)action.getConf());
        Element eConf = eAction.getChild("configuration", eAction.getNamespace());
        XConfiguration actionConf = new XConfiguration((Reader)new StringReader(XmlUtils.prettyPrint((Element)eConf).toString()));
        TestSubmitXCommand.assertEquals((String)"default-output-dir", (String)actionConf.get("outputDir"));
        TestSubmitXCommand.assertEquals((String)"BB", (String)actionConf.get("bb"));
        TestSubmitXCommand.assertEquals((String)"from_action", (String)actionConf.get("cc"));
        TestSubmitXCommand.assertEquals((String)"resolved", (String)actionConf.get("should_resolve"));
        TestSubmitXCommand.assertEquals((String)"default-foo-bar", (String)actionConf.get("foo.bar"));
        TestSubmitXCommand.assertEquals((String)"default-foo-bar", (String)actionConf.get("foobarRef"));
        TestSubmitXCommand.assertEquals((String)"default_value", (String)actionConf.get("key"));
        TestSubmitXCommand.assertEquals((String)(this.getNameNodeUri() + "/default-output-dir"), (String)actionConf.get("mixed"));
    }

    private void writeToFile(String appXml, String appPath) throws IOException {
        File wf = new File(URI.create(appPath));
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(wf));
            out.println(appXml);
        }
    }
}

