/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.command.wf.SubmitMRXCommand;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.Namespace;

public class TestSubmitMRXCommand
extends XFsTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.log4j.file", "oozie-log4j.properties");
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        super.tearDown();
    }

    public void testWFXmlGeneration() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("mapred.job.tracker", "jobtracker");
        conf.set("fs.default.name", "namenode");
        conf.set("oozie.libpath", "libpath");
        conf.set("mapred.mapper.class", "A.Mapper");
        conf.set("mapred.reducer.class", "A.Reducer");
        conf.set("oozie.files", "/user/oozie/input1.txt,/user/oozie/input2.txt#my.txt");
        conf.set("oozie.archives", "/user/oozie/udf1.jar,/user/oozie/udf2.jar#my.jar");
        SubmitMRXCommand submitMRCmd = new SubmitMRXCommand(conf);
        String xml = submitMRCmd.getWorkflowXml(conf);
        XLog.getLog(((Object)((Object)this)).getClass()).info((Object)("xml = " + xml));
        WorkflowAppService wps = (WorkflowAppService)Services.get().get(WorkflowAppService.class);
        wps.parseDef(xml, conf);
        Element wfE = XmlUtils.parseXml((String)xml);
        Namespace ns = wfE.getNamespace();
        Element actionE = wfE.getChild("action", ns).getChild("map-reduce", ns);
        Element confE = actionE.getChild("configuration", ns);
        HashMap<String, String> props = new HashMap<String, String>();
        for (Object prop : confE.getChildren("property", ns)) {
            Element propE = (Element)prop;
            String name = propE.getChild("name", ns).getTextTrim();
            String value = propE.getChild("value", ns).getTextTrim();
            props.put(name, value);
        }
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("mapred.mapper.class", "A.Mapper");
        expected.put("mapred.reducer.class", "A.Reducer");
        for (Map.Entry entry : expected.entrySet()) {
            TestSubmitMRXCommand.assertEquals((String)((String)entry.getValue()), (String)((String)expected.get(entry.getKey())));
        }
        TestSubmitMRXCommand.assertEquals((String)"/user/oozie/input1.txt#input1.txt", (String)((Element)actionE.getChildren("file", ns).get(0)).getTextTrim());
        TestSubmitMRXCommand.assertEquals((String)"/user/oozie/input2.txt#my.txt", (String)((Element)actionE.getChildren("file", ns).get(1)).getTextTrim());
        TestSubmitMRXCommand.assertEquals((String)"/user/oozie/udf1.jar#udf1.jar", (String)((Element)actionE.getChildren("archive", ns).get(0)).getTextTrim());
        TestSubmitMRXCommand.assertEquals((String)"/user/oozie/udf2.jar#my.jar", (String)((Element)actionE.getChildren("archive", ns).get(1)).getTextTrim());
    }

    public void testWFXmlGenerationNegative1() throws Exception {
        Configuration conf = new Configuration();
        conf.set("mapred.job.tracker", "jobtracker");
        conf.set("fs.default.name", "namenode");
        conf.set("name_a", "value_a");
        conf.set("name_b", "value_b");
        conf.set("name_c", "value_c");
        SubmitMRXCommand submitMRCmd = new SubmitMRXCommand(conf);
        try {
            submitMRCmd.getWorkflowXml(conf);
            TestSubmitMRXCommand.fail((String)"shoud have already failed - missing libpath def");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testWFXmlGenerationNewConfigProps() throws Exception {
        try {
            Configuration conf = new Configuration(false);
            conf.set("fs.defaultFS", "new_NN");
            conf.set("mapreduce.jobtracker.address", "new_JT");
            conf.set("mapred.mapper.class", "TestMapper");
            conf.set("mapred.reducer.class", "TestReducer");
            conf.set("mapred.input.dir", "testInput");
            conf.set("mapred.output.dir", "testOutput");
            conf.set("oozie.libpath", "libpath");
            conf.set("mapreduce.job.user.name", "test_user");
            SubmitMRXCommand submitMRCmd = new SubmitMRXCommand(conf);
            String xml = submitMRCmd.getWorkflowXml(conf);
            WorkflowAppService wps = (WorkflowAppService)Services.get().get(WorkflowAppService.class);
            wps.parseDef(xml, conf);
            Element wfE = XmlUtils.parseXml((String)xml);
            Namespace ns = wfE.getNamespace();
            Element actionE = wfE.getChild("action", ns).getChild("map-reduce", ns);
            Element nnE = actionE.getChild("name-node", ns);
            TestSubmitMRXCommand.assertEquals((String)nnE.getTextTrim(), (String)"new_NN");
            Element jtE = actionE.getChild("job-tracker", ns);
            TestSubmitMRXCommand.assertEquals((String)jtE.getTextTrim(), (String)"new_JT");
        }
        catch (Exception e) {
            TestSubmitMRXCommand.fail((String)"should have passed");
        }
    }
}

