/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.Map;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.wf.CompletedActionXCommand;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestCompletedActionXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testEarlyCallbackTimeout() throws Exception {
        long executionCount;
        long executionsCount;
        long xexceptionCount;
        final Instrumentation inst = ((InstrumentationService)Services.get().get(InstrumentationService.class)).get();
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.PREP);
        final CompletedActionXCommand cmd = new CompletedActionXCommand(action.getId(), "SUCCEEDED", null);
        try {
            xexceptionCount = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(cmd.getName() + ".xexceptions")).getValue();
        }
        catch (NullPointerException npe) {
            xexceptionCount = 0L;
        }
        TestCompletedActionXCommand.assertEquals((long)0L, (long)xexceptionCount);
        try {
            executionsCount = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(cmd.getName() + ".executions")).getValue();
        }
        catch (NullPointerException npe) {
            executionsCount = 0L;
        }
        TestCompletedActionXCommand.assertEquals((long)0L, (long)executionsCount);
        try {
            executionCount = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(cmd.getName() + ".execution")).getValue();
        }
        catch (NullPointerException npe) {
            executionCount = 0L;
        }
        TestCompletedActionXCommand.assertEquals((long)0L, (long)executionCount);
        cmd.call();
        int timeout = 100000;
        this.waitFor(timeout, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                long xexceptionCount;
                try {
                    xexceptionCount = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(cmd.getName() + ".xexceptions")).getValue();
                }
                catch (NullPointerException npe) {
                    xexceptionCount = 0L;
                }
                return xexceptionCount == 1L;
            }
        });
        executionsCount = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(cmd.getName() + ".executions")).getValue();
        TestCompletedActionXCommand.assertEquals((long)6L, (long)executionsCount);
        try {
            executionCount = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(cmd.getName() + ".execution")).getValue();
        }
        catch (NullPointerException npe) {
            executionCount = 0L;
        }
        TestCompletedActionXCommand.assertEquals((long)0L, (long)executionCount);
        xexceptionCount = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(cmd.getName() + ".xexceptions")).getValue();
        TestCompletedActionXCommand.assertEquals((long)1L, (long)xexceptionCount);
    }

    public void testEarlyCallbackTransitionToRunning() throws Exception {
        long checkXCommandExecutionsCount;
        long executionsCount;
        long xexceptionCount;
        final Instrumentation inst = ((InstrumentationService)Services.get().get(InstrumentationService.class)).get();
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        final WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.PREP);
        final CompletedActionXCommand cmd = new CompletedActionXCommand(action.getId(), "SUCCEEDED", null);
        try {
            xexceptionCount = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(cmd.getName() + ".xexceptions")).getValue();
        }
        catch (NullPointerException npe) {
            xexceptionCount = 0L;
        }
        TestCompletedActionXCommand.assertEquals((long)0L, (long)xexceptionCount);
        try {
            executionsCount = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(cmd.getName() + ".executions")).getValue();
        }
        catch (NullPointerException npe) {
            executionsCount = 0L;
        }
        TestCompletedActionXCommand.assertEquals((long)0L, (long)executionsCount);
        try {
            checkXCommandExecutionsCount = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get("action.check.executions")).getValue();
        }
        catch (NullPointerException npe) {
            checkXCommandExecutionsCount = 0L;
        }
        TestCompletedActionXCommand.assertEquals((long)0L, (long)checkXCommandExecutionsCount);
        cmd.call();
        int timeout = 1000000;
        this.waitFor(timeout, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                long checkXCommandExecutionsCount;
                long executionsCount;
                try {
                    executionsCount = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(cmd.getName() + ".executions")).getValue();
                }
                catch (NullPointerException npe) {
                    executionsCount = 0L;
                }
                if (executionsCount == 3L && !action.getStatus().equals((Object)WorkflowAction.Status.RUNNING)) {
                    action.setStatus(WorkflowAction.Status.RUNNING);
                    WorkflowActionQueryExecutor.getInstance().executeUpdate((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION, (Object)action);
                }
                try {
                    checkXCommandExecutionsCount = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get("action.check.executions")).getValue();
                }
                catch (NullPointerException npe) {
                    checkXCommandExecutionsCount = 0L;
                }
                return checkXCommandExecutionsCount == 1L;
            }
        });
        executionsCount = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(cmd.getName() + ".executions")).getValue();
        TestCompletedActionXCommand.assertTrue((String)("expected a value greater than 3L, but found " + executionsCount), (executionsCount >= 3L ? 1 : 0) != 0);
        checkXCommandExecutionsCount = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get("action.check.executions")).getValue();
        TestCompletedActionXCommand.assertEquals((long)1L, (long)checkXCommandExecutionsCount);
        try {
            xexceptionCount = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(cmd.getName() + ".xexceptions")).getValue();
        }
        catch (NullPointerException npe) {
            xexceptionCount = 0L;
        }
        TestCompletedActionXCommand.assertEquals((long)0L, (long)xexceptionCount);
    }
}

