/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.LauncherMapperHelper;
import org.apache.oozie.action.hadoop.MapReduceActionExecutor;
import org.apache.oozie.action.hadoop.MapperReducerForTest;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.wf.ActionStartXCommand;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;
import org.jdom.Element;
import org.jdom.Namespace;

public class TestActionStartXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testActionStartPreCondition1() throws Exception {
        Instrumentation inst = ((InstrumentationService)Services.get().get(InstrumentationService.class)).get();
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.FAILED, WorkflowInstance.Status.FAILED);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.PREP);
        TestActionStartXCommand.assertNull(inst.getCounters().get("commands"));
        ActionStartXCommand startCmd = new ActionStartXCommand(action.getId(), "map-reduce");
        startCmd.call();
        Long counterVal = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(startCmd.getName() + ".preconditionfailed")).getValue();
        TestActionStartXCommand.assertEquals((Object)new Long(1L), (Object)new Long(counterVal));
    }

    public void testActionStartPreCondition2() throws Exception {
        Instrumentation inst = ((InstrumentationService)Services.get().get(InstrumentationService.class)).get();
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.FAILED, WorkflowInstance.Status.FAILED);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.START_RETRY);
        TestActionStartXCommand.assertNull(inst.getCounters().get("commands"));
        ActionStartXCommand startCmd = new ActionStartXCommand(action.getId(), "map-reduce");
        startCmd.call();
        Long counterVal = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(startCmd.getName() + ".preconditionfailed")).getValue();
        TestActionStartXCommand.assertEquals((Object)new Long(1L), (Object)new Long(counterVal));
    }

    public void testActionStartPreCondition3() throws Exception {
        Instrumentation inst = ((InstrumentationService)Services.get().get(InstrumentationService.class)).get();
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = super.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.PREP);
        TestActionStartXCommand.assertFalse((boolean)action.isPending());
        TestActionStartXCommand.assertNull(inst.getCounters().get("commands"));
        ActionStartXCommand startCmd = new ActionStartXCommand(action.getId(), "map-reduce");
        startCmd.call();
        Long counterVal = (Long)((Instrumentation.Element)((Map)inst.getCounters().get("commands")).get(startCmd.getName() + ".preconditionfailed")).getValue();
        TestActionStartXCommand.assertEquals((Object)new Long(1L), (Object)new Long(counterVal));
    }

    public void testActionStart() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.PREP);
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        new ActionStartXCommand(action.getId(), "map-reduce").call();
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestActionStartXCommand.assertNotNull((Object)action.getExternalId());
        ActionXCommand.ActionExecutorContext context = new ActionXCommand.ActionExecutorContext(job, action, false, false);
        MapReduceActionExecutor actionExecutor = new MapReduceActionExecutor();
        JobConf conf = actionExecutor.createBaseHadoopConf((ActionExecutor.Context)context, XmlUtils.parseXml((String)action.getConf()));
        String user = conf.get("user.name");
        JobClient jobClient = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createJobClient(user, conf);
        String launcherId = action.getExternalId();
        final RunningJob launcherJob = jobClient.getJob(JobID.forName((String)launcherId));
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return launcherJob.isComplete();
            }
        });
        TestActionStartXCommand.assertTrue((boolean)launcherJob.isSuccessful());
        Map actionData = LauncherMapperHelper.getActionData((FileSystem)this.getFileSystem(), (Path)context.getActionDir(), (Configuration)conf);
        TestActionStartXCommand.assertTrue((boolean)LauncherMapperHelper.hasIdSwap((Map)actionData));
    }

    public void testActionStartToCheckRetry() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        job.setUser(TestActionStartXCommand.getTestUser2());
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)job);
        WorkflowActionBean action = this.addRecordToWfActionTableWithFS(job.getId(), "1", WorkflowAction.Status.PREP);
        TestActionStartXCommand.assertEquals((int)0, (int)action.getUserRetryCount());
        TestActionStartXCommand.assertEquals((int)1, (int)action.getUserRetryMax());
        new ActionStartXCommand(action.getId(), "fs").call();
        action = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, new Object[]{action.getId()});
        TestActionStartXCommand.assertNotNull((Object)action.getExternalId());
        TestActionStartXCommand.assertEquals((int)1, (int)action.getUserRetryCount());
    }

    public void testActionReuseWfJobAppPath() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        WorkflowJobBean job = this.addRecordToWfJobTableWithCustomAppPath(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTableWithAppPathConfig(job.getId(), "1", WorkflowAction.Status.PREP);
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        new ActionStartXCommand(action.getId(), "map-reduce").call();
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestActionStartXCommand.assertNotNull((Object)action.getExternalId());
        Element actionXml = XmlUtils.parseXml((String)action.getConf());
        Namespace ns = actionXml.getNamespace();
        Element configElem = actionXml.getChild("configuration", ns);
        String strConf = XmlUtils.prettyPrint((Element)configElem).toString();
        XConfiguration inlineConf = new XConfiguration((Reader)new StringReader(strConf));
        String workDir = inlineConf.get("work.dir", null);
        TestActionStartXCommand.assertNotNull((Object)workDir);
        TestActionStartXCommand.assertFalse((boolean)workDir.contains("workflow.xml"));
    }

    public void testActionWithEscapedStringAndCDATA() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        WorkflowJobBean job = this.addRecordToWfJobTableWithEscapedStringAndCDATA(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTableWithEscapedStringAndCDATA(job.getId(), WorkflowAction.Status.PREP);
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        new ActionStartXCommand(action.getId(), "map-reduce").call();
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestActionStartXCommand.assertNotNull((Object)action.getExternalId());
        ActionXCommand.ActionExecutorContext context = new ActionXCommand.ActionExecutorContext(job, action, false, false);
        MapReduceActionExecutor actionExecutor = new MapReduceActionExecutor();
        JobConf conf = actionExecutor.createBaseHadoopConf((ActionExecutor.Context)context, XmlUtils.parseXml((String)action.getConf()));
        String user = conf.get("user.name");
        JobClient jobClient = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createJobClient(user, conf);
        String launcherId = action.getExternalId();
        final RunningJob launcherJob = jobClient.getJob(JobID.forName((String)launcherId));
        this.waitFor(240000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return launcherJob.isComplete();
            }
        });
        TestActionStartXCommand.assertTrue((boolean)launcherJob.isSuccessful());
        Map actionData = LauncherMapperHelper.getActionData((FileSystem)this.getFileSystem(), (Path)context.getActionDir(), (Configuration)conf);
        TestActionStartXCommand.assertTrue((boolean)LauncherMapperHelper.hasIdSwap((Map)actionData));
    }

    protected WorkflowJobBean addRecordToWfJobTableWithCustomAppPath(WorkflowJob.Status jobStatus, WorkflowInstance.Status instanceStatus) throws Exception {
        LiteWorkflowApp app = new LiteWorkflowApp("testApp", "<workflow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        Configuration conf = new Configuration();
        Path appUri = this.getAppPath();
        conf.set("oozie.wf.application.path", appUri.toString());
        conf.set("oozie.wf.log.token", "testToken");
        conf.set("user.name", TestActionStartXCommand.getTestUser());
        WorkflowJobBean wfBean = this.createWorkflow((WorkflowApp)app, conf, jobStatus, instanceStatus);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestActionStartXCommand.assertNotNull((Object)jpaService);
            WorkflowJobInsertJPAExecutor wfInsertCmd = new WorkflowJobInsertJPAExecutor(wfBean);
            jpaService.execute((JPAExecutor)wfInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestActionStartXCommand.fail((String)"Unable to insert the test wf job record to table");
            throw je;
        }
        return wfBean;
    }

    protected WorkflowActionBean addRecordToWfActionTableWithAppPathConfig(String wfId, String actionName, WorkflowAction.Status status) throws Exception {
        WorkflowActionBean action = this.createWorkflowActionWithAppPathConfig(wfId, status);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestActionStartXCommand.assertNotNull((Object)jpaService);
            WorkflowActionInsertJPAExecutor actionInsertCmd = new WorkflowActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)actionInsertCmd);
        }
        catch (JPAExecutorException ce) {
            ce.printStackTrace();
            TestActionStartXCommand.fail((String)"Unable to insert the test wf action record to table");
            throw ce;
        }
        return action;
    }

    protected WorkflowActionBean createWorkflowActionWithAppPathConfig(String wfId, WorkflowAction.Status status) throws Exception {
        WorkflowActionBean action = new WorkflowActionBean();
        String actionname = "testAction";
        action.setName(actionname);
        action.setId(((UUIDService)Services.get().get(UUIDService.class)).generateChildId(wfId, actionname));
        action.setJobId(wfId);
        action.setType("map-reduce");
        action.setTransition("transition");
        action.setStatus(status);
        action.setStartTime(new Date());
        action.setEndTime(new Date());
        action.setLastCheckTime(new Date());
        action.setPending();
        Path inputDir = new Path(this.getFsTestCaseDir(), "input");
        Path outputDir = new Path(this.getFsTestCaseDir(), "output");
        FileSystem fs = this.getFileSystem();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "data.txt")));
        w.write("dummy\n");
        w.write("dummy\n");
        ((Writer)w).close();
        String actionXml = "<map-reduce><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>mapred.mapper.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>mapred.reducer.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>work.dir</name><value>${wf:appPath()}/sub</value></property><property><name>mapred.input.dir</name><value>" + inputDir.toString() + "</value></property><property><name>mapred.output.dir</name><value>" + outputDir.toString() + "</value></property></configuration></map-reduce>";
        action.setConf(actionXml);
        return action;
    }

    @Override
    protected WorkflowActionBean addRecordToWfActionTable(String wfId, String actionName, WorkflowAction.Status status) throws Exception {
        WorkflowActionBean action = this.createWorkflowActionSetPending(wfId, status);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestActionStartXCommand.assertNotNull((Object)jpaService);
            WorkflowActionInsertJPAExecutor actionInsertCmd = new WorkflowActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)actionInsertCmd);
        }
        catch (JPAExecutorException ce) {
            ce.printStackTrace();
            TestActionStartXCommand.fail((String)"Unable to insert the test wf action record to table");
            throw ce;
        }
        return action;
    }

    private WorkflowActionBean addRecordToWfActionTableWithFS(String wfId, String actionName, WorkflowAction.Status status) throws Exception {
        WorkflowActionBean action = this.createWorkflowActionForFS(wfId, status);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestActionStartXCommand.assertNotNull((Object)jpaService);
            WorkflowActionInsertJPAExecutor actionInsertCmd = new WorkflowActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)actionInsertCmd);
        }
        catch (JPAExecutorException ce) {
            ce.printStackTrace();
            TestActionStartXCommand.fail((String)"Unable to insert the test wf action record to table");
            throw ce;
        }
        return action;
    }

    protected WorkflowActionBean createWorkflowActionSetPending(String wfId, WorkflowAction.Status status) throws Exception {
        WorkflowActionBean action = new WorkflowActionBean();
        String actionname = "testAction";
        action.setName(actionname);
        action.setId(((UUIDService)Services.get().get(UUIDService.class)).generateChildId(wfId, actionname));
        action.setJobId(wfId);
        action.setType("map-reduce");
        action.setTransition("transition");
        action.setStatus(status);
        action.setStartTime(new Date());
        action.setEndTime(new Date());
        action.setLastCheckTime(new Date());
        action.setPending();
        Path inputDir = new Path(this.getFsTestCaseDir(), "input");
        Path outputDir = new Path(this.getFsTestCaseDir(), "output");
        FileSystem fs = this.getFileSystem();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "data.txt")));
        w.write("dummy\n");
        w.write("dummy\n");
        ((Writer)w).close();
        String actionXml = "<map-reduce><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>mapred.mapper.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>mapred.reducer.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>mapred.input.dir</name><value>" + inputDir.toString() + "</value></property><property><name>mapred.output.dir</name><value>" + outputDir.toString() + "</value></property></configuration></map-reduce>";
        action.setConf(actionXml);
        return action;
    }

    private WorkflowJobBean addRecordToWfJobTableWithEscapedStringAndCDATA(WorkflowJob.Status jobStatus, WorkflowInstance.Status instanceStatus) throws Exception {
        LiteWorkflowApp app = new LiteWorkflowApp("testApp", "<workflow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        Configuration conf = new Configuration();
        Path appUri = new Path(this.getAppPath(), "workflow.xml");
        conf.set("oozie.wf.application.path", appUri.toString());
        conf.set("oozie.wf.log.token", "testToken");
        conf.set("user.name", TestActionStartXCommand.getTestUser());
        conf.set("testAmpSign", "http://test.apache.com/a-webservices?urlSigner=signUrl&namespace=nova.proxy");
        conf.set("testCDATA", "<![CDATA[?redirect=http%3A%2F%2Ftest.apache.com%2Fa-webservices%2Fv1%2FurlSigner%2FsignUrl&amp;namespace=nova.proxy&amp;keyDBHash=Vsy6n_C7K6NG0z4R2eBlKg--]]>");
        WorkflowJobBean wfBean = this.createWorkflow((WorkflowApp)app, conf, jobStatus, instanceStatus);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestActionStartXCommand.assertNotNull((Object)jpaService);
            WorkflowJobInsertJPAExecutor wfInsertCmd = new WorkflowJobInsertJPAExecutor(wfBean);
            jpaService.execute((JPAExecutor)wfInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestActionStartXCommand.fail((String)"Unable to insert the test wf job record to table");
        }
        return wfBean;
    }

    private WorkflowActionBean addRecordToWfActionTableWithEscapedStringAndCDATA(String wfId, WorkflowAction.Status status) throws Exception {
        WorkflowActionBean action = this.createWorkflowActionSetPendingWithEscapedStringAndCDATA(wfId, status);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestActionStartXCommand.assertNotNull((Object)jpaService);
            WorkflowActionInsertJPAExecutor actionInsertCmd = new WorkflowActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)actionInsertCmd);
        }
        catch (JPAExecutorException ce) {
            ce.printStackTrace();
            TestActionStartXCommand.fail((String)"Unable to insert the test wf action record to table");
        }
        return action;
    }

    private WorkflowActionBean createWorkflowActionSetPendingWithEscapedStringAndCDATA(String wfId, WorkflowAction.Status status) throws Exception {
        WorkflowActionBean action = new WorkflowActionBean();
        String actionname = "testAction";
        action.setName(actionname);
        action.setId(((UUIDService)Services.get().get(UUIDService.class)).generateChildId(wfId, actionname));
        action.setJobId(wfId);
        action.setType("map-reduce");
        action.setTransition("transition");
        action.setStatus(status);
        action.setStartTime(new Date());
        action.setEndTime(new Date());
        action.setLastCheckTime(new Date());
        action.setPending();
        Path inputDir = new Path(this.getFsTestCaseDir(), "input");
        Path outputDir = new Path(this.getFsTestCaseDir(), "output");
        FileSystem fs = this.getFileSystem();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "data.txt")));
        w.write("dummy\n");
        w.write("dummy\n");
        ((Writer)w).close();
        String actionXml = "<map-reduce><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>mapred.mapper.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>mapred.reducer.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>mapred.input.dir</name><value>" + inputDir.toString() + "</value></property><property><name>mapred.output.dir</name><value>" + outputDir.toString() + "</value></property><property><name>test.ampsign</name><value>${testAmpSign}</value></property><property><name>test.cdata</name><value>${testCDATA}</value></property></configuration></map-reduce>";
        action.setConf(actionXml);
        return action;
    }

    private WorkflowActionBean createWorkflowActionForFS(String wfId, WorkflowAction.Status status) throws Exception {
        WorkflowActionBean action = new WorkflowActionBean();
        String actionname = "testAction";
        action.setName(actionname);
        action.setId(((UUIDService)Services.get().get(UUIDService.class)).generateChildId(wfId, actionname));
        action.setJobId(wfId);
        action.setType("fs");
        action.setTransition("transition");
        action.setStatus(status);
        action.setStartTime(new Date());
        action.setEndTime(new Date());
        action.setLastCheckTime(new Date());
        action.setPending();
        action.setExecutionPath("a");
        action.setRetries(1);
        action.setUserRetryCount(0);
        action.setUserRetryMax(1);
        Path path = new Path(this.getFsTestCaseDir(), "test");
        FileSystem fs = this.getFileSystem();
        fs.mkdirs(path);
        fs.setPermission(path, FsPermission.valueOf((String)"-rwx------"));
        String actionXml = "<fs><chmod path='" + path.toString() + "' permissions='-r--------' dir-files='false' /></fs>";
        action.setConf(actionXml);
        return action;
    }
}

