/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.Services;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XConfiguration;

public class TestFutureActionsTimeOut
extends XTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testEngine() throws Exception {
        String appPath = this.getTestCaseFileUri("coordinator.xml");
        String jobId = this._testSubmitJob(appPath);
        Date createDate = new Date();
        this._testTimeout(jobId, createDate);
    }

    private String _testSubmitJob(String appPath) throws Exception {
        XConfiguration conf = new XConfiguration();
        GregorianCalendar start = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        start.add(12, -15);
        GregorianCalendar end = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        end.add(12, 45);
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"5\" start=\"" + start.get(1) + "-" + (start.get(2) + 1) + "-" + start.get(5) + "T" + start.get(11) + ":" + start.get(12) + "Z\" end=\"" + end.get(1) + "-" + (end.get(2) + 1) + "-" + end.get(5) + "T" + end.get(11) + ":" + end.get(12) + "Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.1\"> <controls> <timeout>10</timeout> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:days(7)}\" initial-instance=\"9999-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("${YEAR}/${DAY}") + "</uri-template> </dataset> <dataset name=\"local_a\" frequency=\"${coord:days(7)}\" initial-instance=\"9999-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("${YEAR}/${DAY}") + "</uri-template> </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        System.out.println(appXml);
        this.writeToFile(appXml, appPath);
        conf.set("oozie.coord.application.path", appPath);
        conf.set("user.name", TestFutureActionsTimeOut.getTestUser());
        CoordinatorEngine ce = new CoordinatorEngine(TestFutureActionsTimeOut.getTestUser());
        String jobId = ce.submitJob((Configuration)conf, true);
        TestFutureActionsTimeOut.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
        this.checkCoordJob(jobId);
        return jobId;
    }

    private void checkCoordJob(String jobId) throws StoreException {
        CoordinatorJobBean coordJob = null;
        try {
            coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{jobId});
        }
        catch (JPAExecutorException e) {
            TestFutureActionsTimeOut.fail((String)("Job ID " + jobId + " was not stored properly in db"));
        }
    }

    private void writeToFile(String appXml, String appPath) throws Exception {
        File wf = new File(new URI(appPath).getPath());
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(wf));
            out.println(appXml);
        }
    }

    private void _testTimeout(final String jobId, Date createDate) throws Exception {
        final CoordinatorEngine ce = new CoordinatorEngine(TestFutureActionsTimeOut.getTestUser());
        this.waitFor(12000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean job = ce.getCoordJob(jobId);
                return !job.getStatus().equals((Object)Job.Status.PREP);
            }
        });
        CoordinatorJobBean job = ce.getCoordJob(jobId);
        TestFutureActionsTimeOut.assertTrue((!job.getStatus().equals((Object)Job.Status.PREP) ? 1 : 0) != 0);
        this.waitFor(12000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean job = ce.getCoordJob(jobId);
                List actions = job.getActions();
                return actions.size() > 0;
            }
        });
        job = ce.getCoordJob(jobId);
        List actions = job.getActions();
        TestFutureActionsTimeOut.assertTrue((actions.size() > 0 ? 1 : 0) != 0);
        for (CoordinatorAction action : actions) {
            CoordinatorActionBean jsonAction = (CoordinatorActionBean)action;
            if (jsonAction.getNominalTime().before(createDate)) {
                TestFutureActionsTimeOut.assertEquals((int)10, (int)jsonAction.getTimeOut());
                continue;
            }
            TestFutureActionsTimeOut.assertEquals((int)10, (int)jsonAction.getTimeOut());
        }
    }
}

