/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.bundle.BundleStartXCommand;
import org.apache.oozie.command.bundle.BundleSubmitXCommand;
import org.apache.oozie.command.coord.CoordActionsKillXCommand;
import org.apache.oozie.command.coord.CoordSubmitXCommand;
import org.apache.oozie.command.coord.CoordUpdateXCommand;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.Namespace;

public class TestCoordUpdateXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
        LocalOozie.stop();
    }

    private String setupCoord(Configuration conf, String coordFile) throws CommandException, IOException {
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        Reader reader = IOUtils.getResourceAsReader((String)coordFile, (int)-1);
        FileWriter writer = new FileWriter(appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordUpdateXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand(conf);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        sc = new CoordSubmitXCommand(conf);
        return (String)sc.call();
    }

    public void testConfChange() throws Exception {
        XConfiguration conf = new XConfiguration();
        String jobId = this.setupCoord((Configuration)conf, "coord-multiple-input-instance3.xml");
        String addedProperty = "jobrerun";
        XConfiguration xConf = new XConfiguration();
        TestCoordUpdateXCommand.assertNull((Object)xConf.get(addedProperty));
        conf.set(addedProperty, "true");
        CoordinatorJobBean job = this.getCoordJobs(jobId);
        xConf = new XConfiguration((Reader)new StringReader(job.getConf()));
        CoordUpdateXCommand update = new CoordUpdateXCommand(false, (Configuration)conf, jobId);
        String diff = (String)update.call();
        job = this.getCoordJobs(jobId);
        xConf = new XConfiguration((Reader)new StringReader(job.getConf()));
        TestCoordUpdateXCommand.assertEquals((String)xConf.get(addedProperty), (String)"true");
        TestCoordUpdateXCommand.assertTrue((boolean)diff.contains("+    <name>jobrerun</name>"));
        TestCoordUpdateXCommand.assertTrue((boolean)diff.contains("+    <value>true</value>"));
    }

    public void testDefinitionChange() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile1 = new File(this.getTestCaseDir(), "coordinator.xml");
        String jobId = this.setupCoord((Configuration)conf, "coord-multiple-input-instance3.xml");
        CoordinatorJobBean job = this.getCoordJobs(jobId);
        Element processedJobXml = XmlUtils.parseXml((String)job.getJobXml());
        Namespace namespace = processedJobXml.getNamespace();
        String text = ((Element)processedJobXml.getChild("input-events", namespace).getChild("data-in", namespace).getChildren("instance", namespace).get(0)).getText();
        TestCoordUpdateXCommand.assertEquals((String)text, (String)"${coord:latest(0)}");
        Reader reader = IOUtils.getResourceAsReader((String)"coord-multiple-input-instance4.xml", (int)-1);
        FileWriter writer = new FileWriter(appPathFile1);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        conf.set("oozie.coord.application.path", appPathFile1.toURI().toString());
        job = this.getCoordJobs(jobId);
        CoordUpdateXCommand update = new CoordUpdateXCommand(false, (Configuration)conf, jobId);
        update.call();
        job = this.getCoordJobs(jobId);
        processedJobXml = XmlUtils.parseXml((String)job.getJobXml());
        namespace = processedJobXml.getNamespace();
        text = ((Element)processedJobXml.getChild("input-events", namespace).getChild("data-in", namespace).getChildren("instance", namespace).get(0)).getText();
        TestCoordUpdateXCommand.assertEquals((String)text, (String)"${coord:future(0, 1)}");
    }

    public void testCoordDefinitionChangeError() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile1 = new File(this.getTestCaseDir(), "coordinator.xml");
        String jobId = this.setupCoord((Configuration)conf, "coord-multiple-input-instance3.xml");
        CoordinatorJobBean job = this.getCoordJobs(jobId);
        Element processedJobXml = XmlUtils.parseXml((String)job.getJobXml());
        Namespace namespace = processedJobXml.getNamespace();
        String text = ((Element)processedJobXml.getChild("input-events", namespace).getChild("data-in", namespace).getChildren("instance", namespace).get(0)).getText();
        TestCoordUpdateXCommand.assertEquals((String)text, (String)"${coord:latest(0)}");
        Reader reader = IOUtils.getResourceAsReader((String)"coord-multiple-input-instance1.xml", (int)-1);
        FileWriter writer = new FileWriter(appPathFile1);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        conf.set("oozie.coord.application.path", appPathFile1.toURI().toString());
        job = this.getCoordJobs(jobId);
        CoordUpdateXCommand update = new CoordUpdateXCommand(false, (Configuration)conf, jobId);
        try {
            update.call();
            TestCoordUpdateXCommand.fail((String)" should not come here");
        }
        catch (Exception e) {
            TestCoordUpdateXCommand.assertTrue((boolean)e.getMessage().contains("E1021: Coord Action Input Check Error"));
        }
    }

    public void testCoordDefUnsupportedChange() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("start", "2009-02-01T01:00Z");
        conf.set("end", "2012-02-03T23:59Z");
        conf.set("unit", "UTC");
        conf.set("name", "NAME");
        conf.set("throttle", "12");
        conf.set("concurrency", "12");
        conf.set("execution", "FIFO");
        conf.set("timeout", "10");
        String jobId = this.setupCoord((Configuration)conf, "coord-update-test.xml");
        XConfiguration newConf = new XConfiguration(conf.toProperties());
        newConf.set("start", "2010-02-01T01:00Z");
        try {
            new CoordUpdateXCommand(false, (Configuration)newConf, jobId).call();
            TestCoordUpdateXCommand.fail((String)" should not come here");
        }
        catch (XException e) {
            TestCoordUpdateXCommand.assertTrue((boolean)e.getMessage().contains("Start time can't be changed"));
        }
        newConf = new XConfiguration(conf.toProperties());
        newConf.set("end", "2015-02-03T23:59Z");
        try {
            new CoordUpdateXCommand(false, (Configuration)newConf, jobId).call();
            TestCoordUpdateXCommand.fail((String)" should not come here");
        }
        catch (XException e) {
            TestCoordUpdateXCommand.assertTrue((boolean)e.getMessage().contains("End time can't be changed"));
        }
        newConf = new XConfiguration(conf.toProperties());
        newConf.set("name", "test");
        try {
            new CoordUpdateXCommand(false, (Configuration)newConf, jobId).call();
            TestCoordUpdateXCommand.fail((String)" should not come here");
        }
        catch (XException e) {
            TestCoordUpdateXCommand.assertTrue((boolean)e.getMessage().contains("Coord name can't be changed"));
        }
        newConf = new XConfiguration(conf.toProperties());
        newConf.set("unit", "America/New_York");
        try {
            new CoordUpdateXCommand(false, (Configuration)newConf, jobId).call();
            TestCoordUpdateXCommand.fail((String)" should not come here");
        }
        catch (XException e) {
            TestCoordUpdateXCommand.assertTrue((boolean)e.getMessage().contains("TimeZone can't be changed"));
        }
    }

    public void testUpdateControl() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("start", "2009-02-01T01:00Z");
        conf.set("end", "2012-02-03T23:59Z");
        conf.set("unit", "UTC");
        conf.set("name", "NAME");
        conf.set("throttle", "12");
        conf.set("concurrency", "12");
        conf.set("execution", "FIFO");
        conf.set("timeout", "7");
        String jobId = this.setupCoord((Configuration)conf, "coord-update-test.xml");
        CoordinatorJobBean job = this.getCoordJobs(jobId);
        TestCoordUpdateXCommand.assertEquals((int)12, (int)job.getMatThrottling());
        TestCoordUpdateXCommand.assertEquals((int)12, (int)job.getConcurrency());
        TestCoordUpdateXCommand.assertEquals((int)7, (int)job.getTimeout());
        TestCoordUpdateXCommand.assertEquals((String)"FIFO", (String)job.getExecution());
        XConfiguration newConf = new XConfiguration(conf.toProperties());
        newConf.set("throttle", "8");
        new CoordUpdateXCommand(false, (Configuration)newConf, jobId).call();
        job = this.getCoordJobs(jobId);
        TestCoordUpdateXCommand.assertEquals((int)8, (int)job.getMatThrottling());
        newConf = new XConfiguration(conf.toProperties());
        newConf.set("concurrency", "5");
        new CoordUpdateXCommand(false, (Configuration)newConf, jobId).call();
        job = this.getCoordJobs(jobId);
        TestCoordUpdateXCommand.assertEquals((int)5, (int)job.getConcurrency());
        newConf = new XConfiguration(conf.toProperties());
        newConf.set("timeout", "10");
        new CoordUpdateXCommand(false, (Configuration)newConf, jobId).call();
        job = this.getCoordJobs(jobId);
        TestCoordUpdateXCommand.assertEquals((int)10, (int)job.getTimeout());
        newConf = new XConfiguration(conf.toProperties());
        newConf.set("execution", "LIFO");
        new CoordUpdateXCommand(false, (Configuration)newConf, jobId).call();
        job = this.getCoordJobs(jobId);
        TestCoordUpdateXCommand.assertEquals((String)"LIFO", (String)job.getExecution());
    }

    public void testReRunRefresh() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile1 = new File(this.getTestCaseDir(), "coordinator.xml");
        String jobId = this.setupCoord((Configuration)conf, "coord-multiple-input-instance3.xml");
        this.sleep(1000);
        boolean actionNum = true;
        final String actionId = jobId + "@" + 1;
        final OozieClient coordClient = LocalOozie.getCoordClient();
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorAction bean = coordClient.getCoordActionInfo(actionId);
                return bean.getStatus() == CoordinatorAction.Status.WAITING || bean.getStatus() == CoordinatorAction.Status.SUBMITTED;
            }
        });
        CoordinatorAction bean = coordClient.getCoordActionInfo(actionId);
        TestCoordUpdateXCommand.assertEquals((String)bean.getMissingDependencies(), (String)"!!${coord:latest(0)}#${coord:latest(-1)}");
        CoordinatorJobBean job = this.getCoordJobs(jobId);
        Reader reader = IOUtils.getResourceAsReader((String)"coord-multiple-input-instance4.xml", (int)-1);
        FileWriter writer = new FileWriter(appPathFile1);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        conf.set("oozie.coord.application.path", appPathFile1.toURI().toString());
        new CoordUpdateXCommand(false, (Configuration)conf, jobId).call();
        job = this.getCoordJobs(jobId);
        Element processedJobXml = XmlUtils.parseXml((String)job.getJobXml());
        Namespace namespace = processedJobXml.getNamespace();
        String text = ((Element)processedJobXml.getChild("input-events", namespace).getChild("data-in", namespace).getChildren("instance", namespace).get(0)).getText();
        TestCoordUpdateXCommand.assertEquals((String)text, (String)"${coord:future(0, 1)}");
        new CoordActionsKillXCommand(jobId, "action", Integer.toString(1)).call();
        coordClient.reRunCoord(jobId, "action", Integer.toString(1), true, true);
        bean = coordClient.getCoordActionInfo(actionId);
        this.sleep(1000);
        TestCoordUpdateXCommand.assertEquals((String)bean.getMissingDependencies(), (String)"!!${coord:future(0, 1)}");
    }

    public void testCoordFromBundleJobChangeConf() throws Exception {
        XConfiguration jobConf = new XConfiguration();
        String coordJobId = this.setUpBundleAndGetCoordID(jobConf);
        jobConf.set("newvalue", "yes");
        CoordUpdateXCommand update = new CoordUpdateXCommand(false, (Configuration)jobConf, coordJobId);
        update.call();
        CoordinatorJobBean job = this.getCoordJobs(coordJobId);
        XConfiguration xConf = new XConfiguration((Reader)new StringReader(job.getConf()));
        TestCoordUpdateXCommand.assertEquals((String)xConf.get("newvalue"), (String)"yes");
        jobConf.set("testProperty", "xyz");
        new CoordUpdateXCommand(false, (Configuration)jobConf, coordJobId).call();
        job = this.getCoordJobs(coordJobId);
        xConf = new XConfiguration((Reader)new StringReader(job.getConf()));
        TestCoordUpdateXCommand.assertEquals((String)xConf.get("testProperty"), (String)"xyz");
    }

    public void testCoordFromBundleJobChangeDefinition() throws Exception {
        XConfiguration jobConf = new XConfiguration();
        String coordJobId = this.setUpBundleAndGetCoordID(jobConf);
        CoordinatorJobBean job = this.getCoordJobs(coordJobId);
        Element processedJobXml = XmlUtils.parseXml((String)job.getJobXml());
        Namespace namespace = processedJobXml.getNamespace();
        String text = ((Element)processedJobXml.getChild("input-events", namespace).getChild("data-in", namespace).getChildren("instance", namespace).get(0)).getText();
        TestCoordUpdateXCommand.assertEquals((String)text, (String)"${coord:latest(0)}");
        Path coordPath1 = new Path(this.getFsTestCaseDir(), "coord1");
        this.writeCoordXml(coordPath1, "coord-multiple-input-instance4.xml");
        Configuration newConf = new Configuration();
        newConf.set("user.name", TestCoordUpdateXCommand.getTestUser());
        CoordUpdateXCommand update = new CoordUpdateXCommand(false, newConf, coordJobId);
        update.call();
        job = this.getCoordJobs(coordJobId);
        processedJobXml = XmlUtils.parseXml((String)job.getJobXml());
        namespace = processedJobXml.getNamespace();
        text = ((Element)processedJobXml.getChild("input-events", namespace).getChild("data-in", namespace).getChildren("instance", namespace).get(0)).getText();
        TestCoordUpdateXCommand.assertEquals((String)text, (String)"${coord:future(0, 1)}");
    }

    private String setUpBundleAndGetCoordID(XConfiguration jobConf) throws UnsupportedEncodingException, IOException, CommandException, JPAExecutorException {
        Path coordPath1 = new Path(this.getFsTestCaseDir(), "coord1");
        Path coordPath2 = new Path(this.getFsTestCaseDir(), "coord2");
        this.writeCoordXml(coordPath1, "coord-multiple-input-instance3.xml");
        this.writeCoordXml(coordPath2, "coord-multiple-input-instance3.xml");
        Path bundleAppPath = new Path(this.getFsTestCaseDir(), "bundle");
        String bundleAppXml = this.getBundleXml("bundle-submit-job.xml");
        TestCoordUpdateXCommand.assertNotNull((Object)bundleAppXml);
        TestCoordUpdateXCommand.assertTrue((bundleAppXml.length() > 0 ? 1 : 0) != 0);
        bundleAppXml = bundleAppXml.replaceAll("#app_path1", Matcher.quoteReplacement(new Path(coordPath1.toString(), "coordinator.xml").toString()));
        bundleAppXml = bundleAppXml.replaceAll("#app_path2", Matcher.quoteReplacement(new Path(coordPath2.toString(), "coordinator.xml").toString()));
        this.writeToFile(bundleAppXml, bundleAppPath, "bundle.xml");
        Path appPath = new Path(bundleAppPath, "bundle.xml");
        jobConf.set("oozie.bundle.application.path", appPath.toString());
        jobConf.set("appName", "test");
        jobConf.set("user.name", TestCoordUpdateXCommand.getTestUser());
        jobConf.set("coordName1", "NAME");
        jobConf.set("coordName2", "coord2");
        jobConf.set("isEnabled", "true");
        BundleSubmitXCommand command = new BundleSubmitXCommand((Configuration)jobConf);
        BundleJobBean bundleBean = (BundleJobBean)command.getJob();
        bundleBean.setStartTime(new Date());
        bundleBean.setEndTime(new Date());
        final String jobId = (String)command.call();
        this.sleep(2000);
        new BundleStartXCommand(jobId).call();
        this.waitFor(200000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{jobId});
                return ((BundleActionBean)actions.get(0)).getStatus().equals((Object)Job.Status.RUNNING);
            }
        });
        List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{jobId});
        return ((BundleActionBean)actions.get(0)).getCoordId();
    }

    private CoordinatorJobBean getCoordJobs(String jobId) {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            CoordinatorJobBean job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobId));
            return job;
        }
        catch (JPAExecutorException e) {
            TestCoordUpdateXCommand.fail((String)("Job ID " + jobId + " was not stored properly in db"));
            return null;
        }
    }
}

