/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordKillXCommand;
import org.apache.oozie.command.coord.CoordMaterializeTransitionXCommand;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.PartitionDependencyManagerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.StatusTransitService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.HCatURI;
import org.apache.oozie.util.XCallable;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestCoordKillXCommand
extends XDataTestCase {
    private Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordKillSuccess1() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 0);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.READY, "coord-action-get.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordKillXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(action.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestCoordKillXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
        TestCoordKillXCommand.assertEquals((Object)action.getStatus(), (Object)CoordinatorAction.Status.READY);
        TestCoordKillXCommand.assertFalse((boolean)job.isDoneMaterialization());
        new CoordKillXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestCoordKillXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.KILLED);
        TestCoordKillXCommand.assertTrue((boolean)job.isDoneMaterialization());
        TestCoordKillXCommand.assertNotNull((Object)job.getLastModifiedTime());
        TestCoordKillXCommand.assertEquals((Object)action.getStatus(), (Object)CoordinatorAction.Status.KILLED);
        job.setStatus(Job.Status.RUNNINGWITHERROR);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS, job);
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordKillXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNINGWITHERROR);
        CoordMaterializeTransitionXCommand transitionCmd = new CoordMaterializeTransitionXCommand(job.getId(), 3600);
        try {
            transitionCmd.loadState();
            transitionCmd.verifyPrecondition();
            TestCoordKillXCommand.fail();
        }
        catch (PreconditionException preconditionException) {
            // empty catch block
        }
        StatusTransitService.StatusTransitRunnable statusTransit = new StatusTransitService.StatusTransitRunnable();
        statusTransit.run();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordKillXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.KILLED);
        TestCoordKillXCommand.assertTrue((boolean)job.isDoneMaterialization());
        TestCoordKillXCommand.assertNotNull((Object)job.getLastModifiedTime());
    }

    public void testCoordKillSuccess2() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, true, 0);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordKillXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(action.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestCoordKillXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
        TestCoordKillXCommand.assertEquals((Object)action.getStatus(), (Object)CoordinatorAction.Status.RUNNING);
        new CoordKillXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestCoordKillXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.KILLED);
        TestCoordKillXCommand.assertNotNull((Object)job.getLastModifiedTime());
        TestCoordKillXCommand.assertEquals((Object)action.getStatus(), (Object)CoordinatorAction.Status.KILLED);
    }

    public void testCoordKillFailedOnAction() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, true);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordKillXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(action.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestCoordKillXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUCCEEDED);
        TestCoordKillXCommand.assertEquals((Object)action.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        new CoordKillXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestCoordKillXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUCCEEDED);
        TestCoordKillXCommand.assertEquals((Object)action.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
    }

    public void testCoordKillForBackwardSupport() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.coord.status", "true");
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordKillXCommand.assertNotNull((Object)jpaService);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, true);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        job.setAppNamespace("uri:oozie:coordinator:0.1");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_APPNAMESPACE, job);
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(action.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestCoordKillXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)job.getStatus());
        TestCoordKillXCommand.assertEquals((Object)CoordinatorAction.Status.RUNNING, (Object)action.getStatus());
        new CoordKillXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestCoordKillXCommand.assertEquals((Object)Job.Status.KILLED, (Object)job.getStatus());
        TestCoordKillXCommand.assertEquals((Object)CoordinatorAction.Status.KILLED, (Object)action.getStatus());
    }

    public void testCoordKillFailed() throws Exception {
        String testJobId = "0000001-" + new Date().getTime() + "-testCoordKill-C";
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, true);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.READY, "coord-action-get.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordKillXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(action.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestCoordKillXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUCCEEDED);
        TestCoordKillXCommand.assertEquals((Object)action.getStatus(), (Object)CoordinatorAction.Status.READY);
        try {
            new CoordKillXCommand(testJobId).call();
            TestCoordKillXCommand.fail((String)"Job doesn't exist. Should fail.");
        }
        catch (CommandException commandException) {
            // empty catch block
        }
    }

    public void testCoordKillWaiting() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, true, 0);
        WorkflowJobBean wfJob1 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJob1.getId(), "RUNNING", 0);
        CoordinatorActionBean action2 = this.addRecordToCoordActionTable(coordJob.getId(), 2, CoordinatorAction.Status.WAITING, "coord-action-get.xml", null, null, 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordKillXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd1 = new CoordActionGetJPAExecutor(action1.getId());
        CoordActionGetJPAExecutor coordActionGetCmd2 = new CoordActionGetJPAExecutor(action2.getId());
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        action1 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd1);
        action2 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd2);
        TestCoordKillXCommand.assertEquals((Object)coordJob.getStatus(), (Object)Job.Status.RUNNING);
        TestCoordKillXCommand.assertEquals((Object)action1.getStatus(), (Object)CoordinatorAction.Status.RUNNING);
        TestCoordKillXCommand.assertEquals((Object)action2.getStatus(), (Object)CoordinatorAction.Status.WAITING);
        new CoordKillXCommand(coordJob.getId()).call();
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        action1 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd1);
        action2 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd2);
        TestCoordKillXCommand.assertEquals((Object)coordJob.getStatus(), (Object)Job.Status.KILLED);
        TestCoordKillXCommand.assertEquals((Object)action1.getStatus(), (Object)CoordinatorAction.Status.KILLED);
        TestCoordKillXCommand.assertEquals((int)action1.getPending(), (int)1);
        TestCoordKillXCommand.assertEquals((Object)action2.getStatus(), (Object)CoordinatorAction.Status.KILLED);
        TestCoordKillXCommand.assertEquals((int)action2.getPending(), (int)0);
    }

    public void testCoordKillXCommandUniqueness() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 0);
        final MyCoordKillXCommand callable1 = new MyCoordKillXCommand(job.getId(), 100);
        final MyCoordKillXCommand callable2 = new MyCoordKillXCommand(job.getId(), 100);
        final MyCoordKillXCommand callable3 = new MyCoordKillXCommand(job.getId(), 100);
        List<MyCoordKillXCommand> callables = Arrays.asList(callable1, callable2, callable3);
        CallableQueueService queueservice = (CallableQueueService)this.services.get(CallableQueueService.class);
        for (MyCoordKillXCommand c : callables) {
            queueservice.queue((XCallable)c);
        }
        this.waitFor(1000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return callable1.executed != 0L && callable2.executed == 0L && callable3.executed == 0L;
            }
        });
        TestCoordKillXCommand.assertTrue((callable1.executed != 0L ? 1 : 0) != 0);
        TestCoordKillXCommand.assertTrue((callable2.executed == 0L ? 1 : 0) != 0);
        TestCoordKillXCommand.assertTrue((callable3.executed == 0L ? 1 : 0) != 0);
    }

    public void testCoordKillRemovePushMissingDeps() throws Exception {
        try {
            this.services.destroy();
            this.services = super.setupServicesForHCatalog();
            this.services.init();
            String db = "default";
            String table = "tablename";
            String server = "hcatserver";
            String newHCatDependency1 = "hcat://" + server + "/" + db + "/" + table + "/dt=20120430;country=brazil";
            String newHCatDependency2 = "hcat://" + server + "/" + db + "/" + table + "/dt=20120430;country=usa";
            String pushMissingDeps = newHCatDependency1 + "#" + newHCatDependency2;
            PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
            CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-action-input-check.xml", Job.Status.RUNNING, false, true);
            CoordinatorActionBean action1 = this.addRecordToCoordActionTableForWaiting(job.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-for-action-input-check.xml", null, pushMissingDeps, "Z");
            String newHCatDependency3 = "hcat://" + server + "/" + db + "/" + table + "/dt=20120430;country=russia";
            CoordinatorActionBean action2 = this.addRecordToCoordActionTableForWaiting(job.getId(), 2, CoordinatorAction.Status.WAITING, "coord-action-for-action-input-check.xml", null, newHCatDependency3, "Z");
            HCatURI hcatURI1 = new HCatURI(newHCatDependency1);
            HCatURI hcatURI2 = new HCatURI(newHCatDependency2);
            HCatURI hcatURI3 = new HCatURI(newHCatDependency3);
            pdms.addMissingDependency(hcatURI1, action1.getId());
            pdms.addMissingDependency(hcatURI2, action1.getId());
            pdms.addMissingDependency(hcatURI3, action2.getId());
            TestCoordKillXCommand.assertTrue((boolean)pdms.getWaitingActions(new HCatURI(newHCatDependency1)).contains(action1.getId()));
            TestCoordKillXCommand.assertTrue((boolean)pdms.getWaitingActions(new HCatURI(newHCatDependency2)).contains(action1.getId()));
            TestCoordKillXCommand.assertTrue((boolean)pdms.getWaitingActions(new HCatURI(newHCatDependency3)).contains(action2.getId()));
            new CoordKillXCommand(job.getId()).call();
            TestCoordKillXCommand.assertNull((Object)pdms.getWaitingActions(new HCatURI(newHCatDependency1)));
            TestCoordKillXCommand.assertNull((Object)pdms.getWaitingActions(new HCatURI(newHCatDependency2)));
            TestCoordKillXCommand.assertNull((Object)pdms.getWaitingActions(new HCatURI(newHCatDependency3)));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordKillXCommand.fail((String)e.getMessage());
        }
    }

    public class MyCoordKillXCommand
    extends CoordKillXCommand {
        long executed;
        int wait;

        public MyCoordKillXCommand(String jobId, int wait) {
            super(jobId);
            this.executed = 0L;
            this.wait = wait;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Type:").append(this.getType());
            sb.append(",Priority:").append(this.getPriority());
            return sb.toString();
        }

        protected Void execute() throws CommandException {
            super.execute();
            try {
                Thread.sleep(this.wait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executed = System.currentTimeMillis();
            return null;
        }
    }
}

