/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionsIgnoreXCommand;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;

public class TestCoordActionsIgnoreXCommand
extends XDataTestCase {
    private Services services;
    List<CoordinatorJobBean> coordJobs;
    List<CoordinatorActionBean> coordActions;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionsIgnore() throws Exception {
        this.createDBRecords();
        CoordinatorActionInfo retInfo = (CoordinatorActionInfo)new CoordActionsIgnoreXCommand(this.coordJobs.get(0).getId(), "action", "1").call();
        CoordinatorActionBean actionBean1 = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{this.coordActions.get(0).getId()});
        TestCoordActionsIgnoreXCommand.assertEquals((Object)CoordinatorAction.Status.IGNORED, (Object)actionBean1.getStatus());
        TestCoordActionsIgnoreXCommand.assertEquals((int)1, (int)retInfo.getCoordActions().size());
        TestCoordActionsIgnoreXCommand.assertEquals((String)actionBean1.getId(), (String)((CoordinatorActionBean)retInfo.getCoordActions().get(0)).getId());
        retInfo = (CoordinatorActionInfo)new CoordActionsIgnoreXCommand(this.coordJobs.get(0).getId(), "action", "2-3").call();
        CoordinatorActionBean actionBean2 = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{this.coordActions.get(1).getId()});
        CoordinatorActionBean actionBean3 = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{this.coordActions.get(2).getId()});
        TestCoordActionsIgnoreXCommand.assertEquals((Object)CoordinatorAction.Status.IGNORED, (Object)actionBean2.getStatus());
        TestCoordActionsIgnoreXCommand.assertEquals((Object)CoordinatorAction.Status.IGNORED, (Object)actionBean3.getStatus());
        TestCoordActionsIgnoreXCommand.assertEquals((int)2, (int)retInfo.getCoordActions().size());
        String retId1 = ((CoordinatorActionBean)retInfo.getCoordActions().get(0)).getId();
        String retId2 = ((CoordinatorActionBean)retInfo.getCoordActions().get(1)).getId();
        TestCoordActionsIgnoreXCommand.assertTrue((actionBean2.getId().equals(retId1) || actionBean2.getId().equals(retId2) ? 1 : 0) != 0);
        TestCoordActionsIgnoreXCommand.assertTrue((actionBean3.getId().equals(retId1) || actionBean3.getId().equals(retId2) ? 1 : 0) != 0);
        try {
            new CoordActionsIgnoreXCommand(this.coordJobs.get(0).getId(), "action", "4-5").call();
        }
        catch (CommandException ex) {
            TestCoordActionsIgnoreXCommand.assertEquals((Object)ex.getErrorCode(), (Object)ErrorCode.E1024);
            TestCoordActionsIgnoreXCommand.assertTrue((ex.getMessage().indexOf("part or all actions are not eligible to ignore, check state of action number(s) [5]") > -1 ? 1 : 0) != 0);
        }
        try {
            new CoordActionsIgnoreXCommand(this.coordJobs.get(1).getId(), "action", "1").call();
        }
        catch (CommandException ex) {
            TestCoordActionsIgnoreXCommand.assertEquals((Object)ex.getErrorCode(), (Object)ErrorCode.E1024);
            TestCoordActionsIgnoreXCommand.assertTrue((ex.getMessage().indexOf("No actions are materialized to ignore") > -1 ? 1 : 0) != 0);
        }
    }

    private void createDBRecords() throws Exception {
        JPAService jpaService = (JPAService)this.services.get(JPAService.class);
        this.coordJobs = new ArrayList<CoordinatorJobBean>();
        this.coordActions = new ArrayList<CoordinatorActionBean>();
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-08-01T23:59Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-08-02T23:59Z");
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.KILLED, startTime, endTime, false, true, 0);
        CoordinatorJobBean job2 = this.addRecordToCoordJobTable(Job.Status.PREP, startTime, endTime, false, true, 0);
        this.coordJobs.add(job1);
        this.coordJobs.add(job2);
        CoordinatorActionBean action1_1 = this.addRecordToCoordActionTable(job1.getId(), 1, CoordinatorAction.Status.FAILED, "coord-action-get.xml", 0);
        CoordinatorActionBean action1_2 = this.addRecordToCoordActionTable(job1.getId(), 2, CoordinatorAction.Status.FAILED, "coord-action-get.xml", 0);
        CoordinatorActionBean action1_3 = this.addRecordToCoordActionTable(job1.getId(), 3, CoordinatorAction.Status.KILLED, "coord-action-get.xml", 0);
        CoordinatorActionBean action1_4 = this.addRecordToCoordActionTable(job1.getId(), 4, CoordinatorAction.Status.KILLED, "coord-action-get.xml", 0);
        CoordinatorActionBean action1_5 = this.addRecordToCoordActionTable(job1.getId(), 5, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.coordActions.add(action1_1);
        this.coordActions.add(action1_2);
        this.coordActions.add(action1_3);
        this.coordActions.add(action1_4);
        this.coordActions.add(action1_5);
        action1_1.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-12-15T02:00Z"));
        action1_1.setExternalId(null);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION, (Object)action1_1);
    }
}

