/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Collection;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.command.coord.CoordActionUpdatePushMissingDependency;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.PartitionDependencyManagerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.HCatURI;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestCoordActionUpdatePushMissingDependency
extends XDataTestCase {
    private Services services;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.services = super.setupServicesForHCatalog();
        this.services.init();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    @Test
    public void testUpdateCoordTableBasic() throws Exception {
        String newHCatDependency = "hcat://hcat.server.com:5080/mydb/clicks/datastamp=12;region=us";
        HCatURI hcatUri = new HCatURI(newHCatDependency);
        String actionId = this.addInitRecords(newHCatDependency);
        this.checkCoordAction(actionId, newHCatDependency, CoordinatorAction.Status.WAITING);
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        pdms.addMissingDependency(hcatUri, actionId);
        pdms.partitionAvailable("hcat.server.com:5080", "mydb", "clicks", this.getPartitionMap("src=search;datastamp=12;region=us"));
        Collection availableURIs = pdms.getAvailableDependencyURIs(actionId);
        TestCoordActionUpdatePushMissingDependency.assertEquals((int)availableURIs.size(), (int)1);
        TestCoordActionUpdatePushMissingDependency.assertTrue((boolean)availableURIs.contains(newHCatDependency));
        new CoordActionUpdatePushMissingDependency(actionId).call();
        this.checkCoordAction(actionId, "", CoordinatorAction.Status.READY);
        TestCoordActionUpdatePushMissingDependency.assertNull((Object)pdms.getAvailableDependencyURIs(actionId));
    }

    @Test
    public void testUpdateCoordTableAdvanced() throws Exception {
        String newHCatDependency1 = "hcat://hcat.server.com:5080/mydb/clicks/datastamp=11;region=us";
        String newHCatDependency2 = "hcat://hcat.server.com:5080/mydb/clicks/datastamp=12;region=us";
        HCatURI hcatUri1 = new HCatURI(newHCatDependency1);
        HCatURI hcatUri2 = new HCatURI(newHCatDependency2);
        String fullDeps = newHCatDependency1 + "#" + newHCatDependency2;
        String actionId = this.addInitRecords(fullDeps);
        this.checkCoordAction(actionId, fullDeps, CoordinatorAction.Status.WAITING);
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        pdms.addMissingDependency(hcatUri1, actionId);
        pdms.addMissingDependency(hcatUri2, actionId);
        pdms.partitionAvailable("hcat.server.com:5080", "mydb", "clicks", this.getPartitionMap("src=search;datastamp=12;region=us"));
        Collection availableURIs = pdms.getAvailableDependencyURIs(actionId);
        TestCoordActionUpdatePushMissingDependency.assertEquals((int)1, (int)availableURIs.size());
        TestCoordActionUpdatePushMissingDependency.assertTrue((boolean)availableURIs.contains(newHCatDependency2));
        new CoordActionUpdatePushMissingDependency(actionId).call();
        this.checkCoordAction(actionId, newHCatDependency1, CoordinatorAction.Status.WAITING);
        pdms.partitionAvailable("hcat.server.com:5080", "mydb", "clicks", this.getPartitionMap("src=search;datastamp=11;region=us"));
        availableURIs = pdms.getAvailableDependencyURIs(actionId);
        TestCoordActionUpdatePushMissingDependency.assertEquals((int)1, (int)availableURIs.size());
        TestCoordActionUpdatePushMissingDependency.assertTrue((boolean)availableURIs.contains(newHCatDependency1));
        new CoordActionUpdatePushMissingDependency(actionId).call();
        this.checkCoordAction(actionId, "", CoordinatorAction.Status.READY);
        TestCoordActionUpdatePushMissingDependency.assertNull((Object)pdms.getAvailableDependencyURIs(actionId));
    }

    private CoordinatorActionBean checkCoordAction(String actionId, String expDeps, CoordinatorAction.Status stat) throws Exception {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
            String missDeps = action.getPushMissingDependencies();
            TestCoordActionUpdatePushMissingDependency.assertEquals((String)missDeps, (String)expDeps);
            TestCoordActionUpdatePushMissingDependency.assertEquals((Object)action.getStatus(), (Object)stat);
            return action;
        }
        catch (JPAExecutorException se) {
            throw new Exception("Action ID " + actionId + " was not stored properly in db");
        }
    }
}

