/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.hadoop.MapperReducerForTest;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionStartXCommand;
import org.apache.oozie.executor.jpa.CoordActionGetForStartJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionsGetForJobJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;

public class TestCoordActionStartXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testActionStartCommand() throws IOException, JPAExecutorException, CommandException {
        String actionId = new Date().getTime() + "-COORD-ActionStartCommand-C@1";
        this.addRecordToActionTable(actionId, 1, null);
        new CoordActionStartXCommand(actionId, "me", "myapp", "myjob").call();
        this.checkCoordAction(actionId);
    }

    public void testActionStartWithErrorReported() throws IOException, JPAExecutorException, CommandException {
        String actionId = new Date().getTime() + "-COORD-ActionStartCommand-C@1";
        String wfApp = "<start to='${someParam}' />";
        this.addRecordToActionTable(actionId, 1, wfApp);
        new CoordActionStartXCommand(actionId, "me", "myapp", "myjob").call();
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForStartJPAExecutor(actionId));
        if (action.getStatus() == CoordinatorAction.Status.SUBMITTED) {
            TestCoordActionStartXCommand.fail((String)"Expected status was FAILED due to incorrect XML element");
        }
        TestCoordActionStartXCommand.assertEquals((String)action.getErrorCode(), (String)ErrorCode.E0701.toString());
        TestCoordActionStartXCommand.assertTrue((boolean)action.getErrorMessage().contains("XML schema error, cvc-pattern-valid: Value '${someParam}' is not facet-valid with respect to pattern"));
    }

    public void testActionStartWithEscapeStrings() throws Exception {
        Date start = DateUtils.parseDateOozieTZ((String)"2009-12-15T01:00Z");
        Date end = DateUtils.parseDateOozieTZ((String)"2009-12-16T01:00Z");
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 1);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUBMITTED, "coord-action-start-escape-strings.xml", 0);
        String actionId = action.getId();
        new CoordActionStartXCommand(actionId, TestCoordActionStartXCommand.getTestUser(), "myapp", "myjob").call();
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
        if (action.getStatus() == CoordinatorAction.Status.SUBMITTED) {
            TestCoordActionStartXCommand.fail((String)("CoordActionStartCommand didn't work because the status for action id" + actionId + " is :" + action.getStatus() + " expected to be NOT SUBMITTED (i.e. RUNNING)"));
        }
        final String wfId = action.getExternalId();
        this.waitFor(3000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                List wfActions = (List)jpaService.execute((JPAExecutor)new WorkflowActionsGetForJobJPAExecutor(wfId));
                return wfActions.size() > 0;
            }
        });
        List wfActions = (List)jpaService.execute((JPAExecutor)new WorkflowActionsGetForJobJPAExecutor(wfId));
        TestCoordActionStartXCommand.assertTrue((wfActions.size() > 0 ? 1 : 0) != 0);
        final String wfActionId = ((WorkflowActionBean)wfActions.get(0)).getId();
        this.waitFor(20000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                WorkflowActionBean wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(wfActionId));
                return wfAction.getExternalId() != null;
            }
        });
        WorkflowActionBean wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(wfActionId));
        TestCoordActionStartXCommand.assertNotNull((Object)wfAction.getExternalId());
    }

    @Override
    protected Configuration getCoordConf(Path coordAppPath) throws IOException {
        Path wfAppPath = new Path(this.getFsTestCaseDir(), "app");
        FileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path(wfAppPath, "lib"));
        File jarFile = IOUtils.createJar((File)new File(this.getTestCaseDir()), (String)"test.jar", (Class[])new Class[]{MapperReducerForTest.class});
        FileInputStream is = new FileInputStream(jarFile);
        FSDataOutputStream os = fs.create(new Path(wfAppPath, "lib/test.jar"));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        Path input = new Path(wfAppPath, "input");
        fs.mkdirs(input);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(input, "test.txt")));
        writer.write("hello");
        ((Writer)writer).close();
        String APP1 = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='app'><start to='end'/><end name='end'/></workflow-app>";
        String subWorkflowAppPath = new Path(wfAppPath, "subwf").toString();
        fs.mkdirs(new Path(wfAppPath, "subwf"));
        OutputStreamWriter writer2 = new OutputStreamWriter((OutputStream)fs.create(new Path(subWorkflowAppPath, "workflow.xml")));
        writer2.write("<workflow-app xmlns='uri:oozie:workflow:0.1' name='app'><start to='end'/><end name='end'/></workflow-app>");
        ((Writer)writer2).close();
        Reader reader = IOUtils.getResourceAsReader((String)"wf-url-template.xml", (int)-1);
        OutputStreamWriter writer1 = new OutputStreamWriter((OutputStream)fs.create(new Path(wfAppPath, "workflow.xml")));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer1);
        Properties jobConf = new Properties();
        jobConf.setProperty("oozie.coord.application.path", coordAppPath.toString());
        jobConf.setProperty("user.name", TestCoordActionStartXCommand.getTestUser());
        jobConf.setProperty("group.name", TestCoordActionStartXCommand.getTestGroup());
        jobConf.setProperty("myJobTracker", this.getJobTrackerUri());
        jobConf.setProperty("myNameNode", this.getNameNodeUri());
        jobConf.setProperty("wfAppPath", new Path(wfAppPath, "workflow.xml").toString());
        jobConf.setProperty("mrclass", MapperReducerForTest.class.getName());
        jobConf.setProperty("delPath", new Path(wfAppPath, "output").toString());
        jobConf.setProperty("subWfApp", new Path(wfAppPath, "subwf/workflow.xml").toString());
        return new XConfiguration(jobConf);
    }

    private void addRecordToActionTable(String actionId, int actionNum, String wfParam) throws IOException, JPAExecutorException {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordinatorActionBean action = new CoordinatorActionBean();
        action.setJobId(actionId);
        action.setId(actionId);
        action.setActionNumber(actionNum);
        action.setNominalTime(new Date());
        action.setStatus(CoordinatorAction.Status.SUBMITTED);
        File appPath = new File(this.getTestCaseDir(), "coord/no-op/");
        String actionXml = "<coordinator-app xmlns='uri:oozie:coordinator:0.2' xmlns:sla='uri:oozie:sla:0.1' name='NAME' frequency=\"1\" start='2009-02-01T01:00Z' end='2009-02-03T23:59Z' timezone='UTC' freq_timeunit='DAY' end_of_duration='NONE'  instance-number=\"1\" action-nominal-time=\"2009-02-01T01:00Z\">";
        actionXml = actionXml + "<controls>";
        actionXml = actionXml + "<timeout>10</timeout>";
        actionXml = actionXml + "<concurrency>2</concurrency>";
        actionXml = actionXml + "<execution>LIFO</execution>";
        actionXml = actionXml + "</controls>";
        actionXml = actionXml + "<input-events>";
        actionXml = actionXml + "<data-in name='A' dataset='a'>";
        actionXml = actionXml + "<dataset name='a' frequency='7' initial-instance='2009-02-01T01:00Z' timezone='UTC' freq_timeunit='DAY' end_of_duration='NONE'>";
        actionXml = actionXml + "<uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>";
        actionXml = actionXml + "</dataset>";
        actionXml = actionXml + "<instance>${coord:latest(0)}</instance>";
        actionXml = actionXml + "</data-in>";
        actionXml = actionXml + "</input-events>";
        actionXml = actionXml + "<output-events>";
        actionXml = actionXml + "<data-out name='LOCAL_A' dataset='local_a'>";
        actionXml = actionXml + "<dataset name='local_a' frequency='7' initial-instance='2009-02-01T01:00Z' timezone='UTC' freq_timeunit='DAY' end_of_duration='NONE'>";
        actionXml = actionXml + "<uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>";
        actionXml = actionXml + "</dataset>";
        actionXml = actionXml + "<instance>${coord:current(-1)}</instance>";
        actionXml = actionXml + "</data-out>";
        actionXml = actionXml + "</output-events>";
        actionXml = actionXml + "<action>";
        actionXml = actionXml + "<workflow>";
        actionXml = actionXml + "<app-path>" + appPath.toURI() + "</app-path>";
        actionXml = actionXml + "<configuration>";
        actionXml = actionXml + "<property>";
        actionXml = actionXml + "<name>inputA</name>";
        actionXml = actionXml + "<value>" + this.getTestCaseFileUri("coord/US//2009/02/01") + "</value>";
        actionXml = actionXml + "</property>";
        actionXml = actionXml + "<property>";
        actionXml = actionXml + "<name>inputB</name>";
        actionXml = actionXml + "<value>" + this.getTestCaseFileUri("coord/US//2009/02/01") + "</value>";
        actionXml = actionXml + "</property>";
        actionXml = actionXml + "</configuration>";
        actionXml = actionXml + "</workflow>";
        String slaXml = " <sla:info xmlns:sla='uri:oozie:sla:0.1'> <sla:app-name>test-app</sla:app-name> <sla:nominal-time>2009-03-06T10:00Z</sla:nominal-time> <sla:should-start>5</sla:should-start> <sla:should-end>120</sla:should-end> <sla:notification-msg>Notifying User for nominal time : 2009-03-06T10:00Z </sla:notification-msg> <sla:alert-contact>abc@example.com</sla:alert-contact> <sla:dev-contact>abc@example.com</sla:dev-contact> <sla:qa-contact>abc@example.com</sla:qa-contact> <sla:se-contact>abc@example.com</sla:se-contact></sla:info>";
        actionXml = actionXml + slaXml;
        actionXml = actionXml + "</action>";
        actionXml = actionXml + "</coordinator-app>";
        action.setActionXml(actionXml);
        action.setSlaXml(slaXml);
        String createdConf = "<configuration> ";
        createdConf = createdConf + "<property> <name>execution_order</name> <value>LIFO</value> </property>";
        createdConf = createdConf + "<property> <name>user.name</name> <value>" + TestCoordActionStartXCommand.getTestUser() + "</value> </property>";
        createdConf = createdConf + "<property> <name>group.name</name> <value>other</value> </property>";
        createdConf = createdConf + "<property> <name>app-path</name> <value>" + appPath.toURI() + "/</value> </property>";
        createdConf = createdConf + "<property> <name>jobTracker</name> ";
        createdConf = createdConf + "<value>localhost:9001</value></property>";
        createdConf = createdConf + "<property> <name>nameNode</name> <value>hdfs://localhost:9000</value></property>";
        createdConf = createdConf + "<property> <name>queueName</name> <value>default</value></property>";
        createdConf = createdConf + "</configuration> ";
        action.setCreatedConf(createdConf);
        jpaService.execute((JPAExecutor)new CoordActionInsertJPAExecutor(action));
        String content = "<workflow-app xmlns='uri:oozie:workflow:0.2'  xmlns:sla='uri:oozie:sla:0.1' name='no-op-wf'>";
        if (wfParam != null) {
            if (!wfParam.isEmpty()) {
                content = content + wfParam;
            }
        } else {
            content = content + "<start to='end' />";
        }
        String slaXml2 = " <sla:info> <sla:app-name>test-app</sla:app-name> <sla:nominal-time>2009-03-06T10:00Z</sla:nominal-time> <sla:should-start>5</sla:should-start> <sla:should-end>${2 * HOURS}</sla:should-end> <sla:notification-msg>Notifying User for nominal time : 2009-03-06T10:00Z </sla:notification-msg> <sla:alert-contact>abc@example.com</sla:alert-contact> <sla:dev-contact>abc@example.com</sla:dev-contact> <sla:qa-contact>abc@example.com</sla:qa-contact> <sla:se-contact>abc@example.com</sla:se-contact></sla:info>";
        content = content + "<end name='end' />" + slaXml2 + "</workflow-app>";
        this.writeToFile(content, appPath.getAbsolutePath());
    }

    private void checkCoordAction(String actionId) {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
            if (action.getStatus() == CoordinatorAction.Status.SUBMITTED) {
                TestCoordActionStartXCommand.fail((String)("CoordActionStartCommand didn't work because the status for action id" + actionId + " is :" + action.getStatus() + " expected to be NOT SUBMITTED (i.e. RUNNING)"));
            }
            if (action.getExternalId() != null) {
                WorkflowJobBean wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(action.getExternalId()));
                TestCoordActionStartXCommand.assertEquals((String)wfJob.getParentId(), (String)action.getId());
            }
        }
        catch (JPAExecutorException je) {
            TestCoordActionStartXCommand.fail((String)("Action ID " + actionId + " was not stored properly in db"));
        }
    }

    private void writeToFile(String content, String appPath) throws IOException {
        this.createDir(appPath);
        File wf = new File(appPath, "workflow.xml");
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(wf));
            out.println(content);
        }
    }

    private void createDir(String dir) {
        new File(dir, "_SUCCESS").mkdirs();
    }
}

