/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionInputCheckXCommand;
import org.apache.oozie.command.coord.CoordMaterializeTransitionXCommand;
import org.apache.oozie.command.coord.CoordPushDependencyCheckXCommand;
import org.apache.oozie.coord.input.dependency.CoordOldInputDependency;
import org.apache.oozie.executor.jpa.CoordActionGetForInputCheckJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XCallable;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.junit.Test;

public class TestCoordActionInputCheckXCommand
extends XDataTestCase {
    protected Services services;
    private String TZ;

    protected String getProcessingTZ() {
        return "UTC";
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.log4j.file", "oozie-log4j.properties");
        this.setSystemProperty("oozie.processing.timezone", this.getProcessingTZ());
        this.services = new Services();
        this.services.init();
        this.TZ = this.getProcessingTZ().equals("UTC") ? "Z" : this.getProcessingTZ().substring(3);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionInputCheckXCommandUniqueness() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)("2009-02-01T23:59" + this.TZ));
        Date endTime = DateUtils.parseDateOozieTZ((String)("2009-02-02T23:59" + this.TZ));
        CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-action-input-check.xml", Job.Status.RUNNING, startTime, endTime, false, true, 3);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTableForWaiting(job.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-for-action-input-check.xml");
        this.createTestCaseSubDir("2009/01/29/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/01/22/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/01/15/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/01/08/_SUCCESS".split("/"));
        final MyCoordActionInputCheckXCommand callable1 = new MyCoordActionInputCheckXCommand(action1.getId(), 100, "1");
        final MyCoordActionInputCheckXCommand callable2 = new MyCoordActionInputCheckXCommand(action1.getId(), 100, "2");
        final MyCoordActionInputCheckXCommand callable3 = new MyCoordActionInputCheckXCommand(action1.getId(), 100, "3");
        List<MyCoordActionInputCheckXCommand> callables = Arrays.asList(callable1, callable2, callable3);
        CallableQueueService queueservice = (CallableQueueService)this.services.get(CallableQueueService.class);
        for (MyCoordActionInputCheckXCommand c : callables) {
            queueservice.queue((XCallable)c);
        }
        this.waitFor(200, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return callable1.executed != 0L && callable2.executed == 0L && callable3.executed == 0L;
            }
        });
        TestCoordActionInputCheckXCommand.assertTrue((callable1.executed != 0L ? 1 : 0) != 0);
        TestCoordActionInputCheckXCommand.assertTrue((callable2.executed == 0L ? 1 : 0) != 0);
        TestCoordActionInputCheckXCommand.assertTrue((callable3.executed == 0L ? 1 : 0) != 0);
    }

    public void testActionInputCheck() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-TestCoordActionInputCheckXCommand-C";
        Date startTime = DateUtils.parseDateOozieTZ((String)("2009-02-01T23:59" + this.TZ));
        Date endTime = DateUtils.parseDateOozieTZ((String)("2009-02-02T23:59" + this.TZ));
        CoordinatorJobBean job = this.addRecordToCoordJobTable(jobId, startTime, endTime);
        new CoordMaterializeTransitionXCommand(job.getId(), 3600).call();
        this.createTestCaseSubDir("2009/02/05/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/01/15/_SUCCESS".split("/"));
        new CoordActionInputCheckXCommand(job.getId() + "@1", job.getId()).call();
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(job.getId() + "@1"));
        System.out.println("missingDeps " + action.getMissingDependencies() + " Xml " + action.getActionXml());
        if (action.getMissingDependencies().indexOf("/2009/02/05/") >= 0) {
            TestCoordActionInputCheckXCommand.fail((String)("directory should be resolved :" + action.getMissingDependencies()));
        }
        if (action.getMissingDependencies().indexOf("/2009/01/15/") < 0) {
            TestCoordActionInputCheckXCommand.fail((String)("directory should NOT be resolved :" + action.getMissingDependencies()));
        }
    }

    public void testActionInputMissingDependencies() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-TestCoordActionInputCheckXCommand-C";
        Date startTime = DateUtils.parseDateOozieTZ((String)("2009-02-15T23:59" + this.TZ));
        Date endTime = DateUtils.parseDateOozieTZ((String)("2009-02-16T23:59" + this.TZ));
        CoordinatorJobBean job = this.addRecordToCoordJobTable(jobId, startTime, endTime);
        new CoordMaterializeTransitionXCommand(job.getId(), 3600).call();
        this.createTestCaseSubDir("2009/02/19/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/01/29/_SUCCESS".split("/"));
        new CoordActionInputCheckXCommand(job.getId() + "@1", job.getId()).call();
        CoordinatorActionBean action = null;
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(job.getId() + "@1"));
        }
        catch (JPAExecutorException se) {
            TestCoordActionInputCheckXCommand.fail((String)("Action ID " + job.getId() + "@1 was not stored properly in db"));
        }
        String missDepsOrder = action.getMissingDependencies();
        int index = missDepsOrder.indexOf("/2009/02/19");
        if (index >= 0) {
            TestCoordActionInputCheckXCommand.fail((String)("Dependency should be available! current list: " + missDepsOrder));
        }
        if ((index = missDepsOrder.indexOf("/2009/01/29")) < 0) {
            TestCoordActionInputCheckXCommand.fail((String)("Data should have been in missing dependency list! current list: " + missDepsOrder));
        }
        if ((index = missDepsOrder.indexOf("/2009/02/05")) < 0) {
            TestCoordActionInputCheckXCommand.fail((String)("Data should have been in missing dependency list! current list: " + missDepsOrder));
        }
    }

    public void testActionInputCheckLatestActionCreationTime() throws Exception {
        Services.get().getConf().setBoolean("oozie.service.ELService.latest-el.use-current-time", false);
        String jobId = "0000000-" + new Date().getTime() + "-TestCoordActionInputCheckXCommand-C";
        Date startTime = DateUtils.parseDateOozieTZ((String)("2009-02-15T23:59" + this.TZ));
        Date endTime = DateUtils.parseDateOozieTZ((String)("2009-02-16T23:59" + this.TZ));
        CoordinatorJobBean job = this.addRecordToCoordJobTable(jobId, startTime, endTime, "latest");
        new CoordMaterializeTransitionXCommand(job.getId(), 3600).call();
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        TestCoordActionInputCheckXCommand.assertEquals((String)"!!${coord:latestRange(-3,0)}", (String)action.getMissingDependencies());
        String actionXML = action.getActionXml();
        String actionCreationTime = "2009-02-15T01:00" + this.TZ;
        actionXML = actionXML.replaceAll("action-actual-time=\".*\">", "action-actual-time=\"" + actionCreationTime + "\">");
        action.setActionXml(actionXML);
        action.setCreatedTime(DateUtils.parseDateOozieTZ((String)actionCreationTime));
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_INPUTCHECK, (Object)action);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        TestCoordActionInputCheckXCommand.assertTrue((boolean)action.getActionXml().contains("action-actual-time=\"2009-02-15T01:00"));
        Thread.sleep(1000L);
        this.createTestCaseSubDir("2009/03/05/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/02/19/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/02/12/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/02/05/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/01/22/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/01/08/_SUCCESS".split("/"));
        new CoordActionInputCheckXCommand(job.getId() + "@1", job.getId()).call();
        Thread.sleep(1000L);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        actionXML = action.getActionXml();
        TestCoordActionInputCheckXCommand.assertEquals((String)"", (String)action.getMissingDependencies());
        String resolvedList = this.getTestCaseFileUri("2009/02/12") + "#" + this.getTestCaseFileUri("2009/02/05") + "#" + this.getTestCaseFileUri("2009/01/22") + "#" + this.getTestCaseFileUri("2009/01/08");
        System.out.println("Expected: " + resolvedList);
        System.out.println("Actual: " + actionXML.substring(actionXML.indexOf("<uris>") + 6, actionXML.indexOf("</uris>")));
        TestCoordActionInputCheckXCommand.assertEquals((String)resolvedList, (String)actionXML.substring(actionXML.indexOf("<uris>") + 6, actionXML.indexOf("</uris>")));
    }

    public void testActionInputCheckLatestActionCreationTimeWithPushDependency() throws Exception {
        this.setupServicesForHCatalog(this.services);
        Services.get().getConf().setBoolean("oozie.service.ELService.latest-el.use-current-time", false);
        this.services.init();
        String jobId = "0000000-" + new Date().getTime() + "-TestCoordActionInputCheckXCommand-C";
        Date startTime = DateUtils.parseDateOozieTZ((String)("2009-02-15T23:59" + this.TZ));
        Date endTime = DateUtils.parseDateOozieTZ((String)("2009-02-16T23:59" + this.TZ));
        CoordinatorJobBean job = this.addRecordToCoordJobTable(jobId, startTime, endTime, "latest");
        new CoordMaterializeTransitionXCommand(job.getId(), 3600).call();
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        String pushMissingDependency = this.getTestCaseFileUri("2009/02/05");
        action.setPushMissingDependencies(pushMissingDependency);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_PUSH_INPUTCHECK, (Object)action);
        String actionXML = action.getActionXml();
        String actionCreationTime = "2009-02-15T01:00" + this.TZ;
        actionXML = actionXML.replaceAll("action-actual-time=\".*\">", "action-actual-time=\"" + actionCreationTime + "\">");
        action.setActionXml(actionXML);
        action.setCreatedTime(DateUtils.parseDateOozieTZ((String)actionCreationTime));
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_INPUTCHECK, (Object)action);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        TestCoordActionInputCheckXCommand.assertTrue((boolean)action.getActionXml().contains("action-actual-time=\"2009-02-15T01:00"));
        new CoordActionInputCheckXCommand(job.getId() + "@1", job.getId()).call();
        new CoordPushDependencyCheckXCommand(job.getId() + "@1").call();
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        TestCoordActionInputCheckXCommand.assertEquals((String)"!!${coord:latestRange(-3,0)}", (String)action.getMissingDependencies());
        TestCoordActionInputCheckXCommand.assertEquals((String)pushMissingDependency, (String)action.getPushMissingDependencies());
        this.createTestCaseSubDir("2009/03/05/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/02/19/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/02/12/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/01/22/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/01/08/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/01/01/_SUCCESS".split("/"));
        new CoordActionInputCheckXCommand(job.getId() + "@1", job.getId()).call();
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        TestCoordActionInputCheckXCommand.assertEquals((String)"!!${coord:latestRange(-3,0)}", (String)action.getMissingDependencies());
        TestCoordActionInputCheckXCommand.assertEquals((String)pushMissingDependency, (String)action.getPushMissingDependencies());
        this.createTestCaseSubDir("2009/02/05/_SUCCESS".split("/"));
        new CoordPushDependencyCheckXCommand(job.getId() + "@1").call();
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        TestCoordActionInputCheckXCommand.assertEquals((String)"", (String)action.getPushMissingDependencies());
        this.checkCoordAction(job.getId() + "@1", "!!${coord:latestRange(-3,0)}", CoordinatorAction.Status.WAITING);
        new CoordActionInputCheckXCommand(job.getId() + "@1", job.getId()).call();
        Thread.sleep(1000L);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        TestCoordActionInputCheckXCommand.assertEquals((String)"", (String)action.getMissingDependencies());
        actionXML = action.getActionXml();
        String resolvedList = this.getTestCaseFileUri("2009/02/12") + "#" + this.getTestCaseFileUri("2009/02/05") + "#" + this.getTestCaseFileUri("2009/01/22") + "#" + this.getTestCaseFileUri("2009/01/08");
        System.out.println("Expected: " + resolvedList);
        System.out.println("Actual: " + actionXML.substring(actionXML.indexOf("<uris>") + 6, actionXML.indexOf("</uris>")));
        TestCoordActionInputCheckXCommand.assertEquals((String)resolvedList, (String)actionXML.substring(actionXML.indexOf("<uris>") + 6, actionXML.indexOf("</uris>")));
    }

    public void testActionInputCheckLatestCurrentTime() throws Exception {
        Services.get().getConf().setBoolean("oozie.service.ELService.latest-el.use-current-time", true);
        String jobId = "0000000-" + new Date().getTime() + "-TestCoordActionInputCheckXCommand-C";
        Date startTime = DateUtils.parseDateOozieTZ((String)("2009-02-15T23:59" + this.TZ));
        Date endTime = DateUtils.parseDateOozieTZ((String)("2009-02-16T23:59" + this.TZ));
        CoordinatorJobBean job = this.addRecordToCoordJobTable(jobId, startTime, endTime, "latest");
        new CoordMaterializeTransitionXCommand(job.getId(), 3600).call();
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        TestCoordActionInputCheckXCommand.assertEquals((String)"!!${coord:latestRange(-3,0)}", (String)action.getMissingDependencies());
        String actionXML = action.getActionXml();
        String actionCreationTime = "2009-02-15T01:00" + this.TZ;
        actionXML = actionXML.replaceAll("action-actual-time=\".*\">", "action-actual-time=\"" + actionCreationTime + "\">");
        action.setActionXml(actionXML);
        action.setCreatedTime(DateUtils.parseDateOozieTZ((String)actionCreationTime));
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_INPUTCHECK, (Object)action);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        TestCoordActionInputCheckXCommand.assertTrue((boolean)action.getActionXml().contains("action-actual-time=\"2009-02-15T01:00"));
        this.createTestCaseSubDir("2009/03/05/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/02/19/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/02/12/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/02/05/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/01/22/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/01/08/_SUCCESS".split("/"));
        new CoordActionInputCheckXCommand(job.getId() + "@1", job.getId()).call();
        Thread.sleep(1000L);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(job.getId() + "@1"));
        actionXML = action.getActionXml();
        TestCoordActionInputCheckXCommand.assertEquals((String)"", (String)action.getMissingDependencies());
        String resolvedList = this.getTestCaseFileUri("2009/03/05") + "#" + this.getTestCaseFileUri("2009/02/19") + "#" + this.getTestCaseFileUri("2009/02/12") + "#" + this.getTestCaseFileUri("2009/02/05");
        TestCoordActionInputCheckXCommand.assertEquals((String)resolvedList, (String)actionXML.substring(actionXML.indexOf("<uris>") + 6, actionXML.indexOf("</uris>")));
    }

    public void testActionInputCheckLatestCurrentTimeWithPushDependency() throws Exception {
        this.setupServicesForHCatalog(this.services);
        Services.get().getConf().setBoolean("oozie.service.ELService.latest-el.use-current-time", true);
        this.services.init();
        String jobId = "0000000-" + new Date().getTime() + "-TestCoordActionInputCheckXCommand-C";
        Date startTime = DateUtils.parseDateOozieTZ((String)("2009-02-15T23:59" + this.TZ));
        Date endTime = DateUtils.parseDateOozieTZ((String)("2009-02-16T23:59" + this.TZ));
        CoordinatorJobBean job = this.addRecordToCoordJobTable(jobId, startTime, endTime, "latest");
        new CoordMaterializeTransitionXCommand(job.getId(), 3600).call();
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        String pushMissingDependency = this.getTestCaseFileUri("2009/02/05");
        action.setPushMissingDependencies(pushMissingDependency);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_PUSH_INPUTCHECK, (Object)action);
        String actionXML = action.getActionXml();
        String actionCreationTime = "2009-02-15T01:00" + this.TZ;
        actionXML = actionXML.replaceAll("action-actual-time=\".*\">", "action-actual-time=\"" + actionCreationTime + "\">");
        action.setActionXml(actionXML);
        action.setCreatedTime(DateUtils.parseDateOozieTZ((String)actionCreationTime));
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_INPUTCHECK, (Object)action);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        TestCoordActionInputCheckXCommand.assertTrue((boolean)action.getActionXml().contains("action-actual-time=\"2009-02-15T01:00"));
        new CoordActionInputCheckXCommand(job.getId() + "@1", job.getId()).call();
        new CoordPushDependencyCheckXCommand(job.getId() + "@1").call();
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        TestCoordActionInputCheckXCommand.assertEquals((String)"!!${coord:latestRange(-3,0)}", (String)action.getMissingDependencies());
        TestCoordActionInputCheckXCommand.assertEquals((String)pushMissingDependency, (String)action.getPushMissingDependencies());
        this.createTestCaseSubDir("2009/03/05/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/02/19/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/02/12/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/01/22/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/01/08/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/01/05/_SUCCESS".split("/"));
        new CoordActionInputCheckXCommand(job.getId() + "@1", job.getId()).call();
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        TestCoordActionInputCheckXCommand.assertEquals((String)"!!${coord:latestRange(-3,0)}", (String)action.getMissingDependencies());
        TestCoordActionInputCheckXCommand.assertEquals((String)pushMissingDependency, (String)action.getPushMissingDependencies());
        this.createTestCaseSubDir("2009/02/05/_SUCCESS".split("/"));
        new CoordPushDependencyCheckXCommand(job.getId() + "@1").call();
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        TestCoordActionInputCheckXCommand.assertEquals((String)"", (String)action.getPushMissingDependencies());
        this.checkCoordAction(job.getId() + "@1", "!!${coord:latestRange(-3,0)}", CoordinatorAction.Status.WAITING);
        new CoordActionInputCheckXCommand(job.getId() + "@1", job.getId()).call();
        Thread.sleep(1000L);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForInputCheckJPAExecutor(job.getId() + "@1"));
        TestCoordActionInputCheckXCommand.assertEquals((String)"", (String)action.getMissingDependencies());
        actionXML = action.getActionXml();
        String resolvedList = this.getTestCaseFileUri("2009/03/05") + "#" + this.getTestCaseFileUri("2009/02/19") + "#" + this.getTestCaseFileUri("2009/02/12") + "#" + this.getTestCaseFileUri("2009/02/05");
        System.out.println("Expected: " + resolvedList);
        System.out.println("Actual: " + actionXML.substring(actionXML.indexOf("<uris>") + 6, actionXML.indexOf("</uris>")));
        TestCoordActionInputCheckXCommand.assertEquals((String)resolvedList, (String)actionXML.substring(actionXML.indexOf("<uris>") + 6, actionXML.indexOf("</uris>")));
    }

    public void testActionInputCheckFuture() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-TestCoordActionInputCheckXCommand-C";
        Date startTime = DateUtils.parseDateOozieTZ((String)("2009-02-15T23:59" + this.TZ));
        Date endTime = DateUtils.parseDateOozieTZ((String)("2009-02-16T23:59" + this.TZ));
        CoordinatorJobBean job = this.addRecordToCoordJobTable(jobId, startTime, endTime, "future");
        new CoordMaterializeTransitionXCommand(job.getId(), 3600).call();
        this.createTestCaseSubDir("2009/02/12/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/02/26/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/03/05/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/03/26/_SUCCESS".split("/"));
        new CoordActionInputCheckXCommand(job.getId() + "@1", job.getId()).call();
        CoordinatorActionBean action = null;
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        try {
            action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(job.getId() + "@1"));
        }
        catch (JPAExecutorException se) {
            TestCoordActionInputCheckXCommand.fail((String)("Action ID " + job.getId() + "@1 was not stored properly in db"));
        }
        TestCoordActionInputCheckXCommand.assertEquals((String)"!!${coord:futureRange(0,3,'5')}", (String)action.getMissingDependencies());
        this.createTestCaseSubDir("2009/03/12/_SUCCESS".split("/"));
        new CoordActionInputCheckXCommand(job.getId() + "@1", job.getId()).call();
        try {
            action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(job.getId() + "@1"));
        }
        catch (JPAExecutorException se) {
            TestCoordActionInputCheckXCommand.fail((String)("Action ID " + job.getId() + "@1 was not stored properly in db"));
        }
        TestCoordActionInputCheckXCommand.assertEquals((String)"", (String)action.getMissingDependencies());
        String actionXML = action.getActionXml();
        String resolvedList = this.getTestCaseFileUri("2009/02/12") + "#" + this.getTestCaseFileUri("2009/02/26") + "#" + this.getTestCaseFileUri("2009/03/05") + "#" + this.getTestCaseFileUri("2009/03/12");
        TestCoordActionInputCheckXCommand.assertEquals((String)resolvedList, (String)actionXML.substring(actionXML.indexOf("<uris>") + 6, actionXML.indexOf("</uris>")));
    }

    public void testNonExistingNameNode() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-TestCoordActionInputCheckXCommand-C";
        Date startTime = DateUtils.parseDateUTC((String)"2009-02-01T23:59Z");
        Date endTime = DateUtils.parseDateUTC((String)"2009-02-02T23:59Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(jobId, startTime, endTime);
        new CoordMaterializeTransitionXCommand(job.getId(), 3600).call();
        CoordActionInputCheckXCommand caicc = new CoordActionInputCheckXCommand(job.getId() + "@1", job.getId());
        caicc.loadState();
        String[] whiteList = new String[]{"localhost:5330"};
        this.services.destroy();
        this.setSystemProperty("oozie.service.HadoopAccessorService.nameNode.whitelist", whiteList[0]);
        this.services = new Services();
        this.services.init();
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String inputDir = appPath.toString() + "/coord-input/2010/07/09/01/00";
        String nonExistDir = inputDir.replaceFirst("localhost", "nonExist");
        CoordinatorActionBean actionBean = new CoordinatorActionBean();
        try {
            new CoordOldInputDependency().pathExists(actionBean, nonExistDir, (Configuration)new XConfiguration(), TestCoordActionInputCheckXCommand.getTestUser());
            TestCoordActionInputCheckXCommand.fail((String)"Should throw exception due to non-existent NN path. Therefore fail");
        }
        catch (IOException ioe) {
            TestCoordActionInputCheckXCommand.assertEquals((String)actionBean.getErrorCode(), (String)"E0901");
            TestCoordActionInputCheckXCommand.assertTrue((boolean)actionBean.getErrorMessage().contains("not in Oozie's whitelist"));
        }
    }

    public void testRequeueInterval() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-TestCoordActionInputCheckXCommand-C";
        Date startTime = DateUtils.parseDateOozieTZ((String)("2009-02-01T23:59" + this.TZ));
        Date endTime = DateUtils.parseDateOozieTZ((String)("2009-02-02T23:59" + this.TZ));
        CoordinatorJobBean job = this.addRecordToCoordJobTable(jobId, startTime, endTime);
        long testedValue = 12000L;
        Services.get().getConf().setLong("oozie.service.coord.input.check.requeue.interval", testedValue);
        CoordActionInputCheckXCommand caicc = new CoordActionInputCheckXCommand(job.getId() + "@1", job.getId());
        long effectiveValue = caicc.getCoordInputCheckRequeueInterval();
        TestCoordActionInputCheckXCommand.assertEquals((long)testedValue, (long)effectiveValue);
    }

    public void testResolveCoordConfiguration() {
        try {
            CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-action-input-check.xml", Job.Status.RUNNING, false, true);
            CoordinatorActionBean action = this.addRecordToCoordActionTableForWaiting(job.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-for-action-input-check.xml");
            this.createTestCaseSubDir("2009/01/29/_SUCCESS".split("/"));
            this.createTestCaseSubDir("2009/01/22/_SUCCESS".split("/"));
            this.createTestCaseSubDir("2009/01/15/_SUCCESS".split("/"));
            this.createTestCaseSubDir("2009/01/08/_SUCCESS".split("/"));
            this.sleep(3000);
            new CoordActionInputCheckXCommand(action.getId(), job.getId()).call();
            this.sleep(3000);
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            CoordActionGetJPAExecutor coordGetCmd = new CoordActionGetJPAExecutor(action.getId());
            CoordinatorActionBean caBean = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordGetCmd);
            Element eAction = XmlUtils.parseXml((String)caBean.getActionXml());
            Element configElem = eAction.getChild("action", eAction.getNamespace()).getChild("workflow", eAction.getNamespace()).getChild("configuration", eAction.getNamespace());
            List elementList = configElem.getChildren("property", configElem.getNamespace());
            Element e1 = (Element)elementList.get(0);
            Element e2 = (Element)elementList.get(1);
            TestCoordActionInputCheckXCommand.assertEquals((String)"file://,testDir/2009/29,file://,testDir/2009/22,file://,testDir/2009/15,file://,testDir/2009/08", (String)e1.getChild("value", e1.getNamespace()).getValue());
            TestCoordActionInputCheckXCommand.assertEquals((String)"file://,testDir/2009/29", (String)e2.getChild("value", e1.getNamespace()).getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordActionInputCheckXCommand.fail((String)"Unexpected exception");
        }
    }

    public void testNoDatasetDependency() throws Exception {
        CoordinatorJobBean coordJob = new CoordinatorJobBean();
        coordJob.setId("0000000" + new Date().getTime() + "-TestCoordActionInputCheckXCommand-C");
        coordJob.setAppName("testApp");
        coordJob.setAppPath("testAppPath");
        coordJob.setStatus(Job.Status.RUNNING);
        coordJob.setCreatedTime(new Date());
        coordJob.setLastModifiedTime(new Date());
        coordJob.setUser("testUser");
        coordJob.setGroup("testGroup");
        coordJob.setTimeZone("UTC");
        coordJob.setTimeUnit(CoordinatorJob.Timeunit.DAY);
        coordJob.setMatThrottling(2);
        try {
            coordJob.setStartTime(DateUtils.parseDateOozieTZ((String)("2009-02-01T23:59" + this.TZ)));
            coordJob.setEndTime(DateUtils.parseDateOozieTZ((String)("2009-02-02T23:59" + this.TZ)));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordActionInputCheckXCommand.fail((String)"Could not set Date/time");
        }
        XConfiguration jobConf = new XConfiguration();
        jobConf.set("user.name", TestCoordActionInputCheckXCommand.getTestUser());
        String confStr = jobConf.toXmlString(false);
        coordJob.setConf(confStr);
        String wfXml = IOUtils.getResourceAsString((String)"wf-no-op.xml", (int)-1);
        this.writeToFile(wfXml, this.getFsTestCaseDir(), "workflow.xml");
        String appXml = "<coordinator-app xmlns='uri:oozie:coordinator:0.2' name='NAME' frequency=\"1\" start='2009-02-01T01:00" + this.TZ + "' end='2009-02-03T23:59" + this.TZ + "' timezone='UTC' freq_timeunit='DAY' end_of_duration='NONE'>";
        appXml = appXml + "<output-events>";
        appXml = appXml + "<data-out name='LOCAL_A' dataset='local_a'>";
        appXml = appXml + "<dataset name='local_a' frequency='7' initial-instance='2009-01-01T01:00" + this.TZ + "' timezone='UTC' freq_timeunit='DAY' end_of_duration='NONE'>";
        appXml = appXml + "<uri-template>file://" + this.getFsTestCaseDir() + "/${YEAR}/${MONTH}/${DAY}</uri-template>";
        appXml = appXml + "</dataset>";
        appXml = appXml + "<start-instance>${coord:current(-3)}</start-instance>";
        appXml = appXml + "<instance>${coord:current(0)}</instance>";
        appXml = appXml + "</data-out>";
        appXml = appXml + "</output-events>";
        appXml = appXml + "<action>";
        appXml = appXml + "<workflow>";
        appXml = appXml + "<app-path>" + this.getFsTestCaseDir() + "/workflow.xml</app-path>";
        appXml = appXml + "</workflow>";
        appXml = appXml + "</action>";
        appXml = appXml + "</coordinator-app>";
        coordJob.setJobXml(appXml);
        coordJob.setLastActionNumber(0);
        coordJob.setFrequency("1");
        coordJob.setConcurrency(1);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        if (jpaService != null) {
            try {
                jpaService.execute((JPAExecutor)new CoordJobInsertJPAExecutor(coordJob));
            }
            catch (JPAExecutorException e) {
                throw new CommandException((XException)((Object)e));
            }
        } else {
            TestCoordActionInputCheckXCommand.fail((String)"Unable to insert the test job record to table");
        }
        new CoordMaterializeTransitionXCommand(coordJob.getId(), 3600).call();
        new CoordActionInputCheckXCommand(coordJob.getId() + "@1", coordJob.getId()).call();
        CoordinatorActionBean action = null;
        try {
            jpaService = (JPAService)Services.get().get(JPAService.class);
            action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(coordJob.getId() + "@1"));
        }
        catch (JPAExecutorException se) {
            TestCoordActionInputCheckXCommand.fail((String)("Action ID " + coordJob.getId() + "@1 was not stored properly in db"));
        }
        TestCoordActionInputCheckXCommand.assertEquals((Object)CoordinatorAction.Status.RUNNING, (Object)action.getStatus());
        action.setMissingDependencies("");
        action.setStatus(CoordinatorAction.Status.WAITING);
        action.setExternalId(null);
        try {
            jpaService = (JPAService)Services.get().get(JPAService.class);
            CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION, (Object)action);
        }
        catch (JPAExecutorException se) {
            TestCoordActionInputCheckXCommand.fail((String)("Action ID " + coordJob.getId() + "@1 was not stored properly in db"));
        }
        new CoordActionInputCheckXCommand(coordJob.getId() + "@1", coordJob.getId()).call();
        try {
            jpaService = (JPAService)Services.get().get(JPAService.class);
            action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(coordJob.getId() + "@1"));
        }
        catch (JPAExecutorException se) {
            TestCoordActionInputCheckXCommand.fail((String)("Action ID " + coordJob.getId() + "@1 was not stored properly in db"));
        }
        TestCoordActionInputCheckXCommand.assertEquals((Object)CoordinatorAction.Status.RUNNING, (Object)action.getStatus());
    }

    @Test
    public void testTimeout() throws Exception {
        String missingDeps = "hdfs:///dirx/filex";
        String actionId = this.addInitRecords(missingDeps, null, this.TZ);
        new CoordActionInputCheckXCommand(actionId, actionId.substring(0, actionId.indexOf("@"))).call();
        long timeOutCreationTime = System.currentTimeMillis() - 720000L;
        this.setCoordActionCreationTime(actionId, timeOutCreationTime);
        new CoordActionInputCheckXCommand(actionId, actionId.substring(0, actionId.indexOf("@"))).call();
        this.checkCoordActionStatus(actionId, CoordinatorAction.Status.TIMEDOUT);
        this.checkCoordAction(actionId, missingDeps, CoordinatorAction.Status.TIMEDOUT);
    }

    @Test
    public void testTimeoutWithException() throws Exception {
        String missingDeps = "nofs:///dirx/filex";
        String actionId = this.addInitRecords(missingDeps, null, this.TZ);
        try {
            new CoordActionInputCheckXCommand(actionId, actionId.substring(0, actionId.indexOf("@"))).call();
            TestCoordActionInputCheckXCommand.fail();
        }
        catch (Exception e) {
            TestCoordActionInputCheckXCommand.assertTrue((boolean)e.getMessage().contains("No FileSystem for scheme"));
        }
        long timeOutCreationTime = System.currentTimeMillis() - 720000L;
        this.setCoordActionCreationTime(actionId, timeOutCreationTime);
        try {
            new CoordActionInputCheckXCommand(actionId, actionId.substring(0, actionId.indexOf("@"))).call();
            TestCoordActionInputCheckXCommand.fail();
        }
        catch (Exception e) {
            TestCoordActionInputCheckXCommand.assertTrue((boolean)e.getMessage().contains("No FileSystem for scheme"));
        }
        this.checkCoordActionStatus(actionId, CoordinatorAction.Status.TIMEDOUT);
        this.checkCoordAction(actionId, missingDeps, CoordinatorAction.Status.TIMEDOUT);
    }

    @Test
    public void testLastOnly() throws Exception {
        Date start = new Date(new Date().getTime() - 3900000L);
        Date end = new Date(start.getTime() + 18000000L);
        CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-action-input-check.xml", Job.Status.RUNNING, start, end, false, true, 7);
        job.setExecutionOrder(CoordinatorJob.Execution.LAST_ONLY);
        job.setFrequency("10");
        job.setTimeUnit(CoordinatorJob.Timeunit.MINUTE);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        String missingDeps = "hdfs:///dirx/filex";
        String actionId1 = this.addInitRecords(missingDeps, null, this.TZ, job, 1);
        Date nomTime = new Date(start.getTime());
        this.setCoordActionNominalTime(actionId1, nomTime.getTime());
        new CoordActionInputCheckXCommand(actionId1, job.getId()).call();
        this.checkCoordActionStatus(actionId1, CoordinatorAction.Status.SKIPPED);
        String actionId12 = this.addInitRecords(missingDeps, null, this.TZ, job, 12);
        nomTime = new Date(start.getTime() + 0x6DDD00L);
        this.setCoordActionNominalTime(actionId12, nomTime.getTime());
        new CoordActionInputCheckXCommand(actionId12, job.getId()).call();
        this.checkCoordActionStatus(actionId12, CoordinatorAction.Status.WAITING);
        String actionId7 = this.addInitRecords(missingDeps, null, this.TZ, job, 7);
        nomTime = new Date(start.getTime() + 3600000L);
        this.setCoordActionNominalTime(actionId7, nomTime.getTime());
        new CoordActionInputCheckXCommand(actionId7, job.getId()).call();
        this.checkCoordActionStatus(actionId7, CoordinatorAction.Status.WAITING);
        Date endTime = new Date(start.getTime() + 4080000L);
        job.setEndTime(endTime);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordActionInputCheckXCommand(actionId7, job.getId()).call();
        this.checkCoordActionStatus(actionId7, CoordinatorAction.Status.WAITING);
        endTime = new Date(start.getTime() + 300000L);
        job.setEndTime(endTime);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        this.setCoordActionStatus(actionId1, CoordinatorAction.Status.WAITING);
        new CoordActionInputCheckXCommand(actionId1, job.getId()).call();
        this.checkCoordActionStatus(actionId1, CoordinatorAction.Status.WAITING);
    }

    @Test
    public void testNone() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-action-input-check.xml", Job.Status.RUNNING, false, true);
        job.setExecutionOrder(CoordinatorJob.Execution.NONE);
        job.setFrequency("10");
        job.setTimeUnit(CoordinatorJob.Timeunit.MINUTE);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        String missingDeps = "hdfs:///dirx/filex";
        String actionId1 = this.addInitRecords(missingDeps, null, this.TZ, job, 1);
        Date nomTime = new Date(new Date().getTime() - 3600000L);
        this.setCoordActionNominalTime(actionId1, nomTime.getTime());
        new CoordActionInputCheckXCommand(actionId1, job.getId()).call();
        this.checkCoordActionStatus(actionId1, CoordinatorAction.Status.SKIPPED);
        String actionId2 = this.addInitRecords(missingDeps, null, this.TZ, job, 2);
        nomTime = new Date(new Date().getTime() + 3600000L);
        this.setCoordActionNominalTime(actionId2, nomTime.getTime());
        new CoordActionInputCheckXCommand(actionId2, job.getId()).call();
        this.checkCoordActionStatus(actionId2, CoordinatorAction.Status.WAITING);
        String actionId3 = this.addInitRecords(missingDeps, null, this.TZ, job, 3);
        nomTime = new Date(new Date().getTime() - 300000L);
        this.setCoordActionNominalTime(actionId3, nomTime.getTime());
        new CoordActionInputCheckXCommand(actionId3, job.getId()).call();
        this.checkCoordActionStatus(actionId3, CoordinatorAction.Status.SKIPPED);
        String actionId4 = this.addInitRecords(missingDeps, null, this.TZ, job, 4);
        nomTime = new Date(new Date().getTime() - 120000L);
        this.setCoordActionNominalTime(actionId4, nomTime.getTime());
        new CoordActionInputCheckXCommand(actionId4, job.getId()).call();
        this.checkCoordActionStatus(actionId4, CoordinatorAction.Status.SKIPPED);
    }

    protected CoordinatorActionBean addRecordToCoordActionTableForWaiting(String jobId, int actionNum, CoordinatorAction.Status status, String resourceXmlName) throws Exception {
        CoordinatorActionBean action = this.createCoordAction(jobId, actionNum, status, resourceXmlName, 0, this.TZ, null);
        String missDeps = this.getTestCaseFileUri("2009/01/29/_SUCCESS") + "#" + this.getTestCaseFileUri("2009/01/22/_SUCCESS") + "#" + this.getTestCaseFileUri("2009/01/15/_SUCCESS") + "#" + this.getTestCaseFileUri("2009/01/08/_SUCCESS");
        action.setMissingDependencies(missDeps);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordActionInputCheckXCommand.assertNotNull((Object)jpaService);
            CoordActionInsertJPAExecutor coordActionInsertCmd = new CoordActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)coordActionInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestCoordActionInputCheckXCommand.fail((String)"Unable to insert the test coord action record to table");
            throw je;
        }
        return action;
    }

    private CoordinatorJobBean addRecordToCoordJobTable(String jobId, Date start, Date end) throws CommandException {
        return this.addRecordToCoordJobTable(jobId, start, end, "current");
    }

    private CoordinatorJobBean addRecordToCoordJobTable(String jobId, Date start, Date end, String dataInType) throws CommandException {
        CoordinatorJobBean coordJob = new CoordinatorJobBean();
        coordJob.setId(jobId);
        coordJob.setAppName("testApp");
        coordJob.setAppPath("testAppPath");
        coordJob.setStatus(Job.Status.RUNNING);
        coordJob.setCreatedTime(new Date());
        coordJob.setLastModifiedTime(new Date());
        coordJob.setUser("testUser");
        coordJob.setGroup("testGroup");
        coordJob.setTimeZone("UTC");
        coordJob.setTimeUnit(CoordinatorJob.Timeunit.DAY);
        coordJob.setMatThrottling(2);
        try {
            coordJob.setStartTime(start);
            coordJob.setEndTime(end);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordActionInputCheckXCommand.fail((String)"Could not set Date/time");
        }
        String testDir = this.getTestCaseDir();
        XConfiguration jobConf = new XConfiguration();
        jobConf.set("user.name", TestCoordActionInputCheckXCommand.getTestUser());
        String confStr = jobConf.toXmlString(false);
        coordJob.setConf(confStr);
        String appXml = "<coordinator-app xmlns='uri:oozie:coordinator:0.2' name='NAME' frequency=\"1\" start='2009-02-01T01:00" + this.TZ + "' end='2009-02-03T23:59" + this.TZ + "' timezone='UTC' freq_timeunit='DAY' end_of_duration='NONE'>";
        appXml = appXml + "<controls>";
        appXml = appXml + "<timeout>10</timeout>";
        appXml = appXml + "<concurrency>2</concurrency>";
        appXml = appXml + "<execution>LIFO</execution>";
        appXml = appXml + "</controls>";
        appXml = appXml + "<input-events>";
        appXml = appXml + "<data-in name='A' dataset='a'>";
        appXml = appXml + "<dataset name='a' frequency='7' initial-instance='2009-01-01T01:00" + this.TZ + "' timezone='UTC' freq_timeunit='DAY' end_of_duration='NONE'>";
        appXml = appXml + "<uri-template>" + this.getTestCaseFileUri("${YEAR}/${MONTH}/${DAY}") + "</uri-template>";
        appXml = appXml + "</dataset>";
        if (dataInType.equals("future")) {
            appXml = appXml + "<start-instance>${coord:" + dataInType + "(0,5)}</start-instance>";
            appXml = appXml + "<end-instance>${coord:" + dataInType + "(3,5)}</end-instance>";
        } else if (dataInType.equals("latest")) {
            appXml = appXml + "<start-instance>${coord:" + dataInType + "(-3)}</start-instance>";
            appXml = appXml + "<end-instance>${coord:" + dataInType + "(0)}</end-instance>";
        } else if (dataInType.equals("current")) {
            appXml = appXml + "<start-instance>${coord:" + dataInType + "(-3)}</start-instance>";
            appXml = appXml + "<end-instance>${coord:" + dataInType + "(1)}</end-instance>";
        }
        appXml = appXml + "</data-in>";
        appXml = appXml + "</input-events>";
        appXml = appXml + "<output-events>";
        appXml = appXml + "<data-out name='LOCAL_A' dataset='local_a'>";
        appXml = appXml + "<dataset name='local_a' frequency='7' initial-instance='2009-01-01T01:00" + this.TZ + "' timezone='UTC' freq_timeunit='DAY' end_of_duration='NONE'>";
        appXml = appXml + "<uri-template>" + this.getTestCaseFileUri("${YEAR}/${MONTH}/${DAY}") + "</uri-template>";
        appXml = appXml + "</dataset>";
        appXml = appXml + "<start-instance>${coord:current(-3)}</start-instance>";
        appXml = appXml + "<instance>${coord:current(0)}</instance>";
        appXml = appXml + "</data-out>";
        appXml = appXml + "</output-events>";
        appXml = appXml + "<action>";
        appXml = appXml + "<workflow>";
        appXml = appXml + "<app-path>hdfs:///tmp/workflows/</app-path>";
        appXml = appXml + "<configuration>";
        appXml = appXml + "<property>";
        appXml = appXml + "<name>inputA</name>";
        appXml = appXml + "<value>${coord:dataIn('A')}</value>";
        appXml = appXml + "</property>";
        appXml = appXml + "<property>";
        appXml = appXml + "<name>inputB</name>";
        appXml = appXml + "<value>${coord:dataOut('LOCAL_A')}</value>";
        appXml = appXml + "</property>";
        appXml = appXml + "</configuration>";
        appXml = appXml + "</workflow>";
        appXml = appXml + "</action>";
        appXml = appXml + "</coordinator-app>";
        coordJob.setJobXml(appXml);
        coordJob.setLastActionNumber(0);
        coordJob.setFrequency("1");
        coordJob.setExecutionOrder(CoordinatorJob.Execution.FIFO);
        coordJob.setConcurrency(1);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        if (jpaService != null) {
            try {
                jpaService.execute((JPAExecutor)new CoordJobInsertJPAExecutor(coordJob));
            }
            catch (JPAExecutorException e) {
                throw new CommandException((XException)((Object)e));
            }
        } else {
            TestCoordActionInputCheckXCommand.fail((String)"Unable to insert the test job record to table");
        }
        return coordJob;
    }

    private CoordinatorActionBean checkCoordAction(String actionId, String expDeps, CoordinatorAction.Status stat) throws Exception {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
            String missDeps = action.getMissingDependencies();
            TestCoordActionInputCheckXCommand.assertEquals((String)expDeps, (String)missDeps);
            TestCoordActionInputCheckXCommand.assertEquals((Object)stat, (Object)action.getStatus());
            return action;
        }
        catch (JPAExecutorException se) {
            throw new Exception("Action ID " + actionId + " was not stored properly in db");
        }
    }

    public void testHarFileInputCheck() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-action-input-check.xml", Job.Status.RUNNING, false, true);
        String pathName = this.createTestCaseSubDir("2009/01/29".split("/"));
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        String missingDeps = "file://" + pathName + "#" + "har:///dirx/archive.har/data";
        String actionId1 = this.addInitRecords(missingDeps, null, this.TZ, job, 1);
        new CoordActionInputCheckXCommand(actionId1, job.getId()).call();
        CoordinatorActionBean coordAction = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{actionId1});
        TestCoordActionInputCheckXCommand.assertEquals((String)coordAction.getMissingDependencies(), (String)"har:///dirx/archive.har/data");
    }

    public class MyCoordActionInputCheckXCommand
    extends CoordActionInputCheckXCommand {
        long executed;
        int wait;

        public MyCoordActionInputCheckXCommand(String actionId, int wait, String entityKey) {
            super(actionId, entityKey);
            this.executed = 0L;
            this.wait = wait;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Type:").append(this.getType());
            sb.append(",Priority:").append(this.getPriority());
            return sb.toString();
        }

        protected Void execute() throws CommandException {
            try {
                Thread.sleep(this.wait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executed = System.currentTimeMillis();
            return null;
        }
    }
}

