/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Calendar;
import java.util.Date;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.coord.CoordELFunctions;
import org.apache.oozie.util.ELEvaluator;

public class CoordELExtensions {
    private static final String PREFIX = "coordext:";

    public static String ph1_today_echo(int hr, int min) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable(".wrap", (Object)"true");
        return "coordext:today(" + hr + ", " + min + ")";
    }

    public static String ph2_today_inst(int hr, int min) throws Exception {
        Calendar nominalInstanceCal = CoordELFunctions.getEffectiveNominalTime();
        if (nominalInstanceCal == null) {
            return "";
        }
        Calendar dsInstanceCal = Calendar.getInstance(CoordELFunctions.getDatasetTZ());
        dsInstanceCal.setTime(nominalInstanceCal.getTime());
        dsInstanceCal.set(11, hr);
        dsInstanceCal.set(12, min);
        dsInstanceCal.set(13, 0);
        dsInstanceCal.set(14, 0);
        int[] instCnt = new int[1];
        Calendar compInstCal = CoordELFunctions.getCurrentInstance((Date)dsInstanceCal.getTime(), (int[])instCnt);
        if (compInstCal == null) {
            return "";
        }
        int dsInstanceCnt = instCnt[0];
        compInstCal = CoordELFunctions.getCurrentInstance((Date)nominalInstanceCal.getTime(), (int[])instCnt);
        if (compInstCal == null) {
            return "";
        }
        int nominalInstanceCnt = instCnt[0];
        return "coord:current(" + (dsInstanceCnt - nominalInstanceCnt) + ")";
    }

    public static String ph2_today(int hr, int min) throws Exception {
        String inst = CoordELExtensions.ph2_today_inst(hr, min);
        return CoordELExtensions.evaluateCurrent(inst);
    }

    private static String evaluateCurrent(String curExpr) throws Exception {
        if (curExpr.equals("")) {
            return curExpr;
        }
        int inst = CoordCommandUtils.parseOneArg((String)curExpr);
        return CoordELFunctions.ph2_coord_current((int)inst);
    }
}

