/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.bundle.BundleStartXCommand;
import org.apache.oozie.command.bundle.BundleSubmitXCommand;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.StatusTransitService;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XConfiguration;

public class TestBundleStartXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testBundleStart1() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleStartXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleStartXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PREP);
        new BundleStartXCommand(job.getId()).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleStartXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
        this.sleep(2000);
        List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{job.getId()});
        TestBundleStartXCommand.assertEquals((int)2, (int)actions.size());
        TestBundleStartXCommand.assertEquals((boolean)true, (boolean)((BundleActionBean)actions.get(0)).isCritical());
        TestBundleStartXCommand.assertEquals((String)job.getId(), (String)((BundleActionBean)actions.get(0)).getBundleId());
        TestBundleStartXCommand.assertEquals((boolean)false, (boolean)((BundleActionBean)actions.get(1)).isCritical());
        TestBundleStartXCommand.assertEquals((String)job.getId(), (String)((BundleActionBean)actions.get(0)).getBundleId());
    }

    public void testBundleStart2() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleStartXCommand.assertNotNull((Object)jpaService);
        XConfiguration jobConf = null;
        try {
            jobConf = new XConfiguration((Reader)new StringReader(job.getConf()));
        }
        catch (IOException ioe) {
            this.log.warn((Object)("Configuration parse error. read from DB :" + job.getConf()), (Throwable)ioe);
            throw new CommandException(ErrorCode.E1005, new Object[]{ioe});
        }
        Path appPath = new Path(jobConf.get("oozie.bundle.application.path"), "bundle.xml");
        jobConf.set("oozie.bundle.application.path", appPath.toString());
        BundleSubmitXCommand submitCmd = new BundleSubmitXCommand((Configuration)jobConf);
        submitCmd.call();
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(submitCmd.getJob().getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleStartXCommand.assertEquals((String)"bundle-app-name", (String)job.getAppName());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleStartXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PREP);
        new BundleStartXCommand(job.getId()).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleStartXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
        this.sleep(2000);
        List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{job.getId()});
        TestBundleStartXCommand.assertEquals((int)2, (int)actions.size());
        final String jobId = job.getId();
        this.waitFor(200000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{jobId});
                return ((BundleActionBean)actions.get(0)).getStatus().equals((Object)Job.Status.RUNNING) && ((BundleActionBean)actions.get(1)).getStatus().equals((Object)Job.Status.RUNNING);
            }
        });
        actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{job.getId()});
        TestBundleStartXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)((BundleActionBean)actions.get(0)).getStatus());
        TestBundleStartXCommand.assertEquals((boolean)true, (boolean)((BundleActionBean)actions.get(0)).isCritical());
        TestBundleStartXCommand.assertEquals((String)job.getId(), (String)((BundleActionBean)actions.get(0)).getBundleId());
        TestBundleStartXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)((BundleActionBean)actions.get(1)).getStatus());
        TestBundleStartXCommand.assertEquals((boolean)false, (boolean)((BundleActionBean)actions.get(1)).isCritical());
        TestBundleStartXCommand.assertEquals((String)job.getId(), (String)((BundleActionBean)actions.get(1)).getBundleId());
    }

    public void testBundleStart3() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTableDisabledCoord(Job.Status.PREP);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleStartXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleStartXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PREP);
        new BundleStartXCommand(job.getId()).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleStartXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
        this.sleep(2000);
        List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{job.getId()});
        TestBundleStartXCommand.assertEquals((int)1, (int)actions.size());
        TestBundleStartXCommand.assertEquals((String)job.getId(), (String)((BundleActionBean)actions.get(0)).getBundleId());
    }

    public void testBundleStartDryrun() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleStartXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleStartXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PREP);
        new BundleStartXCommand(job.getId(), true).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleStartXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
        this.sleep(2000);
        List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{job.getId()});
        TestBundleStartXCommand.assertEquals((int)2, (int)actions.size());
        TestBundleStartXCommand.assertEquals((boolean)true, (boolean)((BundleActionBean)actions.get(0)).isCritical());
        TestBundleStartXCommand.assertEquals((String)job.getId(), (String)((BundleActionBean)actions.get(0)).getBundleId());
        TestBundleStartXCommand.assertEquals((boolean)false, (boolean)((BundleActionBean)actions.get(1)).isCritical());
        TestBundleStartXCommand.assertEquals((String)job.getId(), (String)((BundleActionBean)actions.get(1)).getBundleId());
    }

    public void testBundleStartNegative1() throws Exception {
        this.addRecordToBundleJobTable(Job.Status.PREP, false);
        try {
            new BundleStartXCommand("bundle-id").call();
            TestBundleStartXCommand.fail((String)"Job doesn't exist. Should fail.");
        }
        catch (CommandException commandException) {
            // empty catch block
        }
    }

    public void testBundleStartNegative2() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTableNegative(Job.Status.PREP);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleStartXCommand.assertNotNull((Object)jpaService);
        final BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleStartXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PREP);
        new BundleStartXCommand(job.getId()).call();
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean job1 = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
                return job1.getStatus().equals((Object)Job.Status.FAILED);
            }
        });
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleStartXCommand.assertEquals((Object)Job.Status.FAILED, (Object)job.getStatus());
    }

    public void testBundleStartWithFailedCoordinator() throws Exception {
        this.services.destroy();
        this.services = new Services();
        String[] excludeServices = new String[]{"org.apache.oozie.service.UUIDService", "org.apache.oozie.service.StatusTransitService"};
        Configuration conf = this.services.getConf();
        this.setClassesToBeExcluded(conf, excludeServices);
        conf.set("oozie.services", conf.get("oozie.services") + "," + DummyUUIDService.class.getName());
        this.services.init();
        CoordinatorJobBean coordJob = new CoordinatorJobBean();
        coordJob.setId("dummy-coord-id");
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
        jpaService.execute((JPAExecutor)coordInsertCmd);
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleStartXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PREP);
        new BundleStartXCommand(job.getId()).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleStartXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
        this.sleep(2000);
        List actions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{job.getId()});
        TestBundleStartXCommand.assertNull((Object)((BundleActionBean)actions.get(0)).getCoordId());
        TestBundleStartXCommand.assertEquals((Object)Job.Status.FAILED, (Object)((BundleActionBean)actions.get(0)).getStatus());
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(2000);
        runnable.run();
        this.sleep(2000);
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestBundleStartXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.DONEWITHERROR);
    }

    public static class DummyUUIDService
    extends UUIDService {
        boolean firstTime = true;

        public String generateId(UUIDService.ApplicationType type) {
            if (type.equals((Object)UUIDService.ApplicationType.COORDINATOR) && this.firstTime) {
                this.firstTime = false;
                return "dummy-coord-id";
            }
            return super.generateId(type);
        }
    }
}

