/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import org.apache.oozie.BundleJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.bundle.BundlePauseXCommand;
import org.apache.oozie.command.bundle.BundleUnpauseXCommand;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestBundlePauseUnpauseXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testBundlePauseUnpause1() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundlePauseUnpauseXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundlePauseUnpauseXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PREP);
        new BundlePauseXCommand(job).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundlePauseUnpauseXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PREPPAUSED);
        new BundleUnpauseXCommand(job).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundlePauseUnpauseXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PREP);
    }

    public void testBundlePauseUnpause2() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundlePauseUnpauseXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundlePauseUnpauseXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
        new BundlePauseXCommand(job).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundlePauseUnpauseXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PAUSED);
        new BundleUnpauseXCommand(job).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundlePauseUnpauseXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
    }

    public void testBundlePauseUnpause3() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.RUNNINGWITHERROR, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundlePauseUnpauseXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundlePauseUnpauseXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNINGWITHERROR);
        new BundlePauseXCommand(job).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundlePauseUnpauseXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PAUSEDWITHERROR);
        new BundleUnpauseXCommand(job).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundlePauseUnpauseXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNINGWITHERROR);
    }

    public void testBundlePauseUnpauseNeg1() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.SUSPENDED, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundlePauseUnpauseXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestBundlePauseUnpauseXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUSPENDED);
        try {
            new BundlePauseXCommand(job).call();
            TestBundlePauseUnpauseXCommand.fail((String)"should not reach here.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

