/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.test.XTestCase;

public class TestLocalOozie
extends XFsTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozielocal.log", "/tmp/oozielocal.log");
    }

    public void testLocalOozieInitDestroy() throws Exception {
        try {
            LocalOozie.stop();
            LocalOozie.getClient();
            TestLocalOozie.fail();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception ex) {
            TestLocalOozie.fail();
        }
        try {
            LocalOozie.start();
            LocalOozie.start();
            TestLocalOozie.fail();
        }
        catch (IllegalStateException ex) {
        }
        catch (Exception ex) {
            TestLocalOozie.fail();
        }
        try {
            LocalOozie.stop();
            LocalOozie.start();
            OozieClient wc = LocalOozie.getClient();
            TestLocalOozie.assertNotNull((Object)wc);
            TestLocalOozie.assertEquals((String)"localoozie", (String)wc.getOozieUrl());
        }
        finally {
            LocalOozie.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWorkflowRun() throws Exception {
        String wfApp = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='test-wf'>    <start to='end'/>    <end name='end'/></workflow-app>";
        FileSystem fs = this.getFileSystem();
        Path appPath = new Path(this.getFsTestCaseDir(), "app");
        fs.mkdirs(appPath);
        fs.mkdirs(new Path(appPath, "lib"));
        Path workflow = new Path(appPath, "workflow.xml");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(workflow));
        writer.write(wfApp);
        ((Writer)writer).close();
        try {
            LocalOozie.start();
            final OozieClient wc = LocalOozie.getClient();
            Properties conf = wc.createConfiguration();
            conf.setProperty("oozie.wf.application.path", workflow.toString());
            conf.setProperty("user.name", TestLocalOozie.getTestUser());
            conf.setProperty("group.name", TestLocalOozie.getTestGroup());
            final String jobId = wc.submit(conf);
            TestLocalOozie.assertNotNull((Object)jobId);
            WorkflowJob wf = wc.getJobInfo(jobId);
            TestLocalOozie.assertNotNull((Object)wf);
            TestLocalOozie.assertEquals((Object)WorkflowJob.Status.PREP, (Object)wf.getStatus());
            wc.start(jobId);
            this.waitFor(1000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    WorkflowJob wf = wc.getJobInfo(jobId);
                    return wf.getStatus() == WorkflowJob.Status.SUCCEEDED;
                }
            });
            wf = wc.getJobInfo(jobId);
            TestLocalOozie.assertNotNull((Object)wf);
            TestLocalOozie.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wf.getStatus());
        }
        finally {
            LocalOozie.stop();
        }
    }
}

