/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.oozie;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.ActionExecutorTestCase;
import org.apache.oozie.action.hadoop.LauncherMainTester;
import org.apache.oozie.action.oozie.JavaSleepAction;
import org.apache.oozie.action.oozie.SubWorkflowActionExecutor;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.wf.SuspendXCommand;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class TestSubWorkflowActionExecutor
extends ActionExecutorTestCase {
    private static final int JOB_TIMEOUT = 100000;
    private static final String APP1 = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='app'><start to='end'/><end name='end'/></workflow-app>";

    public void testType() {
        SubWorkflowActionExecutor subWorkflow = new SubWorkflowActionExecutor();
        TestSubWorkflowActionExecutor.assertEquals((String)"sub-workflow", (String)subWorkflow.getType());
    }

    public void testSubWorkflowConfCreation() throws Exception {
        SubWorkflowActionExecutor subWorkflow = new SubWorkflowActionExecutor();
        XConfiguration protoConf = this.getBaseProtoConf();
        WorkflowJobBean workflow = this.createBaseWorkflow(protoConf, "W");
        WorkflowActionBean action = (WorkflowActionBean)workflow.getActions().get(0);
        action.setConf("<sub-workflow xmlns='uri:oozie:workflow:0.1'>      <app-path>hdfs://foo:9000/user/bar/workflow.xml</app-path>      <configuration>        <property>          <name>a</name>          <value>A</value>        </property>      </configuration></sub-workflow>");
        OozieClient oozieClient = subWorkflow.getWorkflowClient((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), "local");
        TestSubWorkflowActionExecutor.assertNotNull((Object)oozieClient);
        oozieClient = subWorkflow.getWorkflowClient((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), "http://localhost:8080/oozie");
        TestSubWorkflowActionExecutor.assertNotNull((Object)oozieClient);
    }

    public void testSubWorkflowStart() throws Exception {
        Path subWorkflowAppPath = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(subWorkflowAppPath, "workflow.xml")));
        writer.write(APP1);
        ((Writer)writer).close();
        XConfiguration protoConf = this.getBaseProtoConf();
        WorkflowJobBean workflow = this.createBaseWorkflow(protoConf, "W");
        final WorkflowActionBean action = (WorkflowActionBean)workflow.getActions().get(0);
        action.setConf("<sub-workflow xmlns='uri:oozie:workflow:0.1'>      <app-path>" + subWorkflowAppPath + "</app-path>      <configuration>        <property>          <name>a</name>          <value>A</value>        </property>      </configuration></sub-workflow>");
        SubWorkflowActionExecutor subWorkflow = new SubWorkflowActionExecutor();
        subWorkflow.start((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        final OozieClient oozieClient = subWorkflow.getWorkflowClient((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), "local");
        this.waitFor(100000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return oozieClient.getJobInfo(action.getExternalId()).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)oozieClient.getJobInfo(action.getExternalId()).getStatus());
        subWorkflow.check((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowAction.Status.DONE, (Object)action.getStatus());
        subWorkflow.end((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
        TestSubWorkflowActionExecutor.assertEquals((String)workflow.getId(), (String)oozieClient.getJobInfo(action.getExternalId()).getParentId());
    }

    public void testSubWorkflowRecovery() throws Exception {
        Path subWorkflowAppPath = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        Path workflowPath = new Path(subWorkflowAppPath, "workflow.xml");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(workflowPath));
        writer.write(APP1);
        ((Writer)writer).close();
        XConfiguration protoConf = this.getBaseProtoConf();
        WorkflowJobBean workflow = this.createBaseWorkflow(protoConf, "W");
        final WorkflowActionBean action = (WorkflowActionBean)workflow.getActions().get(0);
        action.setConf("<sub-workflow xmlns='uri:oozie:workflow:0.1'>      <app-path>" + workflowPath.toString() + "</app-path>      <configuration>        <property>          <name>a</name>          <value>A</value>        </property>      </configuration></sub-workflow>");
        SubWorkflowActionExecutor subWorkflow = new SubWorkflowActionExecutor();
        subWorkflow.start((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        final OozieClient oozieClient = subWorkflow.getWorkflowClient((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), "local");
        this.waitFor(100000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return oozieClient.getJobInfo(action.getExternalId()).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        String extId = action.getExternalId();
        TestSubWorkflowActionExecutor.assertEquals((String)workflow.getId(), (String)oozieClient.getJobInfo(extId).getParentId());
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)oozieClient.getJobInfo(extId).getStatus());
        WorkflowActionBean action1 = new WorkflowActionBean();
        action1.setId(action.getId());
        action1.setName(action.getName());
        action1.setConf("<sub-workflow xmlns='uri:oozie:workflow:0.1'>      <app-path>wrongAppPath</app-path>      <configuration>        <property>          <name>a</name>          <value>A</value>        </property>      </configuration></sub-workflow>");
        subWorkflow.start((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action1), (WorkflowAction)action1);
        TestSubWorkflowActionExecutor.assertEquals((String)extId, (String)action1.getExternalId());
        TestSubWorkflowActionExecutor.assertEquals((String)workflow.getId(), (String)oozieClient.getJobInfo(extId).getParentId());
        subWorkflow.check((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action1), (WorkflowAction)action1);
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowAction.Status.DONE, (Object)action1.getStatus());
        subWorkflow.end((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action1), (WorkflowAction)action1);
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)action1.getStatus());
    }

    public void testConfigPropagation() throws Exception {
        Path subWorkflowAppPath = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        Path workflowPath = new Path(subWorkflowAppPath, "workflow.xml");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(workflowPath));
        writer.write(APP1);
        ((Writer)writer).close();
        XConfiguration protoConf = this.getBaseProtoConf();
        WorkflowJobBean workflow = this.createBaseWorkflow(protoConf, "W");
        String defaultConf = workflow.getConf();
        XConfiguration newConf = new XConfiguration((Reader)new StringReader(defaultConf));
        newConf.set("abc", "xyz");
        newConf.set("job_prop", "job_prop_val");
        workflow.setConf(newConf.toXmlString());
        final WorkflowActionBean action = (WorkflowActionBean)workflow.getActions().get(0);
        action.setConf("<sub-workflow xmlns='uri:oozie:workflow:0.1' name='subwf'>      <app-path>" + workflowPath.toString() + "</app-path>      <propagate-configuration />      <configuration>        <property>          <name>a</name>          <value>A</value>        </property>        <property>          <name>job_prop</name>          <value>sub_prop_val</value>        </property>      </configuration></sub-workflow>");
        SubWorkflowActionExecutor subWorkflow = new SubWorkflowActionExecutor();
        subWorkflow.start((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        final OozieClient oozieClient = subWorkflow.getWorkflowClient((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), "local");
        this.waitFor(100000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return oozieClient.getJobInfo(action.getExternalId()).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)oozieClient.getJobInfo(action.getExternalId()).getStatus());
        subWorkflow.check((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowAction.Status.DONE, (Object)action.getStatus());
        subWorkflow.end((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
        WorkflowJob wf = oozieClient.getJobInfo(action.getExternalId());
        Configuration childConf = this.getWorkflowConfig(wf);
        TestSubWorkflowActionExecutor.assertEquals((String)"xyz", (String)childConf.get("abc"));
        TestSubWorkflowActionExecutor.assertEquals((String)"A", (String)childConf.get("a"));
        TestSubWorkflowActionExecutor.assertEquals((String)"sub_prop_val", (String)childConf.get("job_prop"));
    }

    public void testGetGroupFromParent() throws Exception {
        Path subWorkflowAppPath = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        Path workflowPath = new Path(subWorkflowAppPath, "workflow.xml");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(workflowPath));
        writer.write(APP1);
        ((Writer)writer).close();
        XConfiguration protoConf = this.getBaseProtoConf();
        final WorkflowJobBean workflow = this.createBaseWorkflow(protoConf, "W");
        String defaultConf = workflow.getConf();
        XConfiguration newConf = new XConfiguration((Reader)new StringReader(defaultConf));
        String actionConf = "<sub-workflow xmlns='uri:oozie:workflow:0.1' name='subwf'>      <app-path>" + workflowPath.toString() + "</app-path>      <configuration>        <property>          <name>a</name>          <value>A</value>        </property>      </configuration></sub-workflow>";
        final WorkflowActionBean action = (WorkflowActionBean)workflow.getActions().get(0);
        action.setConf(actionConf);
        final SubWorkflowActionExecutor subWorkflow = new SubWorkflowActionExecutor();
        workflow.setConf(newConf.toXmlString());
        subWorkflow.start((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        OozieClient oozieClient = subWorkflow.getWorkflowClient((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), "local");
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                subWorkflow.check((ActionExecutor.Context)new ActionExecutorTestCase.Context(TestSubWorkflowActionExecutor.this, workflow, action), (WorkflowAction)action);
                return action.getStatus() == WorkflowAction.Status.DONE;
            }
        });
        subWorkflow.check((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        subWorkflow.end((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
        WorkflowJob wf = oozieClient.getJobInfo(action.getExternalId());
        Configuration childConf = this.getWorkflowConfig(wf);
        TestSubWorkflowActionExecutor.assertFalse((TestSubWorkflowActionExecutor.getTestGroup() == childConf.get("group.name") ? 1 : 0) != 0);
        newConf.set("group.name", TestSubWorkflowActionExecutor.getTestGroup());
        workflow.setConf(newConf.toXmlString());
        final WorkflowActionBean action1 = new WorkflowActionBean();
        action1.setConf(actionConf);
        action1.setId("W1");
        subWorkflow.start((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action1), (WorkflowAction)action1);
        oozieClient = subWorkflow.getWorkflowClient((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action1), "local");
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                subWorkflow.check((ActionExecutor.Context)new ActionExecutorTestCase.Context(TestSubWorkflowActionExecutor.this, workflow, action1), (WorkflowAction)action1);
                return action1.getStatus() == WorkflowAction.Status.DONE;
            }
        });
        subWorkflow.check((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action1), (WorkflowAction)action1);
        subWorkflow.end((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action1), (WorkflowAction)action1);
        wf = oozieClient.getJobInfo(action1.getExternalId());
        childConf = new XConfiguration((Reader)new StringReader(wf.getConf()));
        TestSubWorkflowActionExecutor.assertEquals((String)TestSubWorkflowActionExecutor.getTestGroup(), (String)childConf.get("group.name"));
    }

    public void testConfigNotPropagation() throws Exception {
        Path subWorkflowAppPath = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        Path workflowPath = new Path(subWorkflowAppPath, "workflow.xml");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(workflowPath));
        writer.write(APP1);
        ((Writer)writer).close();
        XConfiguration protoConf = this.getBaseProtoConf();
        WorkflowJobBean workflow = this.createBaseWorkflow(protoConf, "W");
        String defaultConf = workflow.getConf();
        XConfiguration newConf = new XConfiguration((Reader)new StringReader(defaultConf));
        newConf.set("abc", "xyz");
        workflow.setConf(newConf.toXmlString());
        final WorkflowActionBean action = (WorkflowActionBean)workflow.getActions().get(0);
        action.setConf("<sub-workflow xmlns='uri:oozie:workflow:0.1' name='subwf'>      <app-path>" + workflowPath.toString() + "</app-path>      <configuration>        <property>          <name>a</name>          <value>A</value>        </property>      </configuration></sub-workflow>");
        SubWorkflowActionExecutor subWorkflow = new SubWorkflowActionExecutor();
        subWorkflow.start((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        final OozieClient oozieClient = subWorkflow.getWorkflowClient((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), "local");
        this.waitFor(100000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return oozieClient.getJobInfo(action.getExternalId()).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)oozieClient.getJobInfo(action.getExternalId()).getStatus());
        subWorkflow.check((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowAction.Status.DONE, (Object)action.getStatus());
        subWorkflow.end((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
        WorkflowJob wf = oozieClient.getJobInfo(action.getExternalId());
        Configuration childConf = this.getWorkflowConfig(wf);
        TestSubWorkflowActionExecutor.assertNull((Object)childConf.get("abc"));
        TestSubWorkflowActionExecutor.assertEquals((String)"A", (String)childConf.get("a"));
    }

    public void testSubworkflowLib() throws Exception {
        XConfiguration protoConf = this.getBaseProtoConf();
        WorkflowJobBean workflow = this.createBaseWorkflow(protoConf, "W");
        FileSystem fs = this.getFileSystem();
        Path parentLibJar = new Path(this.getFsTestCaseDir(), "lib/parentLibrary.jar");
        fs.create(parentLibJar);
        TestSubWorkflowActionExecutor.assertTrue((boolean)fs.exists(parentLibJar));
        String defaultConf = workflow.getConf();
        XConfiguration newConf = new XConfiguration((Reader)new StringReader(defaultConf));
        newConf.set("oozie.libpath", parentLibJar.getParent().toString());
        workflow.setConf(newConf.toXmlString());
        Path subWorkflowAppPath = new Path(this.getFsTestCaseDir().toString(), "subwf");
        Path workflowPath = new Path(subWorkflowAppPath, "workflow.xml");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(workflowPath));
        writer.write(APP1);
        ((Writer)writer).close();
        Path subwfLibJar = new Path(subWorkflowAppPath, "lib/subwfLibrary.jar");
        fs.create(subwfLibJar);
        TestSubWorkflowActionExecutor.assertTrue((boolean)fs.exists(subwfLibJar));
        final WorkflowActionBean action = (WorkflowActionBean)workflow.getActions().get(0);
        action.setConf("<sub-workflow xmlns='uri:oozie:workflow:0.1' name='subwf'>      <app-path>" + workflowPath.toString() + "</app-path></sub-workflow>");
        SubWorkflowActionExecutor subWorkflow = new SubWorkflowActionExecutor();
        subWorkflow.start((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        final OozieClient oozieClient = subWorkflow.getWorkflowClient((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), "local");
        this.waitFor(100000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return oozieClient.getJobInfo(action.getExternalId()).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)oozieClient.getJobInfo(action.getExternalId()).getStatus());
        subWorkflow.check((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowAction.Status.DONE, (Object)action.getStatus());
        subWorkflow.end((ActionExecutor.Context)new ActionExecutorTestCase.Context(this, workflow, action), (WorkflowAction)action);
        TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
        WorkflowAppService wps = (WorkflowAppService)Services.get().get(WorkflowAppService.class);
        WorkflowJob wf = oozieClient.getJobInfo(action.getExternalId());
        Configuration childConf = this.getWorkflowConfig(wf);
        childConf = wps.createProtoActionConf(childConf, true);
        TestSubWorkflowActionExecutor.assertEquals((String)childConf.get("oozie.wf.application.lib"), (String)subwfLibJar.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubworkflowDepth() throws Exception {
        Path subWorkflowAppPath = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(subWorkflowAppPath, "workflow.xml")));
        String appStr = "<workflow-app xmlns=\"uri:oozie:workflow:0.4\" name=\"workflow\"><start to=\"subwf\"/><action name=\"subwf\">     <sub-workflow xmlns='uri:oozie:workflow:0.4'>          <app-path>" + subWorkflowAppPath.toString() + "</app-path>     </sub-workflow>     <ok to=\"end\"/>     <error to=\"fail\"/></action><kill name=\"fail\">     <message>Sub workflow failed, error message[${wf:errorMessage(wf:lastErrorNode())}]</message></kill><end name=\"end\"/></workflow-app>";
        writer.write(appStr);
        ((Writer)writer).close();
        try {
            Services.get().destroy();
            this.setSystemProperty("oozie.log4j.file", "oozie-log4j.properties");
            LocalOozie.start();
            Services.get().getConf().setInt("oozie.action.subworkflow.max.depth", 3);
            final OozieClient wfClient = LocalOozie.getClient();
            Properties conf = wfClient.createConfiguration();
            conf.setProperty("oozie.wf.application.path", subWorkflowAppPath.toString());
            conf.setProperty("user.name", TestSubWorkflowActionExecutor.getTestUser());
            final String jobId0 = wfClient.submit(conf);
            wfClient.start(jobId0);
            this.waitFor(20000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    return wfClient.getJobInfo(jobId0).getStatus() == WorkflowJob.Status.KILLED;
                }
            });
            TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)wfClient.getJobInfo(jobId0).getStatus());
            String jobId1 = ((WorkflowAction)wfClient.getJobInfo(jobId0).getActions().get(1)).getExternalId();
            TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)wfClient.getJobInfo(jobId1).getStatus());
            String jobId2 = ((WorkflowAction)wfClient.getJobInfo(jobId1).getActions().get(1)).getExternalId();
            TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)wfClient.getJobInfo(jobId2).getStatus());
            String jobId3 = ((WorkflowAction)wfClient.getJobInfo(jobId2).getActions().get(1)).getExternalId();
            TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)wfClient.getJobInfo(jobId3).getStatus());
            String jobId4 = ((WorkflowAction)wfClient.getJobInfo(jobId3).getActions().get(1)).getExternalId();
            TestSubWorkflowActionExecutor.assertNull((Object)jobId4);
        }
        finally {
            LocalOozie.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubWorkflowSuspend() throws Exception {
        try {
            Path subWorkflowAppPath = this.getFsTestCaseDir();
            FileSystem fs = this.getFileSystem();
            Path subWorkflowPath = new Path(subWorkflowAppPath, "workflow.xml");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(subWorkflowPath));
            writer.write(this.getLazyWorkflow());
            ((Writer)writer).close();
            String workflowUri = this.getTestCaseFileUri("workflow.xml");
            String appXml = "<workflow-app xmlns=\"uri:oozie:workflow:0.4\" name=\"workflow\"><start to=\"subwf\"/><action name=\"subwf\">     <sub-workflow xmlns='uri:oozie:workflow:0.4'>          <app-path>" + subWorkflowAppPath.toString() + "</app-path>     </sub-workflow>     <ok to=\"end\"/>     <error to=\"fail\"/></action><kill name=\"fail\">     <message>Sub workflow failed, error message[${wf:errorMessage(wf:lastErrorNode())}]</message></kill><end name=\"end\"/></workflow-app>";
            this.writeToFile(appXml, workflowUri);
            LocalOozie.start();
            final OozieClient wfClient = LocalOozie.getClient();
            Properties conf = wfClient.createConfiguration();
            conf.setProperty("oozie.wf.application.path", workflowUri);
            conf.setProperty("user.name", TestSubWorkflowActionExecutor.getTestUser());
            conf.setProperty("appName", "var-app-name");
            final String jobId = wfClient.submit(conf);
            wfClient.start(jobId);
            this.waitFor(100000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    return wfClient.getJobInfo(jobId).getStatus() == WorkflowJob.Status.RUNNING && ((WorkflowAction)wfClient.getJobInfo(jobId).getActions().get(1)).getStatus() == WorkflowAction.Status.RUNNING;
                }
            });
            WorkflowJob wf = wfClient.getJobInfo(jobId);
            new SuspendXCommand(((WorkflowAction)wf.getActions().get(1)).getExternalId()).call();
            TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowJob.Status.SUSPENDED, (Object)wfClient.getJobInfo(jobId).getStatus());
            TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowJob.Status.SUSPENDED, (Object)wfClient.getJobInfo(((WorkflowAction)wf.getActions().get(1)).getExternalId()).getStatus());
        }
        finally {
            LocalOozie.stop();
        }
    }

    private void writeToFile(String appXml, String appPath) throws IOException {
        File wf = new File(URI.create(appPath));
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(wf));
            out.println(appXml);
        }
    }

    public String getLazyWorkflow() {
        return "<workflow-app xmlns='uri:oozie:workflow:0.4' name='app'><start to='java' />       <action name='java'><java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>" + JavaSleepAction.class.getName() + "</main-class><arg>exit0</arg></java><ok to='end' /><error to='fail' /></action><kill name='fail'><message>shell action fail, error message[${wf:errorMessage(wf:lastErrorNode())}]</message></kill><end name='end' /></workflow-app>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubWorkflowRerun() throws Exception {
        try {
            Path subWorkflowAppPath = this.getFsTestCaseDir();
            FileSystem fs = this.getFileSystem();
            Path subWorkflowPath = new Path(subWorkflowAppPath, "workflow.xml");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(subWorkflowPath));
            writer.write(this.getLazyWorkflow());
            ((Writer)writer).close();
            String workflowUri = this.getTestCaseFileUri("workflow.xml");
            String appXml = "<workflow-app xmlns=\"uri:oozie:workflow:0.4\" name=\"workflow\"><start to=\"subwf\"/><action name=\"subwf\">     <sub-workflow xmlns='uri:oozie:workflow:0.4'>          <app-path>" + subWorkflowAppPath.toString() + "</app-path>     </sub-workflow>     <ok to=\"end\"/>     <error to=\"fail\"/></action><kill name=\"fail\">     <message>Sub workflow failed, error message[${wf:errorMessage(wf:lastErrorNode())}]</message></kill><end name=\"end\"/></workflow-app>";
            this.writeToFile(appXml, workflowUri);
            LocalOozie.start();
            final OozieClient wfClient = LocalOozie.getClient();
            Properties conf = wfClient.createConfiguration();
            conf.setProperty("oozie.wf.application.path", workflowUri);
            conf.setProperty("user.name", TestSubWorkflowActionExecutor.getTestUser());
            conf.setProperty("appName", "var-app-name");
            final String jobId = wfClient.submit(conf);
            wfClient.start(jobId);
            this.waitFor(100000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    return wfClient.getJobInfo(jobId).getStatus() == WorkflowJob.Status.RUNNING && ((WorkflowAction)wfClient.getJobInfo(jobId).getActions().get(1)).getStatus() == WorkflowAction.Status.RUNNING;
                }
            });
            String subWorkflowExternalId = ((WorkflowAction)wfClient.getJobInfo(jobId).getActions().get(1)).getExternalId();
            wfClient.kill(((WorkflowAction)wfClient.getJobInfo(jobId).getActions().get(1)).getExternalId());
            this.waitFor(100000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    return wfClient.getJobInfo(jobId).getStatus() == WorkflowJob.Status.KILLED && ((WorkflowAction)wfClient.getJobInfo(jobId).getActions().get(1)).getStatus() == WorkflowAction.Status.ERROR;
                }
            });
            conf.setProperty("oozie.wf.rerun.failnodes", "true");
            wfClient.reRun(jobId, conf);
            this.waitFor(100000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    return wfClient.getJobInfo(jobId).getStatus() == WorkflowJob.Status.SUCCEEDED && ((WorkflowAction)wfClient.getJobInfo(jobId).getActions().get(2)).getStatus() == WorkflowAction.Status.OK;
                }
            });
            WorkflowJob job = wfClient.getJobInfo(((WorkflowAction)wfClient.getJobInfo(jobId).getActions().get(2)).getExternalId());
            TestSubWorkflowActionExecutor.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)job.getStatus());
            TestSubWorkflowActionExecutor.assertEquals((String)job.getId(), (String)subWorkflowExternalId);
        }
        finally {
            LocalOozie.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentGlobalConf() throws Exception {
        try {
            Path subWorkflowAppPath = this.createSubWorkflowXml();
            String workflowUri = this.createTestWorkflowXml(subWorkflowAppPath);
            LocalOozie.start();
            final OozieClient wfClient = LocalOozie.getClient();
            Properties conf = wfClient.createConfiguration();
            conf.setProperty("oozie.wf.application.path", workflowUri);
            conf.setProperty("user.name", TestSubWorkflowActionExecutor.getTestUser());
            conf.setProperty("appName", "var-app-name");
            final String jobId = wfClient.submit(conf);
            wfClient.start(jobId);
            this.waitFor(100000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    return wfClient.getJobInfo(jobId).getStatus() == WorkflowJob.Status.SUCCEEDED && ((WorkflowAction)wfClient.getJobInfo(jobId).getActions().get(1)).getStatus() == WorkflowAction.Status.OK;
                }
            });
            WorkflowJob subWorkflow = wfClient.getJobInfo(((WorkflowAction)wfClient.getJobInfo(jobId).getActions().get(1)).getExternalId());
            Configuration subWorkflowConf = this.getWorkflowConfig(subWorkflow);
            Element eConf = XmlUtils.parseXml((String)((WorkflowAction)subWorkflow.getActions().get(1)).getConf());
            Element element = eConf.getChild("configuration", eConf.getNamespace());
            XConfiguration actionConf = new XConfiguration((Reader)new StringReader(XmlUtils.prettyPrint((Element)element).toString()));
            TestSubWorkflowActionExecutor.assertEquals((String)"foo1", (String)actionConf.get("foo1"));
            TestSubWorkflowActionExecutor.assertEquals((String)"subconf", (String)actionConf.get("foo2"));
            TestSubWorkflowActionExecutor.assertEquals((String)"foo3", (String)actionConf.get("foo3"));
            TestSubWorkflowActionExecutor.assertEquals((String)"actionconf", (String)subWorkflowConf.get("foo3"));
        }
        finally {
            LocalOozie.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentGlobalConfWithConfigDefault() throws Exception {
        try {
            Path subWorkflowAppPath = this.createSubWorkflowXml();
            this.createConfigDefaultXml();
            this.createSubWorkflowConfigDefaultXml();
            String workflowUri = this.createTestWorkflowXml(subWorkflowAppPath);
            LocalOozie.start();
            final OozieClient wfClient = LocalOozie.getClient();
            Properties conf = wfClient.createConfiguration();
            conf.setProperty("oozie.wf.application.path", workflowUri);
            conf.setProperty("user.name", TestSubWorkflowActionExecutor.getTestUser());
            conf.setProperty("appName", "var-app-name");
            conf.setProperty("foo", "other");
            final String jobId = wfClient.submit(conf);
            wfClient.start(jobId);
            TestSubWorkflowActionExecutor.assertEquals((String)"other", (String)new XConfiguration((Reader)new StringReader(wfClient.getJobInfo(jobId).getConf())).get("foo"));
            this.waitFor(100000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    return wfClient.getJobInfo(jobId).getStatus() == WorkflowJob.Status.SUCCEEDED && ((WorkflowAction)wfClient.getJobInfo(jobId).getActions().get(1)).getStatus() == WorkflowAction.Status.OK;
                }
            });
            WorkflowJob subWorkflow = wfClient.getJobInfo(((WorkflowAction)wfClient.getJobInfo(jobId).getActions().get(1)).getExternalId());
            Configuration subWorkflowConf = this.getWorkflowConfig(subWorkflow);
            Element eConf = XmlUtils.parseXml((String)((WorkflowAction)subWorkflow.getActions().get(1)).getConf());
            Element element = eConf.getChild("configuration", eConf.getNamespace());
            XConfiguration actionConf = new XConfiguration((Reader)new StringReader(XmlUtils.prettyPrint((Element)element).toString()));
            TestSubWorkflowActionExecutor.assertEquals((String)"other", (String)subWorkflowConf.get("foo"));
            TestSubWorkflowActionExecutor.assertEquals((String)"foo1", (String)actionConf.get("foo1"));
            TestSubWorkflowActionExecutor.assertEquals((String)"subconf", (String)actionConf.get("foo2"));
            TestSubWorkflowActionExecutor.assertEquals((String)"foo3", (String)actionConf.get("foo3"));
            TestSubWorkflowActionExecutor.assertEquals((String)"actionconf", (String)subWorkflowConf.get("foo3"));
            TestSubWorkflowActionExecutor.assertEquals((String)"subactionconf", (String)actionConf.get("foo4"));
            TestSubWorkflowActionExecutor.assertEquals((String)"default", (String)subWorkflowConf.get("parentConfigDefault"));
            TestSubWorkflowActionExecutor.assertEquals((String)"default", (String)actionConf.get("subwfConfigDefault"));
        }
        finally {
            LocalOozie.stop();
        }
    }

    private Configuration getWorkflowConfig(WorkflowJob workflow) throws IOException {
        return new XConfiguration((Reader)new StringReader(workflow.getConf()));
    }

    private String createTestWorkflowXml(Path subWorkflowAppPath) throws IOException {
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = "<workflow-app xmlns=\"uri:oozie:workflow:0.4\" name=\"workflow\"><global>   <configuration>        <property>            <name>foo2</name>            <value>foo2</value>        </property>        <property>            <name>foo3</name>            <value>foo3</value>        </property>        <property>            <name>foo4</name>            <value>actionconf</value>        </property>    </configuration></global><start to=\"subwf\"/><action name=\"subwf\">     <sub-workflow xmlns='uri:oozie:workflow:0.4'>          <app-path>" + subWorkflowAppPath.toString() + "</app-path><propagate-configuration/>   <configuration>        <property>            <name>foo3</name>            <value>actionconf</value>        </property>   </configuration>     </sub-workflow>     <ok to=\"end\"/>     <error to=\"fail\"/></action><kill name=\"fail\">     <message>Sub workflow failed, error message[${wf:errorMessage(wf:lastErrorNode())}]</message></kill><end name=\"end\"/></workflow-app>";
        this.writeToFile(appXml, workflowUri);
        return workflowUri;
    }

    private Path createSubWorkflowXml() throws IOException {
        return this.createSubWorkflowFile(this.getWorkflow(), "workflow.xml");
    }

    private void createConfigDefaultXml() throws IOException {
        String config_defaultUri = this.getTestCaseFileUri("config-default.xml");
        String config_default = "<configuration>    <property>      <name>foo</name>      <value>default</value>    </property>    <property>      <name>parentConfigDefault</name>      <value>default</value>    </property></configuration>";
        this.writeToFile(config_default, config_defaultUri);
    }

    private void createSubWorkflowConfigDefaultXml() throws IOException {
        String config_default = "<configuration>    <property>      <name>subwfConfigDefault</name>      <value>default</value>    </property>    <property>      <name>foo4</name>      <value>default</value>    </property></configuration>";
        this.createSubWorkflowFile(config_default, "config-default.xml");
    }

    private Path createSubWorkflowFile(String content, String fileName) throws IOException {
        Path subWorkflowAppPath = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        Path subWorkflowPath = new Path(subWorkflowAppPath, fileName);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(subWorkflowPath));
        writer.write(content);
        ((Writer)writer).close();
        return subWorkflowAppPath;
    }

    public String getWorkflow() {
        return "<workflow-app xmlns='uri:oozie:workflow:0.4' name='app'><global>   <configuration>        <property>            <name>foo1</name>            <value>foo1</value>        </property>        <property>            <name>foo2</name>            <value>subconf</value>        </property>    </configuration></global><start to='java' /><action name='java'><java>    <job-tracker>" + this.getJobTrackerUri() + "</job-tracker>    <name-node>" + this.getNameNodeUri() + "</name-node>        <configuration>            <property>                <name>foo4</name>                <value>subactionconf</value>            </property>        </configuration>    <main-class>" + LauncherMainTester.class.getName() + "</main-class>    <arg>exit0</arg></java><ok to='end' /><error to='fail' /></action><kill name='fail'><message>shell action fail, error message[${wf:errorMessage(wf:lastErrorNode())}]</message></kill><end name='end' /></workflow-app>";
    }
}

