/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.hadoop.MapperReducerForTest;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;

public class TestRerun
extends XFsTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.log4j.file", "oozie-log4j.properties");
        this.setSystemProperty("oozie.service.ActionCheckerService.action.check.delay", "1");
        this.setSystemProperty("oozie.service.ActionCheckerService.action.check.interval", "10");
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        super.tearDown();
    }

    public void testRerun() throws Exception {
        Path appPath = new Path(this.getFsTestCaseDir(), "app");
        FileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path(appPath, "lib"));
        File jarFile = IOUtils.createJar((File)new File(this.getTestCaseDir()), (String)"test.jar", (Class[])new Class[]{MapperReducerForTest.class});
        FileInputStream is = new FileInputStream(jarFile);
        FSDataOutputStream os = fs.create(new Path(appPath, "lib/test.jar"));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        Path input = new Path(appPath, "input");
        Path output = new Path(appPath, "output");
        fs.mkdirs(input);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(input, "test.txt")));
        writer.write("hello");
        ((Writer)writer).close();
        String APP1 = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='app'><start to='end'/><end name='end'/></workflow-app>";
        String subWorkflowAppPath = new Path(appPath, "subwf").toString();
        fs.mkdirs(new Path(appPath, "subwf"));
        OutputStreamWriter writer2 = new OutputStreamWriter((OutputStream)fs.create(new Path(subWorkflowAppPath, "workflow.xml")));
        writer2.write("<workflow-app xmlns='uri:oozie:workflow:0.1' name='app'><start to='end'/><end name='end'/></workflow-app>");
        ((Writer)writer2).close();
        Reader reader = IOUtils.getResourceAsReader((String)"recovery-wf.xml", (int)-1);
        OutputStreamWriter writer1 = new OutputStreamWriter((OutputStream)fs.create(new Path(appPath, "workflow.xml")));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer1);
        final OozieClient wfClient = LocalOozie.getClient();
        Properties conf = wfClient.createConfiguration();
        conf.setProperty("oozie.wf.application.path", new Path(appPath, "workflow.xml").toString());
        conf.setProperty("jobTracker", this.getJobTrackerUri());
        conf.setProperty("nameNode", this.getNameNodeUri());
        conf.setProperty("mrclass", MapperReducerForTest.class.getName());
        conf.setProperty("input", input.toString());
        conf.setProperty("output", output.toString());
        conf.setProperty("delPath", output.toString());
        conf.setProperty("subWfApp", appPath.toString() + "/subwf/workflow.xml");
        final String jobId1 = wfClient.submit(conf);
        wfClient.start(jobId1);
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId1).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestRerun.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfClient.getJobInfo(jobId1).getStatus());
        Map<String, String> extId0 = this.loadExtIds(wfClient.getJobInfo(jobId1).getActions());
        conf.setProperty("oozie.wf.rerun.skip.nodes", "");
        wfClient.reRun(jobId1, conf);
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId1).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestRerun.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfClient.getJobInfo(jobId1).getStatus());
        Map<String, String> extId1 = this.loadExtIds(wfClient.getJobInfo(jobId1).getActions());
        TestRerun.assertNotSame(extId0, extId1);
    }

    private Map<String, String> loadExtIds(List<WorkflowAction> actions) {
        HashMap<String, String> extIds = new HashMap<String, String>();
        for (WorkflowAction action : actions) {
            extIds.put(action.getName(), action.getExternalId());
        }
        return extIds;
    }
}

