/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.action.hadoop.LauncherURIHandler;
import org.apache.oozie.action.hadoop.LauncherURIHandlerFactory;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.test.XFsTestCase;
import org.junit.Test;

public class TestLauncherFSURIHandler
extends XFsTestCase {
    private Services services = null;
    private JobConf conf;
    private LauncherURIHandlerFactory uriHandlerFactory;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        URIHandlerService uriService = (URIHandlerService)this.services.get(URIHandlerService.class);
        this.uriHandlerFactory = new LauncherURIHandlerFactory(uriService.getLauncherConfig());
        this.conf = this.createJobConf();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    @Test
    public void testCreate() throws Exception {
        Path path = new Path(this.getFsTestCaseDir() + "/2012/12/02/");
        LauncherURIHandler handler = this.uriHandlerFactory.getURIHandler(path.toUri());
        TestLauncherFSURIHandler.assertTrue((boolean)handler.create(path.toUri(), (Configuration)this.conf));
        TestLauncherFSURIHandler.assertTrue((boolean)this.getFileSystem().exists(path));
    }

    @Test
    public void testDelete() throws Exception {
        Path path = new Path(this.getFsTestCaseDir() + "/2012/12/02/");
        LauncherURIHandler handler = this.uriHandlerFactory.getURIHandler(path.toUri());
        this.getFileSystem().mkdirs(path);
        TestLauncherFSURIHandler.assertTrue((boolean)handler.delete(path.toUri(), (Configuration)this.conf));
        TestLauncherFSURIHandler.assertFalse((boolean)this.getFileSystem().exists(path));
    }
}

