/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.DagELFunctions;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.service.ELService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;

public class TestFsELFunctions
extends XFsTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        new Services().init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    public void testFunctions() throws Exception {
        String file1 = new Path(this.getFsTestCaseDir(), "file1").toString();
        String file2 = new Path(this.getFsTestCaseDir(), "file2").toString();
        String dir = new Path(this.getFsTestCaseDir(), "dir").toString();
        Configuration protoConf = new Configuration();
        protoConf.set("user.name", TestFsELFunctions.getTestUser());
        protoConf.set("hadoop.job.ugi", TestFsELFunctions.getTestUser() + ",group");
        FileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path(dir));
        fs.create(new Path(file1)).close();
        FSDataOutputStream os = fs.create(new Path(dir, "a"));
        byte[] arr = new byte[1];
        os.write(arr);
        os.close();
        os = fs.create(new Path(dir, "b"));
        arr = new byte[2];
        os.write(arr);
        os.close();
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", "appPath");
        conf.set("user.name", TestFsELFunctions.getTestUser());
        conf.set("test.dir", this.getTestCaseDir());
        conf.set("file1", file1);
        conf.set("file2", file2);
        conf.set("file3", "${file2}");
        conf.set("file4", this.getFsTestCaseDir() + "/file{1,2}");
        conf.set("file5", this.getFsTestCaseDir() + "/file*");
        conf.set("file6", this.getFsTestCaseDir() + "/file_*");
        conf.set("dir", dir);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "<workflow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)conf, "wfId");
        WorkflowJobBean wf = new WorkflowJobBean();
        wf.setId(job.getId());
        wf.setAppName("name");
        wf.setAppPath("appPath");
        wf.setUser(TestFsELFunctions.getTestUser());
        wf.setGroup("group");
        wf.setWorkflowInstance((WorkflowInstance)job);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        protoConf.writeXml((OutputStream)baos);
        wf.setProtoActionConf(baos.toString());
        WorkflowActionBean action = new WorkflowActionBean();
        action.setId("actionId");
        action.setName("actionName");
        ELEvaluator eval = ((ELService)Services.get().get(ELService.class)).createEvaluator("workflow");
        DagELFunctions.configureEvaluator((ELEvaluator)eval, (WorkflowJobBean)wf, (WorkflowActionBean)action);
        TestFsELFunctions.assertEquals((boolean)true, (boolean)((Boolean)eval.evaluate("${fs:exists(wf:conf('file1'))}", Boolean.class)));
        TestFsELFunctions.assertEquals((boolean)false, (boolean)((Boolean)eval.evaluate("${fs:exists(wf:conf('file2'))}", Boolean.class)));
        TestFsELFunctions.assertEquals((boolean)true, (boolean)((Boolean)eval.evaluate("${fs:exists(wf:conf('file4'))}", Boolean.class)));
        TestFsELFunctions.assertEquals((boolean)true, (boolean)((Boolean)eval.evaluate("${fs:exists(wf:conf('file5'))}", Boolean.class)));
        TestFsELFunctions.assertEquals((boolean)false, (boolean)((Boolean)eval.evaluate("${fs:exists(wf:conf('file6'))}", Boolean.class)));
        TestFsELFunctions.assertEquals((boolean)true, (boolean)((Boolean)eval.evaluate("${fs:exists(wf:conf('dir'))}", Boolean.class)));
        TestFsELFunctions.assertEquals((boolean)false, (boolean)((Boolean)eval.evaluate("${fs:isDir(wf:conf('file1'))}", Boolean.class)));
        TestFsELFunctions.assertEquals((int)0, (int)((Integer)eval.evaluate("${fs:fileSize(wf:conf('file1'))}", Integer.class)));
        TestFsELFunctions.assertEquals((int)-1, (int)((Integer)eval.evaluate("${fs:fileSize(wf:conf('file2'))}", Integer.class)));
        TestFsELFunctions.assertEquals((int)3, (int)((Integer)eval.evaluate("${fs:dirSize(wf:conf('dir'))}", Integer.class)));
        TestFsELFunctions.assertEquals((int)-1, (int)((Integer)eval.evaluate("${fs:blockSize(wf:conf('file2'))}", Integer.class)));
        TestFsELFunctions.assertTrue(((Integer)eval.evaluate("${fs:blockSize(wf:conf('file1'))}", Integer.class) > 0 ? 1 : 0) != 0);
    }
}

