/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action;

import java.io.EOFException;
import java.io.IOException;
import java.rmi.RemoteException;
import junit.framework.Assert;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;

public class TestActionExecutor
extends XTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        new Services().init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    public void testActionExecutor() throws Exception {
        ActionExecutor.enableInit();
        ActionExecutor.resetInitInfo();
        MyActionExecutor ae = new MyActionExecutor();
        ae.initActionType();
        ActionExecutor.disableInit();
        ae.start(null, null);
        ae = new MyActionExecutor(1, 2);
        ae.check(null, null);
        Throwable cause = new IOException();
        try {
            throw ae.convertException((Exception)cause);
        }
        catch (ActionExecutorException ex) {
            TestActionExecutor.assertEquals((Object)cause, (Object)ex.getCause());
            TestActionExecutor.assertEquals((Object)ActionExecutorException.ErrorType.TRANSIENT, (Object)ex.getErrorType());
            TestActionExecutor.assertEquals((String)"IO", (String)ex.getErrorCode());
        }
        catch (Exception ex) {
            TestActionExecutor.fail();
        }
        cause = new RemoteException();
        try {
            throw ae.convertException((Exception)cause);
        }
        catch (ActionExecutorException ex) {
            TestActionExecutor.assertEquals((Object)cause, (Object)ex.getCause());
            TestActionExecutor.assertEquals((Object)ActionExecutorException.ErrorType.NON_TRANSIENT, (Object)ex.getErrorType());
            TestActionExecutor.assertEquals((String)"RMI", (String)ex.getErrorCode());
        }
        catch (Exception ex) {
            TestActionExecutor.fail();
        }
        cause = new RuntimeException();
        try {
            throw ae.convertException((Exception)cause);
        }
        catch (ActionExecutorException ex) {
            TestActionExecutor.assertEquals((Object)cause, (Object)ex.getCause());
            TestActionExecutor.assertEquals((Object)ActionExecutorException.ErrorType.ERROR, (Object)ex.getErrorType());
            TestActionExecutor.assertEquals((String)"RuntimeException", (String)ex.getErrorCode());
        }
        catch (Exception ex) {
            TestActionExecutor.fail();
        }
        cause = new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "x", "x");
        try {
            throw ae.convertException((Exception)cause);
        }
        catch (ActionExecutorException ex) {
            TestActionExecutor.assertEquals((Object)cause, (Object)((Object)ex));
        }
        catch (Exception ex) {
            TestActionExecutor.fail();
        }
        cause = new EOFException();
        try {
            throw ae.convertException((Exception)cause);
        }
        catch (ActionExecutorException ex) {
            TestActionExecutor.assertEquals((Object)cause, (Object)ex.getCause());
            TestActionExecutor.assertEquals((Object)ActionExecutorException.ErrorType.TRANSIENT, (Object)ex.getErrorType());
            TestActionExecutor.assertEquals((String)"IO", (String)ex.getErrorCode());
        }
        catch (Exception ex) {
            TestActionExecutor.fail();
        }
        IOException rootCause = new RemoteException();
        cause = new RuntimeException(rootCause);
        try {
            throw ae.convertException((Exception)cause);
        }
        catch (ActionExecutorException ex) {
            TestActionExecutor.assertEquals((Object)rootCause, (Object)ex.getCause());
            TestActionExecutor.assertEquals((Object)ActionExecutorException.ErrorType.NON_TRANSIENT, (Object)ex.getErrorType());
            TestActionExecutor.assertEquals((String)"RMI", (String)ex.getErrorCode());
        }
        catch (Exception ex) {
            TestActionExecutor.fail();
        }
        rootCause = new RemoteException();
        cause = new IOException(rootCause);
        try {
            throw ae.convertException((Exception)cause);
        }
        catch (ActionExecutorException ex) {
            TestActionExecutor.assertEquals((Object)rootCause, (Object)ex.getCause());
            TestActionExecutor.assertEquals((Object)ActionExecutorException.ErrorType.NON_TRANSIENT, (Object)ex.getErrorType());
            TestActionExecutor.assertEquals((String)"RMI", (String)ex.getErrorCode());
        }
        catch (Exception ex) {
            TestActionExecutor.fail();
        }
        rootCause = new IOException();
        cause = new RemoteException("x", rootCause);
        try {
            throw ae.convertException((Exception)cause);
        }
        catch (ActionExecutorException ex) {
            TestActionExecutor.assertEquals((Object)rootCause, (Object)ex.getCause());
            TestActionExecutor.assertEquals((Object)ActionExecutorException.ErrorType.TRANSIENT, (Object)ex.getErrorType());
            TestActionExecutor.assertEquals((String)"IO", (String)ex.getErrorCode());
        }
        catch (Exception ex) {
            TestActionExecutor.fail();
        }
        rootCause = new EOFException();
        cause = new RemoteException("x", rootCause);
        try {
            throw ae.convertException((Exception)cause);
        }
        catch (ActionExecutorException ex) {
            TestActionExecutor.assertEquals((Object)rootCause, (Object)ex.getCause());
            TestActionExecutor.assertEquals((Object)ActionExecutorException.ErrorType.TRANSIENT, (Object)ex.getErrorType());
            TestActionExecutor.assertEquals((String)"IO", (String)ex.getErrorCode());
        }
        catch (Exception ex) {
            TestActionExecutor.fail();
        }
    }

    private static class MyActionExecutor
    extends ActionExecutor {
        private int maxRetries;
        private long retryInterval;

        protected MyActionExecutor() {
            super("type");
            this.maxRetries = this.getMaxRetries();
        }

        public void initActionType() {
            super.initActionType();
            this.registerError("java.rmi.RemoteException", ActionExecutorException.ErrorType.NON_TRANSIENT, "RMI");
            this.registerError("java.io.IOException", ActionExecutorException.ErrorType.TRANSIENT, "IO");
            this.registerError("foo.Exception", ActionExecutorException.ErrorType.TRANSIENT, "FO");
        }

        protected MyActionExecutor(int maxRetries, int retryInterval) {
            super("type", (long)retryInterval);
            super.setMaxRetries(maxRetries);
            this.maxRetries = maxRetries;
            super.setRetryInterval((long)retryInterval);
            this.retryInterval = retryInterval;
        }

        public void start(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
            Assert.assertEquals((String)"type", (String)this.getType());
            Assert.assertEquals((int)this.maxRetries, (int)this.getMaxRetries());
            Assert.assertEquals((long)ConfigurationService.getLong((String)"oozie.action.retry.interval"), (long)this.getRetryInterval());
        }

        public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        }

        public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
            Assert.assertEquals((String)"type", (String)this.getType());
            Assert.assertEquals((int)1, (int)this.getMaxRetries());
            Assert.assertEquals((long)2L, (long)this.getRetryInterval());
        }

        public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        }

        public boolean isCompleted(String externalStatus) {
            return true;
        }
    }
}

