/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorEngineException;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.CoordinatorJobInfo;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.Services;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XConfiguration;

public class TestCoordinatorEngine
extends XTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testEngine() throws Exception {
        String appPath = this.getTestCaseFileUri("coordinator.xml");
        String jobId = this._testSubmitJob(appPath);
        this._testGetJob(jobId, appPath);
        this._testGetJobs(jobId);
        this._testStatus(jobId);
        this._testGetDefinition(jobId);
        this._testSubsetActions(jobId);
    }

    public void testDoneFlag() throws Exception {
        XConfiguration conf = new XConfiguration();
        String appPath = this.getTestCaseFileUri("coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-01T02:00Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.1\"> <controls> <timeout>10</timeout> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"local_a\" frequency=\"${coord:days(1)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("workflows/${YEAR}/${DAY}") + "</uri-template> </dataset></datasets> <input-events> <data-in name=\"A\" dataset=\"local_a\"> <instance>${coord:current(0)}</instance> </data-in>  </input-events> <action> <workflow> <app-path>hdfs:///tmp/workflows2/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> </configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPath);
        conf.set("oozie.coord.application.path", appPath);
        conf.set("user.name", TestCoordinatorEngine.getTestUser());
        final CoordinatorEngine ce = new CoordinatorEngine(TestCoordinatorEngine.getTestUser());
        final String jobId = ce.submitJob((Configuration)conf, true);
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                try {
                    List actions = ce.getCoordJob(jobId).getActions();
                    for (CoordinatorAction action : actions) {
                        CoordinatorAction.Status actionStatus = action.getStatus();
                        if (actionStatus != CoordinatorAction.Status.WAITING) continue;
                        return true;
                    }
                }
                catch (Exception ex) {
                    return false;
                }
                return false;
            }
        });
        List actions = ce.getCoordJob(jobId).getActions();
        TestCoordinatorEngine.assertTrue((actions.size() > 0 ? 1 : 0) != 0);
        CoordinatorAction action = (CoordinatorAction)actions.get(0);
        String missingDeps = action.getMissingDependencies();
        System.out.println("Missing deps=" + missingDeps);
        TestCoordinatorEngine.assertEquals((String)this.getTestCaseFileUri("workflows/2009/01/_SUCCESS"), (String)missingDeps);
    }

    public void testCustomDoneFlag() throws Exception {
        XConfiguration conf = new XConfiguration();
        String appPath = this.getTestCaseFileUri("coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-01T02:00Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.1\"> <controls> <timeout>10</timeout> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"local_a\" frequency=\"${coord:days(1)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("workflows/${YEAR}/${MONTH}/${DAY}") + "</uri-template> <done-flag>consume_me</done-flag> </dataset></datasets> <input-events> <data-in name=\"A\" dataset=\"local_a\"> <instance>${coord:current(0)}</instance> </data-in>  </input-events> <action> <workflow> <app-path>hdfs:///tmp/workflows2/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> </configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPath);
        conf.set("oozie.coord.application.path", appPath);
        conf.set("user.name", TestCoordinatorEngine.getTestUser());
        final CoordinatorEngine ce = new CoordinatorEngine(TestCoordinatorEngine.getTestUser());
        final String jobId = ce.submitJob((Configuration)conf, true);
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                try {
                    List actions = ce.getCoordJob(jobId).getActions();
                    for (CoordinatorAction action : actions) {
                        CoordinatorAction.Status actionStatus = action.getStatus();
                        if (actionStatus != CoordinatorAction.Status.WAITING) continue;
                        return true;
                    }
                }
                catch (Exception ex) {
                    return false;
                }
                return false;
            }
        });
        List actions = ce.getCoordJob(jobId).getActions();
        TestCoordinatorEngine.assertTrue((actions.size() > 0 ? 1 : 0) != 0);
        CoordinatorAction action = (CoordinatorAction)actions.get(0);
        String missingDeps = action.getMissingDependencies();
        System.out.println("..Missing deps=" + missingDeps);
        TestCoordinatorEngine.assertEquals((Object)new URI(this.getTestCaseFileUri("workflows/2009/02/01/consume_me")), (Object)new URI(missingDeps));
    }

    public void testEmptyDoneFlag() throws Exception {
        XConfiguration conf = new XConfiguration();
        String appPath = this.getTestCaseFileUri("coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-01T02:00Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.1\"> <controls> <timeout>10</timeout> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"local_a\" frequency=\"${coord:days(1)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("workflows/${YEAR}/${MONTH}/${DAY}") + "</uri-template> <done-flag></done-flag> </dataset></datasets> <input-events> <data-in name=\"A\" dataset=\"local_a\"> <instance>${coord:current(0)}</instance> </data-in>  </input-events> <action> <workflow> <app-path>hdfs:///tmp/workflows2/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> </configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPath);
        conf.set("oozie.coord.application.path", appPath);
        conf.set("user.name", TestCoordinatorEngine.getTestUser());
        final CoordinatorEngine ce = new CoordinatorEngine(TestCoordinatorEngine.getTestUser());
        final String jobId = ce.submitJob((Configuration)conf, true);
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                try {
                    List actions = ce.getCoordJob(jobId).getActions();
                    for (CoordinatorAction action : actions) {
                        CoordinatorAction.Status actionStatus = action.getStatus();
                        if (actionStatus != CoordinatorAction.Status.WAITING) continue;
                        return true;
                    }
                }
                catch (Exception ex) {
                    return false;
                }
                return false;
            }
        });
        List actions = ce.getCoordJob(jobId).getActions();
        TestCoordinatorEngine.assertTrue((actions.size() > 0 ? 1 : 0) != 0);
        CoordinatorAction action = (CoordinatorAction)actions.get(0);
        String missingDeps = action.getMissingDependencies();
        System.out.println("..Missing deps=" + missingDeps);
        TestCoordinatorEngine.assertEquals((String)this.getTestCaseFileUri("workflows/2009/02/01"), (String)missingDeps);
    }

    public void testDoneFlagCreation() throws Exception {
        XConfiguration conf = new XConfiguration();
        String appPath = this.getTestCaseFileUri("coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-01T02:00Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.1\"> <controls> <timeout>10</timeout> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"local_a\" frequency=\"${coord:days(1)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("workflows/${YEAR}/${MONTH}/${DAY}") + "</uri-template> <done-flag>consume_me</done-flag> </dataset></datasets> <input-events> <data-in name=\"A\" dataset=\"local_a\"> <instance>${coord:current(0)}</instance> </data-in>  </input-events> <action> <workflow> <app-path>hdfs:///tmp/workflows2/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> </configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPath);
        conf.set("oozie.coord.application.path", appPath);
        conf.set("user.name", TestCoordinatorEngine.getTestUser());
        final CoordinatorEngine ce = new CoordinatorEngine(TestCoordinatorEngine.getTestUser());
        final String jobId = ce.submitJob((Configuration)conf, true);
        new File(this.getTestCaseDir(), "workflows/2009/02/01/consume_me").mkdirs();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                try {
                    List actions = ce.getCoordJob(jobId).getActions();
                    for (CoordinatorAction action : actions) {
                        CoordinatorAction.Status actionStatus = action.getStatus();
                        if (actionStatus != CoordinatorAction.Status.SUBMITTED) continue;
                        return true;
                    }
                }
                catch (Exception ex) {
                    return false;
                }
                return false;
            }
        });
        List actions = ce.getCoordJob(jobId).getActions();
        TestCoordinatorEngine.assertTrue((actions.size() > 0 ? 1 : 0) != 0);
        CoordinatorAction action = (CoordinatorAction)actions.get(0);
        System.out.println("status=" + action.getStatus());
        String missingDeps = action.getMissingDependencies();
        System.out.println("..Missing deps=" + missingDeps);
        if (missingDeps != null && !missingDeps.equals("")) {
            TestCoordinatorEngine.fail();
        }
    }

    private String _testSubmitJob(String appPath) throws Exception {
        XConfiguration conf = new XConfiguration();
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"${coord:minutes(20)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.1\"> <controls> <timeout>10</timeout> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:minutes(20)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>file:///tmp/coord/workflows/${YEAR}/${DAY}</uri-template> </dataset> <dataset name=\"local_a\" frequency=\"${coord:minutes(20)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>file:///tmp/coord/workflows/${YEAR}/${DAY}</uri-template> </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPath);
        conf.set("oozie.coord.application.path", appPath);
        conf.set("user.name", TestCoordinatorEngine.getTestUser());
        final CoordinatorEngine ce = new CoordinatorEngine(TestCoordinatorEngine.getTestUser());
        final String jobId = ce.submitJob((Configuration)conf, true);
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                try {
                    ce.getJob(jobId).getStatus();
                }
                catch (Exception ex) {
                    return false;
                }
                return true;
            }
        });
        TestCoordinatorEngine.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
        this.checkCoordJob(jobId);
        return jobId;
    }

    private void _testGetJob(String jobId, String appPath) throws Exception {
        CoordinatorEngine ce = new CoordinatorEngine(TestCoordinatorEngine.getTestUser());
        CoordinatorJobBean job = ce.getCoordJob(jobId);
        TestCoordinatorEngine.assertEquals((String)jobId, (String)job.getId());
        TestCoordinatorEngine.assertEquals((String)job.getAppPath(), (String)appPath);
    }

    public void _testGetJobs(String jobId) throws Exception {
        CoordinatorEngine ce = new CoordinatorEngine(TestCoordinatorEngine.getTestUser());
        CoordinatorJobInfo jobInfo = ce.getCoordJobs("", 1, 10);
        TestCoordinatorEngine.assertEquals((int)1, (int)jobInfo.getCoordJobs().size());
        CoordinatorJob job = (CoordinatorJob)jobInfo.getCoordJobs().get(0);
        TestCoordinatorEngine.assertEquals((String)jobId, (String)job.getId());
        try {
            jobInfo = ce.getCoordJobs("unit=minutes", 1, 10);
        }
        catch (CoordinatorEngineException ex) {
            TestCoordinatorEngine.assertEquals((String)"E0420: Invalid jobs filter [unit=minutes], time unit should be added only when frequency is specified. Either specify frequency also or else remove the time unit", (String)ex.getMessage());
        }
        try {
            jobInfo = ce.getCoordJobs("frequency=ghj;unit=minutes", 1, 10);
        }
        catch (CoordinatorEngineException ex) {
            TestCoordinatorEngine.assertEquals((String)"E0420: Invalid jobs filter [frequency=ghj;unit=minutes], invalid value [ghj] for frequency. A numerical value is expected", (String)ex.getMessage());
        }
        try {
            jobInfo = ce.getCoordJobs("frequency=60;unit=min", 1, 10);
        }
        catch (CoordinatorEngineException ex) {
            TestCoordinatorEngine.assertEquals((String)"E0420: Invalid jobs filter [frequency=60;unit=min], invalid value [min] for time unit. Valid value is one of months, days, hours or minutes", (String)ex.getMessage());
        }
    }

    private void _testGetDefinition(String jobId) throws Exception {
        CoordinatorEngine ce = new CoordinatorEngine(TestCoordinatorEngine.getTestUser());
        CoordinatorJobBean job = ce.getCoordJob(jobId);
        System.out.println("JOBXML=" + job.getOrigJobXml());
        TestCoordinatorEngine.assertNotNull((Object)job.getOrigJobXml());
    }

    private void checkCoordJob(String jobId) throws StoreException {
        try {
            CoordinatorJobBean coordinatorJobBean = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{jobId});
        }
        catch (JPAExecutorException se) {
            se.printStackTrace();
            TestCoordinatorEngine.fail((String)("Job ID " + jobId + " was not stored properly in db"));
        }
    }

    private void writeToFile(String appXml, String appPath) throws Exception {
        File wf = new File(new URI(appPath).getPath());
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(wf));
            out.println(appXml);
        }
    }

    private void _testStatus(final String jobId) throws Exception {
        this.waitFor(6000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorEngine ce = new CoordinatorEngine(TestCoordinatorEngine.getTestUser());
                CoordinatorJobBean job = ce.getCoordJob(jobId);
                return !job.getStatus().equals((Object)Job.Status.PREP);
            }
        });
        CoordinatorEngine ce = new CoordinatorEngine(TestCoordinatorEngine.getTestUser());
        CoordinatorJobBean job = ce.getCoordJob(jobId);
        TestCoordinatorEngine.assertFalse((boolean)job.getStatus().equals((Object)Job.Status.PREP));
    }

    private void _testSubsetActions(String jobId) throws Exception {
        CoordinatorEngine ce = new CoordinatorEngine(TestCoordinatorEngine.getTestUser());
        CoordinatorJobBean job = ce.getCoordJob(jobId, "status=WAITING", 1, 2, false);
        TestCoordinatorEngine.assertEquals((int)job.getActions().size(), (int)2);
        job = ce.getCoordJob(jobId, "status=WAITING", 1, 0, false);
        TestCoordinatorEngine.assertEquals((int)job.getActions().size(), (int)0);
        job = ce.getCoordJob(jobId, "status=RUNNING", 1, 2, false);
        TestCoordinatorEngine.assertEquals((int)job.getActions().size(), (int)0);
        job = ce.getCoordJob(jobId, "status=RUNNING;status=WAITING", 1, 2, false);
        TestCoordinatorEngine.assertEquals((int)job.getActions().size(), (int)2);
        job = ce.getCoordJob(jobId, null, 1, 2, false);
        TestCoordinatorEngine.assertEquals((int)job.getActions().size(), (int)2);
        job = ce.getCoordJob(jobId, "", 1, 2, false);
        TestCoordinatorEngine.assertEquals((int)job.getActions().size(), (int)2);
        job = ce.getCoordJob(jobId, "status!=RUNNING", 1, 2, false);
        TestCoordinatorEngine.assertEquals((int)job.getActions().size(), (int)2);
        job = ce.getCoordJob(jobId, "status!=RUNNING;status!=WAITING", 1, 2, false);
        TestCoordinatorEngine.assertEquals((int)job.getActions().size(), (int)0);
        try {
            job = ce.getCoordJob(jobId, "status=WAITING;status!=WAITING", 1, 2, false);
        }
        catch (CoordinatorEngineException ex) {
            TestCoordinatorEngine.assertEquals((Object)ErrorCode.E0421, (Object)ex.getErrorCode());
            TestCoordinatorEngine.assertEquals((String)"E0421: Invalid job filter [status=WAITING;status!=WAITING], the status [WAITING] specified in both positive and negative filters", (String)ex.getMessage());
        }
        try {
            job = ce.getCoordJob(jobId, "statusRUNNING", 1, 2, false);
        }
        catch (CoordinatorEngineException ex) {
            TestCoordinatorEngine.assertEquals((Object)ErrorCode.E0421, (Object)ex.getErrorCode());
            TestCoordinatorEngine.assertEquals((String)"E0421: Invalid job filter [statusRUNNING], filter should be of format <key><comparator><value> pairs", (String)ex.getMessage());
        }
        try {
            job = ce.getCoordJob(jobId, "status=", 1, 2, false);
        }
        catch (CoordinatorEngineException ex) {
            TestCoordinatorEngine.assertEquals((Object)ErrorCode.E0421, (Object)ex.getErrorCode());
            TestCoordinatorEngine.assertEquals((String)("E0421: Invalid job filter [status=], invalid status value []. Valid status values are: [" + StringUtils.join((Object[])CoordinatorAction.Status.values(), (String)", ") + "]"), (String)ex.getMessage());
        }
        try {
            job = ce.getCoordJob(jobId, "status=blahblah", 1, 2, false);
        }
        catch (CoordinatorEngineException ex) {
            TestCoordinatorEngine.assertEquals((Object)ErrorCode.E0421, (Object)ex.getErrorCode());
            TestCoordinatorEngine.assertEquals((String)("E0421: Invalid job filter [status=blahblah], invalid status value [blahblah]. Valid status values are: [" + StringUtils.join((Object[])CoordinatorAction.Status.values(), (String)", ") + "]"), (String)ex.getMessage());
        }
        try {
            job = ce.getCoordJob(jobId, "status=\"\"", 1, 2, false);
        }
        catch (CoordinatorEngineException ex) {
            TestCoordinatorEngine.assertEquals((Object)ErrorCode.E0421, (Object)ex.getErrorCode());
            TestCoordinatorEngine.assertEquals((String)("E0421: Invalid job filter [status=\"\"], invalid status value [\"\"]. Valid status values are: [" + StringUtils.join((Object[])CoordinatorAction.Status.values(), (String)", ") + "]"), (String)ex.getMessage());
        }
        try {
            job = ce.getCoordJob(jobId, "blahblah=blahblah", 1, 2, false);
        }
        catch (CoordinatorEngineException ex) {
            TestCoordinatorEngine.assertEquals((Object)ErrorCode.E0421, (Object)ex.getErrorCode());
            TestCoordinatorEngine.assertEquals((String)("E0421: Invalid job filter [blahblah=blahblah], invalid filter [blahblah]. Valid filters [" + StringUtils.join((Object[])CoordinatorEngine.VALID_JOB_FILTERS, (String)", ") + "]"), (String)ex.getMessage());
        }
    }
}

