/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.Date;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.test.XTestCase;

public class TestActionBean
extends XTestCase {
    public void testAction() {
        WorkflowActionBean action = new WorkflowActionBean();
        action.setJobId("id");
        action.setExecutionPath("executionPath");
        action.setPending();
        action.setPendingAge(new Date());
        action.setSignalValue("signal");
        action.setLogToken("logToken");
        TestActionBean.assertEquals((String)"id", (String)action.getJobId());
        TestActionBean.assertEquals((String)"executionPath", (String)action.getExecutionPath());
        TestActionBean.assertTrue((boolean)action.isPending());
        TestActionBean.assertNotNull((Object)action.getPendingAge());
        TestActionBean.assertEquals((String)"signal", (String)action.getSignalValue());
        TestActionBean.assertEquals((String)"logToken", (String)action.getLogToken());
        action.setExecutionData("externalStatus", System.getProperties());
        TestActionBean.assertEquals((String)"externalStatus", (String)action.getExternalStatus());
        TestActionBean.assertNotNull((Object)action.getData());
        action.setEndData(WorkflowAction.Status.OK, "signal");
        TestActionBean.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
        TestActionBean.assertEquals((String)"externalStatus", (String)action.getExternalStatus());
        action.setStartData("externalId", "trackerUri", "consoleUrl");
        TestActionBean.assertEquals((String)"externalId", (String)action.getExternalId());
        TestActionBean.assertEquals((String)"trackerUri", (String)action.getTrackerUri());
        TestActionBean.assertEquals((String)"consoleUrl", (String)action.getConsoleUrl());
        action.setStats("jsonStats");
        action.setExternalChildIDs("job1,job2");
        TestActionBean.assertEquals((String)"jsonStats", (String)action.getStats());
        TestActionBean.assertEquals((String)"job1,job2", (String)action.getExternalChildIDs());
    }

    public void testEmptyWriteRead() throws Exception {
        WorkflowActionBean action = new WorkflowActionBean();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        action.write((DataOutput)dos);
        dos.close();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
        action = new WorkflowActionBean();
        action.readFields((DataInput)dis);
    }

    public void testFullWriteRead() throws Exception {
    }
}

