/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.tools;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BuildInfo;
import org.apache.oozie.cli.CLIParser;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.openjpa.jdbc.meta.MappingTool;

public class OozieDBCLI {
    public static final String HELP_CMD = "help";
    public static final String VERSION_CMD = "version";
    public static final String CREATE_CMD = "create";
    public static final String UPGRADE_CMD = "upgrade";
    public static final String POST_UPGRADE_CMD = "postupgrade";
    public static final String SQL_FILE_OPT = "sqlfile";
    public static final String RUN_OPT = "run";
    private static final String DB_VERSION_PRE_4_0 = "1";
    private static final String DB_VERSION_FOR_4_0 = "2";
    static final String DB_VERSION_FOR_5_0 = "3";
    private static final String DISCRIMINATOR_COLUMN = "bean_type";
    private static final String TEMP_COLUMN_PREFIX = "temp_";
    private HashMap<String, List<String>> clobColumnMap;
    public static final String[] HELP_INFO = new String[]{"", "IMPORTANT: If using an Oracle, MS SQL or MySQL Database, before running this", "tool copy the corresponding JDBC driver to the tools libext/ directory"};
    private boolean used = false;
    private static final String UPDATE_OOZIE_VERSION = "update OOZIE_SYS set data='" + BuildInfo.getBuildInfo().getProperty("build.version") + "' where name='oozie.version'";
    private static final String COORD_JOBS_THROTTLING_DEFAULT = "update COORD_JOBS set mat_throttling = 12";
    private static final String COORD_JOBS_ADD_APP_NAMESPACE = "update COORD_JOBS set app_namespace = 'uri:oozie:coordinator:0.1'";
    private static final String COORD_JOBS_STATUS_1 = "update COORD_JOBS set status = 'RUNNING', PENDING = 1 where id in ( select job_id from COORD_ACTIONS where job_id in ( select id from COORD_JOBS where status = 'SUCCEEDED') and (status != 'FAILED' and status != 'SUCCEEDED' and status != 'KILLED' and status != 'TIMEDOUT') )";
    private static final String COORD_JOBS_STATUS_2 = "update COORD_JOBS set status = 'RUNNING' where status = 'PREMATER'";
    private static final String COORD_ACTIONS_STATUS = "update COORD_ACTIONS set status = 'SUSPENDED' where id in( select A.id from COORD_ACTIONS A, WF_JOBS B where A.external_id = B.id and B.status = 'SUSPENDED' and A.status = 'RUNNING' )";
    private static final String UPDATE_DELIMITER_VER_TWO = "UPDATE COORD_ACTIONS SET MISSING_DEPENDENCIES = REPLACE(MISSING_DEPENDENCIES,';','!!')";
    private static final String UPDATE_DELIMITER_VER_TWO_MSSQL = "UPDATE COORD_ACTIONS SET MISSING_DEPENDENCIES = REPLACE(CAST(MISSING_DEPENDENCIES AS varchar(MAX)),';','!!')";
    private static final String COORD_ACTION_ID_DEPS = "SELECT ID, MISSING_DEPENDENCIES FROM COORD_ACTIONS";
    private static final String[] DROP_AUTH_TOKEN_QUERIES = new String[]{"ALTER TABLE BUNDLE_JOBS DROP COLUMN AUTH_TOKEN", "ALTER TABLE COORD_JOBS DROP COLUMN AUTH_TOKEN", "ALTER TABLE WF_JOBS DROP COLUMN AUTH_TOKEN"};
    private static final String WORKFLOW_STATUS_QUERY = "select count(*) from WF_JOBS where status IN ('RUNNING', 'SUSPENDED')";
    private static final String OOZIE_SYS_EXISTS = "select count(*) from OOZIE_SYS";
    private static final String GET_OOZIE_DB_VERSION = "select data from OOZIE_SYS where name = 'db.version'";
    private static final String CREATE_OOZIE_SYS = "create table OOZIE_SYS (name varchar(100), data varchar(100))";
    private static final String SET_OOZIE_VERSION = "insert into OOZIE_SYS (name, data) values ('oozie.version', '" + BuildInfo.getBuildInfo().getProperty("build.version") + "')";
    private static final String CREATE_OOZIE_SYS_INDEX = "create clustered index OOZIE_SYS_PK on OOZIE_SYS (name);";
    private static final String GET_OOZIE_SYS_INFO = "select name, data from OOZIE_SYS order by name";

    public static void main(String[] args) {
        System.exit(new OozieDBCLI().run(args));
    }

    protected Options createUpgradeOptions() {
        Option sqlfile = new Option(SQL_FILE_OPT, true, "Generate SQL script instead creating/upgrading the DB schema");
        Option run = new Option(RUN_OPT, false, "Confirm the DB schema creation/upgrade");
        Options options = new Options();
        options.addOption(sqlfile);
        options.addOption(run);
        return options;
    }

    public synchronized int run(String[] args) {
        if (this.used) {
            throw new IllegalStateException("CLI instance already used");
        }
        this.used = true;
        CLIParser parser = new CLIParser("ooziedb.sh", HELP_INFO);
        parser.addCommand(HELP_CMD, "", "display usage for all commands or specified command", new Options(), false);
        parser.addCommand(VERSION_CMD, "", "show Oozie DB version information", new Options(), false);
        parser.addCommand(CREATE_CMD, "", "create Oozie DB schema", this.createUpgradeOptions(), false);
        parser.addCommand(UPGRADE_CMD, "", "upgrade Oozie DB", this.createUpgradeOptions(), false);
        parser.addCommand(POST_UPGRADE_CMD, "", "post upgrade Oozie DB", this.createUpgradeOptions(), false);
        try {
            System.out.println();
            CLIParser.Command command = parser.parse(args);
            if (command.getName().equals(HELP_CMD)) {
                parser.showHelp(command.getCommandLine());
            } else if (command.getName().equals(VERSION_CMD)) {
                this.showVersion();
            } else {
                if (!command.getCommandLine().hasOption(SQL_FILE_OPT) && !command.getCommandLine().hasOption(RUN_OPT)) {
                    throw new Exception("'-sqlfile <FILE>' or '-run' options must be specified");
                }
                CommandLine commandLine = command.getCommandLine();
                String sqlFile = commandLine.hasOption(SQL_FILE_OPT) ? commandLine.getOptionValue(SQL_FILE_OPT) : File.createTempFile("ooziedb-", ".sql").getAbsolutePath();
                boolean run = commandLine.hasOption(RUN_OPT);
                if (command.getName().equals(CREATE_CMD)) {
                    this.createDB(sqlFile, run);
                }
                if (command.getName().equals(UPGRADE_CMD)) {
                    this.upgradeDB(sqlFile, run);
                }
                if (command.getName().equals(POST_UPGRADE_CMD)) {
                    this.postUpgradeDB(sqlFile, run);
                }
                System.out.println();
                System.out.println("The SQL commands have been written to: " + sqlFile);
                if (!run) {
                    System.out.println();
                    System.out.println("WARN: The SQL commands have NOT been executed, you must use the '-run' option");
                    System.out.println();
                }
            }
            return 0;
        }
        catch (ParseException ex) {
            System.err.println("Invalid sub-command: " + ex.getMessage());
            System.err.println();
            System.err.println(parser.shortHelp());
            return 1;
        }
        catch (Exception ex) {
            System.err.println();
            System.err.println("Error: " + ex.getMessage());
            System.err.println();
            System.err.println("Stack trace for the error was (for debug purposes):");
            System.err.println("--------------------------------------");
            ex.printStackTrace(System.err);
            System.err.println("--------------------------------------");
            System.err.println();
            return 1;
        }
    }

    private Map<String, String> getJdbcConf() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        HashMap<String, String> jdbcConf = new HashMap<String, String>();
        jdbcConf.put("driver", conf.get("oozie.service.JPAService.jdbc.driver"));
        String url = conf.get("oozie.service.JPAService.jdbc.url");
        jdbcConf.put("url", url);
        jdbcConf.put("user", conf.get("oozie.service.JPAService.jdbc.username"));
        jdbcConf.put("password", ConfigurationService.getPassword((Configuration)conf, (String)"oozie.service.JPAService.jdbc.password"));
        String dbType = url.substring("jdbc:".length());
        if (dbType.indexOf(":") <= 0) {
            throw new RuntimeException("Invalid JDBC URL, missing vendor 'jdbc:[VENDOR]:...'");
        }
        dbType = dbType.substring(0, dbType.indexOf(":"));
        jdbcConf.put("dbtype", dbType);
        return jdbcConf;
    }

    private void createDB(String sqlFile, boolean run) throws Exception {
        this.validateConnection();
        if (this.checkDBExists()) {
            return;
        }
        this.verifyOozieSysTable(false);
        this.createUpgradeDB(sqlFile, run, true);
        this.createOozieSysTable(sqlFile, run, DB_VERSION_FOR_5_0);
        System.out.println();
        if (run) {
            System.out.println("Oozie DB has been created for Oozie version '" + BuildInfo.getBuildInfo().getProperty("build.version") + "'");
        }
        System.out.println();
    }

    private void upgradeDB(String sqlFile, boolean run) throws Exception {
        String ver;
        this.validateConnection();
        if (!this.checkDBExists()) {
            throw new Exception("Oozie DB doesn't exist");
        }
        String version = BuildInfo.getBuildInfo().getProperty("build.version");
        if (!this.verifyOozieSysTable(false, false)) {
            this.createOozieSysTable(sqlFile, run, DB_VERSION_PRE_4_0);
        }
        String startingVersion = ver = this.getOozieDBVersion().trim();
        if (ver.equals(DB_VERSION_FOR_5_0)) {
            System.out.println("Oozie DB already upgraded to Oozie version '" + version + "'");
            return;
        }
        this.createUpgradeDB(sqlFile, run, false);
        while (!ver.equals(DB_VERSION_FOR_5_0)) {
            if (ver.equals(DB_VERSION_PRE_4_0)) {
                System.out.println("Upgrading to db schema for Oozie 4.0");
                this.upgradeDBTo40(sqlFile, run);
                ver = run ? this.getOozieDBVersion().trim() : DB_VERSION_FOR_4_0;
                continue;
            }
            if (!ver.equals(DB_VERSION_FOR_4_0)) continue;
            System.out.println("Upgrading to db schema for Oozie " + version);
            this.upgradeDBto50(sqlFile, run, startingVersion);
            ver = run ? this.getOozieDBVersion().trim() : DB_VERSION_FOR_5_0;
        }
        if (run) {
            System.out.println();
            System.out.println("Oozie DB has been upgraded to Oozie version '" + version + "'");
        }
        System.out.println();
    }

    private void upgradeDBTo40(String sqlFile, boolean run) throws Exception {
        this.upgradeOozieDBVersion(sqlFile, run, DB_VERSION_FOR_4_0);
        this.postUpgradeTasksFor40(sqlFile, run);
        this.ddlTweaks(sqlFile, run);
    }

    private void upgradeDBto50(String sqlFile, boolean run, String startingVersion) throws Exception {
        this.upgradeOozieDBVersion(sqlFile, run, DB_VERSION_FOR_5_0);
        this.ddlTweaksFor50(sqlFile, run, startingVersion);
    }

    private void upgradeOozieDBVersion(String sqlFile, boolean run, String version) throws Exception {
        String updateDBVersion = "update OOZIE_SYS set data='" + version + "' where name='db.version'";
        PrintWriter writer = new PrintWriter(new FileWriter(sqlFile, true));
        writer.println();
        writer.println(UPDATE_OOZIE_VERSION);
        writer.println(updateDBVersion);
        writer.close();
        System.out.println("Update db.version in OOZIE_SYS table to " + version);
        if (run) {
            try (Connection conn = this.createConnection();){
                conn.setAutoCommit(true);
                Statement st = conn.createStatement();
                st.executeUpdate(updateDBVersion);
                st.executeUpdate(UPDATE_OOZIE_VERSION);
                st.close();
            }
        }
        System.out.println("DONE");
    }

    private void postUpgradeDB(String sqlFile, boolean run) throws Exception {
        String version = this.getOozieDBVersion();
        if (this.getOozieDBVersion().equals(DB_VERSION_FOR_4_0)) {
            this.postUpgradeDBTo40(sqlFile, run);
        } else {
            System.out.println("No Post ugprade updates available for " + version);
        }
    }

    private void postUpgradeDBTo40(String sqlFile, boolean run) throws Exception {
        this.validateConnection();
        if (!this.checkDBExists()) {
            throw new Exception("Oozie DB doesn't exist");
        }
        this.verifyOozieSysTable(true);
        this.verifyDBState();
        this.postUpgradeTasks(sqlFile, run, true);
        if (run) {
            System.out.println();
            System.out.println("Post ugprade updates have been executed");
        }
        System.out.println();
    }

    private String getDBVendor() throws Exception {
        String url = this.getJdbcConf().get("url");
        String vendor = url.substring("jdbc:".length());
        vendor = vendor.substring(0, vendor.indexOf(":"));
        return vendor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postUpgradeTasks(String sqlFile, boolean run, boolean force) throws Exception {
        PrintWriter writer = new PrintWriter(new FileWriter(sqlFile, true));
        writer.println();
        boolean skipUpdates = this.getDBVendor().equals("mysql");
        Connection conn = run ? this.createConnection() : null;
        try {
            Statement st;
            System.out.println("Post-upgrade COORD_JOBS new columns default values");
            writer.println("update COORD_JOBS set mat_throttling = 12;");
            if (run) {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                st.executeUpdate(COORD_JOBS_THROTTLING_DEFAULT);
                st.close();
            }
            writer.println("update COORD_JOBS set app_namespace = 'uri:oozie:coordinator:0.1';");
            if (run) {
                st = conn.createStatement();
                st.executeUpdate(COORD_JOBS_ADD_APP_NAMESPACE);
                st.close();
            }
            System.out.println("DONE");
            if (!skipUpdates || force) {
                System.out.println("Post-upgrade COORD_JOBS & COORD_ACTIONS status values");
                writer.println("update COORD_JOBS set status = 'RUNNING', PENDING = 1 where id in ( select job_id from COORD_ACTIONS where job_id in ( select id from COORD_JOBS where status = 'SUCCEEDED') and (status != 'FAILED' and status != 'SUCCEEDED' and status != 'KILLED' and status != 'TIMEDOUT') );");
                writer.println("update COORD_JOBS set status = 'RUNNING' where status = 'PREMATER';");
                writer.println("update COORD_ACTIONS set status = 'SUSPENDED' where id in( select A.id from COORD_ACTIONS A, WF_JOBS B where A.external_id = B.id and B.status = 'SUSPENDED' and A.status = 'RUNNING' );");
                if (run) {
                    st = conn.createStatement();
                    st.executeUpdate(COORD_JOBS_STATUS_1);
                    st.close();
                    st = conn.createStatement();
                    st.executeUpdate(COORD_JOBS_STATUS_2);
                    st.close();
                    st = conn.createStatement();
                    st.executeUpdate(COORD_ACTIONS_STATUS);
                    st.close();
                }
                System.out.println("DONE");
            } else {
                System.out.println("SKIPPING Post-upgrade of COORD_JOBS & COORD_ACTIONS status values,");
                System.out.println("         MySQL 5 does not support the update queries");
                System.out.println();
                System.out.println("         Oozie will be able to run jobs started before the upgrade,");
                System.out.println("         although those jobs may show different status names in their actions");
            }
            if (!this.getDBVendor().equals("derby")) {
                String updateMissingDependenciesQuery = this.getDBVendor().equals("sqlserver") ? UPDATE_DELIMITER_VER_TWO_MSSQL : UPDATE_DELIMITER_VER_TWO;
                writer.println(updateMissingDependenciesQuery + ";");
                System.out.println("Post-upgrade MISSING_DEPENDENCIES column");
                if (run) {
                    Statement st2 = conn.createStatement();
                    st2.executeUpdate(updateMissingDependenciesQuery);
                    st2.close();
                }
            } else {
                System.out.println("Post-upgrade MISSING_DEPENDENCIES column in Derby");
                this.replaceForDerby(";", "!!");
            }
            System.out.println("DONE");
            writer.close();
        }
        finally {
            if (run) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postUpgradeTasksFor40(String sqlFile, boolean run) throws Exception {
        PrintWriter writer = new PrintWriter(new FileWriter(sqlFile, true));
        writer.println();
        Connection conn = run ? this.createConnection() : null;
        try {
            if (!this.getDBVendor().equals("derby")) {
                String updateMissingDependenciesQuery = this.getDBVendor().equals("sqlserver") ? UPDATE_DELIMITER_VER_TWO_MSSQL : UPDATE_DELIMITER_VER_TWO;
                writer.println(updateMissingDependenciesQuery + ";");
                System.out.println("Post-upgrade MISSING_DEPENDENCIES column");
                if (run) {
                    Statement st = conn.createStatement();
                    st.executeUpdate(updateMissingDependenciesQuery);
                    st.close();
                }
            } else {
                System.out.println("Post-upgrade MISSING_DEPENDENCIES column in Derby");
                this.replaceForDerby(";", "!!");
            }
            System.out.println("DONE");
            writer.close();
        }
        finally {
            if (run) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceForDerby(String oldStr, String newStr) throws Exception {
        Connection connRead = this.createConnection();
        try {
            connRead.setAutoCommit(false);
            Statement st = connRead.createStatement();
            st.setFetchSize(100);
            ResultSet rs = st.executeQuery(COORD_ACTION_ID_DEPS);
            while (rs.next()) {
                String id = rs.getString(1);
                Clob clob = rs.getClob(2);
                String clobStr = clob.getSubString(1L, (int)clob.length());
                clob.setString(1L, clobStr.replace(oldStr, newStr));
                PreparedStatement prepStmt = connRead.prepareStatement("UPDATE COORD_ACTIONS SET MISSING_DEPENDENCIES=? WHERE ID=?");
                prepStmt.setString(1, clob.getSubString(1L, (int)clob.length()));
                prepStmt.setString(2, id);
                prepStmt.execute();
                prepStmt.close();
            }
        }
        finally {
            connRead.commit();
            connRead.close();
        }
    }

    private void convertClobToBlobInOracle(Connection conn) throws Exception {
        if (conn == null) {
            return;
        }
        System.out.println("Converting clob columns to blob for all tables");
        Statement statement = conn.createStatement();
        CallableStatement tempBlobCall = conn.prepareCall("{call dbms_lob.CREATETEMPORARY(?, TRUE)}");
        tempBlobCall.registerOutParameter(1, 2004);
        CallableStatement dbmsLobCallStmt = conn.prepareCall("{call dbms_lob.CONVERTTOBLOB(?, ?, ?, ?, ?, 0, ?, ?)}");
        dbmsLobCallStmt.registerOutParameter(1, 2004);
        dbmsLobCallStmt.setInt(3, Integer.MAX_VALUE);
        dbmsLobCallStmt.registerOutParameter(4, 4);
        dbmsLobCallStmt.setInt(4, 1);
        dbmsLobCallStmt.registerOutParameter(5, 4);
        dbmsLobCallStmt.setInt(5, 1);
        dbmsLobCallStmt.registerOutParameter(6, 4);
        dbmsLobCallStmt.setInt(6, 0);
        dbmsLobCallStmt.registerOutParameter(7, 4);
        dbmsLobCallStmt.setInt(7, 1);
        for (Map.Entry<String, List<String>> tableClobColumnMap : this.getTableClobColumnMap().entrySet()) {
            String tableName = tableClobColumnMap.getKey();
            List<String> columnNames = tableClobColumnMap.getValue();
            for (String column : columnNames) {
                statement.executeUpdate(this.getAddColumnQuery(tableName, TEMP_COLUMN_PREFIX + column, "blob"));
            }
            ResultSet rs = statement.executeQuery(this.getSelectQuery(tableName, columnNames));
            while (rs.next()) {
                for (int i = 0; i < columnNames.size(); ++i) {
                    Clob srcClob = rs.getClob(columnNames.get(i));
                    if (srcClob == null || srcClob.length() < 1L) continue;
                    tempBlobCall.execute();
                    Blob destLob = tempBlobCall.getBlob(1);
                    dbmsLobCallStmt.setBlob(1, destLob);
                    dbmsLobCallStmt.setClob(2, srcClob);
                    dbmsLobCallStmt.execute();
                    Blob blob = dbmsLobCallStmt.getBlob(1);
                    PreparedStatement ps = conn.prepareStatement("update " + tableName + " set " + TEMP_COLUMN_PREFIX + columnNames.get(i) + "=? where id = ?");
                    ps.setBlob(1, blob);
                    ps.setString(2, rs.getString(1));
                    ps.executeUpdate();
                    ps.close();
                }
            }
            rs.close();
            for (String column : columnNames) {
                statement.executeUpdate(this.getDropColumnQuery(tableName, column));
                statement.executeUpdate(this.getRenameColumnQuery(tableName, TEMP_COLUMN_PREFIX + column, column));
            }
        }
        dbmsLobCallStmt.close();
        tempBlobCall.close();
        System.out.println("Done");
    }

    private void convertClobToBlobInMysql(String sqlFile, Connection conn) throws Exception {
        System.out.println("Converting mediumtext/text columns to mediumblob for all tables");
        PrintWriter writer = new PrintWriter(new FileWriter(sqlFile, true));
        writer.println();
        Statement statement = conn != null ? conn.createStatement() : null;
        for (Map.Entry<String, List<String>> tableClobColumnMap : this.getTableClobColumnMap().entrySet()) {
            String tableName = tableClobColumnMap.getKey();
            List<String> columnNames = tableClobColumnMap.getValue();
            StringBuilder modifyColumn = new StringBuilder();
            modifyColumn.append(" ALTER TABLE " + tableName);
            for (String column : columnNames) {
                modifyColumn.append(" MODIFY " + column + " mediumblob,");
            }
            modifyColumn.replace(modifyColumn.length() - 1, modifyColumn.length(), "");
            writer.println(modifyColumn.toString() + ";");
            if (statement == null) continue;
            statement.executeUpdate(modifyColumn.toString());
        }
        writer.close();
        if (statement != null) {
            statement.close();
        }
        System.out.println("Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertClobToBlobInPostgres(String sqlFile, Connection conn, String startingVersion) throws Exception {
        System.out.println("Converting text columns to bytea for all tables");
        Statement statement = null;
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(sqlFile, true));
            writer.println();
            statement = conn != null ? conn.createStatement() : null;
            for (Map.Entry<String, List<String>> tableClobColumnMap : this.getTableClobColumnMap().entrySet()) {
                String tableName = tableClobColumnMap.getKey();
                List<String> columnNames = tableClobColumnMap.getValue();
                for (String column : columnNames) {
                    if (startingVersion.equals(DB_VERSION_PRE_4_0) && tableName.equals("COORD_ACTIONS") && column.equals("push_missing_dependencies")) continue;
                    String addQuery = this.getAddColumnQuery(tableName, TEMP_COLUMN_PREFIX + column, "bytea");
                    writer.println(addQuery + ";");
                    String updateQuery = "update " + tableName + " set " + TEMP_COLUMN_PREFIX + column + "=(decode(replace(" + column + ", E'\\\\', E'\\\\\\\\'), 'escape'))";
                    writer.println(updateQuery + ";");
                    String dropQuery = this.getDropColumnQuery(tableName, column);
                    writer.println(dropQuery + ";");
                    String renameQuery = this.getRenameColumnQuery(tableName, TEMP_COLUMN_PREFIX + column, column);
                    writer.println(renameQuery + ";");
                    if (statement == null) continue;
                    statement.executeUpdate(addQuery);
                    statement.executeUpdate(updateQuery);
                    statement.executeUpdate(dropQuery);
                    statement.executeUpdate(renameQuery);
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        System.out.println("DONE");
    }

    private void convertClobToBlobinDerby(Connection conn, String startingVersion) throws Exception {
        if (conn == null) {
            return;
        }
        System.out.println("Converting clob columns to blob for all tables");
        Statement statement = conn.createStatement();
        for (Map.Entry<String, List<String>> tableClobColumnMap : this.getTableClobColumnMap().entrySet()) {
            String tableName = tableClobColumnMap.getKey();
            List<String> columnNames = tableClobColumnMap.getValue();
            for (String column : columnNames) {
                statement.executeUpdate(this.getAddColumnQuery(tableName, TEMP_COLUMN_PREFIX + column, "blob"));
            }
            ResultSet rs = statement.executeQuery(this.getSelectQuery(tableName, columnNames));
            while (rs.next()) {
                for (String column : columnNames) {
                    Clob confClob;
                    if (startingVersion.equals(DB_VERSION_PRE_4_0) && tableName.equals("COORD_ACTIONS") && column.equals("push_missing_dependencies") || (confClob = rs.getClob(column)) == null) continue;
                    PreparedStatement ps = conn.prepareStatement("update " + tableName + " set " + TEMP_COLUMN_PREFIX + column + "=? where id = ?");
                    byte[] data = IOUtils.toByteArray((Reader)confClob.getCharacterStream(), (String)"UTF-8");
                    ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(data), data.length);
                    ps.setString(2, rs.getString(1));
                    ps.executeUpdate();
                    ps.close();
                }
            }
            rs.close();
            for (String column : columnNames) {
                statement.executeUpdate(this.getDropColumnQuery(tableName, column));
                statement.executeUpdate("RENAME COLUMN " + tableName + "." + TEMP_COLUMN_PREFIX + column + " TO " + column);
            }
        }
        statement.close();
        System.out.println("DONE");
    }

    private String getRenameColumnQuery(String tableName, String srcColumn, String destColumn) {
        return new String("ALTER TABLE " + tableName + " RENAME column " + srcColumn + " TO " + destColumn);
    }

    private String getDropColumnQuery(String tableName, String column) {
        return new String("ALTER TABLE " + tableName + " DROP column " + column);
    }

    private String getAddColumnQuery(String tableName, String tempColumn, String type) {
        return new String("ALTER TABLE " + tableName + " ADD " + tempColumn + " " + type);
    }

    private String getSelectQuery(String tableName, List<String> columnNames) {
        StringBuilder selectQuery = new StringBuilder();
        selectQuery.append("SELECT id,");
        for (String column : columnNames) {
            selectQuery.append(column);
            selectQuery.append(",");
        }
        selectQuery.replace(selectQuery.length() - 1, selectQuery.length(), "");
        selectQuery.append(" FROM ");
        selectQuery.append(tableName);
        return selectQuery.toString();
    }

    private void ddlTweaksFor50(String sqlFile, boolean run, String startingVersion) throws Exception {
        Connection conn;
        String dbVendor = this.getDBVendor();
        Connection connection = conn = run ? this.createConnection() : null;
        if (dbVendor.equals("oracle")) {
            this.convertClobToBlobInOracle(conn);
        } else if (dbVendor.equals("mysql")) {
            this.convertClobToBlobInMysql(sqlFile, conn);
        } else if (dbVendor.equals("postgresql")) {
            this.convertClobToBlobInPostgres(sqlFile, conn, startingVersion);
        } else if (dbVendor.equals("derby")) {
            this.convertClobToBlobinDerby(conn, startingVersion);
        }
        System.out.println("Dropping discriminator column");
        PrintWriter writer = new PrintWriter(new FileWriter(sqlFile, true));
        writer.println();
        ArrayList<String> ddlQueries = new ArrayList<String>();
        ddlQueries.add(this.getDropColumnQuery("WF_JOBS", DISCRIMINATOR_COLUMN));
        ddlQueries.add(this.getDropColumnQuery("WF_ACTIONS", DISCRIMINATOR_COLUMN));
        ddlQueries.add(this.getDropColumnQuery("COORD_JOBS", DISCRIMINATOR_COLUMN));
        ddlQueries.add(this.getDropColumnQuery("COORD_ACTIONS", DISCRIMINATOR_COLUMN));
        ddlQueries.add(this.getDropColumnQuery("BUNDLE_JOBS", DISCRIMINATOR_COLUMN));
        ddlQueries.add(this.getDropColumnQuery("BUNDLE_ACTIONS", DISCRIMINATOR_COLUMN));
        Statement stmt = conn != null ? conn.createStatement() : null;
        for (String query : ddlQueries) {
            writer.println(query + ";");
            if (!run) continue;
            stmt.executeUpdate(query);
        }
        System.out.println("DONE");
        writer.close();
        if (run) {
            stmt.close();
            conn.close();
        }
    }

    private Map<String, List<String>> getTableClobColumnMap() {
        if (this.clobColumnMap != null) {
            return this.clobColumnMap;
        }
        this.clobColumnMap = new HashMap();
        this.clobColumnMap.put("WF_ACTIONS", new ArrayList<String>(Arrays.asList("conf", "sla_xml", "data", "stats", "external_child_ids")));
        this.clobColumnMap.put("WF_JOBS", new ArrayList<String>(Arrays.asList("proto_action_conf", "sla_xml", "conf")));
        this.clobColumnMap.put("COORD_ACTIONS", new ArrayList<String>(Arrays.asList("sla_xml", "created_conf", "run_conf", "action_xml", "missing_dependencies", "push_missing_dependencies")));
        this.clobColumnMap.put("COORD_JOBS", new ArrayList<String>(Arrays.asList("conf", "job_xml", "orig_job_xml", "sla_xml")));
        this.clobColumnMap.put("BUNDLE_JOBS", new ArrayList<String>(Arrays.asList("conf", "job_xml", "orig_job_xml")));
        return this.clobColumnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ddlTweaks(String sqlFile, boolean run) throws Exception {
        PrintWriter writer = new PrintWriter(new FileWriter(sqlFile, true));
        writer.println();
        String dbVendor = this.getDBVendor();
        ArrayList<String> ddlQueries = new ArrayList<String>();
        if (dbVendor.equals("derby")) {
            ddlQueries.add("ALTER TABLE WF_ACTIONS ALTER COLUMN execution_path SET DATA TYPE VARCHAR(1024)");
            ddlQueries.add("ALTER TABLE WF_ACTIONS ADD COLUMN error_message_temp VARCHAR(500)");
            ddlQueries.add("UPDATE WF_ACTIONS SET error_message_temp = SUBSTR(error_message,1,500)");
            ddlQueries.add("ALTER TABLE WF_ACTIONS DROP COLUMN error_message");
            ddlQueries.add("RENAME COLUMN WF_ACTIONS.error_message_temp TO error_message");
            ddlQueries.add("ALTER TABLE COORD_JOBS ADD COLUMN frequency_temp_a CHAR(254)");
            ddlQueries.add("UPDATE COORD_JOBS SET frequency_temp_a=CAST(frequency AS CHAR(254))");
            ddlQueries.add("ALTER TABLE COORD_JOBS ADD COLUMN frequency_temp_b VARCHAR(255)");
            ddlQueries.add("UPDATE COORD_JOBS SET frequency_temp_b=TRIM(CAST(frequency_temp_a AS VARCHAR(255)))");
            ddlQueries.add("ALTER TABLE COORD_JOBS DROP COLUMN frequency_temp_a");
            ddlQueries.add("ALTER TABLE COORD_JOBS DROP COLUMN frequency");
            ddlQueries.add("RENAME COLUMN COORD_JOBS.frequency_temp_b TO frequency");
        } else if (dbVendor.equals("oracle")) {
            ddlQueries.add("ALTER TABLE WF_ACTIONS MODIFY (execution_path VARCHAR2(1024))");
            ddlQueries.add("ALTER TABLE WF_ACTIONS ADD (error_message_temp VARCHAR2(500))");
            ddlQueries.add("UPDATE WF_ACTIONS SET error_message_temp = dbms_lob.substr(error_message,500,1)");
            ddlQueries.add("ALTER TABLE WF_ACTIONS DROP COLUMN error_message");
            ddlQueries.add("ALTER TABLE WF_ACTIONS RENAME COLUMN error_message_temp TO error_message");
            ddlQueries.add("ALTER TABLE COORD_JOBS ADD (frequency_temp VARCHAR2(255))");
            ddlQueries.add("UPDATE COORD_JOBS SET frequency_temp = CAST(frequency AS VARCHAR(255))");
            ddlQueries.add("ALTER TABLE COORD_JOBS DROP COLUMN frequency");
            ddlQueries.add("ALTER TABLE COORD_JOBS RENAME COLUMN frequency_temp TO frequency");
        } else if (dbVendor.equals("mysql")) {
            ddlQueries.add("ALTER TABLE WF_ACTIONS MODIFY execution_path VARCHAR(1024)");
            ddlQueries.add("ALTER TABLE WF_ACTIONS ADD COLUMN error_message_temp VARCHAR(500)");
            ddlQueries.add("UPDATE WF_ACTIONS SET error_message_temp = SUBSTR(error_message,1,500)");
            ddlQueries.add("ALTER TABLE WF_ACTIONS DROP COLUMN error_message");
            ddlQueries.add("ALTER TABLE WF_ACTIONS CHANGE error_message_temp error_message VARCHAR(500)");
            ddlQueries.add("ALTER TABLE COORD_JOBS MODIFY frequency VARCHAR(255)");
        } else if (dbVendor.equals("postgresql")) {
            ddlQueries.add("ALTER TABLE WF_ACTIONS ALTER COLUMN execution_path TYPE VARCHAR(1024)");
            ddlQueries.add("ALTER TABLE WF_ACTIONS ADD COLUMN error_message_temp VARCHAR(500)");
            ddlQueries.add("UPDATE WF_ACTIONS SET error_message_temp = SUBSTR(error_message,1,500)");
            ddlQueries.add("ALTER TABLE WF_ACTIONS DROP COLUMN error_message");
            ddlQueries.add("ALTER TABLE WF_ACTIONS RENAME error_message_temp TO error_message");
            ddlQueries.add("ALTER TABLE COORD_JOBS ALTER COLUMN frequency TYPE VARCHAR(255)");
        } else if (dbVendor.equals("sqlserver")) {
            ddlQueries.add("ALTER TABLE WF_ACTIONS ALTER COLUMN execution_path VARCHAR(1024)");
            ddlQueries.add("ALTER TABLE WF_ACTIONS ADD error_message_temp VARCHAR(500)");
            ddlQueries.add("UPDATE WF_ACTIONS SET error_message_temp = SUBSTRING(error_message,1,500)");
            ddlQueries.add("ALTER TABLE WF_ACTIONS DROP COLUMN error_message");
            ddlQueries.add("EXEC sp_rename 'WF_ACTIONS.error_message_temp', 'error_message', 'COLUMN'");
            ddlQueries.add("ALTER TABLE COORD_JOBS ALTER COLUMN frequency VARCHAR(255)");
        }
        Connection conn = run ? this.createConnection() : null;
        try {
            System.out.println("Table 'WF_ACTIONS' column 'execution_path', length changed to 1024");
            System.out.println("Table 'WF_ACTIONS, column 'error_message', changed to varchar/varchar2");
            System.out.println("Table 'COORD_JOB' column 'frequency' changed to varchar/varchar2");
            for (String query : ddlQueries) {
                writer.println(query + ";");
                if (!run) continue;
                conn.setAutoCommit(true);
                Statement st = conn.createStatement();
                st.executeUpdate(query);
                st.close();
            }
            System.out.println("DONE");
            System.out.println("Post-upgrade BUNDLE_JOBS, COORD_JOBS, WF_JOBS to drop AUTH_TOKEN column");
            for (String sql : DROP_AUTH_TOKEN_QUERIES) {
                writer.println(sql + ";");
                if (!run) continue;
                Statement st = conn.createStatement();
                st.executeUpdate(sql);
                st.close();
            }
            System.out.println("DONE");
            writer.close();
        }
        finally {
            if (run) {
                conn.close();
            }
        }
    }

    private Connection createConnection() throws Exception {
        Map<String, String> conf = this.getJdbcConf();
        Class.forName(conf.get("driver")).newInstance();
        return DriverManager.getConnection(conf.get("url"), conf.get("user"), conf.get("password"));
    }

    private void validateConnection() throws Exception {
        System.out.println("Validate DB Connection");
        try {
            this.createConnection().close();
            System.out.println("DONE");
        }
        catch (Exception ex) {
            throw new Exception("Could not connect to the database: " + ex.toString(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDBExists() throws Exception {
        boolean schemaExists;
        try (Connection conn = this.createConnection();){
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(WORKFLOW_STATUS_QUERY);
            rs.next();
            rs.close();
            st.close();
            schemaExists = true;
        }
        System.out.println("DB schema " + (schemaExists ? "exists" : "does not exist"));
        return schemaExists;
    }

    private boolean verifyOozieSysTable(boolean exists) throws Exception {
        return this.verifyOozieSysTable(exists, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyOozieSysTable(boolean exists, boolean throwException) throws Exception {
        boolean tableExists;
        System.out.println(exists ? "Check OOZIE_SYS table exists" : "Check OOZIE_SYS table does not exist");
        try (Connection conn = this.createConnection();){
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(OOZIE_SYS_EXISTS);
            rs.next();
            rs.close();
            st.close();
            tableExists = true;
        }
        if (throwException && tableExists != exists) {
            throw new Exception("OOZIE SYS table " + (exists ? "does not exist" : "exists"));
        }
        System.out.println("DONE");
        return tableExists;
    }

    private String getOozieDBVersion() throws Exception {
        String version;
        System.out.println("Get Oozie DB version");
        try (Connection conn = this.createConnection();){
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(GET_OOZIE_DB_VERSION);
            if (!rs.next()) {
                throw new Exception("ERROR: Could not find Oozie DB 'db.version' in OOZIE_SYS table");
            }
            version = rs.getString(1);
            rs.close();
            st.close();
        }
        System.out.println("DONE");
        return version;
    }

    private void createOozieSysTable(String sqlFile, boolean run, String version) throws Exception {
        String insertDbVerion = "insert into OOZIE_SYS (name, data) values ('db.version', '" + version + "')";
        boolean createIndex = this.getDBVendor().equals("sqlserver");
        PrintWriter writer = new PrintWriter(new FileWriter(sqlFile, true));
        writer.println();
        writer.println(CREATE_OOZIE_SYS);
        if (createIndex) {
            writer.println(CREATE_OOZIE_SYS_INDEX);
        }
        writer.println(insertDbVerion);
        writer.println(SET_OOZIE_VERSION);
        writer.close();
        System.out.println("Create OOZIE_SYS table");
        if (run) {
            try (Connection conn = null;){
                conn = this.createConnection();
                conn.setAutoCommit(true);
                Statement st = conn.createStatement();
                st.executeUpdate(CREATE_OOZIE_SYS);
                if (createIndex) {
                    st.executeUpdate(CREATE_OOZIE_SYS_INDEX);
                }
                st.executeUpdate(insertDbVerion);
                st.executeUpdate(SET_OOZIE_VERSION);
                st.close();
            }
        }
        System.out.println("DONE");
    }

    private void showOozieSysInfo() throws Exception {
        try (Connection conn = this.createConnection();){
            System.out.println();
            System.out.println("Oozie DB Version Information");
            System.out.println("--------------------------------------");
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(GET_OOZIE_SYS_INFO);
            while (rs.next()) {
                System.out.println(rs.getString(1) + ": " + rs.getString(2));
            }
            System.out.println("--------------------------------------");
            System.out.println();
            rs.close();
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyDBState() throws Exception {
        System.out.println("Verify there are not active Workflow Jobs");
        try (Connection conn = this.createConnection();){
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(WORKFLOW_STATUS_QUERY);
            rs.next();
            long activeWorkflows = rs.getLong(1);
            rs.close();
            st.close();
            if (activeWorkflows > 0L) {
                throw new Exception("There are [" + activeWorkflows + "] workflows in RUNNING/SUSPENDED state, they must complete or be killed");
            }
            System.out.println("DONE");
        }
    }

    private String[] createMappingToolArguments(String sqlFile) throws Exception {
        Map<String, String> conf = this.getJdbcConf();
        ArrayList<String> args = new ArrayList<String>();
        args.add("-schemaAction");
        args.add("add");
        args.add("-p");
        args.add("persistence.xml#oozie-" + conf.get("dbtype"));
        args.add("-connectionDriverName");
        args.add(conf.get("driver"));
        args.add("-connectionURL");
        args.add(conf.get("url"));
        args.add("-connectionUserName");
        args.add(conf.get("user"));
        args.add("-connectionPassword");
        args.add(conf.get("password"));
        if (sqlFile != null) {
            args.add("-sqlFile");
            args.add(sqlFile);
        }
        args.add("-indexes");
        args.add("true");
        args.add("org.apache.oozie.WorkflowJobBean");
        args.add("org.apache.oozie.WorkflowActionBean");
        args.add("org.apache.oozie.CoordinatorJobBean");
        args.add("org.apache.oozie.CoordinatorActionBean");
        args.add("org.apache.oozie.client.rest.JsonSLAEvent");
        args.add("org.apache.oozie.SLAEventBean");
        args.add("org.apache.oozie.sla.SLARegistrationBean");
        args.add("org.apache.oozie.BundleJobBean");
        args.add("org.apache.oozie.BundleActionBean");
        args.add("org.apache.oozie.sla.SLASummaryBean");
        args.add("org.apache.oozie.util.db.ValidateConnectionBean");
        return args.toArray(new String[args.size()]);
    }

    private void createUpgradeDB(String sqlFile, boolean run, boolean create) throws Exception {
        System.out.println(create ? "Create SQL schema" : "Upgrade SQL schema");
        String[] args = this.createMappingToolArguments(sqlFile);
        MappingTool.main((String[])args);
        if (run) {
            args = this.createMappingToolArguments(null);
            MappingTool.main((String[])args);
        }
        System.out.println("DONE");
    }

    private void showVersion() throws Exception {
        System.out.println("Oozie DB tool version: " + BuildInfo.getBuildInfo().getProperty("build.version"));
        System.out.println();
        this.validateConnection();
        if (!this.checkDBExists()) {
            throw new Exception("Oozie DB doesn't exist");
        }
        try {
            this.verifyOozieSysTable(true);
        }
        catch (Exception ex) {
            throw new Exception("ERROR: It seems this Oozie DB was never upgraded with the 'ooziedb' tool");
        }
        this.showOozieSysInfo();
    }
}

