/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.db;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.db.Schema;

public abstract class SqlStatement {
    private static XLog log = new XLog(LogFactory.getLog(SqlStatement.class));
    protected boolean forUpdate = false;
    protected StringBuilder sb = new StringBuilder("");
    protected List<Object> values = new ArrayList<Object>();

    public static Condition isNull(Schema.Column column) {
        return new Null(false, column);
    }

    public static Condition isNotNull(Schema.Column column) {
        return new Null(true, column);
    }

    public static Condition isLike(Schema.Column column, String value) {
        return new Like(false, column, value);
    }

    public static Condition isNotLike(Schema.Column column, String value) {
        return new Like(true, column, value);
    }

    public static Condition isEqual(Schema.Column column, Object value) {
        return new Compare(" = ", column, value);
    }

    public static Condition isNotEqual(Schema.Column column, Object value) {
        return new Compare(" <> ", column, value);
    }

    public static Condition lessThan(Schema.Column column, Object value) {
        return new Compare(" < ", column, value);
    }

    public static Condition greaterThan(Schema.Column column, Object value) {
        return new Compare(" > ", column, value);
    }

    public static Condition lessThanOrEqual(Schema.Column column, Object value) {
        return new Compare(" <= ", column, value);
    }

    public static Condition greaterThanOrEqual(Schema.Column column, Object value) {
        return new Compare(" >= ", column, value);
    }

    public static Condition in(Schema.Column column, Object ... values) {
        return new In(false, column, values);
    }

    public static Condition notIn(Schema.Column column, Object ... values) {
        return new In(true, column, values);
    }

    public static Condition in(Schema.Column column, Select select) {
        return new In(false, column, select);
    }

    public static Condition notIn(Schema.Column column, Select select) {
        return new In(true, column, select);
    }

    public static Condition between(Schema.Column column, Object lVal, Object rVal) {
        return new Between(false, column, lVal, rVal);
    }

    public static Condition notBetween(Schema.Column column, Object lVal, Object rVal) {
        return new Between(true, column, lVal, rVal);
    }

    public static Condition and(Condition ... conds) {
        Condition retVal = new Condition(null);
        if (conds.length >= 2) {
            for (int i = 0; i < conds.length; ++i) {
                if (i > 0) {
                    retVal.sb.append(" AND ");
                }
                retVal.sb.append((CharSequence)conds[i].sb);
                retVal.values.addAll(conds[i].values);
            }
        } else if (conds.length == 1) {
            return conds[0];
        }
        retVal.sb.append(" )");
        return retVal;
    }

    public static Condition or(Condition ... conds) {
        Condition retVal = new Condition(null);
        if (conds.length >= 2) {
            for (int i = 0; i < conds.length; ++i) {
                if (i > 0) {
                    retVal.sb.append(" OR ");
                }
                retVal.sb.append((CharSequence)conds[i].sb);
                retVal.values.addAll(conds[i].values);
            }
        } else if (conds.length == 1) {
            return conds[0];
        }
        retVal.sb.append(" )");
        return retVal;
    }

    public PreparedStatement prepareAndSetValues(Connection conn) throws SQLException {
        String stmt = this.toString();
        if (this.forUpdate && !Schema.isHsqlConnection(conn)) {
            stmt = stmt + " FOR UPDATE";
        }
        PreparedStatement pStmt = conn.prepareStatement(stmt);
        int i = 1;
        for (Object value : this.values) {
            pStmt.setObject(i, value);
            ++i;
        }
        log.trace(XLog.Info.get().createPrefix() + " Preparing : " + stmt);
        log.trace(XLog.Info.get().createPrefix() + " Values : " + this.values);
        return pStmt;
    }

    public PreparedStatement prepare(PreparedStatement pStmt) throws SQLException {
        int i = 1;
        pStmt.clearParameters();
        for (Object value : this.values) {
            pStmt.setObject(i, value);
            ++i;
        }
        return pStmt;
    }

    public PreparedStatement prepare(Connection conn) throws SQLException {
        String stmt = this.toString();
        if (this.forUpdate && !Schema.isHsqlConnection(conn)) {
            stmt = stmt + " FOR UPDATE";
        }
        return conn.prepareStatement(stmt);
    }

    public PreparedStatement prepareForBatch(Connection conn, List<? extends Map<Object, Object>> values, PreparedStatement pStmt) throws SQLException {
        String stmt = this.toString();
        if (this.forUpdate && !Schema.isHsqlConnection(conn)) {
            stmt = stmt + " FOR UPDATE";
        }
        for (Map<Object, Object> map : values) {
            this.getNewStatementWithValues(map).prepare(pStmt);
            pStmt.addBatch();
        }
        return pStmt;
    }

    public SqlStatement setValue(Object oldVal, Object newVal) {
        ArrayList<Object> temp = new ArrayList<Object>(this.values);
        if (this.values.contains(oldVal)) {
            int i = temp.indexOf(oldVal);
            temp.set(i, newVal);
        }
        SqlStatement retVal = this.create(temp);
        return retVal;
    }

    public SqlStatement getNewStatementWithValues(Map<Object, Object> newValues) {
        ArrayList<Object> temp = new ArrayList<Object>();
        for (Object value : this.values) {
            if (newValues.containsKey(value)) {
                temp.add(newValues.get(value));
                continue;
            }
            temp.add(value);
        }
        SqlStatement retVal = this.create(temp);
        return retVal;
    }

    private SqlStatement create(ArrayList<Object> temp) {
        SqlStatement retVal = null;
        if (this instanceof Select) {
            retVal = new Select((Select)this);
        } else if (this instanceof Insert) {
            retVal = new Insert((Insert)this);
        } else if (this instanceof Update) {
            retVal = new Update((Update)this);
        } else if (this instanceof Delete) {
            retVal = new Delete((Delete)this);
        }
        retVal.values.clear();
        retVal.values.addAll(temp);
        return retVal;
    }

    public static ResultSetReader parse(ResultSet rSet) {
        return new ResultSetReader(rSet);
    }

    public static Insert insertInto(Schema.Table table) {
        return new Insert(table);
    }

    public static Update update(Schema.Table table) {
        return new Update(table);
    }

    public static Delete deleteFrom(Schema.Table table) {
        return new Delete(table);
    }

    public static Select selectAllFrom(Schema.Table ... tables) {
        return new Select(false, tables);
    }

    public static Select selectColumns(Schema.Column ... columns) {
        return new Select(columns);
    }

    public static Select getCount(Schema.Table ... tables) {
        return new Select(true, tables);
    }

    public static class Insert
    extends SqlStatement {
        StringBuilder sbCol = new StringBuilder("");
        StringBuilder sbVal = new StringBuilder("");
        boolean isFirst = true;
        final Schema.Table table;

        Insert(Schema.Table table) {
            this.table = table;
            this.sbCol.append("INSERT INTO " + table + " ( )");
            this.sbVal.append("VALUES ( )");
        }

        private Insert(Insert other) {
            this.table = other.table;
            this.sbCol.append((CharSequence)other.sbCol);
            this.sbVal.append((CharSequence)other.sbVal);
            this.values.addAll(other.values);
            if (other.isFirst) {
                this.isFirst = false;
            }
        }

        public Insert value(Schema.Column column, Object value) {
            Insert retVal = new Insert(this);
            retVal.sbCol.setLength(retVal.sbCol.length() - 1);
            retVal.sbVal.setLength(retVal.sbVal.length() - 1);
            retVal.values.add(value);
            retVal.sbCol.append((this.isFirst ? "" : ", ") + column + " )");
            retVal.sbVal.append((this.isFirst ? "" : ", ") + "? )");
            retVal.isFirst = false;
            return retVal;
        }

        public String toString() {
            return this.sbCol.toString() + " " + this.sbVal.toString();
        }
    }

    public static class Update
    extends SqlStatement {
        Condition condition;
        final Schema.Table table;

        Update(Schema.Table table) {
            this.table = table;
            this.sb.append("UPDATE " + table + " SET ");
        }

        private Update(Update other) {
            this.table = other.table;
            this.condition = other.condition;
            this.sb.append((CharSequence)other.sb);
            this.values.addAll(other.values);
        }

        public Update set(Schema.Column column, Object value) {
            Update retVal = new Update(this);
            retVal.sb.append((this.values.isEmpty() ? "" : ", ") + column + " = ? ");
            retVal.values.add(value);
            return retVal;
        }

        public Update where(Condition condition) {
            Update retVal = new Update(this);
            retVal.condition = condition;
            retVal.values.addAll(condition.values);
            return retVal;
        }

        public String toString() {
            return this.sb.toString() + (this.condition != null ? " WHERE " + this.condition.toString() : "");
        }
    }

    public static class Delete
    extends SqlStatement {
        Condition condition;
        final Schema.Table table;

        Delete(Schema.Table table) {
            this.table = table;
            this.sb.append("DELETE FROM " + table + " ");
        }

        private Delete(Delete other) {
            this.table = other.table;
            this.condition = other.condition;
            this.sb.append((CharSequence)other.sb);
            this.values.addAll(other.values);
        }

        public Delete where(Condition condition) {
            Delete retVal = new Delete(this);
            retVal.condition = condition;
            retVal.values.addAll(condition.values);
            return retVal;
        }

        public String toString() {
            return this.sb.toString() + (this.condition != null ? "WHERE " + this.condition.toString() : "");
        }
    }

    public static class Select
    extends SqlStatement {
        private Condition condition;
        private boolean isOdered = false;
        private Schema.Column[] orderby = null;
        private boolean[] isAscending = null;
        private boolean isLimitSet = false;

        private Select(Select other) {
            this.condition = other.condition;
            this.sb.append((CharSequence)other.sb);
            this.values.addAll(other.values);
            this.isOdered = other.isOdered;
            this.isLimitSet = other.isLimitSet;
            this.orderby = other.orderby;
            this.isAscending = other.isAscending;
            this.forUpdate = other.forUpdate;
        }

        Select(boolean count, Schema.Table ... tables) {
            String temp = count ? "COUNT(*)" : "*";
            this.sb.append("SELECT " + temp + " FROM");
            if (tables != null && tables.length > 0) {
                for (Schema.Table table : tables) {
                    this.sb.append(" " + table + " ,");
                }
            } else {
                throw new RuntimeException("Need atleast 1 Table !!");
            }
            this.sb.setLength(this.sb.length() - 1);
        }

        Select(Schema.Column ... columns) {
            this.sb.append("SELECT");
            if (columns != null && columns.length > 0) {
                HashSet<Schema.Table> tables = new HashSet<Schema.Table>();
                for (Schema.Column column : columns) {
                    tables.add(column.table());
                    this.sb.append(" " + column + " AS " + column.asLabel() + " ,");
                }
                this.sb.setLength(this.sb.length() - 1);
                this.sb.append(" FROM");
                for (Schema.Table table : tables) {
                    this.sb.append(" " + table + " ,");
                }
            } else {
                throw new RuntimeException("Need atleast 1 Column !!");
            }
            this.sb.setLength(this.sb.length() - 1);
        }

        public Select where(Condition condition) {
            Select retVal = new Select(this);
            retVal.condition = condition;
            retVal.values.addAll(condition.values);
            return retVal;
        }

        public Select orderBy(Schema.Column column, boolean order) {
            if (!this.isOdered) {
                Select retVal = new Select(this);
                retVal.orderby = new Schema.Column[]{column};
                retVal.isAscending = new boolean[]{order};
                retVal.isOdered = true;
                return retVal;
            }
            return this;
        }

        public Select orderBy(Schema.Column column0, boolean order0, Schema.Column column1, boolean order1) {
            if (!this.isOdered) {
                Select retVal = new Select(this);
                retVal.orderby = new Schema.Column[]{column0, column1};
                retVal.isAscending = new boolean[]{order0, order1};
                retVal.isOdered = true;
                return retVal;
            }
            return this;
        }

        public Select limit(int offset, int limit) {
            if (this.isOdered) {
                Select retVal = new Select(this);
                retVal.values.add(limit);
                retVal.values.add(offset);
                retVal.isLimitSet = true;
                return retVal;
            }
            return this;
        }

        public Select forUpdate() {
            Select retVal = new Select(this);
            retVal.forUpdate = true;
            return retVal;
        }

        public String toString() {
            String oBy = "";
            if (this.orderby != null && this.isAscending != null && this.orderby.length == this.isAscending.length) {
                StringBuffer osb = new StringBuffer(" ORDER BY ");
                int i = 0;
                for (Schema.Column column : this.orderby) {
                    osb.append(column.asLabel()).append(this.isAscending[i] ? " ASC ," : " DESC ,");
                }
                osb.setLength(osb.length() - 1);
                if (this.isLimitSet) {
                    osb.append("LIMIT ").append("?").append(" OFFSET ").append("?").append(" ");
                }
                oBy = osb.toString();
            }
            return this.sb.toString() + (this.condition != null ? "WHERE " + this.condition.toString() : "") + oBy;
        }
    }

    static class Between
    extends Condition {
        Between(boolean isInvert, Schema.Column column, Object lVal, Object rVal) {
            super(column);
            this.sb.append(isInvert ? " NOT" : "").append(" BETWEEN ");
            this.sb.append(" ? ");
            this.values.add(lVal);
            this.sb.append(" AND ");
            this.sb.append(" ? ").append(" )");
            this.values.add(rVal);
        }
    }

    static class In
    extends Condition {
        In(boolean isInvert, Schema.Column column, Object ... values) {
            super(column);
            this.sb.append(isInvert ? " NOT" : "").append(" IN (");
            for (Object value : values) {
                this.sb.append(" ? ").append(",");
                this.values.add(value);
            }
            this.sb.setLength(this.sb.length() - 1);
            this.sb.append(") )");
        }

        In(boolean isInvert, Schema.Column column, Select select) {
            super(column);
            this.sb.append(isInvert ? " NOT" : "").append(" IN (");
            for (Object value : select.values) {
                this.values.add(value);
            }
            this.sb.append(select.toString());
            this.sb.append(") )");
        }
    }

    static class Compare
    extends Condition {
        Compare(String oper, Schema.Column column, Object value) {
            super(column);
            if (value instanceof Schema.Column) {
                this.sb.append(oper).append(value).append(" )");
            } else {
                this.sb.append(oper).append("?").append(" )");
                this.values.add(value);
            }
        }
    }

    static class Like
    extends Condition {
        Like(boolean isInvert, Schema.Column column, String value) {
            super(column);
            this.sb.append(isInvert ? " NOT" : "").append(" LIKE ").append("?").append(" )");
            this.values.add(value);
        }
    }

    static class Null
    extends Condition {
        Null(boolean isInvert, Schema.Column column) {
            super(column);
            this.sb.append(" IS");
            this.sb.append(isInvert ? " NOT" : "");
            this.sb.append(" NULL ");
            this.sb.append(" )");
        }
    }

    public static class Condition {
        final Schema.Column column;
        protected StringBuilder sb = new StringBuilder("( ");
        protected List<Object> values = new ArrayList<Object>();

        private Condition(Schema.Column column) {
            this.column = column;
            if (column != null) {
                this.sb.append(column);
            }
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    public static class ResultSetReader {
        final ResultSet rSet;

        private ResultSetReader(ResultSet rSet) {
            this.rSet = rSet;
        }

        public boolean next() throws SQLException {
            return this.rSet.next();
        }

        public void close() throws SQLException {
            this.rSet.close();
        }

        public <T> T get(Class<T> clazz, Schema.Column col) throws SQLException {
            if (clazz.isAssignableFrom(col.getType())) {
                return (T)this.rSet.getObject(col.asLabel());
            }
            if (String.class.equals(clazz)) {
                return (T)("" + this.rSet.getObject(col.asLabel()));
            }
            throw new RuntimeException("Column Error : Actual Type [" + col.getType() + "], Requested Type [" + clazz + "] !!");
        }

        public byte[] getByteArray(Schema.Column col) throws SQLException {
            ByteArrayOutputStream baos;
            byte[] bArray = null;
            if (Blob.class.equals(col.getType())) {
                BufferedInputStream bStream = new BufferedInputStream(this.rSet.getBinaryStream(col.asLabel()));
                byte[] temp = new byte[1024];
                int num = 0;
                baos = new ByteArrayOutputStream();
                BufferedOutputStream bOut = new BufferedOutputStream(baos);
                try {
                    while ((num = bStream.read(temp)) != -1) {
                        bOut.write(temp, 0, num);
                    }
                    bOut.flush();
                    bOut.close();
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
            } else {
                throw new RuntimeException("Column Error : Actual Type [" + col.getType() + "], Requested Type [" + Blob.class + "] !!");
            }
            bArray = baos.toByteArray();
            return bArray;
        }

        public String getString(Schema.Column col) throws SQLException {
            return this.get(String.class, col);
        }

        public Timestamp getTimestamp(Schema.Column col) throws SQLException {
            return this.get(Timestamp.class, col);
        }

        public Boolean getBoolean(Schema.Column col) throws SQLException {
            return this.get(Boolean.class, col);
        }

        public Long getLong(Schema.Column col) throws SQLException {
            return this.get(Long.class, col);
        }
    }
}

