/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.db;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class Schema {
    public static String getDbDataType(Column column, DBType dbType) {
        String retVal = null;
        if (String.class.equals(column.getType())) {
            retVal = column.getLength() < 0 ? (dbType.equals((Object)DBType.HSQL) ? "VARCHAR" : (dbType.equals((Object)DBType.ORACLE) ? "CLOB" : "TEXT")) : (dbType.equals((Object)DBType.ORACLE) ? "VARCHAR2(" + column.getLength() + ")" : "VARCHAR(" + column.getLength() + ")");
        } else if (Timestamp.class.equals(column.getType())) {
            retVal = dbType.equals((Object)DBType.ORACLE) ? "DATE" : "DATETIME";
        } else if (Boolean.class.equals(column.getType())) {
            retVal = dbType.equals((Object)DBType.ORACLE) ? "NUMBER(3, 0)" : "BOOLEAN";
        } else if (Long.class.equals(column.getType())) {
            retVal = dbType.equals((Object)DBType.ORACLE) ? "NUMBER (19,0)" : "BIGINT";
        } else if (Blob.class.equals(column.getType())) {
            retVal = dbType.equals((Object)DBType.MySQL) ? "MEDIUMBLOB" : (dbType.equals((Object)DBType.ORACLE) ? "BLOB" : "LONGVARBINARY");
        } else {
            throw new RuntimeException("Column Type[" + column.getType() + "] not mapped to any DB Data Type !!");
        }
        return retVal;
    }

    public static String generateCreateTableScript(Table table, DBType dbType, List<Column> tableColumns) {
        StringBuilder sb = new StringBuilder("CREATE TABLE ").append(table).append(" ( ");
        StringBuilder pk = new StringBuilder(", PRIMARY KEY ( ");
        boolean pkFlag = false;
        String sep = "";
        String psep = "";
        for (Column column : tableColumns) {
            sb.append(sep).append(column.columnName() + " ").append(Schema.getDbDataType(column, dbType));
            if (column.isPrimaryKey()) {
                pkFlag = true;
                pk.append(psep).append(column.columnName());
                psep = ", ";
            }
            sep = ", ";
        }
        if (pkFlag) {
            pk.append(" )");
            sb.append(pk.toString());
        }
        sb.append(" )");
        if (dbType == DBType.MySQL) {
            sb.append(" ENGINE=InnoDB");
        }
        return sb.toString();
    }

    public static String generateDropTableScript(Table table, DBType dbType) {
        StringBuilder sb = new StringBuilder("DROP TABLE ").append(table);
        if (dbType == DBType.ORACLE) {
            sb.append(" purge");
        }
        return sb.toString();
    }

    public static String generateCreateIndexScript(Index index, DBType dbType) {
        StringBuilder sb = new StringBuilder("CREATE INDEX ").append(index).append(" ON ").append(index.column().table()).append("( " + index.column().columnName() + " )");
        return sb.toString();
    }

    public static boolean isHsqlConnection(Connection conn) throws SQLException {
        return conn.getMetaData().getDriverName().toLowerCase().contains(DBType.HSQL.name().toLowerCase());
    }

    public static boolean isMySqlConnection(Connection conn) throws SQLException {
        return conn.getMetaData().getDriverName().toLowerCase().contains(DBType.MySQL.name().toLowerCase());
    }

    public static enum DBType {
        HSQL,
        MySQL,
        ORACLE;

    }

    public static interface Index {
        public Column column();
    }

    public static interface Column {
        public Table table();

        public String asLabel();

        public String columnName();

        public Class<?> getType();

        public int getLength();

        public boolean isPrimaryKey();
    }

    public static interface Table {
        public String name();
    }
}

