/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.service.SchemaService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static SAXBuilder createSAXBuilder() {
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setEntityResolver((EntityResolver)new NoExternalEntityEntityResolver());
        return saxBuilder;
    }

    public static String removeComments(String xmlStr) throws JDOMException {
        if (xmlStr == null) {
            return null;
        }
        try {
            SAXBuilder saxBuilder = XmlUtils.createSAXBuilder();
            Document document = saxBuilder.build((Reader)new StringReader(xmlStr));
            XmlUtils.removeComments(document);
            return XmlUtils.prettyPrint(document.getRootElement()).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException("It should not happen, " + ex.getMessage(), ex);
        }
    }

    private static void removeComments(List l) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Object node = i.next();
            if (node instanceof Comment) {
                i.remove();
                continue;
            }
            if (!(node instanceof org.jdom.Element)) continue;
            XmlUtils.removeComments(((org.jdom.Element)node).getContent());
        }
    }

    private static void removeComments(Document doc) {
        XmlUtils.removeComments(doc.getContent());
    }

    public static org.jdom.Element parseXml(String xmlStr) throws JDOMException {
        ParamChecker.notNull(xmlStr, "xmlStr");
        try {
            SAXBuilder saxBuilder = XmlUtils.createSAXBuilder();
            Document document = saxBuilder.build((Reader)new StringReader(xmlStr));
            return document.getRootElement();
        }
        catch (IOException ex) {
            throw new RuntimeException("It should not happen, " + ex.getMessage(), ex);
        }
    }

    public static org.jdom.Element parseXml(InputStream is) throws JDOMException, IOException {
        ParamChecker.notNull(is, "is");
        SAXBuilder saxBuilder = XmlUtils.createSAXBuilder();
        Document document = saxBuilder.build(is);
        return document.getRootElement();
    }

    public static String getRootAttribute(String filePath, String attributeName) {
        ParamChecker.notNull(filePath, "filePath");
        ParamChecker.notNull(attributeName, "attributeName");
        SAXBuilder saxBuilder = XmlUtils.createSAXBuilder();
        try {
            Document doc = saxBuilder.build(Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath));
            return doc.getRootElement().getAttributeValue(attributeName);
        }
        catch (JDOMException e) {
            throw new RuntimeException();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public static PrettyPrint prettyPrint(org.jdom.Element element) {
        return new PrettyPrint(element);
    }

    public static PrettyPrint prettyPrint(String xmlStr) {
        try {
            return new PrettyPrint(XmlUtils.parseXml(xmlStr));
        }
        catch (Exception e) {
            return new PrettyPrint(xmlStr);
        }
    }

    public static PrettyPrint prettyPrint(Configuration conf) {
        org.jdom.Element root = new org.jdom.Element("configuration");
        for (Map.Entry entry : conf) {
            org.jdom.Element property = new org.jdom.Element("property");
            org.jdom.Element name = new org.jdom.Element("name");
            name.setText((String)entry.getKey());
            org.jdom.Element value = new org.jdom.Element("value");
            value.setText((String)entry.getValue());
            property.addContent((Content)name);
            property.addContent((Content)value);
            root.addContent((Content)property);
        }
        return new PrettyPrint(root);
    }

    public static void validateXml(Schema schema, String xml) throws SAXException, IOException {
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(new ByteArrayInputStream(xml.getBytes())));
    }

    public static Schema createSchema(InputStream is) {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource src = new StreamSource(is);
        try {
            return factory.newSchema(src);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void validateData(String xmlData, SchemaService.SchemaName xsdFile) throws SAXException, IOException {
        if (xmlData == null || xmlData.length() == 0) {
            return;
        }
        Schema schema = Services.get().get(SchemaService.class).getSchema(xsdFile);
        XmlUtils.validateXml(schema, xmlData);
    }

    public static String writePropToString(Properties props) throws IOException {
        try {
            org.w3c.dom.Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element conf = doc.createElement("configuration");
            doc.appendChild(conf);
            conf.appendChild(doc.createTextNode("\n"));
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object object = props.get(name);
                if (!(object instanceof String)) continue;
                String value = (String)object;
                Element propNode = doc.createElement("property");
                conf.appendChild(propNode);
                Element nameNode = doc.createElement("name");
                nameNode.appendChild(doc.createTextNode(name.trim()));
                propNode.appendChild(nameNode);
                Element valueNode = doc.createElement("value");
                valueNode.appendChild(doc.createTextNode(value.trim()));
                propNode.appendChild(valueNode);
                conf.appendChild(doc.createTextNode("\n"));
            }
            DOMSource source = new DOMSource(doc);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static String escapeCharsForXML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static org.jdom.Element getSLAElement(org.jdom.Element elem) {
        org.jdom.Element eSla_1 = elem.getChild("info", Namespace.getNamespace((String)"uri:oozie:sla:0.1"));
        org.jdom.Element eSla_2 = elem.getChild("info", Namespace.getNamespace((String)"uri:oozie:sla:0.2"));
        org.jdom.Element eSla = eSla_2 != null ? eSla_2 : eSla_1;
        return eSla;
    }

    public static class PrettyPrint {
        private String str;
        private org.jdom.Element element;

        private PrettyPrint(String str) {
            this.str = str;
        }

        private PrettyPrint(org.jdom.Element element) {
            this.element = ParamChecker.notNull(element, "element");
        }

        public String toString() {
            if (this.str != null) {
                return this.str;
            }
            XMLOutputter outputter = new XMLOutputter();
            StringWriter stringWriter = new StringWriter();
            outputter.setFormat(Format.getPrettyFormat());
            try {
                outputter.output(this.element, (Writer)stringWriter);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return stringWriter.toString();
        }
    }

    private static class NoExternalEntityEntityResolver
    implements EntityResolver {
        private NoExternalEntityEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

