/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogStreamingService;
import org.apache.oozie.util.XLogFilter;

public class TimestampedMessageParser {
    static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    protected BufferedReader reader;
    private String nextLine = null;
    private String lastTimestamp = null;
    private XLogFilter filter;
    private boolean empty = false;
    private String lastMessage = null;
    private boolean patternMatched = false;
    public int count = 0;

    public TimestampedMessageParser(BufferedReader reader, XLogFilter filter) {
        this.reader = reader;
        this.filter = filter;
        if (filter == null) {
            filter = new XLogFilter();
        }
        filter.constructPattern();
    }

    public boolean increment() throws IOException {
        if (this.empty) {
            return false;
        }
        StringBuilder message = new StringBuilder();
        if (this.nextLine == null) {
            this.nextLine = this.parseNextLine();
            if (this.nextLine == null) {
                this.empty = true;
                return false;
            }
        }
        this.lastTimestamp = this.parseTimestamp(this.nextLine);
        String nextTimestamp = null;
        while (nextTimestamp == null) {
            message.append(this.nextLine).append(SYSTEM_LINE_SEPARATOR);
            this.nextLine = this.parseNextLine();
            if (this.nextLine != null) {
                nextTimestamp = this.parseTimestamp(this.nextLine);
                continue;
            }
            this.empty = true;
            nextTimestamp = "";
        }
        this.lastMessage = message.toString();
        return true;
    }

    public String getLastTimestamp() {
        return this.lastTimestamp;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public void closeReader() throws IOException {
        this.reader.close();
    }

    protected String parseNextLine() throws IOException {
        String line;
        while ((line = this.reader.readLine()) != null) {
            ArrayList<String> logParts = this.filter.splitLogMessage(line);
            if (logParts != null) {
                this.patternMatched = this.filter.matches(logParts);
            }
            if (!this.patternMatched) continue;
            if (this.filter.getLogLimit() != -1 && logParts != null) {
                if (this.count >= this.filter.getLogLimit()) {
                    return null;
                }
                ++this.count;
            }
            if (logParts != null && this.filter.getEndDate() != null && logParts.get(0).substring(0, 19).compareTo(this.filter.getFormattedEndDate()) > 0) {
                return null;
            }
            return line;
        }
        return line;
    }

    private String parseTimestamp(String line) {
        String timestamp = null;
        ArrayList<String> logParts = this.filter.splitLogMessage(line);
        if (logParts != null) {
            timestamp = logParts.get(0);
        }
        return timestamp;
    }

    public void processRemaining(Writer writer, int bufferLen, int bytesWritten) throws IOException {
        while (this.increment()) {
            writer.write(this.lastMessage);
            if ((bytesWritten += this.lastMessage.length()) <= bufferLen) continue;
            writer.flush();
            bytesWritten = 0;
        }
        writer.flush();
    }

    public void processRemaining(Writer writer, int bufferLen) throws IOException {
        this.processRemaining(writer, bufferLen, 0);
    }

    public void processRemaining(Writer writer) throws IOException {
        this.processRemaining(writer, Services.get().get(XLogStreamingService.class).getBufferLen());
    }
}

