/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

class PasswordMasker {
    private static final String PASSWORD_MASK = "*****";
    private static final String PASSWORD_KEY = "pass";
    private static final String REGEX_CONTAINING_PASSWORD_FRAGMENT_OS_ENV_STYLE = ".*[((\\s)+-[D|X][\\w[.\\w]*]*(?i)pass[\\w[.\\w]*]*=)([\\w]+)]+.*";
    private static final String REGEX_EXTRACTING_PASSWORD_FRAGMENTS_OS_ENV_STYLE = "((\\s)+-[D|X][\\w[.\\w]*]*(?i)pass[\\w[.\\w]*]*=)([\\w]+)";
    private static final Pattern PATTERN_CONTAINING_PASSWORD_FRAGMENTS = Pattern.compile(".*[((\\s)+-[D|X][\\w[.\\w]*]*(?i)pass[\\w[.\\w]*]*=)([\\w]+)]+.*");
    private static final Pattern PATTERN_EXTRACTING_PASSWORD_FRAGMENTS = Pattern.compile("((\\s)+-[D|X][\\w[.\\w]*]*(?i)pass[\\w[.\\w]*]*=)([\\w]+)");

    PasswordMasker() {
    }

    Map<String, String> mask(Map<String, String> unmasked) {
        return Maps.transformEntries(unmasked, (Maps.EntryTransformer)new Maps.EntryTransformer<String, String, String>(){

            public String transformEntry(@Nullable String key, @Nullable String value) {
                Preconditions.checkNotNull((Object)key, (Object)"key has to be set");
                Preconditions.checkNotNull((Object)value, (Object)"value has to be set");
                if (PasswordMasker.this.isPasswordKey(key)) {
                    return PasswordMasker.PASSWORD_MASK;
                }
                if (PasswordMasker.this.containsPasswordFragment(value)) {
                    return PasswordMasker.this.maskPasswordFragments(value);
                }
                return value;
            }
        });
    }

    private boolean isPasswordKey(String key) {
        return key.toLowerCase().contains(PASSWORD_KEY);
    }

    private boolean containsPasswordFragment(String maybePasswordFragments) {
        return PATTERN_CONTAINING_PASSWORD_FRAGMENTS.matcher(maybePasswordFragments).matches();
    }

    private String maskPasswordFragments(String maybePasswordFragments) {
        StringBuilder maskedBuilder = new StringBuilder();
        Matcher passwordFragmentsMatcher = PATTERN_EXTRACTING_PASSWORD_FRAGMENTS.matcher(maybePasswordFragments);
        int start = 0;
        while (passwordFragmentsMatcher.find()) {
            int end = passwordFragmentsMatcher.start();
            maskedBuilder.append(maybePasswordFragments.substring(start, end));
            maskedBuilder.append(passwordFragmentsMatcher.group(1));
            maskedBuilder.append(PASSWORD_MASK);
            start = passwordFragmentsMatcher.end();
        }
        maskedBuilder.append(maybePasswordFragments.substring(start));
        return maskedBuilder.toString();
    }
}

