/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.ParameterVerifierException;
import org.apache.oozie.util.XLog;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class ParameterVerifier {
    private static final Pattern nsVersionPattern = Pattern.compile("uri:oozie:(workflow|coordinator|bundle):(\\d+.\\d+)");
    private static final double workflowMinVersion = 0.4;
    private static final double coordinatorMinVersion = 0.4;
    private static final double bundleMinVersion = 0.2;

    public static void verifyParameters(Configuration conf, Element rootElement) throws ParameterVerifierException {
        ParamChecker.notNull(conf, "conf");
        if (rootElement == null) {
            return;
        }
        if (ParameterVerifier.supportsParameters(rootElement.getNamespaceURI())) {
            Element params = rootElement.getChild("parameters", rootElement.getNamespace());
            if (params != null) {
                int numMissing = 0;
                StringBuilder missingParameters = new StringBuilder();
                Namespace paramsNs = params.getNamespace();
                for (Element prop : params.getChildren("property", paramsNs)) {
                    String name = prop.getChildTextTrim("name", paramsNs);
                    if (name == null) continue;
                    if (name.isEmpty()) {
                        throw new ParameterVerifierException(ErrorCode.E0739, new Object[0]);
                    }
                    if (conf.get(name) != null) continue;
                    String defaultValue = prop.getChildTextTrim("value", paramsNs);
                    if (defaultValue != null) {
                        conf.set(name, defaultValue);
                        continue;
                    }
                    missingParameters.append(name);
                    missingParameters.append(", ");
                    ++numMissing;
                }
                if (numMissing > 0) {
                    missingParameters.setLength(missingParameters.length() - 2);
                    throw new ParameterVerifierException(ErrorCode.E0738, numMissing, missingParameters.toString());
                }
            } else {
                XLog.getLog(ParameterVerifier.class).warn("The application does not define formal parameters in its XML definition");
            }
        }
    }

    static boolean supportsParameters(String namespaceURI) {
        boolean supports = false;
        Matcher m = nsVersionPattern.matcher(namespaceURI);
        if (m.matches() && m.groupCount() == 2) {
            String type = m.group(1);
            double ver = Double.parseDouble(m.group(2));
            supports = type.equals("workflow") && ver >= 0.4 || type.equals("coordinator") && ver >= 0.4 || type.equals("bundle") && ver >= 0.2;
        }
        return supports;
    }
}

