/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Appender;
import org.apache.log4j.pattern.ExtrasPatternParser;
import org.apache.log4j.pattern.LiteralPatternConverter;
import org.apache.log4j.rolling.RollingPolicyBase;
import org.apache.log4j.rolling.RolloverDescription;
import org.apache.log4j.rolling.TimeBasedRollingPolicy;
import org.apache.log4j.rolling.TriggeringPolicy;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;

public class OozieRollingPolicy
extends RollingPolicyBase
implements TriggeringPolicy {
    private TimeBasedRollingPolicy tbrp;
    private Semaphore deleteSem = new Semaphore(1);
    private Thread deleteThread = new Thread();
    private int maxHistory = 720;
    String oozieLogDir;
    String logFileName;

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public void setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
    }

    public OozieRollingPolicy() {
        this.tbrp = new TimeBasedRollingPolicy();
    }

    public void setFileNamePattern(String fnp) {
        super.setFileNamePattern(fnp);
        ArrayList converters = new ArrayList();
        StringBuffer file = new StringBuffer();
        ExtrasPatternParser.parse((String)fnp, converters, new ArrayList(), null, (Map)ExtrasPatternParser.getFileNamePatternRules());
        if (!converters.isEmpty()) {
            ((LiteralPatternConverter)converters.get(0)).format(null, file);
            File f = new File(file.toString());
            this.oozieLogDir = f.getParent();
            this.logFileName = f.getName();
        } else {
            XLogService xls = Services.get().get(XLogService.class);
            this.oozieLogDir = xls.getOozieLogPath();
            this.logFileName = xls.getOozieLogName();
        }
    }

    public void activateOptions() {
        super.activateOptions();
        this.tbrp.setFileNamePattern(this.getFileNamePattern());
        this.tbrp.activateOptions();
    }

    public RolloverDescription initialize(String file, boolean append) throws SecurityException {
        return this.tbrp.initialize(file, append);
    }

    public RolloverDescription rollover(String activeFile) throws SecurityException {
        return this.tbrp.rollover(activeFile);
    }

    public boolean isTriggeringEvent(Appender appender, LoggingEvent event, String filename, long fileLength) {
        if (this.maxHistory >= 0 && this.deleteSem.tryAcquire()) {
            if (!this.deleteThread.isAlive()) {
                this.deleteThread = new Thread(){

                    @Override
                    public void run() {
                        OozieRollingPolicy.this.deleteOldFiles();
                    }
                };
                this.deleteThread.start();
            }
            this.deleteSem.release();
        }
        return this.tbrp.isTriggeringEvent(appender, event, filename, fileLength);
    }

    private void deleteOldFiles() {
        String[] children;
        ArrayList<FileInfo> fileList = new ArrayList<FileInfo>();
        if (this.oozieLogDir != null && this.logFileName != null && (children = new File(this.oozieLogDir).list()) != null) {
            for (String child : children) {
                if (!child.startsWith(this.logFileName) || child.equals(this.logFileName)) continue;
                File childFile = new File(new File(this.oozieLogDir).getAbsolutePath(), child);
                if (child.endsWith(".gz")) {
                    long gzFileCreationTime = this.getGZFileCreationTime(child);
                    if (gzFileCreationTime == -1L) continue;
                    fileList.add(new FileInfo(childFile.getAbsolutePath(), gzFileCreationTime));
                    continue;
                }
                long modTime = childFile.lastModified();
                fileList.add(new FileInfo(childFile.getAbsolutePath(), modTime));
            }
        }
        if (fileList.size() > this.maxHistory) {
            Collections.sort(fileList);
            for (int i = this.maxHistory; i < fileList.size(); ++i) {
                new File(((FileInfo)fileList.get(i)).getFileName()).delete();
            }
        }
    }

    private long getGZFileCreationTime(String fileName) {
        String date = fileName.substring(this.logFileName.length(), fileName.length() - 3);
        SimpleDateFormat formatter = date.length() == 10 ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyy-MM-dd-HH");
        try {
            return formatter.parse(date).getTime();
        }
        catch (ParseException e) {
            return -1L;
        }
    }

    class FileInfo
    implements Comparable<FileInfo> {
        String fileName;
        long modTime;

        public FileInfo(String fileName, long modTime) {
            this.fileName = fileName;
            this.modTime = modTime;
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getModTime() {
            return this.modTime;
        }

        @Override
        public int compareTo(FileInfo fileInfo) {
            long diff = fileInfo.modTime - this.modTime;
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }
    }
}

