/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;

public class MultiFileReader
extends Reader {
    private ArrayList<File> files;
    private int index;
    private Reader reader;
    private boolean closed;

    public MultiFileReader(ArrayList<File> files) throws IOException {
        this.files = files;
        this.closed = false;
        this.index = 0;
        this.reader = null;
        this.openNextReader();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int numRead = -1;
        while (!this.closed && numRead == -1) {
            numRead = this.reader.read(cbuf, off, len);
            if (numRead != -1) continue;
            this.reader.close();
            this.openNextReader();
        }
        return numRead;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.closed = true;
    }

    private void openNextReader() throws IOException {
        if (this.index < this.files.size()) {
            if (this.files.get(this.index).getName().endsWith(".gz")) {
                GZIPInputStream gzipInputStream = new GZIPInputStream(new FileInputStream(this.files.get(this.index)));
                this.reader = new InputStreamReader(gzipInputStream);
            } else {
                this.reader = new FileReader(this.files.get(this.index));
            }
            ++this.index;
        } else {
            this.closed = true;
        }
    }
}

