/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.XLog;

public class JobsFilterUtils {
    private static final Set<String> FILTER_NAMES = new HashSet<String>();

    public static Map<String, List<String>> parseFilter(String filter) throws ServletException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (filter != null) {
            StringTokenizer st = new StringTokenizer(filter, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.contains("=")) {
                    ArrayList<String> list;
                    String[] pair = token.split("=");
                    if (pair.length != 2) {
                        throw new XServletException(400, ErrorCode.E0420, "filter elements must be semicolon-separated name=value pairs");
                    }
                    pair[0] = pair[0].toLowerCase();
                    if (!FILTER_NAMES.contains(pair[0])) {
                        throw new XServletException(400, ErrorCode.E0420, "filter name: " + pair[0] + " is invalid");
                    }
                    if (pair[0].equals("status")) {
                        try {
                            Job.Status.valueOf((String)pair[1]);
                        }
                        catch (IllegalArgumentException ex) {
                            throw new XServletException(400, ErrorCode.E0420, XLog.format("invalid status [{0}]", pair[1]));
                        }
                    }
                    if ((list = (ArrayList<String>)map.get(pair[0])) == null) {
                        list = new ArrayList<String>();
                        map.put(pair[0], list);
                    }
                    list.add(pair[1]);
                    continue;
                }
                throw new XServletException(400, ErrorCode.E0420, "filter elements must be semicolon-separated name=value pairs");
            }
        }
        return map;
    }

    static {
        FILTER_NAMES.add("user");
        FILTER_NAMES.add("name");
        FILTER_NAMES.add("group");
        FILTER_NAMES.add("status");
        FILTER_NAMES.add("id");
        FILTER_NAMES.add("sortby");
        FILTER_NAMES.add("startcreatedtime");
        FILTER_NAMES.add("endcreatedtime");
    }
}

