/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;

public class ClassUtils {
    public static String findContainingJar(Class clazz) {
        ClassLoader loader = clazz.getClassLoader();
        String class_file = clazz.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = loader.getResources(class_file);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

