/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla;

import java.text.ParseException;
import java.util.Date;
import org.apache.oozie.AppType;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.SLARegistrationQueryExecutor;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.service.SLAService;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class SLAOperations {
    public static final String NOMINAL_TIME = "nominal-time";
    public static final String SHOULD_START = "should-start";
    public static final String SHOULD_END = "should-end";
    public static final String MAX_DURATION = "max-duration";
    public static final String ALERT_EVENTS = "alert-events";
    public static final String ALL_VALUE = "ALL";
    public static XLog LOG = XLog.getLog(SLAOperations.class);

    public static SLARegistrationBean createSlaRegistrationEvent(Element eSla, String jobId, String parentId, AppType appType, String user, String appName, XLog log, boolean rerun, boolean disableAlert) throws CommandException {
        if (eSla == null || !SLAService.isEnabled()) {
            log.debug("Not registering SLA for job [{0}]. Sla-Xml null OR SLAService not enabled", jobId);
            return null;
        }
        SLARegistrationBean sla = new SLARegistrationBean();
        String strNominalTime = SLAOperations.getTagElement(eSla, NOMINAL_TIME);
        Date nominalTime = SLAOperations.setNominalTime(strNominalTime, sla);
        String strExpectedStart = SLAOperations.getTagElement(eSla, SHOULD_START);
        SLAOperations.setExpectedStart(strExpectedStart, nominalTime, sla);
        String strExpectedEnd = SLAOperations.getTagElement(eSla, SHOULD_END);
        SLAOperations.setExpectedEnd(strExpectedEnd, nominalTime, sla);
        String expectedDurationStr = SLAOperations.getTagElement(eSla, MAX_DURATION);
        SLAOperations.setExpectedDuration(expectedDurationStr, sla);
        String alertEvents = SLAOperations.getTagElement(eSla, ALERT_EVENTS);
        if (alertEvents != null) {
            String[] events = alertEvents.split(",");
            StringBuilder alertsStr = new StringBuilder();
            for (int i = 0; i < events.length; ++i) {
                String event = events[i].trim().toUpperCase();
                try {
                    SLAEvent.EventStatus.valueOf((String)event);
                }
                catch (IllegalArgumentException iae) {
                    XLog.getLog(SLAService.class).warn("Invalid value: [" + event + "] for SLA Alert-event. Should be one of " + SLAEvent.EventStatus.values() + ". Setting it to default [" + SLAEvent.EventStatus.END_MISS.name() + "]");
                    event = SLAEvent.EventStatus.END_MISS.name();
                }
                alertsStr.append(event).append(",");
            }
            sla.setAlertEvents(alertsStr.toString().substring(0, alertsStr.lastIndexOf(",")));
        }
        sla.setNotificationMsg(SLAOperations.getTagElement(eSla, "notification-msg"));
        sla.setAlertContact(SLAOperations.getTagElement(eSla, "alert-contact"));
        sla.setUpstreamApps(SLAOperations.getTagElement(eSla, "upstream-apps"));
        if (disableAlert) {
            sla.addToSLAConfigMap("oozie.sla.disable.alerts", Boolean.toString(disableAlert));
        }
        sla.setId(jobId);
        sla.setAppType(appType);
        sla.setAppName(appName);
        sla.setUser(user);
        sla.setParentId(parentId);
        SLAService slaService = Services.get().get(SLAService.class);
        try {
            if (!rerun) {
                slaService.addRegistrationEvent(sla);
            } else {
                slaService.updateRegistrationEvent(sla);
            }
        }
        catch (ServiceException e) {
            throw new CommandException(ErrorCode.E1007, " id " + jobId, e.getMessage(), e);
        }
        log.debug("Job [{0}] reg for SLA. Size of Sla Xml = [{1}]", jobId, XmlUtils.prettyPrint(eSla).toString().length());
        return sla;
    }

    public static Date setNominalTime(String strNominalTime, SLARegistrationBean sla) throws CommandException {
        Date nominalTime;
        if (strNominalTime == null || strNominalTime.length() == 0) {
            return sla.getNominalTime();
        }
        try {
            nominalTime = DateUtils.parseDateOozieTZ(strNominalTime);
            sla.setNominalTime(nominalTime);
        }
        catch (ParseException pex) {
            throw new CommandException(ErrorCode.E0302, strNominalTime, pex);
        }
        return nominalTime;
    }

    public static void setExpectedStart(String strExpectedStart, Date nominalTime, SLARegistrationBean sla) throws CommandException {
        if (strExpectedStart != null) {
            float expectedStart = Float.parseFloat(strExpectedStart);
            if (expectedStart < 0.0f) {
                throw new CommandException(ErrorCode.E0302, strExpectedStart, "for SLA Expected start time");
            }
            Date expectedStartTime = new Date(nominalTime.getTime() + (long)(expectedStart * 60.0f * 1000.0f));
            sla.setExpectedStart(expectedStartTime);
            LOG.debug("Setting expected start to " + expectedStartTime + " for job " + sla.getId());
        }
    }

    public static void setExpectedEnd(String strExpectedEnd, Date nominalTime, SLARegistrationBean sla) throws CommandException {
        if (strExpectedEnd != null) {
            float expectedEnd = Float.parseFloat(strExpectedEnd);
            if (expectedEnd < 0.0f) {
                throw new CommandException(ErrorCode.E0302, strExpectedEnd, "for SLA Expected end time");
            }
            Date expectedEndTime = new Date(nominalTime.getTime() + (long)(expectedEnd * 60.0f * 1000.0f));
            sla.setExpectedEnd(expectedEndTime);
            LOG.debug("Setting expected end to " + expectedEndTime + " for job " + sla.getId());
        }
    }

    public static void setExpectedDuration(String expectedDurationStr, SLARegistrationBean sla) {
        if (expectedDurationStr != null && expectedDurationStr.length() > 0) {
            float expectedDuration = Float.parseFloat(expectedDurationStr);
            if (expectedDuration > 0.0f) {
                long duration = (long)(expectedDuration * 60.0f * 1000.0f);
                LOG.debug("Setting expected duration to " + duration + " for job " + sla.getId());
                sla.setExpectedDuration(duration);
            }
        } else if (sla.getExpectedStart() != null) {
            long duration = sla.getExpectedEnd().getTime() - sla.getExpectedStart().getTime();
            LOG.debug("Setting expected duration to " + duration + " for job " + sla.getId());
            sla.setExpectedDuration(sla.getExpectedEnd().getTime() - sla.getExpectedStart().getTime());
        }
    }

    public static void updateRegistrationEvent(String jobId) throws CommandException, JPAExecutorException {
        SLAService slaService = Services.get().get(SLAService.class);
        try {
            SLARegistrationBean reg = SLARegistrationQueryExecutor.getInstance().get(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ALL, jobId);
            if (reg != null) {
                slaService.updateRegistrationEvent(reg);
            }
        }
        catch (ServiceException e) {
            throw new CommandException(ErrorCode.E1007, " id " + jobId, e.getMessage(), e);
        }
    }

    public static SLARegistrationBean createSlaRegistrationEvent(Element eSla, String jobId, AppType appType, String user, String appName, XLog log) throws CommandException {
        return SLAOperations.createSlaRegistrationEvent(eSla, jobId, null, appType, user, appName, log, false);
    }

    public static SLARegistrationBean createSlaRegistrationEvent(Element eSla, String jobId, String parentId, AppType appType, String user, XLog log) throws CommandException {
        return SLAOperations.createSlaRegistrationEvent(eSla, jobId, parentId, appType, user, null, log, false);
    }

    public static SLARegistrationBean createSlaRegistrationEvent(Element eSla, String jobId, AppType appType, String user, XLog log) throws CommandException {
        return SLAOperations.createSlaRegistrationEvent(eSla, jobId, null, appType, user, null, log, false);
    }

    public static SLARegistrationBean createSlaRegistrationEvent(Element eSla, String jobId, String parentId, AppType appType, String user, String appName, XLog log, boolean rerun) throws CommandException {
        return SLAOperations.createSlaRegistrationEvent(eSla, jobId, null, appType, user, appName, log, rerun, false);
    }

    public static String getTagElement(Element elem, String tagName) {
        if (elem != null && elem.getChild(tagName, elem.getNamespace("sla")) != null) {
            return elem.getChild(tagName, elem.getNamespace("sla")).getText().trim();
        }
        return null;
    }
}

