/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.BaseJobServlet;
import org.apache.oozie.servlet.XServletException;
import org.json.simple.JSONObject;

public class V0JobServlet
extends BaseJobServlet {
    private static final String INSTRUMENTATION_NAME = "v0job";

    public V0JobServlet() {
        super(INSTRUMENTATION_NAME);
    }

    @Override
    protected void startJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.start(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    @Override
    protected void resumeJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.resume(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    @Override
    protected void suspendJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.suspend(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    @Override
    protected JSONObject killJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.kill(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return null;
    }

    @Override
    protected void changeJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E1014, new Object[0]);
    }

    @Override
    protected JSONObject reRunJob(HttpServletRequest request, HttpServletResponse response, Configuration conf) throws XServletException, IOException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.reRun(jobId, conf);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return null;
    }

    @Override
    protected JsonBean getJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        JsonBean jobBean = null;
        String jobId = this.getResourceName(request);
        try {
            jobBean = (JsonBean)dagEngine.getJob(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return jobBean;
    }

    @Override
    protected String getJobDefinition(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        String wfDefinition = null;
        String jobId = this.getResourceName(request);
        try {
            wfDefinition = dagEngine.getDefinition(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return wfDefinition;
    }

    @Override
    protected void streamJobLog(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.streamLog(jobId, response.getWriter(), request.getParameterMap());
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    @Override
    protected void streamJobErrorLog(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E0306, new Object[0]);
    }

    @Override
    protected void streamJobAuditLog(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E0306, new Object[0]);
    }

    @Override
    protected void streamJobGraph(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E0306, new Object[0]);
    }

    @Override
    protected String getJMSTopicName(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E0306, new Object[0]);
    }

    @Override
    protected JSONObject getJobsByParentId(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E0302, "Not supported in v0");
    }

    @Override
    protected JSONObject updateJob(HttpServletRequest request, HttpServletResponse response, Configuration conf) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E0302, "Not supported in v0");
    }

    @Override
    protected JSONObject ignoreJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E0302, "Not supported in v0");
    }

    @Override
    protected String getJobStatus(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E0302, "Not supported in v0");
    }

    @Override
    void slaEnableAlert(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E0302, "Not supported in v0");
    }

    @Override
    void slaDisableAlert(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E0302, "Not supported in v0");
    }

    @Override
    void slaChange(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E0302, "Not supported in v0");
    }
}

