/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.io.StringReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.bundle.BundleCoordSubmitXCommand;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;
import org.apache.oozie.command.coord.CoordActionInputCheckXCommand;
import org.apache.oozie.command.coord.CoordActionReadyXCommand;
import org.apache.oozie.command.coord.CoordActionStartXCommand;
import org.apache.oozie.command.coord.CoordKillXCommand;
import org.apache.oozie.command.coord.CoordPushDependencyCheckXCommand;
import org.apache.oozie.command.coord.CoordResumeXCommand;
import org.apache.oozie.command.coord.CoordSuspendXCommand;
import org.apache.oozie.command.wf.ActionEndXCommand;
import org.apache.oozie.command.wf.ActionStartXCommand;
import org.apache.oozie.command.wf.KillXCommand;
import org.apache.oozie.command.wf.ResumeXCommand;
import org.apache.oozie.command.wf.SignalXCommand;
import org.apache.oozie.command.wf.SuspendXCommand;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ELUtils;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.XCallable;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Attribute;
import org.jdom.Element;

public class RecoveryService
implements Service {
    public static final String RECOVERY_SERVICE_CONF_PREFIX = "oozie.service.RecoveryService.";
    public static final String CONF_PREFIX_WF_ACTIONS = "oozie.service.RecoveryService.wf.actions.";
    public static final String CONF_PREFIX_COORD = "oozie.service.RecoveryService.coord.";
    public static final String CONF_PREFIX_BUNDLE = "oozie.service.RecoveryService.bundle.";
    public static final String CONF_SERVICE_INTERVAL = "oozie.service.RecoveryService.interval";
    public static final String CONF_CALLABLE_BATCH_SIZE = "oozie.service.RecoveryService.callable.batch.size";
    public static final String CONF_PUSH_DEPENDENCY_INTERVAL = "oozie.service.RecoveryService.push.dependency.interval";
    public static final String CONF_WF_ACTIONS_OLDER_THAN = "oozie.service.RecoveryService.wf.actions.older.than";
    public static final String CONF_WF_ACTIONS_CREATED_TIME_INTERVAL = "oozie.service.RecoveryService.wf.actions.created.time.interval";
    public static final String CONF_COORD_OLDER_THAN = "oozie.service.RecoveryService.coord.older.than";
    public static final String CONF_BUNDLE_OLDER_THAN = "oozie.service.RecoveryService.bundle.older.than";
    private static final String INSTRUMENTATION_GROUP = "recovery";
    private static final String INSTR_RECOVERED_ACTIONS_COUNTER = "actions";
    private static final String INSTR_RECOVERED_COORD_ACTIONS_COUNTER = "coord_actions";
    private static final String INSTR_RECOVERED_BUNDLE_ACTIONS_COUNTER = "bundle_actions";
    public static final long ONE_DAY_MILLISCONDS = 90000000L;

    @Override
    public void init(Services services) {
        Configuration conf = services.getConf();
        RecoveryRunnable recoveryRunnable = new RecoveryRunnable(ConfigurationService.getInt(conf, CONF_WF_ACTIONS_OLDER_THAN), ConfigurationService.getInt(conf, CONF_COORD_OLDER_THAN), ConfigurationService.getInt(conf, CONF_BUNDLE_OLDER_THAN));
        services.get(SchedulerService.class).schedule(recoveryRunnable, 10L, (long)this.getRecoveryServiceInterval(conf), SchedulerService.Unit.SEC);
    }

    public int getRecoveryServiceInterval(Configuration conf) {
        return ConfigurationService.getInt(conf, CONF_SERVICE_INTERVAL);
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return RecoveryService.class;
    }

    private static Configuration mergeConfig(Element coordElem, BundleJobBean bundleJob) throws CommandException {
        XLog.Info.get().clear();
        XLog log = XLog.getLog("RecoveryService");
        String jobConf = bundleJob.getConf();
        XConfiguration runConf = null;
        try {
            runConf = new XConfiguration(new StringReader(jobConf));
        }
        catch (IOException e1) {
            log.warn("Configuration parse error in:" + jobConf);
            throw new CommandException(ErrorCode.E1306, e1.getMessage(), e1);
        }
        Element localConfigElement = coordElem.getChild("configuration", coordElem.getNamespace());
        if (localConfigElement != null) {
            XConfiguration localConf;
            String strConfig = XmlUtils.prettyPrint(localConfigElement).toString();
            try {
                localConf = new XConfiguration(new StringReader(strConfig));
            }
            catch (IOException e1) {
                log.warn("Configuration parse error in:" + strConfig);
                throw new CommandException(ErrorCode.E1307, e1.getMessage(), e1);
            }
            XConfiguration.copy(localConf, runConf);
        }
        String appPath = coordElem.getChild("app-path", coordElem.getNamespace()).getValue();
        runConf.set("oozie.coord.application.path", appPath);
        try {
            JobUtils.normalizeAppPath(runConf.get("user.name"), runConf.get("group.name"), runConf);
        }
        catch (IOException e) {
            throw new CommandException(ErrorCode.E1001, runConf.get("oozie.coord.application.path"));
        }
        return runConf;
    }

    static class RecoveryRunnable
    implements Runnable {
        private final long olderThan;
        private final long coordOlderThan;
        private final long bundleOlderThan;
        private long delay = 0L;
        private List<XCallable<?>> callables;
        private List<XCallable<?>> delayedCallables;
        private StringBuilder msg = null;
        private JPAService jpaService = null;

        public RecoveryRunnable(long olderThan, long coordOlderThan, long bundleOlderThan) {
            this.olderThan = olderThan;
            this.coordOlderThan = coordOlderThan;
            this.bundleOlderThan = bundleOlderThan;
        }

        @Override
        public void run() {
            XLog.Info.get().clear();
            XLog log = XLog.getLog(this.getClass());
            this.msg = new StringBuilder();
            this.jpaService = Services.get().get(JPAService.class);
            this.runWFRecovery();
            this.runCoordActionRecovery();
            this.runBundleRecovery();
            log.debug("QUEUED [{0}] for potential recovery", this.msg.toString());
            boolean ret = false;
            if (null != this.callables) {
                ret = Services.get().get(CallableQueueService.class).queueSerial(this.callables);
                if (!ret) {
                    log.warn("Unable to queue the callables commands for RecoveryService. Most possibly command queue is full. Queue size is :" + Services.get().get(CallableQueueService.class).queueSize());
                }
                this.callables = null;
            }
            if (null != this.delayedCallables) {
                ret = Services.get().get(CallableQueueService.class).queueSerial(this.delayedCallables, this.delay);
                if (!ret) {
                    log.warn("Unable to queue the delayedCallables commands for RecoveryService. Most possibly Callable queue is full. Queue size is :" + Services.get().get(CallableQueueService.class).queueSize());
                }
                this.delayedCallables = null;
                this.delay = 0L;
            }
        }

        private void runBundleRecovery() {
            XLog.Info.get().clear();
            XLog log = XLog.getLog(this.getClass());
            List<BundleActionBean> bactions = null;
            try {
                bactions = BundleActionQueryExecutor.getInstance().getList(BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_WAITING_ACTIONS_OLDER_THAN, this.bundleOlderThan);
            }
            catch (JPAExecutorException ex) {
                log.warn((Object)"Error reading bundle actions from database", ex);
                return;
            }
            this.msg.append(", BUNDLE_ACTIONS : ").append(bactions.size());
            for (BundleActionBean baction : bactions) {
                try {
                    Services.get().get(InstrumentationService.class).get().incr(RecoveryService.INSTRUMENTATION_GROUP, RecoveryService.INSTR_RECOVERED_BUNDLE_ACTIONS_COUNTER, 1L);
                    if (baction.getCoordId() == null && baction.getStatus() != Job.Status.PREP) {
                        log.error("CoordId is null for Bundle action " + baction.getBundleActionId());
                        continue;
                    }
                    if (!Services.get().get(JobsConcurrencyService.class).isJobIdForThisServer(baction.getBundleId())) continue;
                    if (baction.getStatus() == Job.Status.PREP && baction.getCoordId() == null) {
                        CoordinatorJobBean coordJobs = CoordJobQueryExecutor.getInstance().getIfExist(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOBS_FOR_BUNDLE_BY_APPNAME_ID, baction.getCoordName(), baction.getBundleId());
                        if (coordJobs == null) {
                            log.debug("Coord [{0}] for bundle [{1}] is not yet submitted , submitting new one", baction.getCoordName(), baction.getBundleId());
                            BundleJobBean bundleJob = null;
                            if (this.jpaService != null) {
                                bundleJob = BundleJobQueryExecutor.getInstance().get(BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_ID_JOBXML_CONF, baction.getBundleId());
                            }
                            Element bAppXml = XmlUtils.parseXml(bundleJob.getJobXml());
                            List coordElems = bAppXml.getChildren("coordinator", bAppXml.getNamespace());
                            for (Element coordElem : coordElems) {
                                Attribute name = coordElem.getAttribute("name");
                                String coordName = name.getValue();
                                Configuration coordConf = RecoveryService.mergeConfig(coordElem, bundleJob);
                                try {
                                    coordName = ELUtils.resolveAppName(coordName, coordConf);
                                }
                                catch (Exception e) {
                                    log.error((Object)("Error evaluating coord name " + e.getMessage()), e);
                                    continue;
                                }
                                if (!coordName.equals(baction.getCoordName())) continue;
                                coordConf.set("oozie.bundle.id", baction.getBundleId());
                                this.queueCallable(new BundleCoordSubmitXCommand(coordConf, bundleJob.getId(), coordName));
                            }
                            continue;
                        }
                        log.debug("Coord [{0}] for bundle [{1}] is submitted , but bundle action is not updated.", baction.getCoordName(), baction.getBundleId());
                        coordJobs = CoordJobQueryExecutor.getInstance().getIfExist(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_SUSPEND_KILL, baction.getCoordName(), coordJobs.getId());
                        this.queueCallable(new BundleStatusUpdateXCommand(coordJobs, baction.getStatus()));
                        continue;
                    }
                    if (baction.getStatus() == Job.Status.KILLED) {
                        this.queueCallable(new CoordKillXCommand(baction.getCoordId()));
                        continue;
                    }
                    if (baction.getStatus() == Job.Status.SUSPENDED || baction.getStatus() == Job.Status.SUSPENDEDWITHERROR) {
                        this.queueCallable(new CoordSuspendXCommand(baction.getCoordId()));
                        continue;
                    }
                    if (baction.getStatus() != Job.Status.RUNNING && baction.getStatus() != Job.Status.RUNNINGWITHERROR) continue;
                    this.queueCallable(new CoordResumeXCommand(baction.getCoordId()));
                }
                catch (Exception ex) {
                    log.error("Exception, {0}", ex.getMessage(), ex);
                }
            }
        }

        private void runCoordActionRecovery() {
            long pushMissingDepInterval;
            HashSet<String> readyJobs = new HashSet<String>();
            XLog.Info.get().clear();
            XLog log = XLog.getLog(this.getClass());
            long pushMissingDepDelay = pushMissingDepInterval = ConfigurationService.getLong(RecoveryService.CONF_PUSH_DEPENDENCY_INTERVAL);
            Timestamp ts = new Timestamp(System.currentTimeMillis() - this.coordOlderThan * 1000L);
            ArrayList<CoordinatorActionBean> cactions = new ArrayList<CoordinatorActionBean>();
            try {
                cactions.addAll(CoordActionQueryExecutor.getInstance().getList(CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTIONS_FOR_RECOVERY_OLDER_THAN, ts));
                cactions.addAll(CoordActionQueryExecutor.getInstance().getList(CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTIONS_WAITING_READY_SUBMITTED_OLDER_THAN, ts));
            }
            catch (JPAExecutorException ex) {
                log.warn((Object)"Error reading coord actions from database", ex);
                return;
            }
            this.msg.append(", COORD_ACTIONS : " + cactions.size());
            for (CoordinatorActionBean caction : cactions) {
                try {
                    if (!Services.get().get(JobsConcurrencyService.class).isJobIdForThisServer(caction.getId())) continue;
                    Services.get().get(InstrumentationService.class).get().incr(RecoveryService.INSTRUMENTATION_GROUP, RecoveryService.INSTR_RECOVERED_COORD_ACTIONS_COUNTER, 1L);
                    if (caction.getStatus() == CoordinatorAction.Status.WAITING) {
                        this.queueCallable(new CoordActionInputCheckXCommand(caction.getId(), caction.getJobId()));
                        log.debug("Recover a coord action from [WAITING] and resubmit CoordActionInputCheckXCommand :[{0}]", caction.getId());
                        if (caction.getPushMissingDependencies() == null || caction.getPushMissingDependencies().length() == 0) continue;
                        this.queueCallable(new CoordPushDependencyCheckXCommand(caction.getId(), true, true), pushMissingDepDelay);
                        pushMissingDepDelay += pushMissingDepInterval;
                        log.debug("Recover a coord action from [WAITING] and resubmit CoordPushDependencyCheckX :[{0}]", caction.getId());
                        continue;
                    }
                    if (caction.getStatus() == CoordinatorAction.Status.SUBMITTED) {
                        CoordinatorJobBean coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_USER_APPNAME, caction.getJobId());
                        this.queueCallable(new CoordActionStartXCommand(caction.getId(), coordJob.getUser(), coordJob.getAppName(), caction.getJobId()));
                        log.debug("Recover a coord action from [SUBMITTED] and resubmit CoordActionStartCommand :[{0}]", caction.getId());
                        continue;
                    }
                    if (caction.getStatus() == CoordinatorAction.Status.SUSPENDED) {
                        if (caction.getExternalId() == null || caction.getPending() <= 1) continue;
                        this.queueCallable(new SuspendXCommand(caction.getExternalId()));
                        log.debug("Recover a coord action from [SUSPENDED] and resubmit SuspendXCommand :[{0}]", caction.getId());
                        continue;
                    }
                    if (caction.getStatus() == CoordinatorAction.Status.KILLED) {
                        if (caction.getExternalId() == null) continue;
                        this.queueCallable(new KillXCommand(caction.getExternalId()));
                        log.debug("Recover a coord action from [KILLED] and resubmit KillXCommand :[{0}]", caction.getId());
                        continue;
                    }
                    if (caction.getStatus() == CoordinatorAction.Status.RUNNING) {
                        if (caction.getExternalId() == null) continue;
                        this.queueCallable(new ResumeXCommand(caction.getExternalId()));
                        log.debug("Recover a coord action from [RUNNING] and resubmit ResumeXCommand :[{0}]", caction.getId());
                        continue;
                    }
                    if (caction.getStatus() != CoordinatorAction.Status.READY) continue;
                    readyJobs.add(caction.getJobId());
                }
                catch (Exception ex) {
                    log.error("Exception, {0}", ex.getMessage(), ex);
                }
            }
            this.runCoordActionRecoveryForReady(readyJobs);
        }

        private void runCoordActionRecoveryForReady(Set<String> jobIds) {
            XLog.Info.get().clear();
            XLog log = XLog.getLog(this.getClass());
            List<String> coordJobIds = new ArrayList<String>(jobIds);
            try {
                coordJobIds = Services.get().get(JobsConcurrencyService.class).getJobIdsForThisServer(coordJobIds);
                this.msg.append(", COORD_READY_JOBS : " + coordJobIds.size());
                for (String jobid : coordJobIds) {
                    this.queueCallable(new CoordActionReadyXCommand(jobid));
                    log.debug("Recover a coord action from [READY] resubmit CoordActionReadyXCommand :[{0}]", jobid);
                }
            }
            catch (Exception ex) {
                log.error("Exception, {0}", ex.getMessage(), ex);
            }
        }

        private void runWFRecovery() {
            XLog.Info.get().clear();
            XLog log = XLog.getLog(this.getClass());
            long createdTimeInterval = new Date().getTime() - ConfigurationService.getLong(RecoveryService.CONF_WF_ACTIONS_CREATED_TIME_INTERVAL) * 90000000L;
            List<WorkflowActionBean> actions = null;
            try {
                actions = WorkflowActionQueryExecutor.getInstance().getList(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_PENDING_ACTIONS, this.olderThan, createdTimeInterval);
            }
            catch (JPAExecutorException ex) {
                log.warn((Object)"Exception while reading pending actions from storage", ex);
                return;
            }
            this.msg.append(" WF_ACTIONS " + actions.size());
            for (WorkflowActionBean action : actions) {
                try {
                    Date nextRunTime;
                    if (!Services.get().get(JobsConcurrencyService.class).isJobIdForThisServer(action.getId())) continue;
                    Services.get().get(InstrumentationService.class).get().incr(RecoveryService.INSTRUMENTATION_GROUP, RecoveryService.INSTR_RECOVERED_ACTIONS_COUNTER, 1L);
                    if (action.getStatus() == WorkflowAction.Status.PREP || action.getStatus() == WorkflowAction.Status.START_MANUAL) {
                        this.queueCallable(new ActionStartXCommand(action.getId(), action.getType()));
                        log.debug("Recover a workflow action from [{0}] status and resubmit ActionStartXCommand :[{1}]", action.getStatus(), action.getId());
                        continue;
                    }
                    if (action.getStatus() == WorkflowAction.Status.START_RETRY) {
                        nextRunTime = action.getPendingAge();
                        this.queueCallable(new ActionStartXCommand(action.getId(), action.getType()), nextRunTime.getTime() - System.currentTimeMillis());
                        log.debug("Recover a workflow action from [START_RETRY] status and resubmit ActionStartXCommand :[{0}]", action.getId());
                        continue;
                    }
                    if (action.getStatus() == WorkflowAction.Status.DONE || action.getStatus() == WorkflowAction.Status.END_MANUAL) {
                        this.queueCallable(new ActionEndXCommand(action.getId(), action.getType()));
                        log.debug("Recover a workflow action from [{0}] status and resubmit ActionEndXCommand :[{1}]", action.getStatus(), action.getId());
                        continue;
                    }
                    if (action.getStatus() == WorkflowAction.Status.END_RETRY) {
                        nextRunTime = action.getPendingAge();
                        this.queueCallable(new ActionEndXCommand(action.getId(), action.getType()), nextRunTime.getTime() - System.currentTimeMillis());
                        log.debug("Recover a workflow action from [END_RETRY] status and resubmit ActionEndXCommand :[{0}]", action.getId());
                        continue;
                    }
                    if (action.getStatus() == WorkflowAction.Status.OK || action.getStatus() == WorkflowAction.Status.ERROR) {
                        this.queueCallable(new SignalXCommand(action.getJobId(), action.getId()));
                        log.debug("Recover a workflow action from [{0}] status and resubmit SignalXCommand :[{1}]", action.getStatus(), action.getId());
                        continue;
                    }
                    if (action.getStatus() != WorkflowAction.Status.USER_RETRY) continue;
                    this.queueCallable(new ActionStartXCommand(action.getId(), action.getType()));
                    log.debug("Recover a workflow action from [USER_RETRY] status and resubmit ActionStartXCommand :[{0}]", action.getId());
                }
                catch (Exception ex) {
                    log.error("Exception, {0}", ex.getMessage(), ex);
                }
            }
        }

        private void queueCallable(XCallable<?> callable) {
            if (this.callables == null) {
                this.callables = new ArrayList();
            }
            this.callables.add(callable);
            if (this.callables.size() == Services.get().getConf().getInt(RecoveryService.CONF_CALLABLE_BATCH_SIZE, 10)) {
                boolean ret = Services.get().get(CallableQueueService.class).queueSerial(this.callables);
                if (!ret) {
                    XLog.getLog(this.getClass()).warn("Unable to queue the callables commands for RecoveryService. Most possibly command queue is full. Queue size is :" + Services.get().get(CallableQueueService.class).queueSize());
                }
                this.callables = new ArrayList();
            }
        }

        private void queueCallable(XCallable<?> callable, long delay) {
            if (this.delayedCallables == null) {
                this.delayedCallables = new ArrayList();
            }
            this.delay = Math.max(this.delay, delay);
            this.delayedCallables.add(callable);
            if (this.delayedCallables.size() == ConfigurationService.getInt(RecoveryService.CONF_CALLABLE_BATCH_SIZE)) {
                boolean ret = Services.get().get(CallableQueueService.class).queueSerial(this.delayedCallables, this.delay);
                if (!ret) {
                    XLog.getLog(this.getClass()).warn("Unable to queue the delayedCallables commands for RecoveryService. Most possibly Callable queue is full. Queue size is :" + Services.get().get(CallableQueueService.class).queueSize());
                }
                this.delayedCallables = new ArrayList();
                this.delay = 0L;
            }
        }
    }
}

