/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;

public class CallbackService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.CallbackService.";
    public static final String CONF_BASE_URL = "oozie.service.CallbackService.base.url";
    public static final String CONF_EARLY_REQUEUE_MAX_RETRIES = "oozie.service.CallbackService.early.requeue.max.retries";
    private Configuration oozieConf;
    private int earlyRequeueMaxRetries;
    private static final String ID_PARAM = "id=";
    private static final String STATUS_PARAM = "status=";
    private static final String CALL_BACK_QUERY_STRING = "{0}?id={1}&status={2}";

    @Override
    public void init(Services services) {
        this.oozieConf = services.getConf();
        this.earlyRequeueMaxRetries = ConfigurationService.getInt(CONF_EARLY_REQUEUE_MAX_RETRIES);
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return CallbackService.class;
    }

    public String createCallBackUrl(String actionId, String externalStatusVar) {
        ParamChecker.notEmpty(actionId, "actionId");
        ParamChecker.notEmpty(externalStatusVar, "externalStatusVar");
        String baseCallbackUrl = ConfigurationService.get(this.oozieConf, CONF_BASE_URL);
        return MessageFormat.format(CALL_BACK_QUERY_STRING, baseCallbackUrl, actionId, externalStatusVar);
    }

    private String getParam(String str, String name) {
        String value = null;
        int start = str.indexOf(name);
        if (start > -1) {
            int end = str.indexOf("&", start + 1);
            value = end > -1 ? str.substring(start, end) : str.substring(start += name.length());
        }
        return value;
    }

    public boolean isValid(String callback) {
        return callback != null && this.getParam(callback, ID_PARAM) != null && this.getParam(callback, STATUS_PARAM) != null;
    }

    public String getActionId(String callback) {
        try {
            return URLDecoder.decode(this.getParam(ParamChecker.notEmpty(callback, "callback"), ID_PARAM), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getExternalStatus(String callback) {
        try {
            return URLDecoder.decode(this.getParam(ParamChecker.notEmpty(callback, "callback"), STATUS_PARAM), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getEarlyRequeueMaxRetries() {
        return this.earlyRequeueMaxRetries;
    }
}

