/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import com.google.common.base.Joiner;

enum ActionConfFileType {
    XML(".xml"),
    PROPERTIES(".properties");

    private final String extension;

    private ActionConfFileType(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    static boolean isSupportedFileType(String fileName) {
        for (ActionConfFileType actionConfFileType : ActionConfFileType.values()) {
            if (!fileName.endsWith(actionConfFileType.getExtension())) continue;
            return true;
        }
        return false;
    }

    static ActionConfFileType getFileType(String fileName) {
        for (ActionConfFileType actionConfFileType : ActionConfFileType.values()) {
            if (!fileName.endsWith(actionConfFileType.getExtension())) continue;
            return actionConfFileType;
        }
        throw new UnsupportedOperationException(String.format("Unsupported action conf file extension for file %s, supported extension are %s", fileName, Joiner.on((String)", ").join((Object[])ActionConfFileType.values())));
    }
}

