/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.action.email.EmailActionExecutor;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordKillXCommand;
import org.apache.oozie.command.wf.JobXCommand;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XLog;

public class AbandonedCoordCheckerService
implements Service {
    private static final String CONF_PREFIX = "oozie.service.AbandonedCoordCheckerService.";
    public static final String TO_ADDRESS = "oozie.service.AbandonedCoordCheckerService.email.address";
    private static final String CONTENT_TYPE = "text/html";
    private static final String SUBJECT = "Abandoned Coordinators report";
    public static final String CONF_CHECK_INTERVAL = "oozie.service.AbandonedCoordCheckerService.check.interval";
    public static final String CONF_CHECK_DELAY = "oozie.service.AbandonedCoordCheckerService.check.delay";
    public static final String CONF_FAILURE_LEN = "oozie.service.AbandonedCoordCheckerService.failure.limit";
    public static final String CONF_JOB_OLDER_THAN = "oozie.service.AbandonedCoordCheckerService.job.older.than";
    public static final String CONF_JOB_KILL = "oozie.service.AbandonedCoordCheckerService.kill.jobs";
    public static final String OOZIE_BASE_URL = "oozie.base.url";
    private static String[] to;
    private static String serverURL;

    @Override
    public void init(Services services) {
        to = ConfigurationService.getStrings(TO_ADDRESS);
        int failureLen = ConfigurationService.getInt(CONF_FAILURE_LEN);
        boolean shouldKill = ConfigurationService.getBoolean(CONF_JOB_KILL);
        serverURL = ConfigurationService.get(OOZIE_BASE_URL);
        int delay = ConfigurationService.getInt(CONF_CHECK_DELAY);
        AbandonedCoordCheckerRunnable actionCheckRunnable = new AbandonedCoordCheckerRunnable(failureLen, shouldKill);
        services.get(SchedulerService.class).schedule(actionCheckRunnable, (long)delay, (long)ConfigurationService.getInt(CONF_CHECK_INTERVAL), SchedulerService.Unit.MIN);
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return AbandonedCoordCheckerService.class;
    }

    public static class AbandonedCoordCheckerRunnable
    implements Runnable {
        final int failureLimit;
        XLog LOG = XLog.getLog(this.getClass());
        private boolean shouldKill = false;

        public AbandonedCoordCheckerRunnable(int failureLimit) {
            this(failureLimit, false);
        }

        public AbandonedCoordCheckerRunnable(int failureLimit, boolean shouldKill) {
            this.failureLimit = failureLimit;
            this.shouldKill = shouldKill;
        }

        @Override
        public void run() {
            if (!Services.get().get(JobsConcurrencyService.class).isLeader()) {
                this.LOG.info("Server is not primary server. Skipping run");
                return;
            }
            XLog.Info.get().clear();
            try {
                this.checkCoordJobs();
            }
            catch (Exception e) {
                this.LOG.error((Object)"Error running AbandonedCoordChecker", e);
            }
        }

        private void checkCoordJobs() throws Exception {
            StringBuilder msg = new StringBuilder();
            this.addTableHeader(msg);
            try {
                Timestamp createdTS = new Timestamp(System.currentTimeMillis() - (long)(ConfigurationService.getInt(AbandonedCoordCheckerService.CONF_JOB_OLDER_THAN) * 60 * 1000));
                List<CoordinatorJobBean> jobs = CoordJobQueryExecutor.getInstance().getList(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_FOR_ABANDONEDCHECK, this.failureLimit, createdTS);
                for (CoordinatorJobBean job : jobs) {
                    this.processJob(job, msg);
                }
                if (jobs.size() > 0) {
                    this.addTableTail(msg);
                    this.sendMail(msg.toString());
                }
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
        }

        private void processJob(CoordinatorJobBean job, StringBuilder msg) {
            String killStatus = "Coord kill is disabled";
            this.LOG.info("Abandoned Coord found : " + job.getId());
            if (this.shouldKill) {
                try {
                    new CoordKillXCommand(job.getId()).call();
                    this.LOG.info("Killed abandoned coord :  " + job.getId());
                    killStatus = "Successful";
                }
                catch (Exception e) {
                    this.LOG.error((Object)("Can't kill abandoned coord :  " + job.getId()), e);
                    killStatus = " Failed : " + e.getMessage();
                }
            }
            this.addCoordToMessage(job, killStatus, msg);
        }

        public void addCoordToMessage(CoordinatorJobBean job, String killStatus, StringBuilder msg) {
            msg.append("<tr>");
            msg.append("<td><a href=\"").append(JobXCommand.getJobConsoleUrl(job.getId())).append("\">").append(job.getId()).append("</a></td>");
            msg.append("<td>").append(job.getAppName()).append("</td>");
            msg.append("<td>").append(job.getUser()).append("</td>");
            msg.append("<td>").append(job.getGroup()).append("</td>");
            msg.append("<td>").append(killStatus).append("</td>");
            msg.append("</tr>");
        }

        public void addTableHeader(StringBuilder msg) {
            msg.append("<!DOCTYPE html><html><head><style>table,th,td{border:1px solid black;border-collapse:collapse;}</style></head><body><table>");
            msg.append("<tr>");
            msg.append("<td>").append("Coordinator id").append("</td>");
            msg.append("<td>").append("Coordinator name").append("</td>");
            msg.append("<td>").append("User name").append("</td>");
            msg.append("<td>").append("Group").append("</td>");
            msg.append("<td>").append("Kill Status").append("</td>");
            msg.append("</tr>");
        }

        public void addTableTail(StringBuilder msg) {
            msg.append("</table></body></html>");
        }

        public void sendMail(String body) throws Exception {
            if (to == null || to.length == 0 || to.length == 1 && StringUtils.isEmpty((String)to[0])) {
                this.LOG.info("oozie.service.AbandonedCoordCheckerService.email.address is not configured. Not sending email");
                return;
            }
            EmailActionExecutor email = new EmailActionExecutor();
            String subject = "Abandoned Coordinators report for " + serverURL + " at " + DateUtils.formatDateOozieTZ(new Date());
            email.email(to, new String[0], new String[0], subject, body, null, AbandonedCoordCheckerService.CONTENT_TYPE, null);
        }
    }
}

