/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.jms;

import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.oozie.jms.MessageHandler;
import org.apache.oozie.util.XLog;

public class MessageReceiver
implements MessageListener {
    private static XLog LOG = XLog.getLog(MessageReceiver.class);
    private MessageHandler msgHandler;
    private Session session;
    private MessageConsumer consumer;

    public MessageReceiver(MessageHandler handler, Session session, MessageConsumer consumer) {
        this.msgHandler = handler;
        this.session = session;
        this.consumer = consumer;
    }

    public MessageConsumer getConsumer() {
        return this.consumer;
    }

    public MessageHandler getMessageHandler() {
        return this.msgHandler;
    }

    public Session getSession() {
        return this.session;
    }

    public void onMessage(Message msg) {
        LOG.trace("Received a JMS message ");
        this.msgHandler.process(msg);
    }
}

