/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa.sla;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.util.XLog;

public class SLASummaryGetForFilterJPAExecutor
implements JPAExecutor<List<SLASummaryBean>> {
    private static final String selectStr = "SELECT OBJECT(s) FROM SLASummaryBean s WHERE ";
    private static final String bundleIdQuery = "SELECT a.coordId FROM BundleActionBean a WHERE a.bundleId=:bundleId";
    private static final String bundleNameQuery = "SELECT a.coordId FROM BundleActionBean a WHERE a.bundleId in (SELECT b.id from BundleJobBean b WHERE b.appName=:appName)";
    private SLASummaryFilter filter;
    private int numMaxResults;
    private XLog LOG = XLog.getLog(this.getClass());

    public SLASummaryGetForFilterJPAExecutor(SLASummaryFilter filter, int numMaxResults) {
        this.filter = filter;
        this.numMaxResults = numMaxResults;
    }

    @Override
    public String getName() {
        return "SLASummaryGetForFilterJPAExecutor";
    }

    @Override
    public List<SLASummaryBean> execute(EntityManager em) throws JPAExecutorException {
        List ssBean = null;
        StringBuilder sb = new StringBuilder(selectStr);
        LinkedHashMap<String, Object> queryParams = new LinkedHashMap<String, Object>();
        boolean firstCondition = true;
        boolean jobExists = true;
        if (this.filter.getJobId() != null) {
            firstCondition = false;
            if (this.filter.getParentId() != null) {
                sb.append("(s.jobId = :jobId OR s.parentId = :parentId)");
                queryParams.put("jobId", this.filter.getJobId());
                queryParams.put("parentId", this.filter.getParentId());
            } else {
                sb.append("s.jobId = :jobId");
                queryParams.put("jobId", this.filter.getJobId());
            }
        }
        if (this.filter.getParentId() != null && this.filter.getJobId() == null) {
            firstCondition = false;
            sb.append("s.parentId = :parentId");
            queryParams.put("parentId", this.filter.getParentId());
        }
        if (this.filter.getBundleId() != null || this.filter.getBundleName() != null) {
            List returnList;
            firstCondition = false;
            try {
                Query bq;
                if (this.filter.getBundleId() != null) {
                    bq = em.createQuery(bundleIdQuery);
                    bq.setParameter("bundleId", (Object)this.filter.getBundleId());
                } else {
                    bq = em.createQuery(bundleNameQuery);
                    bq.setParameter("appName", (Object)this.filter.getBundleName());
                }
                bq.setMaxResults(this.numMaxResults);
                returnList = bq.getResultList();
            }
            catch (Exception e) {
                throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
            }
            Object sub = null;
            int ind = 0;
            if (returnList.size() == 0) {
                jobExists = false;
            }
            for (Object obj : returnList) {
                String coordId = (String)obj;
                if (sub == null) {
                    sub = new StringBuilder();
                    ((StringBuilder)sub).append("s.parentId in (:parentId").append(ind);
                } else {
                    ((StringBuilder)sub).append(",:parentId").append(ind);
                }
                queryParams.put("parentId" + ind, coordId);
                ++ind;
            }
            if (sub != null) {
                ((StringBuilder)sub).append(")");
                sb.append(((StringBuilder)sub).toString());
            }
        }
        if (this.filter.getAppName() != null) {
            if (firstCondition) {
                firstCondition = false;
            } else {
                sb.append(" AND ");
            }
            sb.append("s.appName = :appName");
            queryParams.put("appName", this.filter.getAppName());
        }
        if (this.filter.getNominalStart() != null) {
            if (firstCondition) {
                firstCondition = false;
            } else {
                sb.append(" AND ");
            }
            sb.append("s.nominalTimeTS >= :nominalTimeStart");
            queryParams.put("nominalTimeStart", new Timestamp(this.filter.getNominalStart().getTime()));
        }
        if (this.filter.getNominalEnd() != null) {
            if (firstCondition) {
                firstCondition = false;
            } else {
                sb.append(" AND ");
            }
            sb.append("s.nominalTimeTS <= :nominalTimeEnd");
            queryParams.put("nominalTimeEnd", new Timestamp(this.filter.getNominalEnd().getTime()));
        }
        if (this.filter.getEventStatus() != null) {
            this.processEventStatusFilter(this.filter, queryParams, sb, firstCondition);
        }
        if (this.filter.getSLAStatus() != null) {
            StringBuilder sub = null;
            int ind = 0;
            if (firstCondition) {
                firstCondition = false;
            } else {
                sb.append(" AND ");
            }
            for (SLAEvent.SLAStatus status : this.filter.getSLAStatus()) {
                if (sub == null) {
                    sub = new StringBuilder();
                    sub.append("s.slaStatus in (:slaStatus").append(ind);
                } else {
                    sub.append(",:slaStatus").append(ind);
                }
                queryParams.put("slaStatus" + ind, status.toString());
                ++ind;
            }
            if (sub != null) {
                sub.append(")");
                sb.append(sub.toString());
            }
        }
        if (jobExists) {
            sb.append(" ORDER BY s.nominalTimeTS");
            this.LOG.debug("Query String: " + sb.toString());
            try {
                Query q = em.createQuery(sb.toString());
                for (Map.Entry entry : queryParams.entrySet()) {
                    q.setParameter((String)entry.getKey(), entry.getValue());
                }
                q.setMaxResults(this.numMaxResults);
                ssBean = q.getResultList();
            }
            catch (Exception e) {
                throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
            }
        }
        return ssBean;
    }

    private void processEventStatusFilter(SLASummaryFilter filter, Map<String, Object> queryParams, StringBuilder sb, boolean firstCondition) {
        if (firstCondition) {
            firstCondition = false;
        } else {
            sb.append(" AND ");
        }
        List<SLAEvent.EventStatus> eventStatusList = filter.getEventStatus();
        int ind = 0;
        Timestamp currentTime = new Timestamp(new Date().getTime());
        for (SLAEvent.EventStatus status : eventStatusList) {
            if (ind > 0) {
                sb.append(" OR ");
            }
            if (status.equals((Object)SLAEvent.EventStatus.START_MET)) {
                sb.append("(s.expectedStartTS IS NOT NULL AND s.actualStartTS IS NOT NULL ").append(" AND s.expectedStartTS >= s.actualStartTS)");
            } else if (status.equals((Object)SLAEvent.EventStatus.START_MISS)) {
                sb.append("((s.expectedStartTS IS NOT NULL AND s.actualStartTS IS NOT NULL ").append(" AND s.expectedStartTS <= s.actualStartTS) ").append("OR (s.expectedStartTS IS NOT NULL AND s.actualStartTS IS NULL ").append(" AND s.expectedStartTS <= :currentTimeStamp))");
                queryParams.put("currentTimeStamp", currentTime);
            } else if (status.equals((Object)SLAEvent.EventStatus.DURATION_MET)) {
                sb.append("(s.expectedDuration <> -1 AND s.actualDuration <> -1 ").append(" AND s.expectedDuration >= s.actualDuration) ");
            } else if (status.equals((Object)SLAEvent.EventStatus.DURATION_MISS)) {
                sb.append("((s.expectedDuration <> -1 AND s.actualDuration <> -1 ").append("AND s.expectedDuration < s.actualDuration) ").append("OR s.eventStatus = 'DURATION_MISS')");
            } else if (status.equals((Object)SLAEvent.EventStatus.END_MET)) {
                sb.append("(s.expectedEndTS IS NOT NULL AND s.actualEndTS IS NOT NULL ").append(" AND s.expectedEndTS <= s.actualEndTS) ");
            } else if (status.equals((Object)SLAEvent.EventStatus.END_MISS)) {
                sb.append("((s.expectedEndTS IS NOT NULL AND s.actualEndTS IS NOT NULL ").append("AND s.expectedEndTS <= s.actualEndTS) ").append("OR (s.expectedEndTS IS NOT NULL AND s.actualEndTS IS NULL ").append("AND s.expectedEndTS <= :currentTimeStamp))");
                queryParams.put("currentTimeStamp", currentTime);
            }
            ++ind;
        }
    }

    public static class SLASummaryFilter {
        private String appName;
        private String jobId;
        private String parentId;
        private String bundleId;
        private String bundleName;
        private List<SLAEvent.EventStatus> eventStatus;
        private List<SLAEvent.SLAStatus> slaStatus;
        private static String EventStatusSep = ",";
        private static String SLAStatusSep = ",";
        private Date nominalStart;
        private Date nominalEnd;

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public String getParentId() {
            return this.parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public Date getNominalStart() {
            return this.nominalStart;
        }

        public void setNominalStart(Date nominalStart) {
            this.nominalStart = nominalStart;
        }

        public Date getNominalEnd() {
            return this.nominalEnd;
        }

        public void setNominalEnd(Date nominalEnd) {
            this.nominalEnd = nominalEnd;
        }

        public String getBundleId() {
            return this.bundleId;
        }

        public void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public String getBundleName() {
            return this.bundleName;
        }

        public void setBundleName(String name) {
            this.bundleName = name;
        }

        public List<SLAEvent.EventStatus> getEventStatus() {
            return this.eventStatus;
        }

        public void setEventStatus(String str) {
            String[] statusArr;
            if (this.eventStatus == null) {
                this.eventStatus = new ArrayList<SLAEvent.EventStatus>();
            }
            for (String s : statusArr = str.split(EventStatusSep)) {
                this.eventStatus.add(SLAEvent.EventStatus.valueOf((String)s));
            }
        }

        public List<SLAEvent.SLAStatus> getSLAStatus() {
            return this.slaStatus;
        }

        public void setSLAStatus(String str) {
            String[] statusArr;
            if (this.slaStatus == null) {
                this.slaStatus = new ArrayList<SLAEvent.SLAStatus>();
            }
            for (String s : statusArr = str.split(SLAStatusSep)) {
                this.slaStatus.add(SLAEvent.SLAStatus.valueOf((String)s));
            }
        }
    }
}

