/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.QueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLASummaryBean;

public class SLASummaryQueryExecutor
extends QueryExecutor<SLASummaryBean, SLASummaryQuery> {
    private static SLASummaryQueryExecutor instance = new SLASummaryQueryExecutor();

    private SLASummaryQueryExecutor() {
    }

    public static QueryExecutor<SLASummaryBean, SLASummaryQuery> getInstance() {
        return instance;
    }

    @Override
    public Query getUpdateQuery(SLASummaryQuery namedQuery, SLASummaryBean bean, EntityManager em) throws JPAExecutorException {
        Query query = em.createNamedQuery(namedQuery.name());
        switch (namedQuery) {
            case UPDATE_SLA_SUMMARY_FOR_STATUS_ACTUAL_TIMES: {
                query.setParameter("jobId", (Object)bean.getId());
                query.setParameter("slaStatus", (Object)bean.getSLAStatus().toString());
                query.setParameter("lastModifiedTS", (Object)bean.getLastModifiedTimestamp());
                query.setParameter("eventStatus", (Object)bean.getEventStatusString());
                query.setParameter("jobStatus", (Object)bean.getJobStatus());
                query.setParameter("eventProcessed", (Object)bean.getEventProcessed());
                query.setParameter("actualStartTS", (Object)bean.getActualStartTimestamp());
                query.setParameter("actualEndTS", (Object)bean.getActualEndTimestamp());
                query.setParameter("actualDuration", (Object)bean.getActualDuration());
                break;
            }
            case UPDATE_SLA_SUMMARY_ALL: {
                query.setParameter("appName", (Object)bean.getAppName());
                query.setParameter("appType", (Object)bean.getAppType().toString());
                query.setParameter("nominalTime", (Object)bean.getNominalTimestamp());
                query.setParameter("expectedStartTime", (Object)bean.getExpectedStartTimestamp());
                query.setParameter("expectedEndTime", (Object)bean.getExpectedEndTimestamp());
                query.setParameter("expectedDuration", (Object)bean.getExpectedDuration());
                query.setParameter("jobStatus", (Object)bean.getJobStatus());
                query.setParameter("slaStatus", (Object)bean.getSLAStatusString());
                query.setParameter("eventStatus", (Object)bean.getEventStatusString());
                query.setParameter("lastModTime", (Object)bean.getLastModifiedTimestamp());
                query.setParameter("user", (Object)bean.getUser());
                query.setParameter("parentId", (Object)bean.getParentId());
                query.setParameter("eventProcessed", (Object)bean.getEventProcessed());
                query.setParameter("actualDuration", (Object)bean.getActualDuration());
                query.setParameter("actualEndTS", (Object)bean.getActualEndTimestamp());
                query.setParameter("actualStartTS", (Object)bean.getActualStartTimestamp());
                query.setParameter("jobId", (Object)bean.getId());
                break;
            }
            case UPDATE_SLA_SUMMARY_FOR_EXPECTED_TIMES: {
                query.setParameter("nominalTime", (Object)bean.getNominalTimestamp());
                query.setParameter("expectedStartTime", (Object)bean.getExpectedStartTimestamp());
                query.setParameter("expectedEndTime", (Object)bean.getExpectedEndTimestamp());
                query.setParameter("expectedDuration", (Object)bean.getExpectedDuration());
                query.setParameter("lastModTime", (Object)bean.getLastModifiedTimestamp());
                query.setParameter("jobId", (Object)bean.getId());
                break;
            }
            case UPDATE_SLA_SUMMARY_EVENTPROCESSED: {
                query.setParameter("eventProcessed", (Object)bean.getEventProcessed());
                query.setParameter("jobId", (Object)bean.getId());
                break;
            }
            case UPDATE_SLA_SUMMARY_LAST_MODIFIED_TIME: {
                query.setParameter("lastModifiedTS", (Object)bean.getLastModifiedTime());
                query.setParameter("jobId", (Object)bean.getId());
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot set parameters for " + namedQuery.name());
            }
        }
        return query;
    }

    @Override
    public Query getSelectQuery(SLASummaryQuery namedQuery, EntityManager em, Object ... parameters) throws JPAExecutorException {
        Query query = em.createNamedQuery(namedQuery.name());
        switch (namedQuery) {
            case GET_SLA_SUMMARY: 
            case GET_SLA_SUMMARY_EVENTPROCESSED: 
            case GET_SLA_SUMMARY_EVENTPROCESSED_LAST_MODIFIED: {
                query.setParameter("id", parameters[0]);
            }
        }
        return query;
    }

    @Override
    public int executeUpdate(SLASummaryQuery namedQuery, SLASummaryBean jobBean) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getUpdateQuery(namedQuery, jobBean, em);
        int ret = jpaService.executeUpdate(namedQuery.name(), query, em);
        return ret;
    }

    @Override
    public SLASummaryBean get(SLASummaryQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        Object ret = jpaService.executeGet(namedQuery.name(), query, em);
        if (ret == null && !namedQuery.equals((Object)SLASummaryQuery.GET_SLA_SUMMARY)) {
            throw new JPAExecutorException(ErrorCode.E0604, query.toString());
        }
        SLASummaryBean bean = this.constructBean(namedQuery, ret, parameters);
        return bean;
    }

    @Override
    public SLASummaryBean getIfExist(SLASummaryQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        Object ret = jpaService.executeGet(namedQuery.name(), query, em);
        if (ret == null && !namedQuery.equals((Object)SLASummaryQuery.GET_SLA_SUMMARY)) {
            return null;
        }
        SLASummaryBean bean = this.constructBean(namedQuery, ret, parameters);
        return bean;
    }

    @Override
    public List<SLASummaryBean> getList(SLASummaryQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        List<SLASummaryBean> beanList = jpaService.executeGetList(namedQuery.name(), query, em);
        return beanList;
    }

    @Override
    public Object getSingleValue(SLASummaryQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        Object ret = jpaService.executeGet(namedQuery.name(), query, em);
        if (ret == null) {
            throw new JPAExecutorException(ErrorCode.E0604, query.toString());
        }
        return ret;
    }

    private SLASummaryBean constructBean(SLASummaryQuery namedQuery, Object ret, Object ... parameters) throws JPAExecutorException {
        SLASummaryBean bean;
        switch (namedQuery) {
            case GET_SLA_SUMMARY: {
                bean = (SLASummaryBean)ret;
                break;
            }
            case GET_SLA_SUMMARY_EVENTPROCESSED: {
                bean = new SLASummaryBean();
                bean.setEventProcessed(((Byte)ret).intValue());
                break;
            }
            case GET_SLA_SUMMARY_EVENTPROCESSED_LAST_MODIFIED: {
                Object[] arr = (Object[])ret;
                bean = new SLASummaryBean();
                bean.setEventProcessed(((Byte)arr[0]).byteValue());
                bean.setLastModifiedTime((Timestamp)arr[1]);
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot construct job bean for " + namedQuery.name());
            }
        }
        return bean;
    }

    public static enum SLASummaryQuery {
        UPDATE_SLA_SUMMARY_FOR_STATUS_ACTUAL_TIMES,
        UPDATE_SLA_SUMMARY_ALL,
        UPDATE_SLA_SUMMARY_EVENTPROCESSED,
        UPDATE_SLA_SUMMARY_FOR_EXPECTED_TIMES,
        UPDATE_SLA_SUMMARY_LAST_MODIFIED_TIME,
        GET_SLA_SUMMARY,
        GET_SLA_SUMMARY_EVENTPROCESSED,
        GET_SLA_SUMMARY_EVENTPROCESSED_LAST_MODIFIED;

    }
}

