/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordinatorJobGetForUserAppnameJPAExecutor
implements JPAExecutor<CoordinatorJobBean> {
    private String coordJobId = null;

    public CoordinatorJobGetForUserAppnameJPAExecutor(String coordJobId) {
        ParamChecker.notNull(coordJobId, "coordJobId");
        this.coordJobId = coordJobId;
    }

    @Override
    public String getName() {
        return "CoordinatorJobGetForUserAppnameJPAExecutor";
    }

    @Override
    public CoordinatorJobBean execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_COORD_JOB_FOR_USER_APPNAME");
            q.setParameter("id", (Object)this.coordJobId);
            Object[] arr = (Object[])q.getSingleResult();
            CoordinatorJobBean bean = new CoordinatorJobBean();
            if (arr[0] != null) {
                bean.setUser((String)arr[0]);
            }
            if (arr[1] != null) {
                bean.setAppName((String)arr[1]);
            }
            return bean;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }
}

