/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;

public class CoordJobGetActionsRunningJPAExecutor
implements JPAExecutor<List<CoordinatorActionBean>> {
    private String coordJobId = null;

    public CoordJobGetActionsRunningJPAExecutor(String coordJobId) {
        ParamChecker.notNull(coordJobId, "coordJobId");
        this.coordJobId = coordJobId;
    }

    @Override
    public String getName() {
        return "CoordJobGetActionsRunningJPAExecutor";
    }

    @Override
    public List<CoordinatorActionBean> execute(EntityManager em) throws JPAExecutorException {
        try {
            ArrayList<CoordinatorActionBean> actionBeansList = new ArrayList<CoordinatorActionBean>();
            Query q = em.createNamedQuery("GET_COORD_ACTIONS_RUNNING");
            q.setParameter("jobId", (Object)this.coordJobId);
            List objectArrList = q.getResultList();
            for (Object[] arr : objectArrList) {
                CoordinatorActionBean caa = this.getBeanForCoordinatorActionFromArray(arr);
                actionBeansList.add(caa);
            }
            return actionBeansList;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }

    private CoordinatorActionBean getBeanForCoordinatorActionFromArray(Object[] arr) {
        CoordinatorActionBean bean = new CoordinatorActionBean();
        if (arr[0] != null) {
            bean.setId((String)arr[0]);
        }
        if (arr[1] != null) {
            bean.setStatus(CoordinatorAction.Status.valueOf((String)((String)arr[1])));
        }
        if (arr[2] != null) {
            bean.setPending((Integer)arr[2]);
        }
        if (arr[3] != null) {
            bean.setExternalId((String)arr[3]);
        }
        if (arr[4] != null) {
            bean.setNominalTime(DateUtils.toDate((Timestamp)arr[4]));
        }
        if (arr[5] != null) {
            bean.setCreatedTime(DateUtils.toDate((Timestamp)arr[5]));
        }
        return bean;
    }
}

